/*###################################################################*/
/*##                          GQview 0.4.3                         ##*/
/*##       This software is Copyright (C) 1998 by John Ellis.      ##*/
/*## This software falls under the GNU Public License. Please read ##*/
/*##              the COPYING file for more information            ##*/
/*###################################################################*/

#include "gqview.h"

#include "pics/icon_thumb.xpm"
#include "pics/icon_home.xpm"
#include "pics/icon_reload.xpm"
#include "pics/icon_zoom_in.xpm"
#include "pics/icon_zoom_out.xpm"
#include "pics/icon_zoom_fit.xpm"
#include "pics/icon_zoom_norm.xpm"
#include "pics/icon_config.xpm"
#include "pics/icon_float.xpm"

#ifdef HAVE_GTK_1_1
	static GtkAccelGroup *accel_table;
#else
	static GtkAcceleratorTable *accel_table;
#endif

static void popdestroy();
static void move_labels(gint new, gint popped, GtkWidget *vbox);
static void hide_button_pressed();
static void float_button_pressed();
static void float_window(gint show);

void size_window(gint w, gint h)
{
	if (!fit_window || !popwindow) return;

	if (debug_mode) printf("auto sized to %d x %d\n", w, h);
	w += 4;
	h += 4;

	if (limit_window_size)
		{
		gint sw = gdk_screen_width() * max_window_size / 100;
		gint sh = gdk_screen_height() * max_window_size / 100;

		if (w > sw) w = sw;
		if (h > sh) h = sh;
		}

	gdk_window_resize(mainwindow->window, w, h);
	gtk_widget_set_usize(mainwindow, w, h);
}

static void popdestroy()
{
	float_button_pressed();
}

static void move_labels(gint new, gint popped, GtkWidget *vbox)
{
	GtkWidget *hbox;
	GtkWidget *frame;
	gchar *statustext;
	gchar *infotext;
	gchar *zoomtext;
	gchar *buf;

	if (new)
		{
		gchar buf1[40];
		statustext = g_strdup("");
		sprintf(buf1, "GQview %d.%d.%d",GQVIEW_VERSION_MAJOR,GQVIEW_VERSION_MINOR,GQVIEW_VERSION_REV);
		infotext = g_strdup(buf1);
		zoomtext = g_strdup("1 : 1");
		}
	else
		{
		gtk_label_get(GTK_LABEL(statuslabel), &buf);
		statustext = g_strdup(buf);
		gtk_label_get(GTK_LABEL(fileinfolabel), &buf);
		infotext = g_strdup(buf);
		gtk_label_get(GTK_LABEL(zoomfactorlabel), &buf);
		zoomtext = g_strdup(buf);
		}

	if (popped)
		{
		hbox = gtk_hbox_new(FALSE, 0);
		gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
		gtk_widget_show(hbox);
		}
	else
		{
		infopackbox = gtk_hbox_new(FALSE, 0);
		gtk_box_pack_end(GTK_BOX(mainbox), infopackbox, FALSE, FALSE, 0);
		gtk_widget_show(infopackbox);
		}

	/* zoom label */
	frame = gtk_frame_new (NULL);
	gtk_widget_set_usize (frame, 48, -1);
	gtk_frame_set_shadow_type(GTK_FRAME(frame),GTK_SHADOW_IN);
	if (popped)
		gtk_box_pack_end (GTK_BOX (hbox), frame, FALSE, FALSE, 0);
	else
		gtk_box_pack_end (GTK_BOX (infopackbox), frame, FALSE, FALSE, 0);
	gtk_widget_show (frame);

	zoomfactorlabel = gtk_label_new (zoomtext);
	gtk_container_add (GTK_CONTAINER (frame), zoomfactorlabel);
	gtk_widget_show (zoomfactorlabel);

	/* progressbar */
	progressbar = gtk_progress_bar_new();
	gtk_widget_set_usize(progressbar,150,-1);
	if (popped)
		gtk_box_pack_start (GTK_BOX (hbox), progressbar, FALSE, FALSE, 0);
	else
		gtk_box_pack_start (GTK_BOX (infopackbox), progressbar, FALSE, FALSE, 0);
	gtk_widget_show(progressbar);

	/* status label */
	frame = gtk_frame_new (NULL);
	gtk_frame_set_shadow_type(GTK_FRAME(frame),GTK_SHADOW_IN);
	gtk_widget_set_usize (frame, list_width, -1);
	if (popped)
		gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, FALSE, 0);
	else
		gtk_box_pack_start (GTK_BOX (infopackbox), frame, FALSE, FALSE, 0);
	gtk_widget_show (frame);

	statuslabel = gtk_label_new (statustext);
	gtk_container_add (GTK_CONTAINER (frame), statuslabel);
	gtk_widget_show (statuslabel);

	/* file info */
	frame = gtk_frame_new (NULL);
	gtk_frame_set_shadow_type(GTK_FRAME(frame),GTK_SHADOW_IN);
	if (popped)
		gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, FALSE, 0);
	else
		gtk_box_pack_end (GTK_BOX (infopackbox), frame, TRUE, TRUE, 0);
	gtk_widget_show (frame);

	fileinfolabel = gtk_label_new (infotext);
	gtk_container_add (GTK_CONTAINER (frame), fileinfolabel);
	gtk_widget_show (fileinfolabel);

	g_free(statustext);
	g_free(infotext);
	g_free(zoomtext);
}

static void hide_button_pressed()
{
	if (popwindow)
		{
		if (!GTK_WIDGET_VISIBLE(popwindow))
			{
			if (tool_floats)
				gtk_widget_show(popwindow);
			else
				float_window(TRUE);

			tool_hidden = FALSE;
			}
		else
			{
			gtk_widget_hide(popwindow);
			tool_hidden = TRUE;
			}
		}
	else
		{
		float_window(FALSE);
		tool_floats = FALSE;
		tool_hidden = TRUE;
		}
}

static void float_button_pressed()
{
	if (popwindow)
		{
		if (!GTK_WIDGET_VISIBLE(popwindow))
			{
			gtk_widget_show(popwindow);
			tool_floats = TRUE;
			tool_hidden = FALSE;
			}
		else
			{
			float_window(TRUE);
			tool_floats = FALSE;
			tool_hidden = FALSE;
			}
		}
	else
		{
		float_window(TRUE);
		tool_floats = TRUE;
		tool_hidden = FALSE;
		}
}

static void float_window(gint show)
{
	if (!popwindow)
		{
		GtkWidget *vbox;

		popwindow = gtk_window_new (GTK_WINDOW_TOPLEVEL);
		gtk_widget_set_usize(popwindow, -1, 450);
		gtk_signal_connect (GTK_OBJECT (popwindow), "delete_event",(GtkSignalFunc) popdestroy, NULL);
		gtk_signal_connect (GTK_OBJECT (popwindow), "key_press_event",(GtkSignalFunc) key_pressed, NULL);
		gtk_window_set_title (GTK_WINDOW (popwindow), "GQview Tools");
		gtk_container_border_width (GTK_CONTAINER (popwindow), 0);

#ifdef HAVE_GTK_1_1
		gtk_window_add_accel_group(GTK_WINDOW(popwindow),accel_table);
#else
		gtk_window_add_accelerator_table(GTK_WINDOW(popwindow),accel_table);
#endif

		vbox = gtk_vbox_new(FALSE, 0);
		gtk_container_add(GTK_CONTAINER(popwindow), vbox);
		gtk_widget_show(vbox);

		gtk_widget_reparent(popvbox, vbox);

		move_labels(FALSE, TRUE, vbox);

		gtk_widget_destroy(infopackbox);
		if (show)
			gtk_widget_show(popwindow);
		else
			gtk_widget_realize(popwindow);
		}
	else
		{
		gtk_widget_reparent(popvbox, popbox_main);

		move_labels(FALSE, FALSE, NULL);

		gtk_widget_destroy(popwindow);
		popwindow = NULL;
		}
}

void update_edit_menu()
{
	GtkWidget *menu;
	GtkWidget *button;
	int i;
	gchar s[40];
	gchar *c;

	/* main edit menu */

	menu = gtk_menu_new();
	for (i=0; i<8; i++)
		{
		if (strlen(editor_name + (i*33)) >0 && strlen(editor_command + (i*256)))
			{
			sprintf(s,"in %s...",editor_name + (i*33));
			button = gtk_menu_item_new_with_label(s);
#ifdef HAVE_GTK_1_1
			gtk_widget_add_accelerator (button, "activate", accel_table, i + 49, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);
#else
			gtk_widget_install_accelerator (button, accel_table, "activate", i + 49, GDK_CONTROL_MASK);
#endif
			c = editor_command + (i*256);
			gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) start_editor_from_image, (gpointer) c);
			gtk_menu_append(GTK_MENU(menu),button);
			gtk_widget_show(button);
			}
		}

	button = gtk_menu_item_new();
	gtk_menu_append(GTK_MENU(menu),button);
	gtk_widget_show(button);

	button = gtk_menu_item_new_with_label("Options...");
#ifdef HAVE_GTK_1_1
	gtk_widget_add_accelerator (button, "activate", accel_table, 'O', GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);
#else
	gtk_widget_install_accelerator (button, accel_table, "activate", 'O', GDK_CONTROL_MASK);
#endif
	gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) show_configuration_window, NULL);
	gtk_menu_append(GTK_MENU(menu),button);
	gtk_widget_show(button);

	button = gtk_menu_item_new_with_label("Save options");
#ifdef HAVE_GTK_1_1
	gtk_widget_add_accelerator (button, "activate", accel_table, 'S', GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);
#else
	gtk_widget_install_accelerator (button, accel_table, "activate", 'S', GDK_CONTROL_MASK);
#endif
	gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) save_options, NULL);
	gtk_menu_append(GTK_MENU(menu),button);
	gtk_widget_show(button);

	button = gtk_menu_item_new();
	gtk_menu_append(GTK_MENU(menu),button);
	gtk_widget_show(button);

	button = gtk_menu_item_new_with_label("Purge outdated thumbnails");
#ifdef HAVE_GTK_1_1
	gtk_widget_add_accelerator (button, "activate", accel_table, 'T', GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);
#else
	gtk_widget_install_accelerator (button, accel_table, "activate", 'T', GDK_CONTROL_MASK);
#endif
	gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) maintain_thumb_cb, NULL);
	gtk_menu_append(GTK_MENU(menu),button);
	gtk_widget_show(button);

	gtk_menu_item_set_submenu(GTK_MENU_ITEM(menu_edit),menu);

	/* image popup edit menu */

	menu = gtk_menu_new();
	for (i=0; i<8; i++)
		{
		if (strlen(editor_name + (i*33)) >0 && strlen(editor_command + (i*256)))
			{
			sprintf(s,"in %s...",editor_name + (i*33));
			button = gtk_menu_item_new_with_label(s);
			c = editor_command + (i*256);
			gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) start_editor_from_image, (gpointer) c);
			gtk_menu_append(GTK_MENU(menu),button);
			gtk_widget_show(button);
			}
		}
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(image_popup_edit_submenu),menu);

	/* filelist popup edit menu */

	menu = gtk_menu_new();
	for (i=0; i<8; i++)
		{
		if (strlen(editor_name + (i*33)) >0 && strlen(editor_command + (i*256)))
			{
			sprintf(s,"in %s...",editor_name + (i*33));
			button = gtk_menu_item_new_with_label(s);
			c = editor_command + (i*256);
			gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) start_editor_from_list, (gpointer) c);
			gtk_menu_append(GTK_MENU(menu),button);
			gtk_widget_show(button);
			}
		}
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(filelist_popup_edit_submenu),menu);
}

void create_main_window()
{
	GtkWidget *pixmapwid;
	GdkPixmap *pixmap;
	GdkBitmap *mask;
	GtkStyle *style;
	GtkObject *h_adj;
	GtkObject *v_adj;
	GtkWidget *hbox;
	GtkWidget *button;
	GtkWidget *menu;
	GtkTooltips *tooltips;

	GdkColormap *colormap;
	static GdkColor tooltip_color = { 0, 0xffff, 0xf9f9, 0xcbcb };
	/*255 249 203*/
	
	gchar *dir_title [] = { "Directories:", };
	gchar *file_title [] = { "Files:", };

	/* set up main window */
	mainwindow = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_window_set_policy(GTK_WINDOW(mainwindow), TRUE, TRUE, FALSE);

	gtk_signal_connect (GTK_OBJECT (mainwindow), "delete_event",(GtkSignalFunc) destroy, NULL);
	gtk_signal_connect (GTK_OBJECT (mainwindow), "key_press_event",(GtkSignalFunc) key_pressed, NULL);
	gtk_widget_set_usize (mainwindow, mainwindow_width, mainwindow_height);
	gtk_window_set_title (GTK_WINDOW (mainwindow), "GQview");
	gtk_container_border_width (GTK_CONTAINER (mainwindow), 0);
#ifdef HAVE_GTK_1_1
	accel_table = gtk_accel_group_new ();
	gtk_window_add_accel_group(GTK_WINDOW(mainwindow),accel_table);
#else
	accel_table = gtk_accelerator_table_new ();
	gtk_window_add_accelerator_table(GTK_WINDOW(mainwindow),accel_table);
#endif

	gtk_widget_realize(mainwindow);

	/* create a tooltip widget */
	tooltips = gtk_tooltips_new();
	colormap = gdk_window_get_colormap (mainwindow->window);
	gdk_color_alloc (colormap, &tooltip_color);
	gtk_tooltips_set_colors(tooltips, &tooltip_color, 
				&mainwindow->style->fg[GTK_STATE_NORMAL]);

	/* create main pack box */
	mainbox = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (mainwindow), mainbox);
	gtk_widget_show (mainbox);

	/* pack in the info labels */
	move_labels(TRUE, FALSE, NULL);

	/* create sub pack box */
	hbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (mainbox), hbox, TRUE, TRUE, 0);
	gtk_widget_show (hbox);

	/* create box for left */
	popbox_main = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (hbox), popbox_main, FALSE, FALSE, 0);
	gtk_widget_show (popbox_main);

	popvbox = gtk_vbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (popbox_main), popvbox, FALSE, FALSE, 0);
	gtk_widget_show (popvbox);

	/* menus */

	menu_bar = gtk_menu_bar_new();
	gtk_box_pack_start (GTK_BOX(popvbox),menu_bar,FALSE,FALSE,0);
	gtk_widget_show(menu_bar);

	/* file menu */

	menu = gtk_menu_new();

	menu_file = gtk_menu_item_new_with_label("File");
	gtk_widget_show(menu_file);

	button = gtk_menu_item_new_with_label("Create Dir...");
#ifdef HAVE_GTK_1_1
	gtk_widget_add_accelerator (button, "activate", accel_table,  'N', GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);
	/* last argument is  GtkAccelFlags        accel_flags */
#else
	gtk_widget_install_accelerator (button, accel_table, "activate", 'N', GDK_CONTROL_MASK);
#endif
	gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) dir_create_dialog, NULL);
	gtk_menu_append(GTK_MENU(menu),button);
	gtk_widget_show(button);

	button = gtk_menu_item_new();
	gtk_menu_append(GTK_MENU(menu),button);
	gtk_widget_show(button);

	button = gtk_menu_item_new_with_label("Copy...");
#ifdef HAVE_GTK_1_1
	gtk_widget_add_accelerator (button, "activate", accel_table, 'C', GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);
#else
	gtk_widget_install_accelerator (button, accel_table, "activate", 'C', GDK_CONTROL_MASK);
#endif
	gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) copy_file_from_image, NULL);
	gtk_menu_append(GTK_MENU(menu),button);
	gtk_widget_show(button);

	button = gtk_menu_item_new_with_label("Move...");
#ifdef HAVE_GTK_1_1
	gtk_widget_add_accelerator (button, "activate", accel_table, 'M', GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);
#else
	gtk_widget_install_accelerator (button, accel_table, "activate", 'M', GDK_CONTROL_MASK);
#endif
	gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) move_file_from_image, NULL);
	gtk_menu_append(GTK_MENU(menu),button);
	gtk_widget_show(button);

	button = gtk_menu_item_new_with_label("Rename...");
#ifdef HAVE_GTK_1_1
	gtk_widget_add_accelerator (button, "activate", accel_table, 'R', GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);
#else
	gtk_widget_install_accelerator (button, accel_table, "activate", 'R', GDK_CONTROL_MASK);
#endif
	gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) rename_file_from_image, NULL);
	gtk_menu_append(GTK_MENU(menu),button);
	gtk_widget_show(button);

	button = gtk_menu_item_new_with_label("Delete...");
#ifdef HAVE_GTK_1_1
	gtk_widget_add_accelerator (button, "activate", accel_table, 'D', GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);
#else
	gtk_widget_install_accelerator (button, accel_table, "activate", 'D', GDK_CONTROL_MASK);
#endif
	gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) delete_file_from_image, NULL);
	gtk_menu_append(GTK_MENU(menu),button);
	gtk_widget_show(button);

	button = gtk_menu_item_new();
	gtk_menu_append(GTK_MENU(menu),button);
	gtk_widget_show(button);

	button = gtk_menu_item_new_with_label("Quit");
#ifdef HAVE_GTK_1_1
	gtk_widget_add_accelerator (button, "activate", accel_table, 'Q', GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);
#else
	gtk_widget_install_accelerator (button, accel_table, "activate", 'Q', GDK_CONTROL_MASK);
#endif
	gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) destroy, NULL);
	gtk_menu_append(GTK_MENU(menu),button);
	gtk_widget_show(button);

	gtk_menu_item_set_submenu(GTK_MENU_ITEM(menu_file),menu);
	gtk_menu_bar_append(GTK_MENU_BAR(menu_bar),menu_file);

	/* edit menu */
	/* this menu is rewritten by the update_edit_menu() routine */
	/* it is left empty here */

	menu = gtk_menu_new();

	menu_edit = gtk_menu_item_new_with_label("Edit");
	gtk_widget_show(menu_edit);

	gtk_menu_item_set_submenu(GTK_MENU_ITEM(menu_edit),menu);
	gtk_menu_bar_append(GTK_MENU_BAR(menu_bar),menu_edit);

	/* view menu */

	menu = gtk_menu_new();

	menu_view = gtk_menu_item_new_with_label("View");
	gtk_widget_show(menu_view);

	button = gtk_menu_item_new_with_label("Zoom in");
#ifdef HAVE_GTK_1_1
	gtk_widget_add_accelerator (button, "activate", accel_table, '=', FALSE, GTK_ACCEL_VISIBLE);
#else
	gtk_widget_install_accelerator (button, accel_table, "activate", '=', FALSE);
#endif
	gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) zoom_image_in, NULL);
	gtk_menu_append(GTK_MENU(menu),button);
	gtk_widget_show(button);

	button = gtk_menu_item_new_with_label("Zoom out");
#ifdef HAVE_GTK_1_1
	gtk_widget_add_accelerator (button, "activate", accel_table, '-', FALSE, GTK_ACCEL_VISIBLE);
#else
	gtk_widget_install_accelerator (button, accel_table, "activate", '-', FALSE);
#endif
	gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) zoom_image_out, NULL);
	gtk_menu_append(GTK_MENU(menu),button);
	gtk_widget_show(button);

	button = gtk_menu_item_new_with_label("Zoom 1:1");
#ifdef HAVE_GTK_1_1
	gtk_widget_add_accelerator (button, "activate", accel_table, 'Z', FALSE, GTK_ACCEL_VISIBLE );
#else
	gtk_widget_install_accelerator (button, accel_table, "activate", 'Z', FALSE);
#endif
	gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) zoom_image_norm, NULL);
	gtk_menu_append(GTK_MENU(menu),button);
	gtk_widget_show(button);

	button = gtk_menu_item_new_with_label("Fit image to window");
#ifdef HAVE_GTK_1_1
	gtk_widget_add_accelerator (button, "activate", accel_table, 'X', FALSE, GTK_ACCEL_VISIBLE);
#else
	gtk_widget_install_accelerator (button, accel_table, "activate", 'X', FALSE);
#endif
	gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) zoom_image_fit, NULL);
	gtk_menu_append(GTK_MENU(menu),button);
	gtk_widget_show(button);

	button = gtk_menu_item_new();
	gtk_menu_append(GTK_MENU(menu),button);
	gtk_widget_show(button);

	thumb_menu_item = gtk_check_menu_item_new_with_label("Thumbnails");
#ifdef HAVE_GTK_1_1
	gtk_widget_add_accelerator (thumb_menu_item, "activate", accel_table, 'T', FALSE, GTK_ACCEL_VISIBLE);
#else
	gtk_widget_install_accelerator (thumb_menu_item, accel_table, "activate", 'T', FALSE);
#endif
	gtk_signal_connect (GTK_OBJECT (thumb_menu_item), "activate",(GtkSignalFunc) thumb_menu_item_clicked, thumb_menu_item);
	gtk_menu_append(GTK_MENU(menu),thumb_menu_item);
	gtk_widget_show(thumb_menu_item);

	button = gtk_menu_item_new();
	gtk_menu_append(GTK_MENU(menu),button);
	gtk_widget_show(button);

	button = gtk_menu_item_new_with_label("Refresh Lists");
#ifdef HAVE_GTK_1_1
	gtk_widget_add_accelerator (button, "activate", accel_table, 'R', FALSE, GTK_ACCEL_VISIBLE);
#else
	gtk_widget_install_accelerator (button, accel_table, "activate", 'R', FALSE);
#endif
	gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) refresh_dir, NULL);
	gtk_menu_append(GTK_MENU(menu),button);
	gtk_widget_show(button);

	button = gtk_menu_item_new_with_label("(Un)Float file list");
#ifdef HAVE_GTK_1_1
	gtk_widget_add_accelerator (button, "activate", accel_table, 'F', FALSE, GTK_ACCEL_VISIBLE);
#else
	gtk_widget_install_accelerator (button, accel_table, "activate", 'F', FALSE);
#endif
	gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) float_button_pressed, NULL);
	gtk_menu_append(GTK_MENU(menu),button);
	gtk_widget_show(button);

	button = gtk_menu_item_new_with_label("(Un)Hide file list");
#ifdef HAVE_GTK_1_1
	gtk_widget_add_accelerator (button, "activate", accel_table, 'H', FALSE, GTK_ACCEL_VISIBLE);
#else
	gtk_widget_install_accelerator (button, accel_table, "activate", 'H', FALSE);
#endif
	gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) hide_button_pressed, NULL);
	gtk_menu_append(GTK_MENU(menu),button);
	gtk_widget_show(button);

	gtk_menu_item_set_submenu(GTK_MENU_ITEM(menu_view),menu);
	gtk_menu_bar_append(GTK_MENU_BAR(menu_bar),menu_view);

	/* help menu */

	menu = gtk_menu_new();

	menu_help = gtk_menu_item_new_with_label("Help");
	gtk_menu_item_right_justify(GTK_MENU_ITEM(menu_help));
	gtk_widget_show(menu_help);

	button = gtk_menu_item_new_with_label("About...");
	gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) show_about_info, NULL);
	gtk_menu_append(GTK_MENU(menu),button);
	gtk_widget_show(button);

	gtk_menu_item_set_submenu(GTK_MENU_ITEM(menu_help),menu);
	gtk_menu_bar_append(GTK_MENU_BAR(menu_bar),menu_help);

	/* filelist popup menu */
	menu_filelist_popup = gtk_menu_new();

	filelist_popup_edit_submenu = gtk_menu_item_new_with_label("Edit");
	gtk_menu_append(GTK_MENU(menu_filelist_popup),filelist_popup_edit_submenu);
	gtk_widget_show(filelist_popup_edit_submenu);

	button = gtk_menu_item_new();
	gtk_menu_append(GTK_MENU(menu_filelist_popup),button);
	gtk_widget_show(button);

	button = gtk_menu_item_new_with_label("Copy...");
	gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) copy_file_from_list, NULL);
	gtk_menu_append(GTK_MENU(menu_filelist_popup),button);
	gtk_widget_show(button);

	button = gtk_menu_item_new_with_label("Move...");
	gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) move_file_from_list, NULL);
	gtk_menu_append(GTK_MENU(menu_filelist_popup),button);
	gtk_widget_show(button);

	button = gtk_menu_item_new_with_label("Rename...");
	gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) rename_file_from_list, NULL);
	gtk_menu_append(GTK_MENU(menu_filelist_popup),button);
	gtk_widget_show(button);

	button = gtk_menu_item_new_with_label("Delete...");
	gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) delete_file_from_list, NULL);
	gtk_menu_append(GTK_MENU(menu_filelist_popup),button);
	gtk_widget_show(button);

	button = gtk_menu_item_new();
	gtk_menu_append(GTK_MENU(menu_filelist_popup),button);
	gtk_widget_show(button);

	button = gtk_menu_item_new_with_label("Refresh");
	gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) refresh_dir, NULL);
	gtk_menu_append(GTK_MENU(menu_filelist_popup),button);
	gtk_widget_show(button);

	/* image popup menu */
	menu_image_popup = gtk_menu_new();

	button = gtk_menu_item_new_with_label("Next Image");
#ifdef HAVE_GTK_1_1
	gtk_widget_add_accelerator (button, "activate", accel_table, ']', FALSE, GTK_ACCEL_VISIBLE);
#else
	gtk_widget_install_accelerator (button, accel_table, "activate", ']', FALSE);
#endif
	gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) select_next_image, NULL);
	gtk_menu_append(GTK_MENU(menu_image_popup),button);
	gtk_widget_show(button);

	button = gtk_menu_item_new_with_label("Previous Image");
#ifdef HAVE_GTK_1_1
	gtk_widget_add_accelerator (button, "activate", accel_table, '[', FALSE, GTK_ACCEL_VISIBLE);
#else
	gtk_widget_install_accelerator (button, accel_table, "activate", '[', FALSE);
#endif
	gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) select_prev_image, NULL);
	gtk_menu_append(GTK_MENU(menu_image_popup),button);
	gtk_widget_show(button);

	button = gtk_menu_item_new();
	gtk_menu_append(GTK_MENU(menu_image_popup),button);
	gtk_widget_show(button);

	button = gtk_menu_item_new_with_label("Zoom in");
	gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) zoom_image_in, NULL);
	gtk_menu_append(GTK_MENU(menu_image_popup),button);
	gtk_widget_show(button);

	button = gtk_menu_item_new_with_label("Zoom out");
	gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) zoom_image_out, NULL);
	gtk_menu_append(GTK_MENU(menu_image_popup),button);
	gtk_widget_show(button);

	button = gtk_menu_item_new_with_label("Zoom 1:1");
	gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) zoom_image_norm, NULL);
	gtk_menu_append(GTK_MENU(menu_image_popup),button);
	gtk_widget_show(button);

	button = gtk_menu_item_new_with_label("Fit image to window");
	gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) zoom_image_fit, NULL);
	gtk_menu_append(GTK_MENU(menu_image_popup),button);
	gtk_widget_show(button);

	button = gtk_menu_item_new();
	gtk_menu_append(GTK_MENU(menu_image_popup),button);
	gtk_widget_show(button);

	image_popup_edit_submenu = gtk_menu_item_new_with_label("Edit");
	gtk_menu_append(GTK_MENU(menu_image_popup),image_popup_edit_submenu);
	gtk_widget_show(image_popup_edit_submenu);

	button = gtk_menu_item_new();
	gtk_menu_append(GTK_MENU(menu_image_popup),button);
	gtk_widget_show(button);

	button = gtk_menu_item_new_with_label("Copy...");
	gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) copy_file_from_image, NULL);
	gtk_menu_append(GTK_MENU(menu_image_popup),button);
	gtk_widget_show(button);
	
	button = gtk_menu_item_new_with_label("Move...");
	gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) move_file_from_image, NULL);
	gtk_menu_append(GTK_MENU(menu_image_popup),button);
	gtk_widget_show(button);
	
	button = gtk_menu_item_new_with_label("Rename...");
	gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) rename_file_from_image, NULL);
	gtk_menu_append(GTK_MENU(menu_image_popup),button);
	gtk_widget_show(button);
	
	button = gtk_menu_item_new_with_label("Delete...");
	gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) delete_file_from_image, NULL);
	gtk_menu_append(GTK_MENU(menu_image_popup),button);
	gtk_widget_show(button);

	button = gtk_menu_item_new();
	gtk_menu_append(GTK_MENU(menu_image_popup),button);
	gtk_widget_show(button);

	button = gtk_menu_item_new_with_label("(Un)Hide file list");
	gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) hide_button_pressed, NULL);
	gtk_menu_append(GTK_MENU(menu_image_popup),button);
	gtk_widget_show(button);
	
	/* create box for dir buttons */
	hboxdir = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (popvbox), hboxdir, FALSE, FALSE, 0);
	gtk_widget_show (hboxdir);

	/* button bar -  thumbnails */
	
	thumb_button = gtk_toggle_button_new ();
	gtk_signal_connect (GTK_OBJECT (thumb_button), "clicked",(GtkSignalFunc) thumb_button_clicked, thumb_button);
	gtk_box_pack_start (GTK_BOX (hboxdir), thumb_button, FALSE, FALSE,0);
	gtk_widget_show (thumb_button);
	gtk_tooltips_set_tip (tooltips, thumb_button, "Create thumbnails", NULL);

	style = gtk_widget_get_style(mainwindow);
	pixmap = gdk_pixmap_create_from_xpm_d( mainwindow->window,  &mask,
			 &style->bg[GTK_STATE_NORMAL], (gchar **)icon_thumb_xpm );
	pixmapwid = gtk_pixmap_new( pixmap, mask );
	gtk_widget_show( pixmapwid );
	gtk_container_add( GTK_CONTAINER(thumb_button), pixmapwid );

	/* button bar -  home */
	
	button = gtk_button_new ();
	gtk_signal_connect (GTK_OBJECT (button), "clicked",(GtkSignalFunc) change_dir_to_home, NULL);
	gtk_box_pack_start (GTK_BOX (hboxdir), button, FALSE, FALSE,0);
	gtk_widget_show (button);
	gtk_tooltips_set_tip (tooltips, button, "Change to home directory", NULL);

	style = gtk_widget_get_style(mainwindow);
	pixmap = gdk_pixmap_create_from_xpm_d( mainwindow->window,  &mask,
			 &style->bg[GTK_STATE_NORMAL], (gchar **)icon_home_xpm );
	pixmapwid = gtk_pixmap_new( pixmap, mask );
	gtk_widget_show( pixmapwid );
	gtk_container_add( GTK_CONTAINER(button), pixmapwid );

	/* button bar -  refresh */
	
	button = gtk_button_new ();
	gtk_signal_connect (GTK_OBJECT (button), "clicked",(GtkSignalFunc) refresh_dir, NULL);
	gtk_box_pack_start (GTK_BOX (hboxdir), button, FALSE, FALSE,0);
	gtk_widget_show (button);
	gtk_tooltips_set_tip (tooltips, button, "Refresh file list", NULL);

	style = gtk_widget_get_style(mainwindow);
	pixmap = gdk_pixmap_create_from_xpm_d( mainwindow->window,  &mask,
			 &style->bg[GTK_STATE_NORMAL], (gchar **)icon_reload_xpm );
	pixmapwid = gtk_pixmap_new( pixmap, mask );
	gtk_widget_show( pixmapwid );
	gtk_container_add( GTK_CONTAINER(button), pixmapwid );

	/* button bar -  zoom in */
	
	button = gtk_button_new ();
	gtk_signal_connect (GTK_OBJECT (button), "clicked",(GtkSignalFunc) zoom_image_in, NULL);
	gtk_box_pack_start (GTK_BOX (hboxdir), button, FALSE, FALSE,0);
	gtk_widget_show (button);
	gtk_tooltips_set_tip (tooltips, button, "Zoom in", NULL);

	style = gtk_widget_get_style(mainwindow);
	pixmap = gdk_pixmap_create_from_xpm_d( mainwindow->window,  &mask,
			 &style->bg[GTK_STATE_NORMAL], (gchar **)icon_zoom_in_xpm );
	pixmapwid = gtk_pixmap_new( pixmap, mask );
	gtk_widget_show( pixmapwid );
	gtk_container_add( GTK_CONTAINER(button), pixmapwid );

	/* button bar -  zoom out */
	
	button = gtk_button_new ();
	gtk_signal_connect (GTK_OBJECT (button), "clicked",(GtkSignalFunc) zoom_image_out, NULL);
	gtk_box_pack_start (GTK_BOX (hboxdir), button, FALSE, FALSE,0);
	gtk_widget_show (button);
	gtk_tooltips_set_tip (tooltips, button, "Zoom out", NULL);

	style = gtk_widget_get_style(mainwindow);
	pixmap = gdk_pixmap_create_from_xpm_d( mainwindow->window,  &mask,
			 &style->bg[GTK_STATE_NORMAL], (gchar **)icon_zoom_out_xpm );
	pixmapwid = gtk_pixmap_new( pixmap, mask );
	gtk_widget_show( pixmapwid );
	gtk_container_add( GTK_CONTAINER(button), pixmapwid );

	/* button bar -  zoom fit */
	
	button = gtk_button_new ();
	gtk_signal_connect (GTK_OBJECT (button), "clicked",(GtkSignalFunc) zoom_image_fit, NULL);
	gtk_box_pack_start (GTK_BOX (hboxdir), button, FALSE, FALSE,0);
	gtk_widget_show (button);
	gtk_tooltips_set_tip (tooltips, button, "Fit image to window", NULL);

	style = gtk_widget_get_style(mainwindow);
	pixmap = gdk_pixmap_create_from_xpm_d( mainwindow->window,  &mask,
			 &style->bg[GTK_STATE_NORMAL], (gchar **)icon_zoom_fit_xpm );
	pixmapwid = gtk_pixmap_new( pixmap, mask );
	gtk_widget_show( pixmapwid );
	gtk_container_add( GTK_CONTAINER(button), pixmapwid );

	/* button bar -  zoom norm */
	
	button = gtk_button_new ();
	gtk_signal_connect (GTK_OBJECT (button), "clicked",(GtkSignalFunc) zoom_image_norm, NULL);
	gtk_box_pack_start (GTK_BOX (hboxdir), button, FALSE, FALSE,0);
	gtk_widget_show (button);
	gtk_tooltips_set_tip (tooltips, button, "Set zoom 1:1", NULL);

	style = gtk_widget_get_style(mainwindow);
	pixmap = gdk_pixmap_create_from_xpm_d( mainwindow->window,  &mask,
			 &style->bg[GTK_STATE_NORMAL], (gchar **)icon_zoom_norm_xpm );
	pixmapwid = gtk_pixmap_new( pixmap, mask );
	gtk_widget_show( pixmapwid );
	gtk_container_add( GTK_CONTAINER(button), pixmapwid );

	/* button bar -  config */
	
	button = gtk_button_new ();
	gtk_signal_connect (GTK_OBJECT (button), "clicked",(GtkSignalFunc) show_configuration_window, NULL);
	gtk_box_pack_start (GTK_BOX (hboxdir), button, FALSE, FALSE,0);
	gtk_widget_show (button);
	gtk_tooltips_set_tip (tooltips, button, "Configure options", NULL);

	style = gtk_widget_get_style(mainwindow);
	pixmap = gdk_pixmap_create_from_xpm_d( mainwindow->window,  &mask,
			 &style->bg[GTK_STATE_NORMAL], (gchar **)icon_config_xpm );
	pixmapwid = gtk_pixmap_new( pixmap, mask );
	gtk_widget_show( pixmapwid );
	gtk_container_add( GTK_CONTAINER(button), pixmapwid );

	/* button bar -  float */
	button = gtk_button_new();
	gtk_signal_connect (GTK_OBJECT (button), "clicked",(GtkSignalFunc) float_button_pressed, NULL);
	gtk_box_pack_start (GTK_BOX (hboxdir), button, FALSE, FALSE,0);
	gtk_widget_show (button);
	gtk_tooltips_set_tip (tooltips, button, "Float Controls", NULL);

	style = gtk_widget_get_style(mainwindow);
	pixmap = gdk_pixmap_create_from_xpm_d( mainwindow->window,  &mask,
			 &style->bg[GTK_STATE_NORMAL], (gchar **)icon_float_xpm );
	pixmapwid = gtk_pixmap_new( pixmap, mask );
	gtk_widget_show( pixmapwid );
	gtk_container_add( GTK_CONTAINER(button), pixmapwid );

	/* history button */
	historypulldown = gtk_option_menu_new ();
	gtk_box_pack_start (GTK_BOX (popvbox), historypulldown, FALSE, FALSE,0);
	gtk_widget_show (historypulldown);

	/* panes for lists */
	vpaned = gtk_vpaned_new ();
	gtk_paned_handle_size (GTK_PANED(vpaned), 10);
	gtk_paned_gutter_size (GTK_PANED(vpaned), 10);
	gtk_box_pack_start (GTK_BOX (popvbox), vpaned, TRUE, TRUE, 0);
	gtk_widget_show (vpaned);

	/* directory list */
	dirlist_clist=gtk_clist_new_with_titles (1, dir_title);
	gtk_signal_connect (GTK_OBJECT (dirlist_clist), "select_row",(GtkSignalFunc) change_dir, NULL);
	gtk_clist_set_policy (GTK_CLIST (dirlist_clist), GTK_POLICY_ALWAYS, GTK_POLICY_AUTOMATIC); 
	gtk_clist_column_titles_passive (GTK_CLIST (dirlist_clist)); 
	gtk_widget_set_usize(dirlist_clist,-1,144);
	gtk_paned_add1 (GTK_PANED(vpaned), dirlist_clist);
	gtk_widget_show (dirlist_clist);

	/* file list */
	filelist_clist=gtk_clist_new_with_titles (1, file_title);
	gtk_signal_connect (GTK_OBJECT (filelist_clist), "button_press_event",(GtkSignalFunc) change_file, NULL);
	gtk_clist_set_policy (GTK_CLIST (filelist_clist), GTK_POLICY_ALWAYS, GTK_POLICY_AUTOMATIC); 
	gtk_clist_column_titles_passive (GTK_CLIST (filelist_clist)); 
	gtk_paned_add2 (GTK_PANED(vpaned), filelist_clist);
	gtk_widget_show (filelist_clist);

	/* event box */
	eventbox = gtk_event_box_new();
	gtk_box_pack_start (GTK_BOX (hbox), eventbox, TRUE, TRUE, 0);
	gtk_widget_show(eventbox);

	gtk_signal_connect(GTK_OBJECT(eventbox),"motion_notify_event",GTK_SIGNAL_FUNC(imagewindow_moved),NULL);
	gtk_signal_connect(GTK_OBJECT(eventbox),"button_press_event",GTK_SIGNAL_FUNC(imagewindow_pressed),NULL);
	gtk_signal_connect(GTK_OBJECT(eventbox),"button_release_event",GTK_SIGNAL_FUNC(imagewindow_released),NULL);
	gtk_widget_set_events(eventbox, GDK_POINTER_MOTION_MASK | GDK_BUTTON_RELEASE_MASK | GDK_BUTTON_PRESS_MASK);

	/* viewer */
	h_adj = gtk_adjustment_new(0.0,0.0,0.0,1.0,1.0,1.0);
	v_adj = gtk_adjustment_new(0.0,0.0,0.0,1.0,1.0,1.0);

	viewwindow = gtk_viewport_new (GTK_ADJUSTMENT(h_adj), GTK_ADJUSTMENT(v_adj));
	gtk_container_add(GTK_CONTAINER(eventbox), viewwindow);
	gtk_widget_show (viewwindow);

	/* table for resize */
	viewtable= gtk_table_new (1,1,TRUE);
	gtk_container_add(GTK_CONTAINER (viewwindow),viewtable);
	gtk_widget_show (viewtable);

	/* imagewindow */
	imagewindow = gtk_drawing_area_new();
	gtk_table_attach(GTK_TABLE (viewtable),imagewindow,0,1,0,1,GTK_EXPAND,GTK_EXPAND,0,0);

	gtk_widget_show (imagewindow);

	/* restore tool condition */
	if (restore_tool)
		{
		if (tool_hidden)
			hide_button_pressed();
		else if (tool_floats)
			float_button_pressed();
		}

	/* show main window */
	gtk_widget_show (mainwindow);
}
