/*###################################################################*/
/*##                          GQview 0.4.3                         ##*/
/*##       This software is Copyright (C) 1998 by John Ellis.      ##*/
/*## This software falls under the GNU Public License. Please read ##*/
/*##              the COPYING file for more information            ##*/
/*###################################################################*/

#include "gqview.h"

static int list_compare_func(const void *a, const void *b);
static GList *sort_glist(GList *list);

static int list_compare_func(const void *a, const void *b)
{
	return strcmp (*(gchar **)a, *(gchar **)b);
}

static GList *sort_glist(GList *list)
{
	GList *list_t;
	gchar **list_ptrs;
	int list_length;
	int i;

	if (!list) return NULL;

	list_length = g_list_length(list);
	list_ptrs = g_malloc (sizeof(gchar *) * list_length);
	list_t = list;

	for (i = 0; i < list_length; i++)
		{
		list_ptrs[i] = list_t->data;
		list_t = list_t->next;
		}

	g_list_free (list);
	list = NULL;

	qsort (list_ptrs, list_length, sizeof(gchar *), list_compare_func);

	while (list_length > 0)
		{
		list_length--;
		list = g_list_prepend (list, list_ptrs[list_length]);
		}

	g_free (list_ptrs);
	return list;
}

void filelist_init()
{
	filelist = NULL;
	filelist_count = 0;
}

void filelist_clear()
{
	if (filelist)
		{
		GList *list;
		list = filelist;
		while (list)
			{
			g_free(list->data);
			list = list->next;
			}
		g_list_free(filelist);
		filelist = NULL;
		}
	filelist_init();
}

void filelist_add_item(gchar *fn)
{
	filelist = g_list_append(filelist, g_strdup(fn));
	filelist_count++;
}

void filelist_insert_item(gchar *fn, gint n)
{
	if (n >= filelist_count)
		{
		filelist = g_list_append(filelist, g_strdup(fn));
		filelist_count++;
		return;
		}
	filelist = g_list_insert(filelist, strdup(fn), n);
	filelist_count++;
}

void filelist_remove_item(gint n)
{
	GList *list;
	if (n >= filelist_count) return;
	list = g_list_nth(filelist,n);
	filelist = g_list_remove(filelist,list->data);
	filelist_count--;
	g_free(list->data);
}

void filelist_swap_items(gint n1, gint n2)
{
	GList *list1;
	GList *list2;
	if (n1 >= filelist_count || n2 >= filelist_count) return;
	list1 =  g_list_nth(filelist,n2);
	list2 =  g_list_nth(filelist,n1);
	filelist = g_list_remove(filelist,list1->data);
	filelist = g_list_insert(filelist,list1->data, n1);
	filelist = g_list_remove(filelist,list2->data);
	filelist = g_list_insert(filelist,list2->data, n2);
}

void filelist_sort()
{
	filelist = sort_glist(filelist);
}

gchar *filelist_get_item(gint n)
{
	GList *list;
	if (n >= filelist_count) return '\0';
	list = g_list_nth(filelist, n);
	return list->data;
}

void dirlist_init()
{
	dirlist = NULL;
	dirlist_count = 0;
}

void dirlist_clear()
{
	if (dirlist)
		{
		GList *list;
		list = dirlist;
		while (list)
			{
			g_free(list->data);
			list = list->next;
			}
		g_list_free(dirlist);
		dirlist = NULL;
		}
	dirlist_init();
}

void dirlist_add_item(gchar *fn)
{
	dirlist = g_list_append(dirlist, g_strdup(fn));
	dirlist_count++;
}

void dirlist_insert_item(gchar *fn, gint n)
{
	if (n >= dirlist_count)
		{
		dirlist = g_list_append(dirlist, g_strdup(fn));
		dirlist_count++;
		return;
		}
	dirlist = g_list_insert(dirlist, strdup(fn), n);
	dirlist_count++;
}

void dirlist_remove_item(gint n)
{
	GList *list;
	if (n >= dirlist_count) return;
	list = g_list_nth(dirlist,n);
	dirlist = g_list_remove(dirlist,list->data);
	dirlist_count--;
	g_free(list->data);
}

void dirlist_swap_items(gint n1, gint n2)
{
	GList *list1;
	GList *list2;
	if (n1 >= dirlist_count || n2 >= dirlist_count) return;
	list1 =  g_list_nth(dirlist,n2);
	list2 =  g_list_nth(dirlist,n1);
	dirlist = g_list_remove(dirlist,list1->data);
	dirlist = g_list_insert(dirlist,list1->data, n1);
	dirlist = g_list_remove(dirlist,list2->data);
	dirlist = g_list_insert(dirlist,list2->data, n2);
}

void dirlist_sort()
{
	dirlist = sort_glist(dirlist);
}

gchar *dirlist_get_item(gint n)
{
	GList *list;
	if (n >= dirlist_count) return '\0';
	list = g_list_nth(dirlist, n);
	return list->data;
}


