/*###################################################################*/
/*##                          GQview 0.4.3                         ##*/
/*##       This software is Copyright (C) 1998 by John Ellis.      ##*/
/*## This software falls under the GNU Public License. Please read ##*/
/*##              the COPYING file for more information            ##*/
/*###################################################################*/

#include <dirent.h>
#include <pwd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <time.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <gdk_imlib.h>

	/* definitions */
#define GQVIEW_VERSION_MAJOR 0
#define GQVIEW_VERSION_MINOR 4
#define GQVIEW_VERSION_REV 3
#define list_width 182
#define list_height 180
#define mainwindow_width 600
#define mainwindow_height 400
#define foreground_color 0
#define background_color 255
#define THUMBNAIL_CACHE_DIR "/.gqview_thmb"

	/* pixmaps */
extern gchar  **img_unknown_xpm_data;

	/* main window widgets */
extern GtkWidget *mainwindow;
extern GtkWidget *mainbox;
extern GtkWidget *infopackbox;
extern GtkWidget *hboxdir;
extern GtkWidget *viewtable;
extern GtkWidget *viewwindow;
extern GtkWidget *imagewindow;
extern GtkWidget *filelist_clist;
extern GtkWidget *dirlist_clist;
extern GtkWidget *fileinfolabel;
extern GtkWidget *progressbar;
extern GtkWidget *zoomfactorlabel;
extern GtkWidget *statuslabel;
extern GtkWidget *historypulldown;
extern GtkWidget *historymenu;
extern GtkWidget *thumb_menu_item;
extern GtkWidget *thumb_button;

extern GtkWidget *menu_bar;
extern GtkWidget *menu_file;
extern GtkWidget *menu_edit;
extern GtkWidget *menu_view;
extern GtkWidget *menu_help;
extern GtkWidget *menu_image_popup;
extern GtkWidget *image_popup_edit_submenu;
extern GtkWidget *menu_filelist_popup;
extern GtkWidget *filelist_popup_edit_submenu;
extern GtkWidget *vpaned;

extern GtkWidget *popwindow;
extern GtkWidget *popbox_main;
extern GtkWidget *popvbox;

extern GtkWidget *eventbox;

	/* images */
extern GdkPixmap *logo_pixmap;
extern GdkPixmap *image_pixmap;
extern GdkImlibImage *image;

	/* variables */
	/* file lists */
extern GList *filelist;
extern gint filelist_count;
extern gint filelist_pos;
extern GList *dirlist;
extern gint dirlist_count;
extern gint dirlist_pos;

	/* filtering */
extern gchar FILTER[];
extern gint FILTERING_DISABLE;
extern gint DOT_FILES;
extern gchar CUSTOM_FILTER[];


	/* built-in filters */
extern gint FILTER_INCLUDE_PPM;
extern gint FILTER_INCLUDE_PNG;
extern gint FILTER_INCLUDE_JPG;
extern gint FILTER_INCLUDE_TIF;
extern gint FILTER_INCLUDE_PGM;
extern gint FILTER_INCLUDE_XPM;
extern gint FILTER_INCLUDE_GIF;
extern gint FILTER_INCLUDE_PCX;
extern gint FILTER_INCLUDE_BMP;

	/* zoom modes */
extern gint ZOOM;
extern gint ZOOM_MODE;

	/* miscellaneous */
extern gint ENABLE_THUMB_CACHING;
extern gint STARTUP_PATH_ENABLE;
extern gchar STARTUP_PATH[];
extern gchar current_dir[];
extern gchar current_file[];
extern gchar current_path[];
extern gchar image_file_name[];
extern gchar image_dir_name[];
extern gchar editor_name[];
extern gchar editor_command[];
extern gint thumbnail_mode;
extern int thumb_max_width;
extern int thumb_max_height;
extern int debug_mode;
extern gint confirm_delete;

extern gint tool_floats;
extern gint tool_hidden;
extern gint restore_tool;
extern gint fit_window;
extern gint limit_window_size;
extern gint max_window_size;
extern gint save_on_exit;

	/* logo */
extern unsigned char logodata[];

	/* main.c routines */
void set_zoom_label(gint z, gfloat f);
void zoom_image_in();
void zoom_image_out();
void zoom_image_norm();
void zoom_image_fit();
void thumb_button_clicked(GtkWidget *w);
void thumb_menu_item_clicked(GtkWidget *w);
void select_next_image();
void select_prev_image();
void change_image_to_logo();
void load_from_filelist(gint row);
void change_image_to_nearest();
void start_editor_from_list(GtkWidget *w,gchar *c);
void start_editor_from_image(GtkWidget *w,gchar *c);
void key_pressed(GtkWidget *widget, GdkEventKey *event);
void destroy(GtkWidget *widget, gpointer *data);
int main (int argc, char *argv[]);

	/* window.c routines */
void update_edit_menu();
void create_main_window();
void size_window(gint w, gint h);

	/* image.c routines */
void imagewindow_pressed(GtkWidget *widget, GdkEventButton *bevent);
void imagewindow_released(GtkWidget *widget, GdkEventButton *bevent);
void imagewindow_moved(GtkWidget *widget, GdkEventButton *bevent);
void window_resized();
void image_redraw(gint zoom_size);
void update_image();
void draw_img(GtkWidget *widget, GtkAllocation *allocation);

	/* thumb.c routines */
gint maintain_thumbnail_dir(gchar *dir, gint recursive);
void maintain_thumb_cb(GtkWidget *w, gpointer data);
gint create_thumbnail(gchar *thumb_filename, GdkPixmap **thumb_pixmap, GdkBitmap **thumb_mask);

	/* fileops.c routines */
gchar *homedir();
int isfile(char *s);
int isdir(char *s);
int filesize(char *s);
time_t filetime(gchar *s);
void get_current_dir();
void set_current_dir(char *s);
void read_dir();
int copy_file(char *s, char *t);
int move_file(char *s, char *t);


	/* filelist.c routines */
void history_menu_select(GtkWidget *widget, gchar *newdir);
void change_dir_to_home();
void change_dir(GtkWidget *widget, gint row, gint column, GdkEventButton *bevent);
void change_file(GtkWidget *widget, GdkEventButton *bevent, gpointer data);
gint dot_file_check(gchar *file);
gint filter_file_check(gchar *file);
void rebuild_filter();
void update_list_highlight(gint old, gint new, gint move);
void interrupt_thumbs();
void refresh_dir();

	/* listutil.c routines */
void filelist_init();
void filelist_clear();
void filelist_add_item(gchar *fn);
void filelist_insert_item(gchar *fn, gint n);
void filelist_remove_item(gint n);
void filelist_swap_items(gint n1, gint n2);
void filelist_sort();
gchar *filelist_get_item(gint n);
void dirlist_init();
void dirlist_clear();
void dirlist_add_item(gchar *fn);
void dirlist_insert_item(gchar *fn, gint n);
void dirlist_remove_item(gint n);
void dirlist_swap_items(gint n1, gint n2);
void dirlist_sort();
gchar *dirlist_get_item(gint n);

	/* config.c routines */
void show_about_info();
void show_configuration_window();

	/* utildlg.c dialog routines */
void warning_dialog(gchar *title, gchar *message);
void dir_create_dialog();
void move_file_from_list();
void move_file_from_image();
void copy_file_from_list();
void copy_file_from_image();
void delete_file_from_list();
void delete_file_from_image();
void rename_file_from_list();
void rename_file_from_image();

	/* movedlg.c routines */
GtkWidget *destination_widget_new(gchar *path, GtkWidget *entry);

	/* config.c save/load routines */
void save_options();
void load_options();

/* end of header */

