.\"
.\" Copyright (c) Mark J. Kilgard, 1996.
.\"
.TH glutSetColor 3GLUT "3.6" "GLUT" "GLUT"
.SH NAME
glutSetColor - sets the color of a colormap entry in the layer of use
for the current window. 
.SH SYNTAX
.nf
.LP
void glutSetColor(int cell,
		  GLfloat red, GLfloat green, GLfloat blue);
.fi
.SH ARGUMENTS
.IP \fIcell\fP 1i
Color cell index (starting at zero). 
.IP \fIred\fP 1i
Red intensity (clamped between 0.0 and 1.0 inclusive). 
.IP \fIgreen\fP 1i
Green intensity (clamped between 0.0 and 1.0 inclusive).
.IP \fIblue\fP 1i
Blue intensity (clamped between 0.0 and 1.0 inclusive). 
.SH DESCRIPTION
Sets the cell color index colormap entry of the current window's
logical colormap for the layer in use with the color specified by red,
green, and blue.  The layer in use of the current window should be a
color index window.  cell should be zero or greater and less than the
total number of colormap entries for the window.  If the layer in use's
colormap was copied by reference, a glutSetColor call will force the
duplication of the colormap.  Do not attempt to set the color of an
overlay's transparent index. 
.SH SEE ALSO
glutGetColor, glutCopyColormap, glutInitDisplayMode
.SH AUTHOR
Mark J. Kilgard (mjk@sgi.com)
