/* interfaces to external (helper) programs */

#ifndef EXTERNAL_H
#define EXTERNAL_H

#include <gtk/gtk.h>

/* structure with information about subprocesses */
typedef struct _ChildRec ChildRec;
typedef struct _ExitJob ExitJob;
typedef void (*ExitJobProc) (ChildRec *child, gpointer data1, gpointer
			     data2);

struct _ChildRec
{
  gint tag, pipefd, exit_status;
  /* window associated with this child */
  GtkWidget *toplevel;
  /* queue of stuff to do when it finishes */
  GSList *exit_jobs;
};

struct _ExitJob
{
  ExitJobProc proc;
  gpointer data1, data2;
};
  
/* returns the file descriptor to listen on for falling children */
int init_external (void);

/* queues a job to be done when child exits */
void on_child_exit (ChildRec *child, ExitJobProc proc, gpointer data1, 
		    gpointer data2);

/* these functions return a ChildRec with info about the child */

/* runs type1inst (in the future, the relevant parts of this program
   may be rewritten in C and incorporated into gglyph... either that,
   or gglyph will be rewritten in Perl) */
ChildRec *type1inst (gchar *directory);

/* constructs a sample sheet from the fontfile font, and pipes it to
   the program specified by progname. */
void sample_sheet (gchar *cmd, gchar *arg, gchar *font, gchar
		   *fontname);

#endif /* EXTERNAL_H */
