/* Risk! for Linux..
 * countries.h
 *
 * Copyright (C) 1998 Joel Nordell
 *
 * This file is protected under the GPL license.
 */

#define __GAME_C__
#include "gamedefs.h"

char *country_names[] = {
};

/************************ THE CONTINENTS *********************/
Continent Continents[NUM_CONTINENTS] = {
  { "North America", 5, 9,
    { ALASKA, NORTHWEST_TERRITORY, GREENLAND, ALBERTA, ONTARIO, QUEBEC,
      WESTERN_UNITED_STATES, EASTERN_UNITED_STATES, CENTRAL_AMERICA }
  },

  { "South America", 2, 4,
    { VENEZUELA, PERU, BRAZIL, ARGENTINA }
  },

  { "Europe", 5, 7,
    { ICELAND, SCANDINAVIA, UKRAINE, GREAT_BRITAIN, NORTHERN_EUROPE,
      WESTERN_EUROPE, SOUTHERN_EUROPE }
  },

  { "Africa", 3, 6,
    { NORTH_AFRICA, EGYPT, EAST_AFRICA, CONGO, SOUTH_AFRICA, MADAGASCAR }
  },

  { "Asia", 7, 12,
    { URAL, SIBERIA, IRKUTSK, YAKUTSK, KAMCHATKA, JAPAN, AFGHANISTAN,
      CHINA, MONGOLIA, MIDDLE_EAST, INDIA, SIAM },
  },

  { "Australia", 2, 4,
    { INDONESIA, NEW_GUINEA, WESTERN_AUSTRALIA, EASTERN_AUSTRALIA }
  }
};
/*************************************************************/

/************************ THE COUNTRIES **********************/
Country Countries[NUM_COUNTRIES] = {
  {	"Alaska",		/* Name */
	NORTH_AMERICA,		/* Continent */
	NULL,			/* Bitmap */
    	43, 56,			/* Width, Height */
	44, 77,			/* Bitmap Position */
	62, 105, 		/* Text Position */
	3,			/* Number of Neighbors */
	{ NORTHWEST_TERRITORY,
	  ALBERTA,
	  KAMCHATKA },
	0.90,			/* Lightness */
	{ 0, 0, 0, 0 },		/* Current Color */
	-1,			/* Owner */
	0			/* Number of Armies */
  },

  {	"Northwest Territory",	/* Name */
	NORTH_AMERICA,		/* Continent */
	NULL,			/* Bitmap */
    	68, 32,			/* Width, Height */
	86, 80,			/* Bitmap Position */
	113, 105, 		/* Text Position */
	4,			/* Number of Neighbors */
	{ ALASKA,
	  ALBERTA,
	  ONTARIO,
	  GREENLAND },
	0.78,			/* Lightness */
	{ 0, 0, 0, 0 },		/* Current Color */
	-1,			/* Owner */
	0			/* Number of Armies */
  },

  {	"Alberta",		/* Name */
	NORTH_AMERICA,		/* Continent */
	NULL,			/* Bitmap */
    	50, 42,			/* Width, Height */
	86, 108,		/* Bitmap Position */
	111, 134, 		/* Text Position */
	4,			/* Number of Neighbors */
	{ ALASKA,
	  NORTHWEST_TERRITORY,
	  ONTARIO,
	  WESTERN_UNITED_STATES },
	0.84,			/* Lightness */
	{ 0, 0, 0, 0 },		/* Current Color */
	-1,			/* Owner */
	0			/* Number of Armies */
  },

  {	"Greenland",		/* Name */
	NORTH_AMERICA,		/* Continent */
	NULL,			/* Bitmap */
    	97, 79,			/* Width, Height */
	154, 37,		/* Bitmap Position */
	223, 78, 		/* Text Position */
	4,			/* Number of Neighbors */
	{ NORTHWEST_TERRITORY,
	  ONTARIO,
	  QUEBEC,
	  ICELAND },
	0.90,			/* Lightness */
	{ 0, 0, 0, 0 },		/* Current Color */
	-1,			/* Owner */
	0			/* Number of Armies */
  },

  {	"Ontario",		/* Name */
	NORTH_AMERICA,		/* Continent */
	NULL,			/* Bitmap */
    	51, 47,			/* Width, Height */
	136, 111,		/* Bitmap Position */
	145, 142, 		/* Text Position */
	6,			/* Number of Neighbors */
	{ NORTHWEST_TERRITORY,
	  GREENLAND,
	  QUEBEC,
	  EASTERN_UNITED_STATES,
	  WESTERN_UNITED_STATES,
	  ALBERTA },
	0.72,			/* Lightness */
	{ 0, 0, 0, 0 },		/* Current Color */
	-1,			/* Owner */
	0			/* Number of Armies */
  },

  {	"Quebec",		/* Name */
	NORTH_AMERICA,		/* Continent */
	NULL,			/* Bitmap */
    	37, 46,			/* Width, Height */
	179, 111,		/* Bitmap Position */
	190, 140, 		/* Text Position */
	3,			/* Number of Neighbors */
	{ ONTARIO,
	  GREENLAND,
	  EASTERN_UNITED_STATES },
	0.78,			/* Lightness */
	{ 0, 0, 0, 0 },		/* Current Color */
	-1,			/* Owner */
	0			/* Number of Armies */
  },

  {	"Western United States",/* Name */
	NORTH_AMERICA,		/* Continent */
	NULL,			/* Bitmap */
    	38, 36,			/* Width, Height */
	110, 150,		/* Bitmap Position */
	122, 171, 		/* Text Position */
	4,			/* Number of Neighbors */
	{ ALBERTA,
	  ONTARIO,
	  EASTERN_UNITED_STATES,
	  CENTRAL_AMERICA },
	0.90,			/* Lightness */
	{ 0, 0, 0, 0 },		/* Current Color */
	-1,			/* Owner */
	0			/* Number of Armies */
  },

  {	"Eastern United States",/* Name */
	NORTH_AMERICA,		/* Continent */
	NULL,			/* Bitmap */
    	71, 48,			/* Width, Height */
	135, 150,		/* Bitmap Position */
	159, 176, 		/* Text Position */
	4,			/* Number of Neighbors */
	{ WESTERN_UNITED_STATES,
	  ONTARIO,
	  QUEBEC,
	  CENTRAL_AMERICA },
	0.84,			/* Lightness */
	{ 0, 0, 0, 0 },		/* Current Color */
	-1,			/* Owner */
	0			/* Number of Armies */
  },

  {	"Central America",	/* Name */
	NORTH_AMERICA,		/* Continent */
	NULL,			/* Bitmap */
    	58, 43,			/* Width, Height */
	122, 183,		/* Bitmap Position */
	138, 202, 		/* Text Position */
	3,			/* Number of Neighbors */
	{ WESTERN_UNITED_STATES,
	  EASTERN_UNITED_STATES,
	  VENEZUELA },
	0.78,			/* Lightness */
	{ 0, 0, 0, 0 },		/* Current Color */
	-1,			/* Owner */
	0			/* Number of Armies */
  },

  {	"Venezuela",		/* Name */
	SOUTH_AMERICA,		/* Continent */
	NULL,			/* Bitmap */
    	44, 26,			/* Width, Height */
	181, 215,		/* Bitmap Position */
	192, 230, 		/* Text Position */
	3,			/* Number of Neighbors */
	{ CENTRAL_AMERICA,
	  PERU,
	  BRAZIL },
	0.84,			/* Lightness */
	{ 0, 0, 0, 0 },		/* Current Color */
	-1,			/* Owner */
	0			/* Number of Armies */
  },

  {	"Peru",			/* Name */
	SOUTH_AMERICA,		/* Continent */
	NULL,			/* Bitmap */
    	39, 52,			/* Width, Height */
	175, 234,		/* Bitmap Position */
	190, 266, 		/* Text Position */
	3,			/* Number of Neighbors */
	{ VENEZUELA,
	  BRAZIL,
	  ARGENTINA },
	0.90,			/* Lightness */
	{ 0, 0, 0, 0 },		/* Current Color */
	-1,			/* Owner */
	0			/* Number of Armies */
  },

  {	"Brazil",		/* Name */
	SOUTH_AMERICA,		/* Continent */
	NULL,			/* Bitmap */
    	64, 68,			/* Width, Height */
	187, 229,		/* Bitmap Position */
	218, 260, 		/* Text Position */
	4,			/* Number of Neighbors */
	{ VENEZUELA,
	  PERU,
	  ARGENTINA,
	  NORTH_AFRICA },
	0.78,			/* Lightness */
	{ 0, 0, 0, 0 },		/* Current Color */
	-1,			/* Owner */
	0			/* Number of Armies */
  },

  {	"Argentina",		/* Name */
	SOUTH_AMERICA,		/* Continent */
	NULL,			/* Bitmap */
    	36, 80,			/* Width, Height */
	185, 275,		/* Bitmap Position */
	195, 304, 		/* Text Position */
	2,			/* Number of Neighbors */
	{ PERU,
	  BRAZIL },
	0.84,			/* Lightness */
	{ 0, 0, 0, 0 },		/* Current Color */
	-1,			/* Owner */
	0			/* Number of Armies */
  },

  {	"Iceland",		/* Name */
	EUROPE,			/* Continent */
	NULL,			/* Bitmap */
    	15, 10,			/* Width, Height */
	254, 99,		/* Bitmap Position */
	262, 96, 		/* Text Position */
	3,			/* Number of Neighbors */
	{ GREENLAND,
	  SCANDINAVIA,
	  GREAT_BRITAIN },
	0.78,			/* Lightness */
	{ 0, 0, 0, 0 },		/* Current Color */
	-1,			/* Owner */
	0			/* Number of Armies */
  },

  {	"Scandinavia",		/* Name */
	EUROPE,			/* Continent */
	NULL,			/* Bitmap */
    	39, 55,			/* Width, Height */
	311, 76,		/* Bitmap Position */
	331, 94, 		/* Text Position */
	4,			/* Number of Neighbors */
	{ ICELAND,
	  UKRAINE,
	  NORTHERN_EUROPE,
	  GREAT_BRITAIN },
	0.84,			/* Lightness */
	{ 0, 0, 0, 0 },		/* Current Color */
	-1,			/* Owner */
	0			/* Number of Armies */
  },

  {	"Great Britain",	/* Name */
	EUROPE,			/* Continent */
	NULL,			/* Bitmap */
    	19, 23,			/* Width, Height */
	286, 122,		/* Bitmap Position */
	271, 141, 		/* Text Position */
	4,			/* Number of Neighbors */
	{ ICELAND,
	  SCANDINAVIA,
	  NORTHERN_EUROPE,
	  WESTERN_EUROPE },
	0.90,			/* Lightness */
	{ 0, 0, 0, 0 },		/* Current Color */
	-1,			/* Owner */
	0			/* Number of Armies */
  },

  {	"Northern Europe",	/* Name */
	EUROPE,			/* Continent */
	NULL,			/* Bitmap */
    	44, 29,			/* Width, Height */
	307, 125,		/* Bitmap Position */
	318, 146, 		/* Text Position */
	5,			/* Number of Neighbors */
	{ GREAT_BRITAIN,
	  SCANDINAVIA,
	  UKRAINE,
	  SOUTHERN_EUROPE,
	  WESTERN_EUROPE },
	0.78,			/* Lightness */
	{ 0, 0, 0, 0 },		/* Current Color */
	-1,			/* Owner */
	0			/* Number of Armies */
  },

  {	"Ukraine",		/* Name */
	EUROPE,			/* Continent */
	NULL,			/* Bitmap */
    	60, 88,			/* Width, Height */
	339, 81,		/* Bitmap Position */
	364, 122,		/* Text Position */
	6,			/* Number of Neighbors */
	{ SCANDINAVIA,
	  URAL,
	  AFGHANISTAN,
	  MIDDLE_EAST,
	  SOUTHERN_EUROPE,
	  NORTHERN_EUROPE },
	0.90,			/* Lightness */
	{ 0, 0, 0, 0 },		/* Current Color */
	-1,			/* Owner */
	0			/* Number of Armies */
  },

  {	"Western Europe",	/* Name */
	EUROPE,			/* Continent */
	NULL,			/* Bitmap */
    	26, 33,			/* Width, Height */
	288, 142,		/* Bitmap Position */
	288, 171, 		/* Text Position */
	4,			/* Number of Neighbors */
	{ GREAT_BRITAIN,
	  NORTHERN_EUROPE,
	  SOUTHERN_EUROPE,
	  NORTH_AFRICA },
	0.72,			/* Lightness */
	{ 0, 0, 0, 0 },		/* Current Color */
	-1,			/* Owner */
	0			/* Number of Armies */
  },

  {	"Southern Europe",	/* Name */
	EUROPE,			/* Continent */
	NULL,			/* Bitmap */
    	50, 35,			/* Width, Height */
	312, 139,		/* Bitmap Position */
	331, 162, 		/* Text Position */
	6,			/* Number of Neighbors */
	{ WESTERN_EUROPE,
	  NORTHERN_EUROPE,
	  UKRAINE,
	  MIDDLE_EAST,
	  EGYPT,
	  NORTH_AFRICA },
	0.84,			/* Lightness */
	{ 0, 0, 0, 0 },		/* Current Color */
	-1,			/* Owner */
	0			/* Number of Armies */
  },

  {	"North Africa",		/* Name */
	AFRICA,			/* Continent */
	NULL,			/* Bitmap */
    	66, 71,			/* Width, Height */
	273, 174,		/* Bitmap Position */
	290, 208, 		/* Text Position */
	6,			/* Number of Neighbors */
	{ BRAZIL,
	  WESTERN_EUROPE,
	  SOUTHERN_EUROPE,
	  EGYPT,
	  EAST_AFRICA,
	  CONGO },
	0.84,			/* Lightness */
	{ 0, 0, 0, 0 },		/* Current Color */
	-1,			/* Owner */
	0			/* Number of Armies */
  },

  {	"Egypt",		/* Name */
	AFRICA,			/* Continent */
	NULL,			/* Bitmap */
    	43, 26,			/* Width, Height */
	313, 181,		/* Bitmap Position */
	328, 199, 		/* Text Position */
	4,			/* Number of Neighbors */
	{ NORTH_AFRICA,
	  SOUTHERN_EUROPE,
	  MIDDLE_EAST,
	  EAST_AFRICA },
	0.72,			/* Lightness */
	{ 0, 0, 0, 0 },		/* Current Color */
	-1,			/* Owner */
	0			/* Number of Armies */
  },

  {	"East Africa",		/* Name */
	AFRICA,			/* Continent */
	NULL,			/* Bitmap */
    	44, 59,			/* Width, Height */
	334, 201,		/* Bitmap Position */
	351, 229, 		/* Text Position */
	6,			/* Number of Neighbors */
	{ NORTH_AFRICA,
	  EGYPT,
	  MIDDLE_EAST,
	  MADAGASCAR,
	  SOUTH_AFRICA,
	  CONGO },
	0.78,			/* Lightness */
	{ 0, 0, 0, 0 },		/* Current Color */
	-1,			/* Owner */
	0			/* Number of Armies */
  },

  {	"Congo",		/* Name */
	AFRICA,			/* Continent */
	NULL,			/* Bitmap */
    	28, 30,			/* Width, Height */
	319, 226,		/* Bitmap Position */
	329, 245, 		/* Text Position */
	3,			/* Number of Neighbors */
	{ NORTH_AFRICA,
	  EAST_AFRICA,
	  SOUTH_AFRICA },
	0.90,			/* Lightness */
	{ 0, 0, 0, 0 },		/* Current Color */
	-1,			/* Owner */
	0			/* Number of Armies */
  },

  {	"South Africa",		/* Name */
	AFRICA,			/* Continent */
	NULL,			/* Bitmap */
    	43, 47,			/* Width, Height */
	318, 247,		/* Bitmap Position */
	330, 275, 		/* Text Position */
	3,			/* Number of Neighbors */
	{ CONGO,
	  EAST_AFRICA,
	  MADAGASCAR },
	0.72,			/* Lightness */
	-1,			/* Owner */
	0			/* Number of Armies */
  },

  {	"Madagascar",		/* Name */
	AFRICA,			/* Continent */
	NULL,			/* Bitmap */
    	10, 21,			/* Width, Height */
	367, 255,		/* Bitmap Position */
	379, 269, 		/* Text Position */
	2,			/* Number of Neighbors */
	{ SOUTH_AFRICA,
	  EAST_AFRICA },
	0.84,			/* Lightness */
	{ 0, 0, 0, 0 },		/* Current Color */
	-1,			/* Owner */
	0			/* Number of Armies */
  },

  {	"Ural",			/* Name */
	ASIA,			/* Continent */
	NULL,			/* Bitmap */
    	40, 86,			/* Width, Height */
	394, 68,		/* Bitmap Position */
	401, 113, 		/* Text Position */
	4,			/* Number of Neighbors */
	{ UKRAINE,
	  SIBERIA,
	  CHINA,
	  AFGHANISTAN },
	0.78,			/* Lightness */
	{ 0, 0, 0, 0 },		/* Current Color */
	-1,			/* Owner */
	0			/* Number of Armies */
  },

  {	"Afghanistan",		/* Name */
	ASIA,			/* Continent */
	NULL,			/* Bitmap */
    	49, 53,			/* Width, Height */
	378, 133,		/* Bitmap Position */
	395, 160, 		/* Text Position */
	5,			/* Number of Neighbors */
	{ UKRAINE,
	  URAL,
	  CHINA,
	  INDIA,
	  MIDDLE_EAST },
	0.72,			/* Lightness */
	{ 0, 0, 0, 0 },		/* Current Color */
	-1,			/* Owner */
	0			/* Number of Armies */
  },

  {	"Middle East",		/* Name */
	ASIA,			/* Continent */
	NULL,			/* Bitmap */
    	70, 53,			/* Width, Height */
	341, 163,		/* Bitmap Position */
	370, 184, 		/* Text Position */
	6,			/* Number of Neighbors */
	{ SOUTHERN_EUROPE,
	  UKRAINE,
	  AFGHANISTAN,
	  INDIA,
	  EAST_AFRICA,
	  EGYPT },
	0.66,			/* Lightness */
	{ 0, 0, 0, 0 },		/* Current Color */
	-1,			/* Owner */
	0			/* Number of Armies */
  },

  {	"India",		/* Name */
	ASIA,			/* Continent */
	NULL,			/* Bitmap */
    	46, 43,			/* Width, Height */
	403, 180,		/* Bitmap Position */
	415, 201, 		/* Text Position */
	4,			/* Number of Neighbors */
	{ MIDDLE_EAST,
	  AFGHANISTAN,
	  CHINA,
	  SIAM },
	0.90,			/* Lightness */
	{ 0, 0, 0, 0 },		/* Current Color */
	-1,			/* Owner */
	0			/* Number of Armies */
  },

  {	"Siam",			/* Name */
	ASIA,			/* Continent */
	NULL,			/* Bitmap */
    	26, 26,			/* Width, Height */
	441, 193,		/* Bitmap Position */
	447, 208, 		/* Text Position */
	3,			/* Number of Neighbors */
	{ INDIA,
	  CHINA,
	  INDONESIA },
	0.78,			/* Lightness */
	{ 0, 0, 0, 0 },		/* Current Color */
	-1,			/* Owner */
	0			/* Number of Armies */
  },

  {	"China",		/* Name */
	ASIA,			/* Continent */
	NULL,			/* Bitmap */
    	74, 51,			/* Width, Height */
	413, 150,		/* Bitmap Position */
	446, 180, 		/* Text Position */
	6,			/* Number of Neighbors */
	{ AFGHANISTAN,
	  URAL,
	  SIBERIA,
	  MONGOLIA,
	  SIAM,
	  INDIA },
	0.84,			/* Lightness */
	{ 0, 0, 0, 0 },		/* Current Color */
	-1,			/* Owner */
	0			/* Number of Armies */
  },

  {	"Mongolia",		/* Name */
	ASIA,			/* Continent */
	NULL,			/* Bitmap */
    	58, 42,			/* Width, Height */
	444, 136,		/* Bitmap Position */
	474, 159, 		/* Text Position */
	5,			/* Number of Neighbors */
	{ SIBERIA,
	  IRKUTSK,
	  KAMCHATKA,
	  JAPAN,
	  CHINA },
	0.78,			/* Lightness */
	{ 0, 0, 0, 0 },		/* Current Color */
	-1,			/* Owner */
	0			/* Number of Armies */
  },

  {	"Siberia",		/* Name */
	ASIA,			/* Continent */
	NULL,			/* Bitmap */
    	55, 117,		/* Width, Height */
	419, 38,		/* Bitmap Position */
	436, 105, 		/* Text Position */
	5,			/* Number of Neighbors */
	{ URAL,
	  YAKUTSK,
	  IRKUTSK,
	  MONGOLIA,
	  CHINA },
	0.72,			/* Lightness */
	{ 0, 0, 0, 0 },		/* Current Color */
	-1,			/* Owner */
	0			/* Number of Armies */
  },

  {	"Irkutsk",		/* Name */
	ASIA,			/* Continent */
	NULL,			/* Bitmap */
    	56, 48,			/* Width, Height */
	449, 99,		/* Bitmap Position */
	473, 125, 		/* Text Position */
	4,			/* Number of Neighbors */
	{ SIBERIA,
	  YAKUTSK,
	  KAMCHATKA,
	  MONGOLIA },
	0.90,			/* Lightness */
	{ 0, 0, 0, 0 },		/* Current Color */
	-1,			/* Owner */
	0			/* Number of Armies */
  },

  {	"Yakutsk",		/* Name */
	ASIA,			/* Continent */
	NULL,			/* Bitmap */
    	47, 44,			/* Width, Height */
	465, 58,		/* Bitmap Position */
	480, 86, 		/* Text Position */
	3,			/* Number of Neighbors */
	{ SIBERIA,
	  KAMCHATKA,
	  IRKUTSK },
	0.84,			/* Lightness */
	{ 0, 0, 0, 0 },		/* Current Color */
	-1,			/* Owner */
	0			/* Number of Armies */
  },

  {	"Kamchatka",		/* Name */
	ASIA,			/* Continent */
	NULL,			/* Bitmap */
    	100, 93,		/* Width, Height */
	495, 69,		/* Bitmap Position */
	532, 103, 		/* Text Position */
	5,			/* Number of Neighbors */
	{ ALASKA,
	  YAKUTSK,
	  IRKUTSK,
	  MONGOLIA,
	  JAPAN },
	0.72,			/* Lightness */
	{ 0, 0, 0, 0 },		/* Current Color */
	-1,			/* Owner */
	0			/* Number of Armies */
  },

  {	"Japan",		/* Name */
	ASIA,			/* Continent */
	NULL,			/* Bitmap */
    	24, 26,			/* Width, Height */
	499, 158,		/* Bitmap Position */
	522, 174, 		/* Text Position */
	2,			/* Number of Neighbors */
	{ MONGOLIA,
	  KAMCHATKA },
	0.90,			/* Lightness */
	{ 0, 0, 0, 0 },		/* Current Color */
	-1,			/* Owner */
	0			/* Number of Armies */
  },

  {	"Indonesia",		/* Name */
	AUSTRALIA,		/* Continent */
	NULL,			/* Bitmap */
    	25, 36,			/* Width, Height */
	468, 207,		/* Bitmap Position */
	492, 213, 		/* Text Position */
	3,			/* Number of Neighbors */
	{ SIAM,
	  NEW_GUINEA,
	  WESTERN_AUSTRALIA },
	0.72,			/* Lightness */
	{ 0, 0, 0, 0 },		/* Current Color */
	-1,			/* Owner */
	0			/* Number of Armies */
  },

  {	"New Guinea",		/* Name */
	AUSTRALIA,		/* Continent */
	NULL,			/* Bitmap */
    	33, 15,			/* Width, Height */
	502, 237,		/* Bitmap Position */
	515, 236, 		/* Text Position */
	3,			/* Number of Neighbors */
	{ INDONESIA,
	  WESTERN_AUSTRALIA,
	  EASTERN_AUSTRALIA },
	0.78,			/* Lightness */
	{ 0, 0, 0, 0 },		/* Current Color */
	-1,			/* Owner */
	0			/* Number of Armies */
  },

  {	"Western Australia",	/* Name */
	AUSTRALIA,		/* Continent */
	NULL,			/* Bitmap */
    	38, 42,			/* Width, Height */
	475, 258,		/* Bitmap Position */
	482, 287, 		/* Text Position */
	3,			/* Number of Neighbors */
	{ INDONESIA,
	  NEW_GUINEA,
	  EASTERN_AUSTRALIA },
	0.84,			/* Lightness */
	{ 0, 0, 0, 0 },		/* Current Color */
	-1,			/* Owner */
	0			/* Number of Armies */
  },

  {	"Eastern Australia",	/* Name */
	AUSTRALIA,		/* Continent */
	NULL,			/* Bitmap */
    	36, 58,			/* Width, Height */
	499, 258,		/* Bitmap Position */
	512, 290, 		/* Text Position */
	2,			/* Number of Neighbors */
	{ NEW_GUINEA,
	  WESTERN_AUSTRALIA },
	0.66,			/* Lightness */
	{ 0, 0, 0, 0 },		/* Current Color */
	-1,			/* Owner */
	0			/* Number of Armies */
  }
};


/* COUNTRY BITMAP DATA */

char country_xbm_data[NUM_COUNTRIES][5000] = {
 { /* static char alaska_bits[] = { */
 0x00,0x00,0x0e,0x00,0x00,0x00,0x00,0xf0,0x3f,0x00,0x00,0x00,0x00,0xfc,0xff,
 0x00,0x00,0x00,0x00,0xfc,0xff,0x3f,0x00,0x00,0x00,0xfc,0xff,0x7f,0x00,0x00,
 0x00,0xfe,0xff,0xff,0x03,0x00,0x00,0xfe,0xff,0xff,0xff,0x00,0x00,0xff,0xff,
 0xff,0xff,0x03,0xc0,0xff,0xff,0xff,0xff,0x03,0xfc,0xff,0xff,0xff,0xff,0x03,
 0xfc,0xff,0xff,0xff,0xff,0x03,0xfc,0xff,0xff,0xff,0xff,0x03,0xfc,0xff,0xff,
 0xff,0xff,0x03,0xf8,0xff,0xff,0xff,0xff,0x03,0xf0,0xff,0xff,0xff,0xff,0x03,
 0xc0,0xff,0xff,0xff,0xff,0x03,0x80,0xff,0xff,0xff,0xff,0x03,0x00,0xff,0xff,
 0xff,0xff,0x03,0x00,0xfe,0xff,0xff,0xff,0x03,0x00,0xfe,0xff,0xff,0xff,0x03,
 0x08,0xfe,0xff,0xff,0xff,0x03,0x3c,0xff,0xff,0xff,0xff,0x03,0xfe,0xff,0xff,
 0xff,0xff,0x03,0xff,0xff,0xff,0xff,0xff,0x03,0xff,0xff,0xff,0xff,0xff,0x03,
 0xfe,0xff,0xff,0xff,0xff,0x03,0xfc,0xfe,0xff,0xff,0xff,0x03,0x00,0xfc,0xff,
 0xff,0xff,0x03,0x00,0xfc,0xff,0xff,0xff,0x03,0x00,0xfc,0xff,0xff,0xff,0x03,
 0x00,0xfc,0xff,0xff,0xff,0x03,0x00,0xfe,0xff,0xff,0xff,0x03,0x80,0xff,0xff,
 0xff,0xff,0x03,0xc0,0xff,0xff,0xff,0xff,0x03,0xc0,0xff,0xff,0xff,0xff,0x03,
 0xe0,0xff,0xff,0xff,0xff,0x03,0xf8,0xff,0xff,0xff,0xff,0x03,0xfc,0xff,0xff,
 0xff,0xff,0x03,0xfc,0xff,0xff,0xff,0xff,0x03,0xf8,0xff,0xff,0xbe,0xff,0x03,
 0xf0,0xff,0x7f,0x1c,0xfc,0x03,0xf0,0xff,0x3f,0x1c,0xf8,0x07,0xf0,0xff,0x3f,
 0x0e,0x00,0x07,0x00,0xff,0x1f,0x06,0x00,0x02,0x00,0xfe,0x1f,0x02,0x00,0x00,
 0x00,0xfe,0x0f,0x00,0x00,0x00,0x00,0xfc,0x1f,0x00,0x00,0x00,0x00,0x90,0x1f,
 0x00,0x00,0x00,0x00,0x00,0x0f,0x00,0x00,0x00,0x00,0x80,0x0f,0x00,0x00,0x00,
 0x00,0xc0,0x1b,0x00,0x00,0x00,0x00,0xe0,0x11,0x00,0x00,0x00,0x00,0x70,0x00,
 0x00,0x00,0x00,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x1c,0x00,0x00,0x00,0x00,
 0x00,0x0e,0x00,0x00,0x00,0x00},

 { /* static char northwest_territory_bits[] = { */
 0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x7a,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7f,
 0x04,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0xff,0x7e,0x00,0x00,0x00,0x00,0x00,
 0x0f,0xfc,0xff,0xff,0x01,0x00,0x00,0x00,0x00,0x3f,0xfe,0xff,0xff,0x43,0x00,
 0x00,0x00,0x00,0x7f,0xff,0xff,0xff,0xef,0x00,0x18,0x00,0x00,0xff,0xff,0xff,
 0xff,0xff,0x00,0x3c,0x00,0x00,0xff,0xff,0xff,0xff,0x7f,0x00,0x3c,0x00,0x00,
 0xff,0xff,0xff,0xff,0x7f,0x00,0x7c,0x00,0x0c,0xff,0xff,0xff,0xff,0x7f,0x20,
 0xf8,0x03,0x0c,0xff,0xff,0xff,0xff,0xff,0x70,0xfc,0x67,0x0e,0xff,0xff,0xff,
 0xff,0xff,0xff,0xfe,0xff,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0f,
 0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,
 0xff,0xff,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0f,0xff,0xff,0xff,
 0xff,0xff,0xff,0xff,0xff,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0f,
 0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,
 0xff,0xff,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0f,0xff,0xff,0xff,
 0xff,0xff,0xff,0xff,0xff,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0f,
 0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,
 0xff,0xff,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0f,0xf8,0xff,0xff,
 0xff,0xff,0xff,0xff,0xff,0x0f,0x00,0x00,0xf0,0xff,0xff,0xff,0xff,0xff,0x0f,
 0x00,0x00,0x00,0x00,0xe0,0xff,0xff,0xff,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,
 0xc0,0xff,0x0f},

 { /* static char alberta_bits[] = { */
 0x07,0x00,0x00,0x00,0x00,0x00,0xfc,0xff,0xff,0x0f,0x00,0x00,0x00,0xfc,0xff,
 0xff,0xff,0xff,0x1f,0x00,0xfc,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
 0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
 0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
 0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfe,0xff,0xff,0xff,0xff,
 0xff,0xff,0xfe,0xff,0xff,0xff,0xff,0xff,0xff,0xfc,0xff,0xff,0xff,0xff,0xff,
 0xff,0xf8,0xff,0xff,0xff,0xff,0xff,0xff,0xf8,0xff,0xff,0xff,0xff,0xff,0xff,
 0xf0,0xff,0xff,0xff,0xff,0xff,0xff,0xe0,0xff,0xff,0xff,0xff,0xff,0xff,0x80,
 0xff,0xff,0xff,0xff,0xff,0xff,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0xf8,
 0xff,0xff,0xff,0xff,0xff,0x00,0xf0,0xff,0xff,0xff,0xff,0xff,0x00,0xe0,0xff,
 0xff,0xff,0xff,0xff,0x00,0xe0,0xff,0xff,0xff,0xff,0xff,0x00,0xe0,0xff,0xff,
 0xff,0xff,0xff,0x00,0x80,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0xff,0xff,0xff,
 0xff,0xff,0x00,0x80,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0xff,0xff,0xff,0xff,
 0xff,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0xfe,0xff,0xff,0xff,0xff,
 0x00,0x00,0xfe,0xff,0xff,0xff,0xff,0x00,0x00,0xfe,0xff,0xff,0xff,0xff,0x00,
 0x00,0xfc,0xff,0xff,0xff,0xff,0x00,0x00,0xfc,0xff,0xff,0xff,0xff,0x00,0x00,
 0xf8,0xff,0xff,0xff,0xff,0x00,0x00,0xf0,0xff,0xff,0xff,0xff,0x00,0x00,0xe0,
 0xff,0xff,0xff,0xff,0x00,0x00,0x80,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0xfe,
 0xff,0xff,0xff,0x00,0x00,0x00,0xfc,0xff,0xff,0xff,0x00,0x00,0x00,0xfc,0xff,
 0xff,0xff,0x00,0x00,0x00,0xfc,0xff,0xff,0xff},

 { /* static char greenland_bits[] = { */
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x0f,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0xfe,0x7f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x80,0xff,0xff,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0xff,
 0xff,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xec,0xff,0xff,0x01,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xff,0xff,0xff,0x1b,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0xff,0xff,0xff,0x3f,0x01,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0xfe,0xff,0xff,0xff,0xff,0x01,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0xfe,0xff,0xff,0xff,0xff,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0xfe,0xff,0xff,0xff,0xff,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xff,
 0xff,0xff,0xff,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xff,0xff,0xff,
 0xff,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0xe0,0xff,0xff,0xff,0xff,0x7f,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0xf0,0xff,0xff,0xff,0xff,0x7f,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0xf8,0xff,0xff,0xff,0xff,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0xe0,0xff,0xff,0xff,0xff,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0xff,
 0xff,0xff,0xff,0x7f,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0xff,0xff,0xff,
 0xff,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0xff,0xff,0xff,0xff,0x07,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe0,0xff,0xff,0xff,0xff,0x03,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0xf0,0xff,0xff,0xff,0xff,0x03,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0xfc,0xff,0xff,0xff,0xff,0x03,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0xff,0xff,0xff,0xff,0xff,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0xff,
 0xff,0xff,0xff,0xff,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0xff,0xff,0xff,
 0xff,0xff,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xff,0xff,0xff,0xff,0xff,
 0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0x03,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xff,0xff,0xff,0xff,0x43,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0xfe,0xff,0xff,0xff,0xff,0xc7,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xc7,0x01,0x00,0x00,0x00,0x00,0x00,0x80,
 0xff,0xff,0xff,0xff,0xff,0x6f,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,
 0xff,0xff,0xff,0x0f,0x00,0x00,0x00,0x00,0x08,0x00,0x00,0xfe,0xff,0xff,0xff,
 0xff,0x07,0x00,0x00,0x00,0x00,0x8c,0x00,0x00,0x3c,0xf8,0xff,0xff,0xff,0x0f,
 0x00,0x00,0x00,0x00,0xdf,0x00,0x00,0x08,0xf0,0xff,0xff,0xff,0x7f,0x00,0x30,
 0x00,0x00,0x7f,0x00,0x00,0x00,0xe0,0xff,0xff,0xff,0x7f,0x00,0x38,0x00,0x00,
 0xff,0x00,0x00,0x00,0xc0,0xff,0xff,0xff,0xff,0x00,0x7c,0x00,0x00,0xff,0x17,
 0x00,0x00,0xc0,0xff,0xff,0xff,0xff,0x01,0x7e,0x00,0x80,0xff,0xff,0x00,0x00,
 0xc0,0xff,0xff,0xff,0xff,0x00,0x7e,0x00,0x80,0xff,0xff,0x01,0x00,0xc0,0xff,
 0xff,0xff,0x7f,0x00,0x7e,0x00,0x00,0xff,0xff,0x01,0x00,0x80,0xff,0xff,0xff,
 0x7f,0x00,0xfe,0x00,0x00,0xff,0xff,0x0b,0x00,0x80,0xff,0xff,0xff,0x3f,0x00,
 0xfc,0x00,0x00,0xff,0xff,0x07,0x00,0x80,0xff,0xff,0xff,0x0f,0x00,0xfc,0x00,
 0x00,0xfe,0xff,0x0f,0x00,0x80,0xff,0xff,0xff,0x07,0x00,0xf8,0x00,0x38,0xf0,
 0xff,0x7f,0x00,0x80,0xff,0xff,0xff,0x07,0x00,0xf0,0x01,0x78,0xe0,0xff,0xff,
 0x00,0x80,0xff,0xff,0xff,0x07,0x00,0xe0,0x07,0x78,0x00,0xf8,0xff,0x00,0x80,
 0xff,0xff,0xff,0x07,0x00,0xe0,0x2f,0x3c,0x00,0xe0,0xff,0x00,0x80,0xff,0xff,
 0xff,0x0f,0x00,0xc0,0x7f,0x1c,0x00,0x80,0xff,0x00,0xc0,0xff,0xff,0xff,0x0f,
 0x00,0x80,0xff,0x3e,0x00,0x00,0xff,0x00,0x00,0xff,0xff,0xff,0x0f,0x00,0xc0,
 0xff,0x3f,0x00,0x00,0xfe,0x00,0x00,0xfe,0xff,0xff,0x1f,0x00,0xe0,0xff,0x7f,
 0x00,0x00,0x7e,0x00,0x00,0xff,0xff,0xff,0x1f,0x00,0xf9,0xff,0x7f,0x00,0x00,
 0xfe,0x00,0x00,0xfe,0xff,0xff,0x1f,0x00,0xff,0xff,0x7f,0x00,0x00,0xfe,0x03,
 0x00,0xfc,0xff,0xff,0x07,0x00,0xff,0xff,0x7f,0x00,0x00,0xfe,0x0f,0x00,0xf8,
 0xff,0xff,0x03,0x00,0xff,0xff,0x3f,0x00,0x00,0xfe,0x1f,0x00,0xfc,0xff,0xff,
 0x01,0x00,0xff,0xff,0x1f,0x00,0x00,0xfe,0xff,0x00,0xfe,0xff,0xff,0x00,0x00,
 0xff,0xff,0x03,0x00,0x00,0xfe,0xff,0x00,0xfe,0xff,0x1f,0x00,0x00,0xff,0x1f,
 0x00,0x00,0x00,0xfe,0x7f,0x00,0xfe,0xff,0x0f,0x00,0x00,0xff,0x0f,0x00,0x00,
 0x00,0xff,0xff,0x00,0xff,0xff,0x07,0x00,0x00,0xff,0x1f,0x00,0x00,0x80,0xff,
 0x0f,0x00,0xff,0xff,0x01,0x00,0x00,0xff,0xbf,0x06,0x00,0xf0,0xff,0x03,0x00,
 0xfe,0xff,0x00,0x00,0x00,0xff,0x1f,0x0f,0x00,0xf0,0xff,0x01,0x00,0xfe,0xff,
 0x00,0x00,0x00,0xff,0x1f,0x3f,0x00,0x00,0xfe,0x03,0x00,0xfe,0x7f,0x00,0x00,
 0x00,0xff,0x1f,0x7f,0x00,0x00,0xfc,0x07,0x00,0xfe,0x0f,0x00,0x00,0x00,0xff,
 0x0f,0x5f,0x00,0x00,0xf8,0x07,0x00,0xfe,0x07,0x00,0x00,0x00,0xff,0x0f,0x07,
 0x00,0x00,0xf0,0x0f,0x00,0xfe,0x07,0x00,0x00,0x00,0xff,0x0f,0x00,0x00,0x00,
 0xe0,0x0d,0x00,0xfe,0x07,0x00,0x00,0x00,0xff,0x0c,0x00,0x00,0x00,0x80,0x00,
 0x00,0xfe,0x07,0x00,0x00,0x00,0x7f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,
 0x03,0x00,0x00,0x00,0x7f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0x01,0x00,
 0x00,0x00,0x7f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0x01,0x00,0x00,0x00,
 0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0x01,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0xc0,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x01,0x00,0x00,0x00},

 { /* static char ontario_bits[] = { */
 0x0f,0x00,0x00,0x00,0x00,0x00,0xf8,0xff,0xff,0x03,0x00,0x00,0x00,0xf8,0xff,
 0xff,0x7f,0x00,0x00,0x00,0xf8,0xff,0xff,0x3f,0x00,0x00,0x00,0xf8,0xff,0xff,
 0x1f,0x00,0x00,0x00,0xf8,0xff,0xff,0x0f,0x00,0x00,0x00,0xf8,0xff,0xff,0x07,
 0x00,0x00,0x00,0xf8,0xff,0xff,0x07,0x00,0x00,0x00,0xf8,0xff,0xff,0x07,0x00,
 0x00,0x00,0xf8,0xff,0xff,0x07,0x00,0x00,0x00,0xf8,0xff,0xff,0x07,0x00,0x00,
 0x00,0xf8,0xff,0xff,0x07,0x00,0x00,0x00,0xf8,0xff,0xff,0x0f,0x00,0x00,0x00,
 0xf8,0xff,0xff,0x1f,0x00,0x00,0x00,0xf8,0xff,0xff,0xff,0x00,0x00,0x00,0xf8,
 0xff,0xff,0xff,0x00,0x00,0x00,0xf8,0xff,0xff,0xff,0x01,0x00,0x00,0xf8,0xff,
 0xff,0xff,0x03,0x00,0x00,0xf8,0xff,0xff,0xff,0x03,0x00,0x00,0xf8,0xff,0xff,
 0xff,0x07,0x00,0x00,0xf8,0xff,0xff,0xff,0x07,0x00,0x00,0xf8,0xff,0xff,0xff,
 0x0f,0x00,0x00,0xf8,0xff,0xff,0xff,0x1f,0x00,0x00,0xf8,0xff,0xff,0xff,0xff,
 0x1f,0x00,0xf8,0xff,0xff,0xff,0xff,0x3f,0x00,0xf8,0xff,0xff,0xff,0xff,0x3f,
 0x00,0xf8,0xff,0xff,0xff,0xff,0x3f,0x00,0xf8,0xff,0xff,0xff,0xff,0x3f,0x00,
 0xf8,0xff,0xff,0xff,0xff,0x7f,0x00,0xf8,0xff,0xff,0xff,0xff,0x7f,0x00,0xf8,
 0xff,0xff,0xff,0xff,0xff,0x00,0xf8,0xff,0xff,0xff,0xff,0xff,0x01,0xf8,0xff,
 0xff,0xff,0xff,0xff,0x01,0xf8,0xff,0xff,0xff,0xff,0xff,0x03,0xf8,0xff,0xff,
 0xff,0xff,0xff,0x07,0xf8,0xff,0xff,0xff,0xff,0xff,0x0f,0xf8,0xff,0xff,0xff,
 0xff,0xff,0x0f,0xf8,0xff,0xff,0xff,0xff,0xff,0x1f,0xf8,0xff,0xff,0xff,0xff,
 0xff,0x3f,0xf8,0x00,0x00,0xf0,0xff,0xff,0x7f,0xf8,0x00,0x00,0x00,0xff,0xff,
 0x7f,0xf8,0x00,0x00,0x00,0xe0,0xff,0xff,0xf8,0x00,0x00,0x00,0x00,0xff,0xff,
 0xf9,0x00,0x00,0x00,0x00,0xfc,0xff,0xf9,0x00,0x00,0x00,0x00,0xf0,0xff,0xfb,
 0x00,0x00,0x00,0x00,0x00,0xfe,0xfb,0x00,0x00,0x00,0x00,0x00,0xf0,0xff},

 { /* static char quebec_bits[] = { */
 0x10,0x00,0x00,0x00,0x00,0xf8,0x0f,0x00,0x00,0x00,0xf8,0x1f,0x00,0x00,0x00,
 0xf8,0x3f,0x00,0x00,0x00,0xf8,0x7f,0x00,0x00,0x00,0xf0,0x7f,0x00,0x00,0x00,
 0xf0,0x7f,0x00,0x00,0x00,0xf0,0x7f,0x00,0x00,0x00,0xf8,0x7f,0x00,0x00,0x00,
 0xf8,0x7f,0x00,0x00,0x00,0xf8,0xff,0x80,0x00,0x00,0xf8,0xff,0xc0,0x01,0x00,
 0xfc,0xff,0xe1,0x01,0x00,0xf8,0xff,0xff,0x03,0x00,0xf8,0xff,0xff,0x07,0x00,
 0xf0,0xff,0xff,0x07,0x00,0xf0,0xff,0xff,0x0f,0x00,0xf0,0xff,0xff,0x0f,0x00,
 0xf0,0xff,0xff,0x1f,0x00,0xe0,0xff,0xff,0x1f,0x00,0xf0,0xff,0xff,0x3f,0x00,
 0xf8,0xff,0xff,0x3f,0x00,0xfc,0xff,0xff,0x7f,0x00,0xfe,0xff,0xff,0xff,0x00,
 0xfe,0xff,0xff,0xff,0x07,0xfe,0xff,0xff,0xff,0x07,0xfe,0xff,0xff,0xff,0x0f,
 0xfe,0xff,0xff,0xff,0x1f,0xfe,0xff,0xff,0xff,0x1f,0xfe,0xff,0xff,0xff,0x1f,
 0xfc,0xff,0xff,0xff,0x0f,0xfe,0xff,0xff,0xff,0x01,0xfe,0xff,0xff,0xff,0x00,
 0xff,0xff,0xff,0xff,0x00,0xff,0xff,0xff,0x7f,0x00,0xfe,0xff,0x1f,0x00,0x00,
 0xfe,0xff,0x07,0x00,0x00,0xfc,0xff,0x03,0x00,0x00,0xf8,0xff,0x07,0x00,0x00,
 0xf0,0xff,0x7f,0x00,0x00,0xf0,0xff,0x0f,0x00,0x00,0xe0,0xff,0x03,0x00,0x00,
 0xc0,0xff,0x03,0x00,0x00,0xc0,0xff,0x01,0x00,0x00,0x80,0x7f,0x00,0x00,0x00,
 0x80,0x3f,0x00,0x00,0x00},

 { /* static char western_us_bits[] = { */
 0xfc,0xff,0xff,0xff,0x3f,0xfe,0xff,0xff,0xff,0x3f,0xfe,0xff,0xff,0xff,0x3f,
 0xfe,0xff,0xff,0xff,0x3f,0xfe,0xff,0xff,0xff,0x3f,0xfe,0xff,0xff,0xff,0x3f,
 0xfe,0xff,0xff,0xff,0x3f,0xfe,0xff,0xff,0xff,0x3f,0xfe,0xff,0xff,0xff,0x3f,
 0xfc,0xff,0xff,0xff,0x3f,0xfc,0xff,0xff,0xff,0x3f,0xfc,0xff,0xff,0xff,0x3f,
 0xfe,0xff,0xff,0xff,0x3f,0xff,0xff,0xff,0xff,0x3f,0xff,0xff,0xff,0xff,0x3f,
 0xff,0xff,0xff,0xff,0x3f,0xff,0xff,0xff,0xff,0x3f,0xfe,0xff,0xff,0xff,0x3f,
 0xfe,0xff,0xff,0xff,0x3f,0xfe,0xff,0xff,0xff,0x3f,0xfc,0xff,0xff,0xff,0x3f,
 0xfc,0xff,0xff,0xff,0x3f,0xfc,0xff,0xff,0xff,0x3f,0xfc,0xff,0xff,0xff,0x3f,
 0xfc,0xff,0xff,0xff,0x3f,0xf8,0xff,0xff,0x0f,0x00,0xf0,0xff,0xff,0x0f,0x00,
 0xf0,0xff,0xff,0x07,0x00,0xc0,0xff,0xff,0x07,0x00,0x80,0xff,0xff,0x07,0x00,
 0x80,0xff,0xff,0x07,0x00,0x00,0xff,0xff,0x03,0x00,0x00,0xfc,0xff,0x03,0x00,
 0x00,0xb8,0xff,0x03,0x00,0x00,0x18,0xff,0x01,0x00,0x00,0x00,0xf0,0x01,0x00
 },

 { /* static char eastern_us_bits[] = { */
 0x00,0xe0,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe0,0xff,0x01,0x00,0x00,
 0x00,0x00,0x07,0x00,0xe0,0xff,0x3f,0x00,0x00,0x00,0xc0,0x07,0x00,0xe0,0xff,
 0xff,0x01,0x00,0x00,0xc0,0x07,0x00,0xe0,0xff,0xff,0x07,0x00,0x00,0xe0,0x03,
 0x00,0xe0,0xff,0xff,0x1f,0x00,0x00,0xf8,0x07,0x00,0xe0,0xff,0xff,0xff,0x03,
 0x00,0xfc,0x07,0x00,0xe0,0xff,0xff,0xff,0x1f,0xf0,0xff,0x0f,0x00,0xe0,0xff,
 0xff,0xff,0xff,0xff,0x7f,0x7e,0x00,0xe0,0xff,0xff,0xff,0xff,0xff,0x0f,0x1c,
 0x00,0xe0,0xff,0xff,0xff,0xff,0xff,0x07,0x0c,0x00,0xe0,0xff,0xff,0xff,0xff,
 0xff,0x03,0x00,0x00,0xe0,0xff,0xff,0xff,0xff,0xff,0x03,0x00,0x00,0xe0,0xff,
 0xff,0xff,0xff,0xff,0x01,0x00,0x00,0xe0,0xff,0xff,0xff,0xff,0xff,0x01,0x00,
 0x00,0xe0,0xff,0xff,0xff,0xff,0xff,0x03,0x00,0x00,0xe0,0xff,0xff,0xff,0xff,
 0x1f,0x00,0x00,0x00,0xe0,0xff,0xff,0xff,0xff,0x0f,0x00,0x00,0x00,0xe0,0xff,
 0xff,0xff,0xff,0x0f,0x00,0x00,0x00,0xe0,0xff,0xff,0xff,0xff,0x0f,0x00,0x00,
 0x00,0xe0,0xff,0xff,0xff,0xff,0x0f,0x00,0x00,0x00,0xe0,0xff,0xff,0xff,0xff,
 0x0f,0x00,0x00,0x00,0xe0,0xff,0xff,0xff,0xff,0x0f,0x00,0x00,0x00,0xe0,0xff,
 0xff,0xff,0xff,0x07,0x00,0x00,0x00,0xe0,0xff,0xff,0xff,0xff,0x03,0x00,0x00,
 0xf8,0xff,0xff,0xff,0xff,0xff,0x03,0x00,0x00,0xf8,0xff,0xff,0xff,0xff,0xff,
 0x03,0x00,0x00,0xfc,0xff,0xff,0xff,0xff,0xff,0x03,0x00,0x00,0xfc,0xff,0xff,
 0xff,0xff,0xff,0x01,0x00,0x00,0xfc,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,
 0xfc,0xff,0xff,0xff,0xff,0x7f,0x00,0x00,0x00,0xfe,0xff,0xff,0xff,0xff,0x3f,
 0x00,0x00,0x00,0xfe,0xff,0xff,0xff,0xff,0x0f,0x00,0x00,0x00,0xfe,0xff,0xff,
 0xff,0xff,0x07,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0x03,0x00,0x00,0x00,
 0xff,0xff,0xff,0xff,0xff,0x03,0x00,0x00,0x00,0xe0,0xff,0xff,0xff,0xff,0x01,
 0x00,0x00,0x00,0xc0,0xff,0xff,0xff,0xff,0x01,0x00,0x00,0x00,0xc0,0xff,0xff,
 0x3f,0xfc,0x01,0x00,0x00,0x00,0x80,0xff,0xff,0x07,0xc0,0x01,0x00,0x00,0x00,
 0x00,0xf8,0x07,0x00,0x80,0x03,0x00,0x00,0x00,0x00,0xf0,0x03,0x00,0x80,0x03,
 0x00,0x00,0x00,0x00,0xe0,0x01,0x00,0x80,0x03,0x00,0x00,0x00,0x00,0xc0,0x00,
 0x00,0x00,0x03,0x00,0x00,0x00,0x00,0x80,0x00,0x00,0x00,0x07,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x00},

 { /* static char central_america_bits[] = { */
 0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0e,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xff,0x03,0x00,0x00,0x00,
 0x00,0x00,0xfe,0xff,0x07,0x00,0x00,0x00,0x00,0x00,0xfc,0xff,0x07,0x00,0x00,
 0x00,0x00,0x00,0xfc,0xff,0x0f,0x00,0x00,0x00,0x00,0x00,0xb8,0xff,0xff,0x00,
 0x00,0x00,0x00,0x00,0x18,0xff,0xff,0x01,0x00,0x00,0x00,0x00,0x10,0xfe,0xff,
 0x03,0x00,0x00,0x00,0x00,0x30,0xf8,0xff,0x07,0x00,0x00,0x00,0x00,0x20,0xf0,
 0xff,0x0f,0x00,0x00,0x00,0x00,0x40,0xf0,0xff,0x1f,0x00,0x00,0x00,0x00,0x40,
 0xe0,0xff,0x1f,0x00,0x00,0x00,0x00,0x80,0xc0,0xff,0x1f,0x00,0x00,0x00,0x00,
 0x00,0xc1,0xff,0x1f,0x00,0x00,0x00,0x00,0x00,0x82,0xff,0x1f,0x00,0x00,0x00,
 0x00,0x00,0x02,0xff,0x1f,0x00,0x00,0x00,0x00,0x00,0x04,0xfe,0x3f,0x00,0x00,
 0x00,0x00,0x00,0x00,0xfe,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0x3f,0x00,
 0x00,0x00,0x00,0x00,0x00,0xfc,0x3f,0x00,0x3c,0x00,0x00,0x00,0x00,0xfc,0x3f,
 0x00,0x3f,0x00,0x00,0x00,0x00,0xfc,0x7f,0x80,0x1f,0x00,0x00,0x00,0x00,0xf8,
 0xff,0xc0,0x0f,0x00,0x00,0x00,0x00,0xe0,0xff,0xff,0x0f,0x00,0x00,0x00,0x00,
 0xc0,0xff,0xff,0x0f,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0x0f,0x00,0x00,0x00,
 0x00,0x00,0xf0,0xff,0x0f,0x00,0x00,0x00,0x00,0x00,0xc0,0xff,0x1f,0x00,0x00,
 0x00,0x00,0x00,0x00,0xe0,0xff,0x07,0x00,0x00,0x00,0x00,0x00,0xc0,0xff,0x07,
 0x00,0x00,0x00,0x00,0x00,0x80,0xff,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0xff,
 0x03,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,
 0xe0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x01,0x00,0x00,0x00,0x00,0x00,
 0x00,0x80,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x03,0x00,0x00,0x00,0x00,
 0x00,0x00,0x80,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0f,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0xfe,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x01},

 { /* static char venezuela_bits[] = { */
 0x00,0x30,0x00,0x00,0x00,0x00,0x80,0x7f,0x00,0x00,0x00,0x00,0xc0,0xff,0x00,
 0x00,0x00,0x00,0xe0,0xff,0xe1,0x03,0x00,0x00,0xf0,0xff,0xff,0x07,0x00,0x00,
 0xf0,0xff,0xff,0x1f,0x00,0x00,0xf8,0xff,0xff,0x1f,0x00,0x00,0xfc,0xff,0xff,
 0x3f,0x00,0x00,0xfe,0xff,0xff,0x7f,0x00,0x00,0xfe,0xff,0xff,0xff,0x01,0x00,
 0xfc,0xff,0xff,0xff,0x03,0x00,0xfc,0xff,0xff,0xff,0x1f,0x00,0xfc,0xff,0xff,
 0xff,0x7f,0x00,0xfc,0xff,0xff,0xff,0xff,0x01,0xfc,0xff,0xff,0xef,0xff,0x03,
 0xfc,0xff,0xfe,0xe3,0xff,0x07,0xfe,0xff,0xfe,0xe0,0xff,0x0f,0xfe,0x7f,0x7e,
 0x00,0x00,0x00,0xff,0x3f,0x7e,0x00,0x00,0x00,0xfc,0x1f,0x3c,0x00,0x00,0x00,
 0xf8,0x1f,0x38,0x00,0x00,0x00,0xe0,0x1f,0x00,0x00,0x00,0x00,0xc0,0x1f,0x00,
 0x00,0x00,0x00,0x00,0x3f,0x00,0x00,0x00,0x00,0x00,0x3e,0x00,0x00,0x00,0x00,
 0x00,0x3c,0x00,0x00,0x00,0x00},

 { /* static char peru_bits[] = { */
 0xe0,0x00,0x00,0x00,0x00,0xe0,0x01,0x00,0x00,0x00,0xf0,0x07,0x00,0x00,0x00,
 0xf0,0x0f,0x00,0x00,0x00,0xf0,0x3f,0x00,0x00,0x00,0xf8,0x7f,0x00,0x00,0x00,
 0xfc,0xff,0x00,0x00,0x00,0xfe,0xff,0x03,0x00,0x00,0xfe,0xff,0x03,0x00,0x00,
 0xfe,0xff,0x03,0x00,0x00,0xfe,0xff,0x00,0x00,0x00,0xff,0x7f,0x00,0x00,0x00,
 0xfe,0x3f,0x00,0x00,0x00,0xfc,0x1f,0x00,0x00,0x00,0xf8,0x0f,0x00,0x00,0x00,
 0xf8,0x0f,0x00,0x00,0x00,0xf8,0x1f,0x00,0x00,0x00,0xf0,0x1f,0x00,0x00,0x00,
 0xe0,0x3f,0x00,0x00,0x00,0xe0,0x7f,0x00,0x00,0x00,0xe0,0xff,0x01,0x00,0x00,
 0xc0,0xff,0x07,0x03,0x00,0x80,0xff,0xff,0x03,0x00,0x00,0xff,0xff,0x07,0x00,
 0x00,0xff,0xff,0x07,0x00,0x00,0xff,0xff,0x7f,0x00,0x00,0xfe,0xff,0xff,0x00,
 0x00,0xfe,0xff,0xff,0x01,0x00,0xfe,0xff,0xff,0x03,0x00,0xfc,0xff,0xff,0x07,
 0x00,0xe0,0xff,0xff,0x0f,0x00,0x80,0xff,0xff,0x1f,0x00,0x00,0xff,0xff,0x3f,
 0x00,0x00,0xfe,0xff,0x3f,0x00,0x00,0xfc,0xff,0x3f,0x00,0x00,0xfc,0xff,0x3f,
 0x00,0x00,0xfc,0xff,0x3f,0x00,0x00,0xf8,0xff,0x3f,0x00,0x00,0xf8,0xff,0x3f,
 0x00,0x00,0xf8,0xff,0x3f,0x00,0x00,0xf8,0xff,0x3f,0x00,0x00,0xf8,0x00,0x7f,
 0x00,0x00,0xfc,0x00,0x7e,0x00,0x00,0x7c,0x00,0x7c,0x00,0x00,0x3c,0x00,0x7c,
 0x00,0x00,0x3c,0x00,0x7c,0x00,0x00,0x1c,0x00,0x3c,0x00,0x00,0x1c,0x00,0x3c,
 0x00,0x00,0x0c,0x00,0x3c,0x00,0x00,0x0c,0x00,0x18,0x00,0x00,0x04,0x00,0x10,
 0x00,0x00,0x00,0x00,0x10},

 { /* static char brazil_bits[] = { */
 0x00,0x00,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x70,0x00,0x00,0x00,0x00,
 0x00,0x00,0x04,0x7c,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0xfe,0xff,0x7f,0x00,
 0x00,0x00,0x00,0x07,0xfe,0xff,0x7f,0x00,0x00,0x00,0x80,0x0f,0xff,0xff,0x7f,
 0x00,0x00,0x00,0x80,0x1f,0xff,0xff,0x7f,0x00,0x00,0x00,0x80,0xff,0xff,0xff,
 0xff,0x00,0x00,0x00,0x80,0xff,0xff,0xff,0xff,0x01,0x00,0x00,0x00,0xff,0xff,
 0xff,0xff,0x7f,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0xff,
 0xff,0xff,0xff,0xff,0x03,0x00,0xc0,0xff,0xff,0xff,0xff,0xff,0x3f,0x00,0xc0,
 0xff,0xff,0xff,0xff,0xff,0xff,0x03,0xc0,0xff,0xff,0xff,0xff,0xff,0xff,0x0f,
 0xf0,0xff,0xff,0xff,0xff,0xff,0xff,0x3f,0xf8,0xff,0xff,0xff,0xff,0xff,0xff,
 0x7f,0xfc,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfe,0xff,0xff,0xff,0xff,0xff,
 0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
 0xff,0xff,0xff,0xfe,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfe,0xff,0xff,0xff,
 0xff,0xff,0xff,0xff,0xfc,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xf8,0xff,0xff,
 0xff,0xff,0xff,0xff,0xff,0xe0,0xff,0xff,0xff,0xff,0xff,0xff,0x7f,0x80,0xcf,
 0xff,0xff,0xff,0xff,0xff,0x3f,0x00,0xc0,0xff,0xff,0xff,0xff,0xff,0x1f,0x00,
 0x80,0xff,0xff,0xff,0xff,0xff,0x0f,0x00,0x80,0xff,0xff,0xff,0xff,0xff,0x0f,
 0x00,0x00,0xf8,0xff,0xff,0xff,0xff,0x07,0x00,0x00,0xf0,0xff,0xff,0xff,0xff,
 0x03,0x00,0x00,0xe0,0xff,0xff,0xff,0xff,0x03,0x00,0x00,0xc0,0xff,0xff,0xff,
 0xff,0x01,0x00,0x00,0x80,0xff,0xff,0xff,0xff,0x01,0x00,0x00,0x00,0xff,0xff,
 0xff,0xff,0x01,0x00,0x00,0x00,0xfe,0xff,0xff,0xff,0x01,0x00,0x00,0x00,0xfc,
 0xff,0xff,0xff,0x00,0x00,0x00,0x00,0xfc,0xff,0xff,0xff,0x00,0x00,0x00,0x00,
 0xfc,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0xfc,0xff,0xff,0xff,0x00,0x00,0x00,
 0x00,0xfc,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0xfc,0xff,0xff,0xff,0x00,0x00,
 0x00,0x00,0xfc,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0xfc,0xff,0xff,0x7f,0x00,
 0x00,0x00,0x00,0xfc,0xff,0xff,0x7f,0x00,0x00,0x00,0x00,0xf8,0xff,0xff,0x1f,
 0x00,0x00,0x00,0x00,0xf8,0xff,0xff,0x0f,0x00,0x00,0x00,0x00,0xf8,0xff,0xff,
 0x03,0x00,0x00,0x00,0x00,0xf8,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0xff,
 0x7f,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,
 0xff,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x03,0x00,0x00,0x00,0x00,0x00,
 0x00,0xfc,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0x01,0x00,0x00,0x00,0x00,
 0x00,0x00,0xfe,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x00,0x00,0x00,0x00,
 0x00,0x00,0x80,0x7f,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x7f,0x00,0x00,0x00,
 0x00,0x00,0x00,0xc0,0x7f,0x00,0x00,0x00,0x00,0x00,0x00,0xe0,0x3f,0x00,0x00,
 0x00,0x00,0x00,0x00,0xe0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x3f,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1e,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x04,0x00,0x00,0x00},

 { /* static char argentina_bits[] = { */
 0x00,0xc0,0x3f,0x00,0x00,0x00,0xc0,0x7f,0x00,0x00,0x00,0xe0,0xff,0x00,0x00,
 0x00,0xf0,0xff,0x00,0x00,0x00,0xf0,0xff,0xe0,0x03,0x00,0xf8,0xff,0xf0,0x03,
 0x00,0xf8,0xff,0xf0,0x03,0x00,0xfc,0xff,0xf0,0x0f,0x00,0xfc,0xff,0xf9,0x0f,
 0x00,0xfe,0xff,0xfb,0x07,0x00,0xff,0xff,0xfb,0x07,0x00,0xff,0xff,0xff,0x03,
 0x00,0xff,0xff,0xff,0x01,0x80,0xff,0xff,0xff,0x00,0x80,0xff,0xff,0xff,0x00,
 0xc0,0xff,0xff,0x7f,0x00,0xc0,0xff,0xff,0x7f,0x00,0xc0,0xff,0xff,0xff,0x00,
 0xc0,0xff,0xff,0xff,0x03,0xc0,0xff,0xff,0xff,0x07,0xc0,0xff,0xff,0xff,0x0f,
 0xe0,0xff,0xff,0xff,0x0f,0xe0,0xff,0xff,0xff,0x0f,0xe0,0xff,0xff,0xff,0x0f,
 0xe0,0xff,0xff,0xff,0x07,0xe0,0xff,0xff,0xff,0x07,0xe0,0xff,0xff,0xff,0x03,
 0xe0,0xff,0xff,0x3f,0x00,0xf0,0xff,0xff,0x1f,0x00,0xf0,0xff,0xff,0x1f,0x00,
 0xf8,0xff,0xff,0x1f,0x00,0xf8,0xff,0xff,0x3f,0x00,0xf8,0xff,0xff,0x1f,0x00,
 0xf8,0xff,0xff,0x0f,0x00,0xf0,0xff,0xff,0x0f,0x00,0xe0,0xff,0xbf,0x07,0x00,
 0xe0,0xff,0x1f,0x00,0x00,0xf0,0xff,0x1f,0x00,0x00,0xf8,0xff,0x0f,0x00,0x00,
 0xf8,0xff,0x0f,0x00,0x00,0xfc,0xff,0x03,0x00,0x00,0xfe,0xff,0x01,0x00,0x00,
 0xfc,0xff,0x01,0x00,0x00,0xfc,0xff,0x01,0x00,0x00,0xf8,0xff,0x01,0x00,0x00,
 0xf8,0xff,0x01,0x00,0x00,0xf8,0xff,0x01,0x00,0x00,0xf8,0xff,0x00,0x00,0x00,
 0xf8,0xff,0x00,0x00,0x00,0xfc,0x7f,0x00,0x00,0x00,0xfc,0x7f,0x00,0x00,0x00,
 0xfc,0x1f,0x00,0x00,0x00,0xfe,0x0f,0x00,0x00,0x00,0xfe,0x0f,0x00,0x00,0x00,
 0xfe,0x0f,0x00,0x00,0x00,0xfe,0x1f,0x00,0x00,0x00,0xfe,0x7f,0x00,0x00,0x00,
 0xfe,0x7f,0x00,0x00,0x00,0xff,0x7f,0x00,0x00,0x00,0xff,0x3f,0x00,0x00,0x00,
 0xff,0x1f,0x00,0x00,0x00,0xff,0x0f,0x00,0x00,0x00,0xff,0x07,0x00,0x00,0x00,
 0xff,0x03,0x00,0x00,0x00,0xff,0x01,0x00,0x00,0x00,0xff,0x01,0x00,0x00,0x00,
 0xff,0x01,0x00,0x00,0x00,0xff,0x01,0x00,0x00,0x00,0xff,0x01,0x00,0x00,0x00,
 0xfe,0x01,0x00,0x00,0x00,0xee,0x03,0x00,0x00,0x00,0x84,0x07,0x00,0x00,0x00,
 0x00,0x07,0x00,0x00,0x00,0x00,0x0e,0x00,0x00,0x00,0x00,0x1f,0x00,0x00,0x00,
 0x00,0xff,0x00,0x00,0x00,0x80,0xff,0x01,0x00,0x00,0xc0,0xff,0x01,0x00,0x00,
 0x00,0xfb,0x01,0x00,0x00,0x00,0xf0,0x01,0x00,0x00},

 { /* static char iceland_bits[] = { */
 0x46,0x00,0xef,0x38,0xfc,0x7f,0xf8,0x7f,0xf8,0x7f,0xfc,0x7f,0xff,0x7f,0xf8,
 0x3f,0xf0,0x1f,0x40,0x00},

 { /* static char scandinavia_bits[] = { */
 0x00,0x00,0x00,0xc0,0x0f,0x00,0x00,0x00,0xfc,0x1f,0x00,0x00,0x00,0xfe,0x3f,
 0x00,0x00,0x60,0xff,0x1f,0x00,0x00,0xf0,0xff,0x0f,0x00,0x00,0xf8,0xff,0x1f,
 0x00,0x00,0xfc,0xff,0x7f,0x00,0x00,0xfc,0xff,0x7f,0x00,0x00,0xfc,0xff,0x3f,
 0x00,0x00,0xfe,0xff,0x0f,0x00,0x00,0xfe,0xff,0x0f,0x00,0x00,0xff,0xff,0x0f,
 0x00,0x00,0xff,0xff,0x0f,0x00,0x80,0xff,0xff,0x3f,0x00,0x80,0xff,0xff,0x7f,
 0x00,0xc0,0xff,0xff,0x7f,0x00,0xe0,0xff,0xff,0x7f,0x00,0xe0,0xff,0xff,0x7f,
 0x00,0xf0,0xff,0xff,0x7f,0x00,0xf0,0xff,0xff,0x3f,0x00,0xf0,0xff,0xff,0x3f,
 0x00,0xf8,0xff,0xff,0x3f,0x00,0xf8,0xff,0xc7,0x3f,0x00,0xfc,0xff,0x81,0x3f,
 0x00,0xfc,0xff,0xc0,0x3f,0x00,0xfc,0xff,0xc0,0x3f,0x00,0xfe,0xff,0xc0,0x3f,
 0x80,0xff,0xff,0xe0,0x3f,0x80,0xff,0x7f,0xf0,0x3f,0xc0,0xff,0x3f,0xf8,0x3f,
 0xe0,0xff,0x1f,0xfc,0x3f,0xf8,0xff,0x0f,0xfe,0x7f,0xfc,0xff,0x07,0xfe,0x7f,
 0xfc,0xff,0x03,0xfe,0x7f,0xfe,0xff,0x03,0xfe,0x7f,0xff,0xff,0x03,0xfe,0x7f,
 0xff,0xff,0x03,0xfe,0x7f,0xff,0xff,0x03,0xfe,0x3f,0xff,0xff,0x03,0xfe,0x1f,
 0xff,0xff,0x03,0xfe,0x0f,0xff,0xff,0x07,0xfc,0x03,0xff,0xfe,0x0f,0xe0,0x01,
 0x7f,0xfc,0x0f,0x00,0x00,0x3f,0xfc,0x07,0x00,0x00,0x1f,0xfc,0x07,0x00,0x00,
 0x1f,0xfc,0x03,0x00,0x00,0x1e,0xfc,0x01,0x00,0x00,0x0e,0xfc,0x01,0x00,0x00,
 0x00,0xfc,0x01,0x00,0x00,0x00,0xfc,0x01,0x00,0x00,0x00,0xfc,0x00,0x00,0x00,
 0x00,0xfc,0x00,0x00,0x00,0x00,0x78,0x00,0x00,0x00,0x00,0x30,0x00,0x00,0x00,
 0x00,0x10,0x00,0x00,0x00},

 { /* static char great_britain_bits[] = { */
 0x00,0x02,0x00,0x00,0x02,0x00,0x00,0x02,0x00,0x00,0x07,0x00,0x80,0x0f,0x00,
 0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x0e,0x00,0x00,0x1c,0x00,0x00,0x3c,0x00,
 0xf8,0x3e,0x00,0xfc,0x7c,0x00,0x7f,0xf8,0x00,0x7f,0xf8,0x00,0x7e,0xfc,0x01,
 0x7c,0xfc,0x01,0x7c,0xfc,0x03,0x3c,0xfc,0x03,0x04,0xfc,0x03,0x00,0xf8,0x03,
 0x00,0x7c,0x04,0x00,0x06,0x00,0x80,0x01,0x00},

 { /* static char northern_europe_bits[] = { */
 0x00,0x00,0x00,0x00,0x1f,0x00,0x00,0x00,0x00,0xf0,0x1f,0x00,0x00,0x00,0x00,
 0xf0,0x3f,0x00,0x00,0x00,0x00,0xf8,0x3f,0x00,0x00,0x00,0x00,0xf8,0x7f,0x00,
 0x00,0x00,0x00,0xf8,0xff,0x00,0x00,0x00,0x00,0xfc,0xff,0x01,0x00,0x00,0x00,
 0xfc,0xff,0x03,0x00,0x00,0x00,0xfe,0xff,0x07,0x00,0x00,0xfc,0xff,0xff,0x07,
 0x80,0xff,0xff,0xff,0xff,0x07,0xf0,0xff,0xff,0xff,0xff,0x07,0xf8,0xff,0xff,
 0xff,0xff,0x0f,0xf8,0xff,0xff,0xff,0xff,0x0f,0xfc,0xff,0xff,0xff,0x0f,0x00,
 0xfc,0xff,0xff,0xff,0x03,0x00,0xfe,0xff,0xff,0xff,0x01,0x00,0xff,0xff,0xff,
 0xff,0x01,0x00,0xfe,0xff,0xff,0xff,0x00,0x00,0xfc,0xff,0xff,0x7f,0x00,0x00,
 0xfc,0xff,0xff,0x3f,0x00,0x00,0xe0,0xff,0xff,0x3f,0x00,0x00,0xe0,0xff,0xff,
 0x3f,0x00,0x00,0xc0,0xff,0xff,0x1f,0x00,0x00,0x80,0xff,0xff,0x03,0x00,0x00,
 0x80,0xff,0x3f,0x00,0x00,0x00,0x80,0xff,0x07,0x00,0x00,0x00,0xc0,0x03,0x00,
 0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x00},

 { /* static char ukraine_bits[] = { */
 0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7c,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0xff,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x1f,0x00,0x00,
 0x40,0x60,0x00,0x00,0xff,0x3f,0x80,0x03,0xe0,0x70,0x00,0x00,0xff,0x3f,0x00,
 0x07,0xf8,0x7f,0x00,0x00,0xfc,0x7f,0x00,0x07,0xff,0x7f,0x00,0x00,0xf8,0xff,
 0x00,0x83,0xff,0x7f,0x00,0x00,0xf8,0xff,0x03,0xc1,0xff,0x7f,0x00,0x00,0xf8,
 0xff,0x03,0xe1,0xff,0x7f,0x00,0x00,0xf8,0xff,0x03,0xf3,0xff,0x7f,0x00,0x00,
 0xf8,0xff,0x03,0xff,0xff,0x7f,0x00,0x00,0xfc,0xff,0x01,0xff,0xff,0x7f,0x00,
 0x00,0xfc,0xff,0xb0,0xff,0xff,0x7f,0x00,0x00,0xfc,0x7f,0xf0,0xff,0xff,0x7f,
 0x00,0x00,0xfc,0x1f,0xf8,0xff,0xff,0x7f,0x00,0x00,0xfc,0x0f,0xfc,0xff,0xff,
 0x7f,0x00,0x00,0xfc,0x1f,0xff,0xff,0xff,0x7f,0x00,0x00,0xfc,0xff,0xff,0xff,
 0xff,0x7f,0x00,0x00,0xfc,0xff,0xff,0xff,0xff,0x7f,0x00,0x00,0xfc,0xff,0xff,
 0xff,0xff,0x7f,0x00,0x00,0xfc,0xff,0xff,0xff,0xff,0x7f,0x00,0x00,0xfc,0xff,
 0xff,0xff,0xff,0x7f,0x00,0x00,0xfc,0xff,0xff,0xff,0xff,0x7f,0x00,0x00,0xf8,
 0xff,0xff,0xff,0xff,0x7f,0x00,0x00,0xf8,0xff,0xff,0xff,0xff,0x7f,0x00,0x00,
 0xf8,0xff,0xff,0xff,0xff,0x7f,0x00,0x00,0xf8,0xff,0xff,0xff,0xff,0x7f,0x00,
 0x00,0xf8,0xff,0xff,0xff,0xff,0x7f,0x00,0x00,0xf8,0xff,0xff,0xff,0xff,0xff,
 0x00,0x00,0xfc,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0xfe,0xff,0xff,0xff,0xff,
 0xff,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0x01,0xc0,0xff,0xff,0xff,0xff,
 0xff,0xff,0x01,0xe0,0xff,0xff,0xff,0xff,0xff,0xff,0x03,0xfc,0xff,0xff,0xff,
 0xff,0xff,0xff,0x03,0xfe,0xff,0xff,0xff,0xff,0xff,0xff,0x03,0xff,0xff,0xff,
 0xff,0xff,0xff,0xff,0x07,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x07,0xff,0xff,
 0xff,0xff,0xff,0xff,0xff,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0f,0xfe,
 0xff,0xff,0xff,0xff,0xff,0xff,0x0f,0xe0,0xff,0xff,0xff,0xff,0xff,0xff,0x07,
 0xe0,0xff,0xff,0xff,0xff,0xff,0xff,0x07,0xc0,0xff,0xff,0xff,0xff,0xff,0xff,
 0x07,0xc0,0xff,0xff,0xff,0xff,0xff,0xff,0x07,0x80,0xff,0xff,0xff,0xff,0xff,
 0xff,0x07,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0x07,0x00,0xfe,0xff,0xff,0xff,
 0xff,0xff,0x07,0x00,0xfc,0xff,0xff,0xff,0xff,0xff,0x07,0x00,0xf8,0xff,0xff,
 0xff,0xff,0xff,0x03,0x00,0xf8,0xff,0xff,0xff,0xff,0xff,0x01,0x00,0xf8,0xff,
 0xff,0xff,0xff,0xff,0x01,0x00,0xf8,0xff,0xff,0xff,0xfd,0xff,0x00,0x00,0xf0,
 0xff,0xff,0xff,0xfd,0x7f,0x00,0x00,0xf0,0xff,0xff,0xff,0xf9,0x0f,0x00,0x00,
 0xf0,0xff,0xff,0xff,0xe0,0x07,0x00,0x00,0xf0,0xff,0xff,0xff,0x00,0x00,0x00,
 0x00,0xc0,0xff,0xff,0x7f,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0x7f,0x00,0x00,
 0x00,0x00,0x00,0xfe,0xff,0x7f,0x00,0x00,0x00,0x00,0x00,0xfc,0xff,0x7f,0x00,
 0x00,0x00,0x00,0x00,0xc0,0xff,0x7f,0x00,0x00,0x00,0x00,0x00,0x80,0xff,0x7f,
 0x00,0x00,0x00,0x00,0x00,0xc0,0xff,0x7f,0x00,0x00,0x00,0x00,0x00,0x80,0xff,
 0x7f,0x00,0x00,0x00,0x00,0x00,0x80,0xff,0x7f,0x00,0x00,0x00,0x00,0x00,0xc0,
 0xff,0x7f,0x00,0x00,0x00,0x00,0x00,0xf0,0xff,0x7f,0x00,0x00,0x00,0x00,0x00,
 0xf0,0xff,0x3f,0x00,0x00,0x00,0x00,0x00,0xe0,0xff,0x1f,0x00,0x00,0x00,0x00,
 0x00,0xe0,0xff,0x0f,0x00,0x00,0x00,0x00,0x00,0xe0,0xff,0x03,0x00,0x00,0x00,
 0x00,0x00,0xf8,0xff,0x01,0x00,0x00,0x00,0x00,0x00,0xf0,0xff,0x03,0x00,0x00,
 0x00,0x00,0x00,0xc0,0xff,0x03,0x00,0x00,0x00,0x00,0x00,0x80,0xff,0x07,0x00,
 0x00,0x00,0x00,0x00,0x00,0xff,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0x07,
 0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,
 0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,
 0xf0,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0xe0,0x1f,0x00,0x00,0x00,0x00,0x00,
 0x00,0x80,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0f,0x00,0x00,0x00},

 { /* static char western_europe_bits[] = { */
 0x00,0x00,0x04,0x00,0x00,0x00,0x0e,0x00,0x00,0x00,0x1f,0x00,0x00,0x80,0x1f,
 0x00,0x00,0xe0,0xff,0x00,0x00,0xfe,0xff,0x00,0x00,0xff,0xff,0x01,0x00,0xff,
 0xff,0x03,0x00,0xfc,0xff,0x03,0x00,0xf8,0xff,0x03,0x00,0xf8,0xff,0x01,0x00,
 0xf0,0xff,0x01,0x00,0xf0,0xff,0x01,0x00,0xf0,0xff,0x00,0x00,0xf0,0xff,0x00,
 0x00,0xf0,0xff,0x01,0x00,0xf0,0xff,0x01,0x06,0xf8,0xff,0x01,0xff,0xff,0xcf,
 0x01,0xff,0xff,0x07,0x00,0xff,0xff,0x03,0x00,0xff,0xff,0x07,0x00,0xff,0xff,
 0x01,0x00,0xff,0xff,0x00,0x00,0xff,0x7f,0x00,0x00,0xff,0x3f,0x00,0x00,0xff,
 0x3f,0x00,0x00,0xff,0x1f,0x00,0x00,0xff,0x0f,0x00,0x00,0xff,0x07,0x00,0x00,
 0xff,0x07,0x00,0x00,0xfe,0x03,0x00,0x00,0x7c,0x00,0x00,0x00},

 { /* static char southern_europe_bits[] = { */
 0x00,0x00,0x00,0x80,0x7f,0x00,0x00,0x00,0x00,0x00,0xe0,0x7f,0x00,0x00,0x00,
 0x00,0x00,0xf0,0xff,0x01,0x00,0x00,0x00,0x00,0xf0,0xff,0x07,0x00,0x00,0x00,
 0x00,0xf8,0xff,0x0f,0x00,0x00,0x00,0x00,0xfc,0xff,0x1f,0x00,0x00,0x00,0x00,
 0xfe,0xff,0xff,0x01,0x00,0x00,0x00,0xfe,0xff,0xff,0x03,0x00,0x00,0x00,0xfe,
 0xff,0xff,0x01,0x00,0x00,0x00,0xff,0xff,0xff,0x03,0x00,0x00,0xe0,0xff,0xff,
 0xff,0x03,0x00,0x00,0xfe,0xff,0xff,0xff,0x01,0x00,0xc0,0xff,0xff,0xff,0x7f,
 0x00,0xe0,0xff,0xff,0xff,0xff,0x7f,0x00,0xf8,0xff,0xff,0xff,0xff,0xff,0x00,
 0xfe,0xff,0xff,0xff,0x07,0xff,0x00,0xff,0xff,0xff,0xff,0x03,0xfc,0x00,0xff,
 0xff,0xff,0xff,0x03,0x38,0x00,0xfe,0xf3,0xff,0xff,0x03,0x00,0x00,0xfe,0xc1,
 0xff,0xff,0x03,0x00,0x00,0xfe,0x83,0xff,0xff,0x01,0x00,0x00,0xfc,0x07,0xff,
 0xff,0x01,0x00,0x00,0xb8,0x0f,0xfe,0xff,0x01,0x00,0x00,0x10,0x0f,0xfc,0xff,
 0x01,0x00,0x00,0x00,0x1e,0xf8,0xff,0x01,0x00,0x00,0x00,0x3e,0xf0,0xff,0x00,
 0x00,0x00,0x00,0xfc,0xf0,0x7f,0x00,0x00,0x00,0x00,0xf0,0xf0,0x0f,0x00,0x00,
 0x00,0x00,0xc0,0xf1,0x07,0x00,0x00,0x00,0x00,0x80,0xfb,0x03,0x00,0x00,0x00,
 0x00,0xc0,0xf1,0x03,0x00,0x00,0x00,0x00,0xc0,0xe0,0x03,0x00,0x00,0x00,0x00,
 0x60,0xc0,0x03,0x00,0x00,0x00,0x00,0x3e,0xc0,0x01,0x00,0x00,0x00,0x00,0x18,
 0x80,0x01,0x00,0x00,0x00},

 { /* static char north_africa_bits[] = { */
 0x00,0x00,0xc0,0x03,0x70,0x07,0x00,0x00,0x00,0x00,0x00,0xfc,0xff,0xff,0x0f,
 0x00,0x00,0x00,0x00,0x00,0xfe,0xff,0xff,0x0f,0x00,0x00,0x00,0x00,0x00,0xfe,
 0xff,0xff,0x1f,0x00,0x00,0x00,0x00,0x00,0xfe,0xff,0xff,0x0f,0x00,0x00,0x00,
 0x00,0x00,0xff,0xff,0xff,0x07,0x00,0x00,0x00,0x00,0x80,0xff,0xff,0xff,0x0f,
 0x00,0x00,0x00,0x00,0x80,0xff,0xff,0xff,0x0f,0x00,0x00,0x00,0x00,0x80,0xff,
 0xff,0xff,0x0f,0x00,0x00,0x00,0x00,0xc0,0xff,0xff,0xff,0x07,0x00,0x00,0x00,
 0x00,0xc0,0xff,0xff,0xff,0x03,0x00,0x00,0x00,0x00,0xc0,0xff,0xff,0xff,0x03,
 0x00,0x00,0x00,0x00,0xe0,0xff,0xff,0xff,0x01,0x00,0x00,0x00,0x00,0xf0,0xff,
 0xff,0xff,0x01,0x00,0x00,0x00,0x00,0xf8,0xff,0xff,0xff,0x00,0x00,0x00,0x00,
 0x00,0xfc,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x80,0xff,0xff,0xff,0xff,0x00,
 0x00,0x00,0x00,0x80,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x80,0xff,0xff,
 0xff,0xff,0x00,0x00,0x00,0x00,0xc0,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,
 0xf0,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0xe0,0xff,0xff,0xff,0xff,0x00,
 0x00,0x00,0x00,0xe0,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0xe0,0xff,0xff,
 0xff,0xff,0x01,0x00,0x00,0x00,0xf0,0xff,0xff,0xff,0xff,0x03,0x00,0x00,0x00,
 0xfe,0xff,0xff,0xff,0xff,0x07,0x00,0x00,0x00,0xfe,0xff,0xff,0xff,0xff,0x0f,
 0x00,0x00,0x00,0xfe,0xff,0xff,0xff,0xff,0x7f,0x00,0x00,0x00,0xfc,0xff,0xff,
 0xff,0xff,0xff,0x01,0x00,0x00,0xfe,0xff,0xff,0xff,0xff,0xff,0x0f,0x00,0x00,
 0xfe,0xff,0xff,0xff,0xff,0xff,0x7f,0x00,0x00,0xfe,0xff,0xff,0xff,0xff,0xff,
 0xff,0x03,0x00,0xfc,0xff,0xff,0xff,0xff,0xff,0xff,0x1f,0x00,0xfc,0xff,0xff,
 0xff,0xff,0xff,0xff,0xff,0x00,0xfe,0xff,0xff,0xff,0xff,0xff,0xff,0x7f,0x00,
 0xfe,0xff,0xff,0xff,0xff,0xff,0xff,0x7f,0x00,0xff,0xff,0xff,0xff,0xff,0xff,
 0xff,0x7f,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x3f,0x00,0xff,0xff,0xff,
 0xff,0xff,0xff,0xff,0x1f,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x1f,0x00,
 0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x1f,0x00,0xfc,0xff,0xff,0xff,0xff,0xff,
 0xff,0x1f,0x00,0xf8,0xff,0xff,0xff,0xff,0xff,0xff,0x1f,0x00,0xf0,0xff,0xff,
 0xff,0xff,0xff,0xff,0x1f,0x00,0xe0,0xff,0xff,0xff,0xff,0xff,0xff,0x1f,0x00,
 0xc0,0xff,0xff,0xff,0xff,0xff,0xff,0x3f,0x00,0x80,0xff,0xff,0xff,0xff,0xff,
 0xff,0x3f,0x00,0x80,0xff,0xff,0xff,0xff,0xff,0xff,0x3f,0x00,0x80,0xff,0xff,
 0xff,0xff,0xff,0xff,0x7f,0x00,0x00,0xfe,0xff,0xff,0xff,0xff,0xff,0xff,0x00,
 0x00,0xfc,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0xf0,0xff,0xff,0xff,0xff,
 0xff,0xff,0x01,0x00,0xe0,0xff,0x0f,0xfe,0xff,0xff,0xff,0x03,0x00,0xe0,0x83,
 0x07,0xf8,0xff,0xff,0x3f,0x00,0x00,0xc0,0x00,0x00,0xc0,0xff,0xff,0x07,0x00,
 0x00,0x00,0x00,0x00,0x00,0xfe,0x7f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,
 0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0x3f,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0xfc,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0x1f,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0xfe,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,
 0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x1f,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0xff,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0x0f,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0xfc,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,
 0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x03,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0xf0,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe0,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x60,0x00,0x00,0x00},

 { /* static char egypt_bits[] = { */
 0x10,0x00,0x00,0x00,0x00,0x00,0xf0,0x00,0x00,0x00,0x00,0x00,0xf8,0x07,0xf8,
 0x00,0x00,0x00,0xfc,0x0f,0xfc,0x01,0x20,0x00,0xfc,0x1f,0xf8,0x7f,0x7e,0x00,
 0xfe,0x3f,0xfc,0xff,0x7f,0x00,0xfe,0x7f,0xfe,0xff,0x7f,0x00,0xff,0xff,0xff,
 0xff,0x7f,0x00,0xff,0xff,0xff,0xff,0xff,0x00,0xff,0xff,0xff,0xff,0xff,0x00,
 0xff,0xff,0xff,0xff,0x7f,0x00,0xff,0xff,0xff,0xff,0xff,0x00,0xff,0xff,0xff,
 0xff,0xff,0x00,0xff,0xff,0xff,0xff,0xff,0x00,0xff,0xff,0xff,0xff,0xff,0x00,
 0xff,0xff,0xff,0xff,0xff,0x01,0xfe,0xff,0xff,0xff,0xff,0x01,0xfc,0xff,0xff,
 0xff,0xff,0x03,0xf8,0xff,0xff,0xff,0xff,0x03,0xf0,0xff,0xff,0xff,0xff,0x07,
 0x80,0xff,0xff,0xff,0x3f,0x00,0x00,0xfe,0xff,0xff,0x01,0x00,0x00,0xf0,0xff,
 0x07,0x00,0x00,0x00,0x80,0xff,0x03,0x00,0x00,0x00,0x00,0xfc,0x03,0x00,0x00,
 0x00,0x00,0xe0,0x01,0x00,0x00},

 { /* static char east_africa_bits[] = { */
 0x00,0x00,0x7e,0x00,0x00,0x00,0x00,0xf0,0x7f,0x00,0x00,0x00,0xc0,0xff,0x7f,
 0x00,0x00,0x00,0xe0,0xff,0x7f,0x00,0x00,0x00,0xe0,0xff,0xff,0x00,0x00,0x00,
 0xf0,0xff,0xff,0x01,0x00,0x00,0xf8,0xff,0xff,0x03,0x00,0x00,0xfc,0xff,0xff,
 0x03,0x00,0x00,0xfc,0xff,0xff,0x03,0x00,0x00,0xfc,0xff,0xff,0x07,0x00,0x00,
 0xfe,0xff,0xff,0x07,0x00,0x00,0xff,0xff,0xff,0x07,0x00,0x00,0xff,0xff,0xff,
 0x1f,0x00,0x00,0xff,0xff,0xff,0x3f,0x00,0x00,0xff,0xff,0xff,0x7f,0x00,0x00,
 0xff,0xff,0xff,0x7f,0x00,0x00,0xff,0xff,0xff,0x3f,0x00,0x08,0xff,0xff,0xff,
 0x3f,0x00,0x0f,0xfe,0xff,0xff,0x7f,0xfe,0x0f,0xfe,0xff,0xff,0xff,0xff,0x07,
 0xfe,0xff,0xff,0xff,0xff,0x07,0xfc,0xff,0xff,0xff,0xff,0x03,0xf8,0xff,0xff,
 0xff,0xff,0x03,0xf8,0xff,0xff,0xff,0xff,0x01,0xf0,0xff,0xff,0xff,0xff,0x01,
 0xc0,0xff,0xff,0xff,0xff,0x00,0x00,0xff,0xff,0xff,0xff,0x00,0x00,0xfc,0xff,
 0xff,0x7f,0x00,0x00,0xf8,0xff,0xff,0x7f,0x00,0x00,0xf0,0xff,0xff,0x3f,0x00,
 0x00,0xe0,0xff,0xff,0x1f,0x00,0x00,0xe0,0xff,0xff,0x0f,0x00,0x00,0xe0,0xff,
 0xff,0x0f,0x00,0x00,0xe0,0xff,0xff,0x03,0x00,0x00,0xe0,0xff,0xff,0x01,0x00,
 0x00,0xe0,0xff,0x7f,0x00,0x00,0x00,0xe0,0xff,0x3f,0x00,0x00,0x00,0xe0,0xff,
 0x1f,0x00,0x00,0x00,0xf0,0xff,0x0f,0x00,0x00,0x00,0xf0,0xff,0x07,0x00,0x00,
 0x00,0xf0,0xff,0x07,0x00,0x00,0x00,0xf0,0xff,0x03,0x00,0x00,0x00,0xf0,0xff,
 0x03,0x00,0x00,0x00,0xe0,0xff,0x03,0x00,0x00,0x00,0xe0,0xff,0x01,0x00,0x00,
 0x00,0xe0,0xff,0x01,0x00,0x00,0x00,0xe0,0xff,0x01,0x00,0x00,0x00,0xe0,0xff,
 0x03,0x00,0x00,0x00,0xe0,0xff,0x03,0x00,0x00,0x00,0xc0,0xff,0x03,0x00,0x00,
 0x00,0x00,0xfe,0x07,0x00,0x00,0x00,0x00,0xfe,0x07,0x00,0x00,0x00,0x00,0xfe,
 0x07,0x00,0x00,0x00,0x00,0xfe,0x07,0x00,0x00,0x00,0x00,0x7e,0x00,0x00,0x00,
 0x00,0x00,0x7e,0x00,0x00,0x00,0x00,0x00,0x7e,0x00,0x00,0x00,0x00,0x00,0x7c,
 0x00,0x00,0x00,0x00,0x00,0x38,0x00,0x00,0x00},

 { /* static char congo_bits[] = { */
 0x00,0x00,0x10,0x00,0x00,0x00,0x7f,0x00,0x00,0xe0,0xff,0x01,0x00,0xfe,0xff,
 0x03,0x00,0xff,0xff,0x07,0x00,0xff,0xff,0x0f,0x00,0xff,0xff,0x0f,0x80,0xff,
 0xff,0x0f,0x80,0xff,0xff,0x0f,0x80,0xff,0xff,0x0f,0x80,0xff,0xff,0x0f,0x80,
 0xff,0xff,0x0f,0xc0,0xff,0xff,0x0f,0xe0,0xff,0xff,0x07,0xf0,0xff,0xff,0x07,
 0xf0,0xff,0xff,0x07,0xf8,0xff,0xff,0x07,0xfc,0xff,0xff,0x07,0xfe,0xff,0xff,
 0x0f,0xff,0xff,0xff,0x0f,0xff,0xff,0xff,0x0f,0xc7,0xff,0xff,0x0f,0x80,0xfd,
 0xff,0x0f,0x00,0xf8,0xff,0x0f,0x00,0xf8,0xff,0x0f,0x00,0xf0,0xff,0x0f,0x00,
 0xf0,0xff,0x07,0x00,0xe0,0xff,0x07,0x00,0x00,0xfc,0x07,0x00,0x00,0xf0,0x03
 },

 { /* static char south_africa_bits[] = { */
 0x70,0x00,0x00,0x00,0x00,0x00,0xfc,0x04,0x00,0x00,0x00,0x00,0xf8,0x0f,0x00,
 0x00,0x00,0x00,0xf8,0x0f,0x00,0x20,0x00,0x00,0xf8,0x1f,0x00,0xe0,0x01,0x00,
 0xf8,0x1f,0x00,0xf0,0x01,0x00,0xf8,0x3f,0x00,0xf0,0x01,0x00,0xf8,0xff,0x07,
 0xf0,0x01,0x00,0xfc,0xff,0x1f,0xf8,0x81,0x07,0xfc,0xff,0xff,0xff,0x81,0x07,
 0xfc,0xff,0xff,0xff,0x81,0x07,0xfe,0xff,0xff,0xff,0x83,0x07,0xfe,0xff,0xff,
 0xff,0xc7,0x07,0xfe,0xff,0xff,0xff,0xff,0x07,0xfe,0xff,0xff,0xff,0xff,0x07,
 0xff,0xff,0xff,0xff,0xff,0x07,0xff,0xff,0xff,0xff,0xff,0x07,0xff,0xff,0xff,
 0xff,0x7f,0x00,0xfe,0xff,0xff,0xff,0x3f,0x00,0xfe,0xff,0xff,0xff,0x3f,0x00,
 0xfc,0xff,0xff,0xff,0x1f,0x00,0xfc,0xff,0xff,0xff,0x0f,0x00,0xfc,0xff,0xff,
 0xff,0x07,0x00,0xf8,0xff,0xff,0xff,0x07,0x00,0xf8,0xff,0xff,0xff,0x07,0x00,
 0xf8,0xff,0xff,0xff,0x07,0x00,0xf8,0xff,0xff,0xff,0x07,0x00,0xf8,0xff,0xff,
 0xff,0x0f,0x00,0xf0,0xff,0xff,0xff,0x07,0x00,0xf0,0xff,0xff,0xff,0x07,0x00,
 0xf0,0xff,0xff,0xff,0x03,0x00,0xf0,0xff,0xff,0xff,0x01,0x00,0xe0,0xff,0xff,
 0xff,0x01,0x00,0xc0,0xff,0xff,0xff,0x01,0x00,0x80,0xff,0xff,0xff,0x00,0x00,
 0x80,0xff,0xff,0x7f,0x00,0x00,0x80,0xff,0xff,0x3f,0x00,0x00,0x00,0xff,0xff,
 0x1f,0x00,0x00,0x00,0xff,0xff,0x0f,0x00,0x00,0x00,0xff,0xff,0x07,0x00,0x00,
 0x00,0xfe,0xff,0x07,0x00,0x00,0x00,0xfe,0xff,0x03,0x00,0x00,0x00,0xfe,0xff,
 0x01,0x00,0x00,0x00,0xfe,0xff,0x00,0x00,0x00,0x00,0xfe,0x7f,0x00,0x00,0x00,
 0x00,0xfc,0x07,0x00,0x00,0x00,0x00,0x78,0x00,0x00,0x00,0x00},

 { /* static char madagascar_bits[] = { */
 0x00,0x03,0xc0,0x01,0xe0,0x01,0xe0,0x01,0xf0,0x01,0xf8,0x01,0xfe,0x00,0xfe,
 0x00,0xfe,0x00,0xfe,0x00,0x7e,0x00,0x7c,0x00,0x7e,0x00,0x3e,0x00,0x3f,0x00,
 0x3f,0x00,0x3f,0x00,0x3f,0x00,0x1e,0x00,0x0c,0x00,0x08,0x00},

 { /* static char ural_bits[] = { */
 0x00,0xc0,0x8f,0x01,0x00,0x00,0xc0,0x87,0x01,0x00,0x00,0xc0,0x83,0x03,0x00,
 0x00,0xc0,0x03,0x0f,0x00,0x00,0xe0,0x83,0x1f,0x00,0x00,0xf0,0xc1,0xff,0x00,
 0x00,0xf8,0xe1,0xff,0x03,0x00,0xfc,0xe1,0xff,0x03,0x00,0xfc,0xe3,0xff,0x01,
 0x00,0xfc,0xc3,0xff,0x01,0x00,0xfc,0xc3,0xff,0x01,0x00,0xfc,0xc3,0xff,0x01,
 0x00,0xfc,0xe3,0xff,0x01,0x00,0xfc,0xe3,0xff,0x01,0x00,0xfc,0xe3,0xff,0x01,
 0x0c,0xf8,0xe3,0xff,0x00,0x7c,0xf8,0xe3,0xff,0x00,0xfe,0xfd,0x83,0x7f,0x00,
 0xff,0xff,0x03,0x7f,0x00,0xff,0xff,0x87,0x7f,0x00,0xff,0xff,0xff,0x3f,0x00,
 0xff,0xff,0xff,0x1f,0x00,0xff,0xff,0xff,0x0f,0x00,0xff,0xff,0xff,0x07,0x00,
 0xff,0xff,0xff,0x07,0x00,0xff,0xff,0xff,0x03,0x00,0xff,0xff,0xff,0x03,0x00,
 0xff,0xff,0xff,0x01,0x00,0xff,0xff,0xff,0x01,0x00,0xff,0xff,0xff,0x01,0x00,
 0xff,0xff,0xff,0x01,0x00,0xff,0xff,0xff,0x01,0x00,0xff,0xff,0xff,0x01,0x00,
 0xff,0xff,0xff,0x01,0x00,0xff,0xff,0xff,0x01,0x00,0xff,0xff,0xff,0x01,0x00,
 0xff,0xff,0xff,0x01,0x00,0xff,0xff,0xff,0x01,0x00,0xff,0xff,0xff,0x01,0x00,
 0xff,0xff,0xff,0x01,0x00,0xff,0xff,0xff,0x01,0x00,0xff,0xff,0xff,0x03,0x00,
 0xff,0xff,0xff,0x03,0x00,0xff,0xff,0xff,0x03,0x00,0xfe,0xff,0xff,0x07,0x00,
 0xfe,0xff,0xff,0x07,0x00,0xfe,0xff,0xff,0x0f,0x00,0xfc,0xff,0xff,0x1f,0x00,
 0xfc,0xff,0xff,0x1f,0x00,0xf8,0xff,0xff,0x3f,0x00,0xf8,0xff,0xff,0x3f,0x00,
 0xf8,0xff,0xff,0x7f,0x00,0xf0,0xff,0xff,0xff,0x00,0xf0,0xff,0xff,0xff,0x00,
 0xe0,0xff,0xff,0xff,0x01,0xe0,0xff,0xff,0xff,0x01,0xe0,0xff,0xff,0xff,0x01,
 0xf0,0xff,0xff,0xff,0x01,0xf0,0xff,0xff,0xff,0x01,0xf0,0xff,0xff,0xff,0x01,
 0xf0,0xff,0xff,0xff,0x03,0xf0,0xff,0xff,0xff,0x03,0xf0,0xff,0xff,0xff,0x03,
 0xf0,0xff,0xff,0xff,0x07,0xf0,0xff,0xff,0xff,0x07,0x00,0x00,0xfe,0xff,0x0f,
 0x00,0x00,0xf8,0xff,0x0f,0x00,0x00,0xf0,0xff,0x0f,0x00,0x00,0x00,0xff,0x1f,
 0x00,0x00,0x00,0xfc,0x1f,0x00,0x00,0x00,0xfc,0x1f,0x00,0x00,0x00,0xf8,0x3f,
 0x00,0x00,0x00,0xf0,0x3f,0x00,0x00,0x00,0xc0,0x3f,0x00,0x00,0x00,0x80,0x7f,
 0x00,0x00,0x00,0x80,0x7f,0x00,0x00,0x00,0x80,0x7f,0x00,0x00,0x00,0x80,0xff,
 0x00,0x00,0x00,0x80,0xff,0x00,0x00,0x00,0x80,0xff,0x00,0x00,0x00,0x80,0xff,
 0x00,0x00,0x00,0x80,0xff,0x00,0x00,0x00,0x00,0x3f,0x00,0x00,0x00,0x00,0x0f,
 0x00,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x00,0x02},

 { /* static char afghanistan_bits[] = { */
 0x00,0x00,0xf8,0xff,0x01,0x00,0x00,0x00,0x00,0xfc,0xff,0x07,0x00,0x00,0x00,
 0x00,0xfc,0xff,0x0f,0x00,0x00,0x04,0x00,0xfe,0xff,0xff,0x00,0x00,0x04,0x00,
 0xff,0xff,0xff,0x03,0x00,0x0c,0xe0,0xff,0xff,0xff,0x03,0x00,0x3e,0xf0,0xff,
 0xff,0xff,0x07,0x00,0xfe,0xff,0xff,0xff,0xff,0x0f,0x00,0xff,0xff,0xff,0xff,
 0xff,0x3f,0x00,0xff,0xff,0xff,0xff,0xff,0x7f,0x00,0xff,0xff,0xff,0xff,0xff,
 0x7f,0x00,0xff,0xff,0xff,0xff,0xff,0x7f,0x00,0xff,0xff,0xff,0xff,0xff,0x7f,
 0x00,0xff,0xff,0xff,0xff,0xff,0x7f,0x00,0xff,0xff,0xff,0xff,0xff,0x7f,0x00,
 0xff,0xff,0xff,0xff,0xff,0x7f,0x00,0xff,0xff,0xff,0xff,0xff,0x7f,0x00,0xff,
 0xff,0xff,0xff,0xff,0xff,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0xfe,0xff,
 0xff,0xff,0xff,0xff,0x01,0xf8,0xff,0xff,0xff,0xff,0xff,0x01,0xf0,0xff,0xff,
 0xff,0xff,0xff,0x01,0xe0,0xff,0xff,0xff,0xff,0xff,0x00,0xe0,0xff,0xff,0xff,
 0xff,0x7f,0x00,0xf0,0xff,0xff,0xff,0xff,0x3f,0x00,0xfe,0xff,0xff,0xff,0xff,
 0x1f,0x00,0xfe,0xff,0xff,0xff,0xff,0x0f,0x00,0xfe,0xff,0xff,0xff,0xff,0x0f,
 0x00,0xfc,0xff,0xff,0xff,0xff,0x1f,0x00,0xf8,0xff,0xff,0xff,0xff,0x3f,0x00,
 0xf8,0xff,0xff,0xff,0xff,0x3f,0x00,0xf8,0xff,0xff,0xff,0xff,0x3f,0x00,0xf8,
 0xff,0xff,0xff,0xff,0x1f,0x00,0xf0,0xff,0xff,0xff,0xff,0x0f,0x00,0xf0,0xff,
 0xff,0xff,0xff,0x01,0x00,0xf0,0xff,0xff,0xff,0x1f,0x00,0x00,0xf0,0xff,0xff,
 0xff,0x0f,0x00,0x00,0xf0,0xff,0xff,0xff,0x07,0x00,0x00,0xf0,0xff,0xff,0xff,
 0x07,0x00,0x00,0xe0,0xff,0xff,0xff,0x07,0x00,0x00,0xe0,0xff,0xff,0xff,0x07,
 0x00,0x00,0x70,0x80,0xff,0xff,0x0f,0x00,0x00,0x00,0x00,0xff,0xff,0x0f,0x00,
 0x00,0x00,0x00,0xff,0xff,0x1f,0x00,0x00,0x00,0x00,0xfc,0xff,0x1f,0x00,0x00,
 0x00,0x00,0xe8,0xff,0x1f,0x00,0x00,0x00,0x00,0xc0,0xff,0x3f,0x00,0x00,0x00,
 0x00,0x00,0xff,0x3f,0x00,0x00,0x00,0x00,0x00,0xfe,0x1f,0x00,0x00,0x00,0x00,
 0x00,0xf8,0x0f,0x00,0x00,0x00,0x00,0x00,0xf0,0x07,0x00,0x00,0x00,0x00,0x00,
 0x80,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00},

 { /* static char middle_east_bits[] = { */
 0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x78,0x80,0x01,0x00,0x00,
 0x00,0x00,0x00,0xfc,0xff,0xff,0x03,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0xff,
 0x07,0x00,0x00,0x00,0x00,0x00,0xfe,0xff,0xff,0x1f,0x00,0x00,0x00,0x00,0x00,
 0xfc,0xff,0xff,0x3f,0x00,0x00,0x00,0x00,0x00,0xfc,0xff,0xff,0xff,0x07,0x00,
 0x00,0x00,0x00,0xfc,0xff,0xff,0xff,0x07,0x00,0x00,0x00,0x00,0xfc,0xff,0xff,
 0xff,0x07,0x00,0x00,0x00,0x00,0xf8,0xff,0xff,0xff,0x0f,0x00,0x00,0x00,0x00,
 0xf8,0xff,0xff,0xff,0x0f,0x00,0x00,0x00,0x00,0xf0,0xf8,0xff,0xff,0x1f,0xf0,
 0x0f,0x00,0x00,0x00,0xc0,0xff,0xff,0xff,0xff,0x1f,0x00,0x00,0x00,0x80,0xff,
 0xff,0xff,0xff,0x1f,0x00,0x00,0x00,0x80,0xff,0xff,0xff,0xff,0x7f,0x00,0x00,
 0x00,0x80,0xff,0xff,0xff,0xff,0xff,0x02,0x00,0x00,0x80,0xff,0xff,0xff,0xff,
 0xff,0x07,0x00,0x00,0x80,0xff,0xff,0xff,0xff,0xff,0x1f,0x00,0x00,0xc0,0xff,
 0xff,0xff,0xff,0xff,0x3f,0x00,0x00,0xe0,0xff,0xff,0xff,0xff,0xff,0xff,0x00,
 0x00,0xe0,0xff,0xff,0xff,0xff,0xff,0xff,0x01,0x00,0xf0,0xff,0xff,0xff,0xff,
 0xff,0xff,0x0f,0x00,0xf8,0xff,0xff,0xff,0xff,0xff,0xff,0x3f,0x00,0xf8,0xff,
 0xff,0xff,0xff,0xff,0xff,0x1f,0x00,0xf8,0xff,0x7f,0xe0,0xff,0xff,0xff,0x0f,
 0x00,0xf8,0xff,0x3f,0xc0,0xff,0xff,0xff,0x07,0x00,0xf0,0xff,0x3f,0xc0,0xff,
 0xff,0xff,0x03,0x00,0xe0,0xff,0x7f,0x00,0xff,0xff,0xff,0x03,0x00,0x80,0xff,
 0xff,0x0f,0xfe,0xff,0xff,0x03,0x00,0x00,0xff,0xff,0x0f,0xc0,0xff,0xff,0x07,
 0x00,0x00,0xfe,0xff,0x1f,0x80,0xff,0xff,0x07,0x00,0x00,0xfe,0xff,0x1f,0x80,
 0xff,0xff,0x03,0x00,0x00,0xfc,0xff,0x1f,0x00,0xfc,0x7e,0x00,0x00,0x00,0xfc,
 0xff,0x3f,0x00,0x18,0x20,0x00,0x00,0x00,0xf8,0xff,0x7f,0x00,0x00,0x00,0x00,
 0x00,0x00,0xf0,0xff,0xff,0x03,0x01,0x00,0x00,0x00,0x00,0xe0,0xff,0xff,0xff,
 0x03,0x00,0x00,0x00,0x00,0xe0,0xff,0xff,0xff,0x07,0x00,0x00,0x00,0x00,0xe0,
 0xff,0xff,0xff,0x07,0x00,0x00,0x00,0x00,0xe0,0xff,0xff,0xff,0x03,0x00,0x00,
 0x00,0x00,0xc0,0xff,0xff,0xff,0x01,0x00,0x00,0x00,0x00,0xc0,0xff,0xff,0xff,
 0x00,0x00,0x00,0x00,0x00,0x80,0xff,0xff,0x3f,0x00,0x00,0x00,0x00,0x00,0x80,
 0xff,0xff,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0x1f,0x00,0x00,0x00,
 0x00,0x00,0x00,0xfe,0xff,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0x7f,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0xfc,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x1f,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0xfc,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0x01,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x00,0x00,0x00,0x00,0x00},

 { /* static char india_bits[] = { */
 0x00,0xe0,0x0f,0x00,0x00,0x00,0x00,0xf0,0x0f,0x00,0x00,0x00,0x00,0xf8,0x0f,
 0x00,0x00,0x00,0x00,0xfc,0x1f,0x00,0x00,0x00,0x00,0xfc,0x1f,0x00,0x00,0x00,
 0x00,0xfe,0x3f,0x00,0x00,0x00,0x80,0xff,0x7f,0x00,0x00,0x00,0xc0,0xff,0x7f,
 0x00,0x00,0x00,0xe0,0xff,0xff,0x01,0x00,0x00,0xf0,0xff,0xff,0x0f,0x00,0x00,
 0xf0,0xff,0xff,0xff,0x3f,0x00,0xf0,0xff,0xff,0xff,0xff,0x0f,0xe0,0xff,0xff,
 0xff,0xff,0x1f,0xe0,0xff,0xff,0xff,0xff,0x3f,0xf0,0xff,0xff,0xff,0xff,0x3f,
 0xfe,0xff,0xff,0xff,0xff,0x1f,0xff,0xff,0xff,0xff,0xff,0x0f,0xff,0xff,0xff,
 0xff,0xff,0x07,0xfc,0xff,0xff,0xff,0xff,0x03,0xf8,0xff,0xff,0xff,0xff,0x00,
 0xfc,0xff,0xff,0xff,0x63,0x00,0xf8,0xff,0xff,0x7f,0x00,0x00,0xb0,0xff,0xff,
 0x3f,0x00,0x00,0x00,0xff,0xff,0x1f,0x00,0x00,0x00,0xff,0xff,0x0f,0x00,0x00,
 0x00,0xff,0xff,0x07,0x00,0x00,0x00,0xff,0xff,0x01,0x00,0x00,0x00,0xff,0xff,
 0x00,0x00,0x00,0x00,0xff,0x7f,0x00,0x00,0x00,0x00,0xff,0x3f,0x00,0x00,0x00,
 0x00,0xfe,0x1f,0x00,0x00,0x00,0x00,0xfe,0x0f,0x00,0x00,0x00,0x00,0xfe,0x07,
 0x00,0x00,0x00,0x00,0xfe,0x03,0x00,0x00,0x00,0x00,0xfe,0x03,0x00,0x00,0x00,
 0x00,0xfc,0x07,0x00,0x00,0x00,0x00,0xf8,0x07,0x00,0x00,0x00,0x00,0xf8,0x07,
 0x00,0x00,0x00,0x00,0xf0,0x03,0x00,0x00,0x00,0x00,0xe0,0x03,0x00,0x00,0x00,
 0x00,0xe0,0x01,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,
 0x00,0x00,0x00},

 { /* static char siam_bits[] = { */
 0x00,0x1f,0x00,0x00,0x00,0x3f,0x00,0x00,0x80,0x7f,0x00,0x00,0xc0,0xff,0x00,
 0x00,0xe0,0xff,0x03,0x00,0xf0,0xff,0x1f,0x00,0xfc,0xff,0x7f,0x00,0xfe,0xff,
 0xff,0x00,0xff,0xff,0xff,0x00,0xfe,0xff,0x3f,0x00,0xfe,0xff,0x1f,0x00,0xfc,
 0xff,0x0f,0x00,0xfc,0xff,0x0f,0x00,0xf8,0xff,0x1f,0x00,0xf0,0xff,0x3f,0x00,
 0xf0,0xff,0x7f,0x00,0xf0,0xff,0xff,0x01,0x30,0xff,0xff,0x01,0x10,0xfe,0xff,
 0x01,0x00,0xfe,0xff,0x01,0x00,0xe0,0xff,0x03,0x00,0xc0,0xff,0x03,0x00,0xc0,
 0xff,0x01,0x00,0x00,0xff,0x00,0x00,0x00,0xfe,0x00,0x00,0x00,0x6e,0x00},

 { /* static char china_bits[] = { */
 0x00,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3e,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x80,0xff,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0xff,0x03,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0xe0,0xff,0xff,0x3f,0x00,0x00,0x00,0x00,0x00,
 0x00,0xf0,0xff,0xff,0xff,0x07,0x00,0x00,0x00,0x00,0x00,0xf8,0xff,0xff,0xff,
 0x1f,0x00,0x00,0x00,0x00,0x00,0xfc,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,
 0x00,0xfe,0xff,0xff,0xff,0xff,0x03,0x00,0x00,0x00,0x00,0xfe,0xff,0xff,0xff,
 0xff,0x1f,0x00,0x00,0x00,0x00,0xfc,0xff,0xff,0xff,0xff,0x7f,0x00,0x00,0x00,
 0x00,0xf8,0xff,0xff,0xff,0xff,0xff,0x01,0x00,0x00,0x00,0xf8,0xff,0xff,0xff,
 0xff,0xff,0x07,0x00,0x00,0x00,0xf8,0xff,0xff,0xff,0xff,0xff,0x0f,0x00,0x00,
 0x00,0xfc,0xff,0xff,0xff,0xff,0xff,0x3f,0x00,0x00,0x00,0xfe,0xff,0xff,0xff,
 0xff,0xff,0x7f,0x00,0x00,0xc0,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,
 0xfc,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x01,0x00,0xfe,0xff,0xff,0xff,0xff,
 0xff,0xff,0xff,0x01,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x03,0x00,
 0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x07,0x00,0xff,0xff,0xff,0xff,0xff,
 0xff,0xff,0xff,0x0f,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xbf,0x03,
 0xfe,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x7f,0x00,0xfe,0xff,0xff,0xff,0xff,
 0xff,0xff,0xff,0x3f,0x00,0xfc,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x1f,0x00,
 0xfc,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x3f,0x00,0xfc,0xff,0xff,0xff,0xff,
 0xff,0xff,0xff,0x7f,0x00,0xf8,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x7f,0x00,
 0x00,0xfc,0xff,0xff,0xff,0xff,0xff,0xff,0x7f,0x00,0x00,0xfc,0xff,0xff,0xff,
 0xff,0xff,0xff,0xff,0x00,0x00,0xfc,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,
 0x00,0xf8,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0xf8,0xff,0xff,0xff,
 0xff,0xff,0xff,0xff,0x00,0x00,0xf0,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x01,
 0x00,0xe0,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x01,0x00,0xe0,0xff,0xff,0xff,
 0xff,0xff,0xff,0xff,0x01,0x00,0x80,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x01,
 0x00,0x00,0xfc,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0xf0,0xff,
 0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0xfc,0xff,0xff,0xff,0xff,0x00,
 0x00,0x00,0x00,0x00,0xf8,0xff,0xff,0xff,0x7f,0x00,0x00,0x00,0x00,0x00,0x00,
 0xfe,0xff,0xff,0x7f,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0xff,0xff,0x3f,0x00,
 0x00,0x00,0x00,0x00,0x00,0xf8,0xff,0xff,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,
 0xf0,0xff,0xff,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0xff,0xff,0x0f,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xff,0x01,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0xf8,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x07,0x00,0x00
 },

 { /* static char mongolia_bits[] = { */
 0x00,0x00,0x00,0x00,0x00,0xfe,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x03,
 0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0xff,
 0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x0f,0x00,0x00,0x00,0x00,0x00,0x80,
 0xff,0x0f,0x00,0x00,0xe0,0x01,0x00,0x80,0xff,0x1f,0x00,0x00,0xf0,0x03,0xc0,
 0xf1,0xff,0x1f,0x00,0x00,0xf8,0x07,0xf0,0xfb,0xff,0x1f,0x00,0x00,0xfc,0x0f,
 0xfc,0xff,0xff,0x1f,0x00,0x00,0xff,0x7f,0xfe,0xff,0xff,0x3f,0x00,0xe0,0xff,
 0xff,0xff,0xff,0xff,0x3f,0x00,0xf0,0xff,0xff,0xff,0xff,0xff,0x7f,0x00,0xf0,
 0xff,0xff,0xff,0xff,0xff,0x7f,0x00,0xf8,0xff,0xff,0xff,0xff,0xff,0xff,0x00,
 0xfc,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0xfe,0xff,0xff,0xff,0xff,0xff,0xff,
 0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x01,0xff,0xff,0xff,0xff,0xff,0xff,
 0xff,0x01,0x80,0xff,0xff,0xff,0xff,0xff,0xff,0x03,0x00,0xf0,0xff,0xff,0xff,
 0xff,0xff,0x03,0x00,0xc0,0xff,0xff,0xff,0xff,0xff,0x03,0x00,0x00,0xfe,0xff,
 0xff,0xff,0xff,0x03,0x00,0x00,0xf8,0xff,0xff,0xff,0xff,0x03,0x00,0x00,0xc0,
 0xff,0xff,0xff,0xff,0x03,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0x01,0x00,0x00,
 0x00,0xfc,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0xf0,0xff,0xff,0x7f,0x00,0x00,
 0x00,0x00,0xe0,0xff,0xff,0x3f,0x00,0x00,0x00,0x00,0x80,0xff,0xff,0x1f,0x00,
 0x00,0x00,0x00,0x00,0xff,0xff,0x0f,0x00,0x00,0x00,0x00,0x00,0xfe,0xfe,0x07,
 0x00,0x00,0x00,0x00,0x00,0x7c,0xcc,0x03,0x00,0x00,0x00,0x00,0x00,0x0c,0x80,
 0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1e,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x1c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1c,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x1c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1c,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x0c,0x00},

 { /* static char siberia_bits[] = { */
 0x00,0x00,0x00,0x00,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x1e,0x00,0x00,
 0x00,0x00,0x00,0x00,0x1e,0x00,0x00,0x00,0x00,0x00,0x00,0x0f,0x00,0x00,0x00,
 0x00,0x00,0x80,0x0f,0x00,0x00,0x00,0x00,0x00,0xc0,0x0f,0x00,0x00,0x00,0x00,
 0x00,0xc0,0x0f,0x1c,0x00,0x00,0x00,0x00,0xe0,0x1f,0x7e,0x00,0x00,0x00,0x00,
 0xf0,0xff,0x7f,0x00,0x00,0x00,0x00,0xf0,0xff,0x7f,0x00,0x00,0x00,0x00,0xe0,
 0xff,0x7f,0x00,0x00,0x00,0xe6,0xc0,0xff,0x7f,0x00,0x00,0x00,0xff,0xc3,0xff,
 0x7f,0x00,0x00,0x80,0xff,0xc7,0xff,0x7f,0x00,0x00,0xf8,0xff,0xef,0xff,0x7f,
 0x00,0x00,0xfc,0xff,0xff,0xff,0x3f,0x00,0x00,0xfc,0xff,0xff,0xff,0x1f,0x00,
 0x00,0xfe,0xff,0xff,0xff,0x0f,0x00,0x00,0xfe,0xff,0xff,0xff,0x0f,0x00,0x00,
 0xfe,0xff,0xff,0xff,0x07,0x00,0x00,0xfe,0xff,0xff,0xff,0x01,0x00,0x00,0xff,
 0xff,0xff,0xff,0x00,0x00,0xc0,0xff,0xff,0xff,0x3f,0x00,0x00,0xc0,0xff,0xff,
 0xff,0x3f,0x00,0x00,0xe0,0xff,0xff,0xff,0x3f,0x00,0x00,0xfc,0xff,0xff,0xff,
 0x3f,0x00,0x00,0xfe,0xff,0xff,0xff,0xff,0x00,0x00,0xff,0xff,0xff,0xff,0x7f,
 0x00,0x00,0xff,0xff,0xff,0xff,0x7f,0x00,0x00,0xff,0xff,0xff,0xff,0x7f,0x00,
 0x00,0xff,0xff,0xff,0xff,0x7f,0x00,0x00,0xff,0xff,0xff,0xff,0x7f,0x00,0x00,
 0xff,0xff,0xff,0xff,0x7f,0x00,0x00,0xfc,0xff,0xff,0xff,0x7f,0x00,0x00,0xf8,
 0xff,0xff,0xff,0x7f,0x00,0x00,0xfc,0xff,0xff,0xff,0x7f,0x00,0x00,0xfe,0xff,
 0xff,0xff,0x7f,0x00,0x00,0xfe,0xff,0xff,0xff,0x7f,0x00,0x00,0xff,0xff,0xff,
 0xff,0x7f,0x00,0x00,0xff,0xff,0xff,0xff,0x7f,0x00,0x00,0xff,0xff,0xff,0xff,
 0x7f,0x00,0x00,0xff,0xff,0xff,0xff,0x7f,0x00,0x00,0xff,0xff,0xff,0xff,0x7f,
 0x00,0x00,0xff,0xff,0xff,0xff,0x7f,0x00,0x00,0xff,0xff,0xff,0xff,0x7f,0x00,
 0x80,0xff,0xff,0xff,0xff,0x7f,0x00,0x80,0xff,0xff,0xff,0xff,0x7f,0x00,0xc0,
 0xff,0xff,0xff,0xff,0x7f,0x00,0xc0,0xff,0xff,0xff,0xff,0x7f,0x00,0xc0,0xff,
 0xff,0xff,0xff,0x7f,0x00,0xe0,0xff,0xff,0xff,0xff,0x7f,0x00,0xf0,0xff,0xff,
 0xff,0xff,0x7f,0x00,0xf8,0xff,0xff,0xff,0xff,0xff,0x00,0xfc,0xff,0xff,0xff,
 0xff,0xff,0x00,0xfc,0xff,0xff,0xff,0xff,0xff,0x00,0xfe,0xff,0xff,0xff,0xff,
 0xff,0x00,0xfe,0xff,0xff,0xff,0xff,0xff,0x00,0xff,0xff,0xff,0xff,0xff,0xff,
 0x00,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0x01,
 0xff,0xff,0xff,0xff,0xff,0xff,0x01,0xff,0xff,0xff,0xff,0xff,0xff,0x01,0xff,
 0xff,0xff,0xff,0xff,0xff,0x01,0xff,0xff,0xff,0xff,0xff,0xff,0x01,0xff,0xff,
 0xff,0xff,0xff,0xff,0x01,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0xff,0xff,0xff,
 0xff,0xff,0xff,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0xff,0xff,0xff,0xff,
 0xff,0xff,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0xff,0xff,0xff,0xff,0xff,
 0x7f,0x00,0xfe,0xff,0xff,0xff,0xff,0x7f,0x00,0xfe,0xff,0xff,0xff,0xff,0x7f,
 0x00,0xfe,0xff,0xff,0xff,0xff,0x7f,0x00,0xfc,0xff,0xff,0xff,0xff,0x3f,0x00,
 0xfc,0xff,0xff,0xff,0xff,0x3f,0x00,0xf8,0xff,0xff,0xff,0xff,0x1f,0x00,0xf0,
 0xff,0xff,0xff,0xff,0x0f,0x00,0xf0,0xff,0xff,0xff,0xff,0x07,0x00,0xe0,0xff,
 0xff,0xff,0xff,0x03,0x00,0xe0,0xff,0xff,0xff,0xff,0x03,0x00,0xc0,0xff,0xff,
 0xff,0xff,0x01,0x00,0x80,0xff,0xff,0xff,0xff,0x00,0x00,0x80,0xff,0xff,0xff,
 0x7f,0x00,0x00,0x00,0xff,0xff,0xff,0x3f,0x00,0x00,0x00,0xff,0xff,0xff,0x1f,
 0x00,0x00,0x00,0xff,0xff,0xff,0x0f,0x00,0x00,0x00,0xff,0xff,0xff,0x0f,0x00,
 0x00,0x00,0xff,0xff,0xff,0x07,0x00,0x00,0x00,0xff,0xff,0xff,0x07,0x00,0x00,
 0x00,0xfe,0xff,0xff,0x07,0x00,0x00,0x00,0xfe,0xff,0xff,0x07,0x00,0x00,0x00,
 0xfe,0xff,0xff,0x07,0x00,0x00,0x00,0xfc,0xff,0xff,0x07,0x00,0x00,0x00,0xfc,
 0xff,0xff,0x07,0x00,0x00,0x00,0xf8,0xff,0xff,0x07,0x00,0x00,0x00,0xf8,0xff,
 0xff,0x03,0x00,0x00,0x00,0xf8,0xff,0xff,0x03,0x00,0x00,0x00,0xf0,0xff,0xff,
 0x03,0x00,0x00,0x00,0xf0,0xff,0xff,0x01,0x00,0x00,0x00,0xf0,0xff,0xff,0x01,
 0x00,0x00,0x00,0xe0,0xff,0xff,0x00,0x00,0x00,0x00,0xe0,0xff,0xff,0x00,0x00,
 0x00,0x00,0xe0,0xff,0xff,0x00,0x00,0x00,0x00,0xc0,0xff,0x7f,0x00,0x00,0x00,
 0x00,0xc0,0xff,0x7f,0x00,0x00,0x00,0x00,0xc0,0xff,0x3f,0x00,0x00,0x00,0x00,
 0x80,0xff,0x3f,0x00,0x00,0x00,0x00,0x80,0xff,0x3f,0x00,0x00,0x00,0x00,0x80,
 0xff,0x3f,0x00,0x00,0x00,0x00,0x80,0xff,0x1f,0x00,0x00,0x00,0x00,0x80,0xff,
 0x1f,0x00,0x00,0x00,0x00,0x00,0xff,0x0f,0x00,0x00,0x00,0x00,0x00,0xff,0x07,
 0x00,0x00,0x00,0x00,0x00,0xfe,0x03,0x00,0x00,0x00,0x00,0x00,0xf8,0x01,0x00,
 0x00,0x00,0x00,0x00,0xf0,0x01,0x00,0x00,0x00},

 { /* static char irkutsk_bits[] = { */
 0x00,0x00,0x00,0xf0,0x03,0x00,0x30,0x00,0x00,0x00,0xf8,0x1f,0x00,0x3f,0x00,
 0x00,0x00,0xff,0xff,0xff,0x7f,0x00,0x00,0xf8,0xff,0xff,0xff,0x7f,0x00,0x00,
 0xfc,0xff,0xff,0xff,0x7f,0x00,0x00,0xfc,0xff,0xff,0xff,0x7f,0x00,0x00,0xfc,
 0xff,0xff,0xff,0xff,0x00,0x00,0xfc,0xff,0xff,0xff,0xff,0x00,0x00,0xfc,0xff,
 0xff,0xff,0xff,0x00,0x00,0xfe,0xff,0xff,0xff,0xff,0x00,0x00,0xfe,0xff,0xff,
 0xff,0xff,0x00,0x00,0xfe,0xff,0xff,0xff,0xff,0x00,0x00,0xfe,0xff,0xff,0xff,
 0xff,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0xff,0xff,0xff,0xff,0xff,
 0x00,0x80,0xff,0xff,0xff,0xff,0xff,0x00,0xc0,0xff,0xff,0xff,0xff,0x7f,0x00,
 0xe0,0xff,0xff,0xff,0xff,0x7f,0x00,0xf0,0xff,0xff,0xff,0xff,0x7f,0x00,0xf0,
 0xff,0xff,0xff,0xff,0x7f,0x00,0xf8,0xff,0xff,0xff,0xff,0x3f,0x00,0xfc,0xff,
 0xff,0xff,0xff,0x3f,0x00,0xfe,0xff,0xff,0xff,0xff,0x1f,0x00,0xff,0xff,0xff,
 0xff,0xff,0x1f,0x80,0xff,0xff,0xff,0xff,0xff,0x0f,0xc0,0xff,0xff,0xff,0xff,
 0xff,0x0f,0xc0,0xff,0xff,0xff,0xff,0xff,0x07,0xe0,0xff,0xff,0xff,0xff,0xff,
 0x07,0xe0,0xff,0xff,0xff,0xff,0xff,0x03,0xe0,0xff,0xff,0xff,0xff,0xff,0x01,
 0xe0,0xff,0xff,0xff,0xff,0xff,0x01,0xe0,0xff,0xff,0xff,0xff,0xff,0x00,0xe0,
 0xff,0xff,0xff,0xff,0xff,0x00,0xe0,0xff,0xff,0xff,0xff,0x7f,0x00,0xe0,0xff,
 0xff,0xff,0xff,0x7f,0x00,0xf0,0xff,0xff,0xff,0xff,0x7f,0x00,0xf0,0xff,0xff,
 0xff,0xff,0x7f,0x00,0xf0,0xff,0xff,0xff,0x0f,0x38,0x00,0xf8,0xff,0xff,0xff,
 0x07,0x20,0x00,0xf8,0xff,0xff,0xff,0x07,0x00,0x00,0xfc,0xff,0xff,0xff,0x07,
 0x00,0x00,0xfc,0xff,0xff,0xff,0x07,0x00,0x00,0xfc,0xff,0xff,0xff,0x03,0x00,
 0x00,0xfe,0xf0,0xff,0xff,0x03,0x00,0x00,0x7e,0xe0,0xff,0x71,0x00,0x00,0x00,
 0x3f,0xc0,0x7f,0x20,0x00,0x00,0x00,0x1f,0x80,0x1f,0x00,0x00,0x00,0x00,0x07,
 0x00,0x0c,0x00,0x00,0x00,0x00},

 { /* static char yakutsk_bits[] = { */
 0x38,0x00,0x00,0x00,0x00,0x00,0xfc,0x01,0x00,0x00,0x00,0x00,0xff,0x00,0x00,
 0x00,0x00,0x00,0xff,0x01,0x00,0x00,0x00,0x00,0xff,0x03,0x00,0x00,0x00,0x00,
 0xff,0x07,0x00,0x00,0x00,0x00,0xfc,0xff,0x01,0x00,0x00,0x00,0xfe,0xff,0x07,
 0x00,0x00,0x00,0xfe,0xff,0x1f,0x38,0x00,0x00,0xfe,0xff,0x7f,0xfc,0x03,0x00,
 0xfe,0xff,0xff,0xff,0x0f,0x00,0xfe,0xff,0xff,0xff,0x07,0x00,0xfe,0xff,0xff,
 0xff,0x07,0x00,0xfe,0xff,0xff,0xff,0x07,0x00,0xfe,0xff,0xff,0xff,0x07,0x00,
 0xfe,0xff,0xff,0xff,0x07,0x00,0xfe,0xff,0xff,0xff,0x07,0x01,0xfe,0xff,0xff,
 0xff,0x8f,0x23,0xfe,0xff,0xff,0xff,0xdf,0x7f,0xfe,0xff,0xff,0xff,0xff,0x3f,
 0xfe,0xff,0xff,0xff,0xff,0x3f,0xfe,0xff,0xff,0xff,0xff,0x3f,0xfe,0xff,0xff,
 0xff,0xff,0x1f,0xfe,0xff,0xff,0xff,0xff,0x1f,0xfe,0xff,0xff,0xff,0xff,0x0f,
 0xfe,0xff,0xff,0xff,0xff,0x0f,0xfe,0xff,0xff,0xff,0xff,0x07,0xfe,0xff,0xff,
 0xff,0xff,0x07,0xfe,0xff,0xff,0xff,0xff,0x03,0xfe,0xff,0xff,0xff,0xff,0x03,
 0xfe,0xff,0xff,0xff,0xff,0x01,0xfe,0xff,0xff,0xff,0xff,0x00,0xfc,0xff,0xff,
 0xff,0xff,0x00,0xfc,0xff,0xff,0xff,0x7f,0x00,0xfc,0xff,0xff,0xff,0x7f,0x00,
 0xfc,0xff,0xff,0xff,0x7f,0x00,0xfc,0xff,0xff,0xff,0x7f,0x00,0xfc,0xff,0xff,
 0xff,0x7f,0x00,0xfc,0xff,0xff,0xff,0x7f,0x00,0xf8,0xff,0xff,0xff,0x3f,0x00,
 0xf8,0xff,0xff,0xff,0x3f,0x00,0xf8,0x0f,0xfc,0xff,0x0f,0x00,0xf8,0x07,0xe0,
 0xff,0x00,0x00,0xf8,0x00,0x00,0x00,0x00,0x00},

 { /* static char kamchatka_bits[] = { */
 0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x80,0x7f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe0,0xff,
 0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe0,0xff,0x0f,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe0,0xff,0x0f,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe0,0xff,0x0f,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0xf0,0xff,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0xfc,0xff,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0xff,0xff,0xff,0xe0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,
 0xff,0xff,0xff,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0xff,
 0xff,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xff,0xff,0xff,0xff,0x07,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xff,0xff,0xff,0xff,0x07,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0xc0,0xff,0xff,0xff,0xff,0x07,0x80,0x20,0x00,0x00,
 0x00,0x00,0x00,0xc0,0xff,0xff,0xff,0xff,0x07,0x00,0xf1,0x00,0x00,0x00,0x00,
 0x00,0xe0,0xff,0xff,0xff,0xff,0x8f,0xc1,0xf0,0x07,0x00,0x00,0x00,0x00,0xe0,
 0xff,0xff,0xff,0xff,0xdf,0xff,0xf0,0x3f,0x00,0x00,0x00,0x00,0xf0,0xff,0xff,
 0xff,0xff,0xff,0xff,0xf1,0x7f,0x00,0x00,0x00,0x00,0xf0,0xff,0xff,0xff,0xff,
 0xff,0xff,0xfb,0xff,0x01,0x00,0x00,0x00,0xf8,0xff,0xff,0xff,0xff,0xff,0xff,
 0xff,0xff,0x03,0x00,0x00,0x00,0xfc,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
 0x07,0x00,0x00,0x00,0xfc,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x1f,0x00,
 0x00,0x00,0xfe,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x3f,0x00,0x00,0x00,
 0xfe,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x7f,0x00,0x00,0x00,0xfe,0xff,
 0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0xfe,0xff,0xff,0xff,
 0xff,0xff,0xff,0xff,0xff,0xff,0x01,0x00,0x00,0xfe,0xff,0xff,0xff,0xff,0xff,
 0xff,0xff,0xff,0xff,0x0f,0x00,0x00,0xfe,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
 0xff,0xff,0x1f,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfb,
 0x7f,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xf1,0xff,0x00,
 0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xe1,0xff,0x00,0x00,0xff,
 0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x81,0x0f,0x00,0x00,0xfe,0xff,0xff,
 0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x06,0x00,0x00,0xfe,0xff,0xff,0xff,0xff,
 0xff,0xff,0xff,0x7f,0x00,0x04,0x00,0x00,0xfe,0xff,0xff,0xff,0xff,0xff,0xff,
 0xff,0x1f,0x00,0x04,0x00,0x00,0xfe,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0f,
 0x00,0x00,0x00,0x00,0xfc,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x1f,0x00,0x00,
 0x00,0x00,0xfc,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x3f,0x00,0x00,0x00,0x00,
 0xfc,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x7f,0x00,0x00,0x00,0x00,0xfc,0xff,
 0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x0c,0x00,0xfc,0xff,0xff,0xff,
 0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0xfc,0xff,0xff,0xff,0xff,0xff,
 0xff,0xff,0xff,0x00,0x00,0x00,0x00,0xfc,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
 0x03,0x00,0x00,0x00,0x00,0xfc,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x01,0x00,
 0x00,0x00,0x00,0xfc,0xff,0xff,0xff,0xff,0xf9,0xff,0x7f,0x00,0x00,0x00,0x00,
 0x00,0xfc,0xff,0xff,0xff,0xff,0xf0,0xff,0x3f,0x00,0x00,0x00,0x00,0x00,0xfe,
 0xff,0xff,0xff,0xff,0xf8,0xff,0x1f,0x00,0x00,0x00,0x00,0x00,0xfe,0xff,0xff,
 0xff,0x3f,0xe0,0x7f,0x06,0x00,0x00,0x00,0x00,0x00,0xfe,0xff,0xff,0xff,0x0f,
 0xc0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xff,0xff,0xff,0x07,0xe0,0x0f,
 0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xe3,0x03,0xf0,0x07,0x00,0x00,
 0x00,0x00,0x00,0x00,0xff,0xff,0xf8,0xc1,0x03,0xf0,0x03,0x00,0x00,0x00,0x00,
 0x00,0x80,0xff,0x7f,0x00,0x80,0x00,0xf8,0x01,0x00,0x00,0x00,0x00,0x00,0x80,
 0xff,0x7f,0x00,0x00,0x00,0xf8,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0xff,0x3f,
 0x00,0x00,0x00,0x78,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0xff,0x1f,0x00,0x00,
 0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0xe0,0xff,0x07,0x00,0x00,0x00,0x7f,
 0x00,0x00,0x00,0x00,0x00,0x00,0xe0,0xff,0x03,0x00,0x00,0xc0,0x7f,0x00,0x00,
 0x00,0x00,0x00,0x00,0xf0,0xff,0x01,0x00,0x00,0xc0,0x7f,0x00,0x00,0x00,0x00,
 0x00,0x00,0xf8,0xff,0x00,0x00,0x00,0xe0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,
 0xf8,0x7f,0x00,0x00,0x00,0xe0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x7f,
 0x00,0x00,0x00,0xf0,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x7f,0x00,0x00,
 0x00,0xf0,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0x3f,0x00,0x00,0x00,0xf0,
 0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0x7f,0x00,0x00,0x00,0xf0,0x1f,0x00,
 0x00,0x00,0x00,0x00,0x00,0xfe,0xff,0x00,0x00,0x00,0xf0,0x07,0x00,0x00,0x00,
 0x00,0x00,0x00,0xfe,0xff,0x1f,0x00,0x00,0xf0,0x03,0x00,0x00,0x00,0x00,0x00,
 0x00,0xff,0xff,0x1f,0x00,0x00,0xe0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0xff,
 0xff,0x1f,0x00,0x00,0xe0,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0x1f,
 0x00,0x00,0xe0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xff,0x3f,0x00,0x00,
 0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xff,0x3f,0x00,0x00,0xc0,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xff,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0xfc,0xff,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0xfc,0xff,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0xfc,0xff,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0xff,
 0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0xff,0x07,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0xff,0x07,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0xff,0x07,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0xf0,0xff,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0xe0,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0xe0,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe0,
 0x7f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x7f,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x7f,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x3f,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x80,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x80,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x80,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x07,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},

 { /* static char japan_bits[] = { */
 0x00,0x00,0x0c,0x00,0x00,0xfc,0x00,0x00,0xfe,0x00,0x00,0x3e,0x00,0x00,0x1f,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x80,0x03,
 0x00,0x80,0x03,0x00,0x80,0x03,0x00,0x80,0x01,0x00,0xc0,0x01,0x00,0xc0,0x01,
 0x00,0xe0,0x01,0x00,0xf0,0x00,0x00,0x7c,0x00,0xe0,0x3f,0x00,0x7c,0x0f,0x00,
 0x3c,0x06,0x00,0x38,0x00,0x00,0x1c,0x00,0x00,0x0f,0x00,0x00,0x06,0x00,0x00,
 0x04,0x00,0x00},

 { /* static char indonesia_bits[] = { */
 0x00,0x00,0x06,0x00,0x00,0x00,0x07,0x00,0x00,0x00,0x07,0x00,0x00,0x00,0x03,
 0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x06,0x00,0x00,0x00,
 0x1f,0x00,0x00,0x00,0x1e,0x00,0x00,0x00,0x3c,0x00,0x00,0x00,0xfc,0x00,0x00,
 0x00,0xfc,0x00,0x00,0x40,0x3c,0x00,0x00,0x00,0x18,0x00,0x00,0x00,0x10,0x00,
 0x00,0x00,0x30,0x01,0x00,0x00,0xf8,0x01,0x00,0x00,0xe8,0x01,0x00,0x1c,0xc0,
 0x01,0x00,0x1e,0x00,0x00,0x00,0x3e,0x00,0x00,0x00,0x7f,0x00,0x00,0x00,0x3f,
 0x00,0x00,0x80,0x1f,0x00,0x00,0xe0,0x0f,0x00,0x00,0xf0,0x07,0x38,0x00,0xf8,
 0x0f,0xfc,0x00,0xfc,0x1f,0x3e,0x00,0xfe,0x0f,0x1f,0x00,0xff,0x07,0x0f,0x00,
 0xfe,0x83,0x0f,0x00,0xff,0x83,0x0f,0x00,0xfe,0x01,0x0f,0x00,0xe0,0x01,0x0f,
 0x00,0x80,0x01,0x1d,0x00,0x00,0x00,0x18,0x00},

 { /* static char new_guinea_bits[] = { */
 0x07,0x00,0x00,0x00,0xfe,0x07,0x00,0x00,0x00,0xfe,0x0e,0x0e,0x00,0x00,0xfe,
 0x1c,0xfe,0x01,0x00,0xff,0x34,0xff,0x0f,0x80,0xfe,0xc0,0xff,0x1f,0xc0,0xfe,
 0x00,0xff,0x3f,0x60,0xfe,0x00,0xfc,0x7f,0x18,0xfe,0x00,0xf8,0xff,0x03,0xfe,
 0x00,0xf0,0xff,0x01,0xfe,0x00,0xe0,0xe3,0x01,0xfe,0x00,0x80,0x81,0x01,0xfe,
 0x00,0x00,0x00,0x03,0xfe,0x00,0x00,0x00,0x0e,0xfe,0x00,0x00,0x00,0x10,0xfe
 },

 { /* static char western_australia_bits[] = { */
 0x00,0x00,0x00,0x18,0x00,0x00,0x00,0x00,0x78,0x00,0x00,0x00,0x00,0xfc,0x06,
 0x00,0x00,0x00,0xff,0x07,0x00,0x00,0x00,0xff,0x07,0x00,0x00,0x80,0xff,0x03,
 0x00,0x00,0xc8,0xff,0x07,0x00,0x00,0xfe,0xff,0x0f,0x00,0x00,0xff,0xff,0x1f,
 0x00,0x80,0xff,0xff,0x3f,0x00,0xc0,0xff,0xff,0x1f,0x00,0xe0,0xff,0xff,0x1f,
 0x00,0xe0,0xff,0xff,0x1f,0x00,0xf0,0xff,0xff,0x0f,0x00,0xf8,0xff,0xff,0x0f,
 0x00,0xfc,0xff,0xff,0x0f,0xe0,0xff,0xff,0xff,0x0f,0xf8,0xff,0xff,0xff,0x0f,
 0xfc,0xff,0xff,0xff,0x07,0xff,0xff,0xff,0xff,0x07,0xff,0xff,0xff,0xff,0x03,
 0xff,0xff,0xff,0xff,0x03,0xff,0xff,0xff,0xff,0x01,0xfe,0xff,0xff,0x01,0x00,
 0xfe,0xff,0xff,0x00,0x00,0xfe,0xff,0xff,0x00,0x00,0xff,0xff,0xff,0x00,0x00,
 0xff,0xff,0xff,0x00,0x00,0xff,0xff,0xff,0x00,0x00,0xfe,0xff,0xff,0x00,0x00,
 0xfe,0xff,0xff,0x00,0x00,0xfc,0xff,0xff,0x00,0x00,0xf8,0xff,0xff,0x00,0x00,
 0xf8,0xff,0xff,0x00,0x00,0xf8,0xff,0xff,0x00,0x00,0xf8,0xff,0x1f,0x00,0x00,
 0xf8,0xff,0x0f,0x00,0x00,0xf8,0xff,0x07,0x00,0x00,0xf8,0xff,0x00,0x00,0x00,
 0xfc,0x7f,0x00,0x00,0x00,0xfc,0x00,0x00,0x00,0x00,0x78,0x00,0x00,0x00,0x00
 },

 { /* static char eastern_australia_bits[] = { */
 0x00,0x00,0x08,0x00,0x00,0x00,0x00,0x08,0x00,0x00,0x00,0x00,0x08,0x00,0x00,
 0x00,0x00,0x08,0x00,0x00,0x00,0x00,0x08,0x00,0x00,0x00,0x00,0x18,0x00,0x00,
 0x00,0x00,0x7c,0x00,0x00,0x00,0x00,0xfc,0x00,0x00,0x00,0x00,0xfe,0x00,0x00,
 0x00,0x00,0xff,0x01,0x00,0x00,0xe0,0xff,0x01,0x00,0x00,0xe0,0xff,0x03,0x00,
 0x00,0xe0,0xff,0x07,0x00,0x00,0xf0,0xff,0x07,0x00,0x00,0xf0,0xff,0x0f,0x00,
 0x00,0xf0,0xff,0x1f,0x00,0x00,0xf0,0xff,0x1f,0x00,0x00,0xf0,0xff,0x1f,0x00,
 0x00,0xf8,0xff,0x3f,0x00,0x00,0xf8,0xff,0xff,0x00,0x00,0xfc,0xff,0xff,0x03,
 0x00,0xfc,0xff,0xff,0x07,0x00,0xfe,0xff,0xff,0x07,0xfe,0xff,0xff,0xff,0x07,
 0xff,0xff,0xff,0xff,0x07,0xff,0xff,0xff,0xff,0x07,0xff,0xff,0xff,0xff,0x07,
 0xff,0xff,0xff,0xff,0x07,0xff,0xff,0xff,0xff,0x07,0xff,0xff,0xff,0xff,0x0f,
 0xff,0xff,0xff,0xff,0x0f,0xff,0xff,0xff,0xff,0x0f,0xff,0xff,0xff,0xff,0x0f,
 0xff,0xff,0xff,0xff,0x07,0xff,0xff,0xff,0xff,0x07,0xe0,0xff,0xff,0xff,0x03,
 0x80,0xff,0xff,0xff,0x01,0x00,0xff,0xff,0xff,0x01,0x00,0xfc,0xff,0xff,0x01,
 0x00,0xc0,0xff,0xff,0x00,0x00,0x80,0xff,0x7f,0x00,0x00,0x80,0xff,0x3f,0x00,
 0x00,0x00,0xff,0x3f,0x00,0x00,0x00,0xff,0x7f,0x00,0x00,0x00,0xff,0x7f,0x00,
 0x00,0x00,0xfe,0x7f,0x00,0x00,0x00,0xb8,0x1f,0x00,0x00,0x00,0x00,0x0f,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x00,0x00,0x00,0x80,0x09,0x00,
 0x00,0x00,0x00,0x1f,0x00,0x00,0x00,0x00,0x1f,0x00,0x00,0x00,0x00,0x0e,0x00,
 0x00,0x00,0x00,0x04,0x00}
};
