/***********************************************************************/
/* REXX.C - REXX interface routines.                                   */
/***********************************************************************/
/*
 * THE - The Hessling Editor. A text editor similar to VM/CMS xedit.
 * Copyright (C) 1991-1997 Mark Hessling
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to:
 *
 *    The Free Software Foundation, Inc.
 *    675 Mass Ave,
 *    Cambridge, MA 02139 USA.
 *
 *
 * If you make modifications to this software that you feel increases
 * it usefulness for the rest of the community, please email the
 * changes, enhancements, bug fixes as well as any and all ideas to me.
 * This software is going to be maintained and enhanced as deemed
 * necessary by the community.
 *
 * Mark Hessling                 Email:             M.Hessling@qut.edu.au
 * PO Box 203                    Phone:                    +617 3802 0800
 * Bellara                       http://www.gu.edu.au/gext/the/markh.html
 * QLD 4507                      **** Maintainer PDCurses & REXX/SQL ****
 * Australia                     ************* Author of THE ************
 */

/*
$Id: rexx.c 2.1 1995/06/24 16:31:04 MH Rel MH $
*/

#if defined(__EMX__) && defined(USE_REGINA) && !defined(MSDOS)
# include <os2.h>
#else
/*--------------------------- global data -----------------------------*/
/* these are here because EMX include REXX definitions from within os2.h */
/*---------------------------------------------------------------------*/
#  define INCL_RXSUBCOM       /* Subcommand handler values */
#  define INCL_RXSHV          /* Shared variable support */
#  define INCL_RXSYSEXIT      /* System exit routines */
#  define INCL_DOSPROCESS     /* Process/Thread Info */
#  define INCL_RXFUNC         /* External functions */
#endif
#include <the.h>
#include <proto.h>

LINE *rexxout_first_line=NULL;
LINE *rexxout_last_line=NULL;
LINE *rexxout_curr=NULL;
LINETYPE rexxout_number_lines=0L;

#if (defined(HAVE_PROTO) && !defined(NOREXX)) || defined(USE_REXXIMC)

/*
 * Because Rexx interpreters include <windows.h> on Windows platforms
 * and it defines MOUSE_MOVED, we have to undef it here to avoid
 * conflict.
 */
#undef MOUSE_MOVED
#include <query.h>
#if defined(__EMX__) && defined(USE_REGINA) && !defined(MSDOS)
#  define INCL_RXSUBCOM       /* Subcommand handler values */
#  define INCL_RXSHV          /* Shared variable support */
#  define INCL_RXSYSEXIT      /* System exit routines */
#  define INCL_DOSPROCESS     /* Process/Thread Info */
#  define INCL_RXFUNC         /* External functions */
#endif
#include <therexx.h>

#if defined(HAVE_SYS_WAIT_H)
# include <sys/wait.h>
#endif

#define BUF_SIZE 512

#if defined(USE_REXX6000)
LONG THE_Commands( RSH_ARG0_TYPE, RSH_ARG1_TYPE, RSH_ARG2_TYPE );
LONG THE_Exit_Handler( REH_ARG0_TYPE, REH_ARG1_TYPE, REH_ARG2_TYPE );
USHORT THE_Function_Handler( RFH_ARG0_TYPE, RFH_ARG1_TYPE, RFH_ARG2_TYPE, RFH_ARG3_TYPE, RFH_ARG4_TYPE );
#else
RexxSubcomHandler THE_Commands;
RexxExitHandler THE_Exit_Handler;
RexxFunctionHandler THE_Function_Handler;
#endif

#if defined(HAVE_PROTO)
static RXSTRING *get_compound_rexx_variable(CHARTYPE *,RXSTRING *,short);
static short valid_target_function(ULONG, RXSTRING []);
static short run_os_function(ULONG, RXSTRING []);
static int run_os_command(CHARTYPE *,CHARTYPE *,CHARTYPE *,CHARTYPE *);
static CHARTYPE *MakeAscii(RXSTRING *);
static char *get_a_line(FILE *, char *, int *, int *);
static short set_rexx_variables_from_file(char *,CHARTYPE *);
#else
static RXSTRING *get_compound_rexx_variable();
static short valid_target_function();
static short run_os_function();
static int run_os_command();
static CHARTYPE *MakeAscii();
static char *get_a_line();
static short set_rexx_variables_from_file();
#endif

static LINETYPE captured_lines;
static bool rexx_halted;

#define LVL_GLOB  1
#define LVL_FILE  2
#define LVL_VIEW  3

struct function_item
 {
  CHARTYPE *name;                                      /* name of item */
  char  name_length;                        /* length of function name */
  short item_number;                         /* unique number for item */
  short item_index;                  /* index value for the whole item */
  short level;                    /* level of item; global, file, view */
 };
typedef struct function_item FUNCTION_ITEM;

 static FUNCTION_ITEM function_item[] =
  {
   {(CHARTYPE *)"ALT.0",5,ITEM_ALT,0,LVL_FILE},
   {(CHARTYPE *)"ALT.1",5,ITEM_ALT,1,LVL_FILE},
   {(CHARTYPE *)"ALT.2",5,ITEM_ALT,2,LVL_FILE},
   {(CHARTYPE *)"ARBCHAR.0",9,ITEM_ARBCHAR,0,LVL_VIEW},
   {(CHARTYPE *)"ARBCHAR.1",9,ITEM_ARBCHAR,1,LVL_VIEW},
   {(CHARTYPE *)"ARBCHAR.2",9,ITEM_ARBCHAR,2,LVL_VIEW},
   {(CHARTYPE *)"AUTOSAVE.0",10,ITEM_AUTOSAVE,0,LVL_FILE},
   {(CHARTYPE *)"AUTOSAVE.1",10,ITEM_AUTOSAVE,1,LVL_FILE},
   {(CHARTYPE *)"BACKUP.0",8,ITEM_BACKUP,0,LVL_FILE},
   {(CHARTYPE *)"BACKUP.1",8,ITEM_BACKUP,1,LVL_FILE},
   {(CHARTYPE *)"BEEP.0",6,ITEM_BEEP,0,LVL_GLOB},
   {(CHARTYPE *)"BEEP.1",6,ITEM_BEEP,1,LVL_GLOB},
   {(CHARTYPE *)"BLOCK.0",7,ITEM_BLOCK,0,LVL_VIEW},
   {(CHARTYPE *)"BLOCK.1",7,ITEM_BLOCK,1,LVL_VIEW},
   {(CHARTYPE *)"BLOCK.2",7,ITEM_BLOCK,2,LVL_VIEW},
   {(CHARTYPE *)"BLOCK.3",7,ITEM_BLOCK,3,LVL_VIEW},
   {(CHARTYPE *)"BLOCK.4",7,ITEM_BLOCK,4,LVL_VIEW},
   {(CHARTYPE *)"BLOCK.5",7,ITEM_BLOCK,5,LVL_VIEW},
   {(CHARTYPE *)"BLOCK.6",7,ITEM_BLOCK,6,LVL_VIEW},
   {(CHARTYPE *)"CASE.0",6,ITEM_CASE,0,LVL_VIEW},
   {(CHARTYPE *)"CASE.1",6,ITEM_CASE,1,LVL_VIEW},
   {(CHARTYPE *)"CASE.2",6,ITEM_CASE,2,LVL_VIEW},
   {(CHARTYPE *)"CASE.3",6,ITEM_CASE,3,LVL_VIEW},
   {(CHARTYPE *)"CASE.4",6,ITEM_CASE,4,LVL_VIEW},
   {(CHARTYPE *)"CLEARSCREEN.0",13,ITEM_CLEARSCREEN,0,LVL_GLOB},
   {(CHARTYPE *)"CLEARSCREEN.1",13,ITEM_CLEARSCREEN,1,LVL_GLOB},
   {(CHARTYPE *)"CLOCK.0",7,ITEM_CLOCK,0,LVL_GLOB},
   {(CHARTYPE *)"CLOCK.1",7,ITEM_CLOCK,1,LVL_GLOB},
   {(CHARTYPE *)"CMDARROWS.0",11,ITEM_CMDARROWS,0,LVL_GLOB},
   {(CHARTYPE *)"CMDARROWS.1",11,ITEM_CMDARROWS,1,LVL_GLOB},
   {(CHARTYPE *)"CMDLINE.0",9,ITEM_CMDLINE,0,LVL_VIEW},
   {(CHARTYPE *)"CMDLINE.1",9,ITEM_CMDLINE,1,LVL_VIEW},
   {(CHARTYPE *)"CMDLINE.2",9,ITEM_CMDLINE,2,LVL_VIEW},
   {(CHARTYPE *)"CMDLINE.3",9,ITEM_CMDLINE,3,LVL_VIEW},
   {(CHARTYPE *)"COLOR.0",7,ITEM_COLOR,0,LVL_FILE},
   {(CHARTYPE *)"COLOR.1",7,ITEM_COLOR,1,LVL_FILE},
   {(CHARTYPE *)"COLOR.2",7,ITEM_COLOR,2,LVL_FILE},
   {(CHARTYPE *)"COLOR.3",7,ITEM_COLOR,3,LVL_FILE},
   {(CHARTYPE *)"COLOR.4",7,ITEM_COLOR,4,LVL_FILE},
   {(CHARTYPE *)"COLOR.5",7,ITEM_COLOR,5,LVL_FILE},
   {(CHARTYPE *)"COLOR.6",7,ITEM_COLOR,6,LVL_FILE},
   {(CHARTYPE *)"COLOR.7",7,ITEM_COLOR,7,LVL_FILE},
   {(CHARTYPE *)"COLOR.8",7,ITEM_COLOR,8,LVL_FILE},
   {(CHARTYPE *)"COLOR.9",7,ITEM_COLOR,9,LVL_FILE},
   {(CHARTYPE *)"COLOR.10",8,ITEM_COLOR,10,LVL_FILE},
   {(CHARTYPE *)"COLOR.11",8,ITEM_COLOR,11,LVL_FILE},
   {(CHARTYPE *)"COLOR.12",8,ITEM_COLOR,12,LVL_FILE},
   {(CHARTYPE *)"COLOR.13",8,ITEM_COLOR,13,LVL_FILE},
   {(CHARTYPE *)"COLOR.14",8,ITEM_COLOR,14,LVL_FILE},
   {(CHARTYPE *)"COLOR.15",8,ITEM_COLOR,15,LVL_FILE},
   {(CHARTYPE *)"COLOR.16",8,ITEM_COLOR,16,LVL_FILE},
   {(CHARTYPE *)"COLOR.17",8,ITEM_COLOR,17,LVL_FILE},
   {(CHARTYPE *)"COLOR.18",8,ITEM_COLOR,18,LVL_FILE},
   {(CHARTYPE *)"COLOR.19",8,ITEM_COLOR,19,LVL_FILE},
   {(CHARTYPE *)"COLOR.20",8,ITEM_COLOR,20,LVL_FILE},
   {(CHARTYPE *)"COLOR.21",8,ITEM_COLOR,21,LVL_FILE},
   {(CHARTYPE *)"COLOR.22",8,ITEM_COLOR,22,LVL_FILE},
   {(CHARTYPE *)"COLOR.23",8,ITEM_COLOR,23,LVL_FILE},
   {(CHARTYPE *)"COLOUR.0",7,ITEM_COLOUR,0,LVL_FILE},
   {(CHARTYPE *)"COLOUR.1",7,ITEM_COLOUR,1,LVL_FILE},
   {(CHARTYPE *)"COLOUR.2",7,ITEM_COLOUR,2,LVL_FILE},
   {(CHARTYPE *)"COLOUR.3",7,ITEM_COLOUR,3,LVL_FILE},
   {(CHARTYPE *)"COLOUR.4",7,ITEM_COLOUR,4,LVL_FILE},
   {(CHARTYPE *)"COLOUR.5",7,ITEM_COLOUR,5,LVL_FILE},
   {(CHARTYPE *)"COLOUR.6",7,ITEM_COLOUR,6,LVL_FILE},
   {(CHARTYPE *)"COLOUR.7",7,ITEM_COLOUR,7,LVL_FILE},
   {(CHARTYPE *)"COLOUR.8",7,ITEM_COLOUR,8,LVL_FILE},
   {(CHARTYPE *)"COLOUR.9",7,ITEM_COLOUR,9,LVL_FILE},
   {(CHARTYPE *)"COLOUR.10",8,ITEM_COLOUR,10,LVL_FILE},
   {(CHARTYPE *)"COLOUR.11",8,ITEM_COLOUR,11,LVL_FILE},
   {(CHARTYPE *)"COLOUR.12",8,ITEM_COLOUR,12,LVL_FILE},
   {(CHARTYPE *)"COLOUR.13",8,ITEM_COLOUR,13,LVL_FILE},
   {(CHARTYPE *)"COLOUR.14",8,ITEM_COLOUR,14,LVL_FILE},
   {(CHARTYPE *)"COLOUR.15",8,ITEM_COLOUR,15,LVL_FILE},
   {(CHARTYPE *)"COLOUR.16",8,ITEM_COLOUR,16,LVL_FILE},
   {(CHARTYPE *)"COLOUR.17",8,ITEM_COLOUR,17,LVL_FILE},
   {(CHARTYPE *)"COLOUR.18",8,ITEM_COLOUR,18,LVL_FILE},
   {(CHARTYPE *)"COLOUR.19",8,ITEM_COLOUR,19,LVL_FILE},
   {(CHARTYPE *)"COLOUR.20",8,ITEM_COLOUR,20,LVL_FILE},
   {(CHARTYPE *)"COLOUR.21",8,ITEM_COLOUR,21,LVL_FILE},
   {(CHARTYPE *)"COLOUR.22",8,ITEM_COLOUR,22,LVL_FILE},
   {(CHARTYPE *)"COLOUR.23",8,ITEM_COLOUR,23,LVL_FILE},
   {(CHARTYPE *)"COLUMN.0",8,ITEM_COLUMN,0,LVL_VIEW},
   {(CHARTYPE *)"COLUMN.1",8,ITEM_COLUMN,1,LVL_VIEW},
   {(CHARTYPE *)"COMPAT.0",8,ITEM_COMPAT,0,LVL_GLOB},
   {(CHARTYPE *)"COMPAT.1",8,ITEM_COMPAT,1,LVL_GLOB},
   {(CHARTYPE *)"COMPAT.2",8,ITEM_COMPAT,2,LVL_GLOB},
   {(CHARTYPE *)"COMPAT.3",8,ITEM_COMPAT,3,LVL_GLOB},
   {(CHARTYPE *)"CURLINE.0",9,ITEM_CURLINE,0,LVL_VIEW},
   {(CHARTYPE *)"CURLINE.1",9,ITEM_CURLINE,1,LVL_VIEW},
   {(CHARTYPE *)"CURLINE.2",9,ITEM_CURLINE,2,LVL_VIEW},
   {(CHARTYPE *)"CURLINE.3",9,ITEM_CURLINE,3,LVL_VIEW},
   {(CHARTYPE *)"CURLINE.4",9,ITEM_CURLINE,4,LVL_VIEW},
   {(CHARTYPE *)"CURLINE.5",9,ITEM_CURLINE,5,LVL_VIEW},
   {(CHARTYPE *)"CURLINE.6",9,ITEM_CURLINE,6,LVL_VIEW},
   {(CHARTYPE *)"CURSOR.0",8,ITEM_CURSOR,0,LVL_VIEW},
   {(CHARTYPE *)"CURSOR.1",8,ITEM_CURSOR,1,LVL_VIEW},
   {(CHARTYPE *)"CURSOR.2",8,ITEM_CURSOR,2,LVL_VIEW},
   {(CHARTYPE *)"CURSOR.3",8,ITEM_CURSOR,3,LVL_VIEW},
   {(CHARTYPE *)"CURSOR.4",8,ITEM_CURSOR,4,LVL_VIEW},
   {(CHARTYPE *)"CURSOR.5",8,ITEM_CURSOR,5,LVL_VIEW},
   {(CHARTYPE *)"CURSOR.6",8,ITEM_CURSOR,6,LVL_VIEW},
   {(CHARTYPE *)"CURSOR.7",8,ITEM_CURSOR,7,LVL_VIEW},
   {(CHARTYPE *)"CURSOR.8",8,ITEM_CURSOR,8,LVL_VIEW},
   {(CHARTYPE *)"CURSORSTAY.0",12,ITEM_CURSORSTAY,0,LVL_GLOB},
   {(CHARTYPE *)"CURSORSTAY.1",12,ITEM_CURSORSTAY,1,LVL_GLOB},
   {(CHARTYPE *)"DEFSORT.0",12,ITEM_DEFSORT,0,LVL_GLOB},
   {(CHARTYPE *)"DEFSORT.1",12,ITEM_DEFSORT,1,LVL_GLOB},
   {(CHARTYPE *)"DEFSORT.2",12,ITEM_DEFSORT,2,LVL_GLOB},
   {(CHARTYPE *)"DIRFILEID.0",11,ITEM_DIRFILEID,0,LVL_FILE},
   {(CHARTYPE *)"DIRFILEID.1",11,ITEM_DIRFILEID,1,LVL_FILE},
   {(CHARTYPE *)"DIRFILEID.2",11,ITEM_DIRFILEID,2,LVL_FILE},
   {(CHARTYPE *)"DISPLAY.0",9,ITEM_DISPLAY,0,LVL_VIEW},
   {(CHARTYPE *)"DISPLAY.1",9,ITEM_DISPLAY,1,LVL_VIEW},
   {(CHARTYPE *)"DISPLAY.2",9,ITEM_DISPLAY,2,LVL_VIEW},
   {(CHARTYPE *)"EOF.0",5,ITEM_EOF,0,LVL_VIEW},
   {(CHARTYPE *)"EOF.1",5,ITEM_EOF,1,LVL_VIEW},
   {(CHARTYPE *)"EOLOUT.0",8,ITEM_EOLOUT,0,LVL_FILE},
   {(CHARTYPE *)"EOLOUT.1",8,ITEM_EOLOUT,1,LVL_FILE},
   {(CHARTYPE *)"ETMODE.0",8,ITEM_ETMODE,0,LVL_GLOB},
   {(CHARTYPE *)"ETMODE.1",8,ITEM_ETMODE,1,LVL_GLOB},
   {(CHARTYPE *)"ETMODE.2",8,ITEM_ETMODE,2,LVL_GLOB},
   {(CHARTYPE *)"FEXT.0",6,ITEM_FEXT,0,LVL_FILE},
   {(CHARTYPE *)"FEXT.1",6,ITEM_FEXT,1,LVL_FILE},
   {(CHARTYPE *)"FIELD.0",7,ITEM_FIELD,0,LVL_VIEW},
   {(CHARTYPE *)"FIELD.1",7,ITEM_FIELD,1,LVL_VIEW},
   {(CHARTYPE *)"FIELD.2",7,ITEM_FIELD,2,LVL_VIEW},
   {(CHARTYPE *)"FIELD.3",7,ITEM_FIELD,3,LVL_VIEW},
   {(CHARTYPE *)"FIELD.4",7,ITEM_FIELD,4,LVL_VIEW},
   {(CHARTYPE *)"FILENAME.0",10,ITEM_FILENAME,0,LVL_FILE},
   {(CHARTYPE *)"FILENAME.1",10,ITEM_FILENAME,1,LVL_FILE},
   {(CHARTYPE *)"FMODE.0",7,ITEM_FMODE,0,LVL_FILE},
   {(CHARTYPE *)"FMODE.1",7,ITEM_FMODE,1,LVL_FILE},
   {(CHARTYPE *)"FNAME.0",7,ITEM_FNAME,0,LVL_FILE},
   {(CHARTYPE *)"FNAME.1",7,ITEM_FNAME,1,LVL_FILE},
   {(CHARTYPE *)"FPATH.0",7,ITEM_FPATH,0,LVL_FILE},
   {(CHARTYPE *)"FPATH.1",7,ITEM_FPATH,1,LVL_FILE},
   {(CHARTYPE *)"FTYPE.0",7,ITEM_FTYPE,0,LVL_FILE},
   {(CHARTYPE *)"FTYPE.1",7,ITEM_FTYPE,1,LVL_FILE},
   {(CHARTYPE *)"FULLFNAME.0",11,ITEM_FULLFNAME,0,LVL_FILE},
   {(CHARTYPE *)"FULLFNAME.1",11,ITEM_FULLFNAME,1,LVL_FILE},
   {(CHARTYPE *)"GETENV.0",8,ITEM_GETENV,0,LVL_GLOB},
   {(CHARTYPE *)"GETENV.1",8,ITEM_GETENV,1,LVL_GLOB},
   {(CHARTYPE *)"HEX.0",5,ITEM_HEX,0,LVL_VIEW},
   {(CHARTYPE *)"HEX.1",5,ITEM_HEX,1,LVL_VIEW},
   {(CHARTYPE *)"HEXDISPLAY.0",12,ITEM_HEXDISPLAY,0,LVL_GLOB},
   {(CHARTYPE *)"HEXDISPLAY.1",12,ITEM_HEXDISPLAY,1,LVL_GLOB},
   {(CHARTYPE *)"HEXSHOW.0",9,ITEM_HEXSHOW,0,LVL_VIEW},
   {(CHARTYPE *)"HEXSHOW.1",9,ITEM_HEXSHOW,1,LVL_VIEW},
   {(CHARTYPE *)"HEXSHOW.2",9,ITEM_HEXSHOW,2,LVL_VIEW},
   {(CHARTYPE *)"HIGHLIGHT.0",11,ITEM_HIGHLIGHT,0,LVL_VIEW},
   {(CHARTYPE *)"HIGHLIGHT.1",11,ITEM_HIGHLIGHT,1,LVL_VIEW},
   {(CHARTYPE *)"HIGHLIGHT.2",11,ITEM_HIGHLIGHT,2,LVL_VIEW},
   {(CHARTYPE *)"HIGHLIGHT.3",11,ITEM_HIGHLIGHT,3,LVL_VIEW},
   {(CHARTYPE *)"IDLINE.0",8,ITEM_IDLINE,0,LVL_VIEW},
   {(CHARTYPE *)"IDLINE.1",8,ITEM_IDLINE,1,LVL_VIEW},
   {(CHARTYPE *)"IMPMACRO.0",10,ITEM_IMPMACRO,0,LVL_VIEW},
   {(CHARTYPE *)"IMPMACRO.1",10,ITEM_IMPMACRO,1,LVL_VIEW},
   {(CHARTYPE *)"IMPMOS.0",8,ITEM_IMPOS,0,LVL_VIEW},
   {(CHARTYPE *)"IMPMOS.1",8,ITEM_IMPOS,1,LVL_VIEW},
   {(CHARTYPE *)"INPUTMODE.0",11,ITEM_INPUTMODE,0,LVL_VIEW},
   {(CHARTYPE *)"INPUTMODE.1",11,ITEM_INPUTMODE,1,LVL_VIEW},
   {(CHARTYPE *)"INSERTMODE.0",12,ITEM_INSERTMODE,0,LVL_GLOB},
   {(CHARTYPE *)"INSERTMODE.1",12,ITEM_INSERTMODE,1,LVL_GLOB},
   {(CHARTYPE *)"LASTMSG.0",9,ITEM_LASTMSG,0,LVL_GLOB},
   {(CHARTYPE *)"LASTMSG.1",9,ITEM_LASTMSG,1,LVL_GLOB},
   {(CHARTYPE *)"LASTRC.0",8,ITEM_LASTRC,0,LVL_GLOB},
   {(CHARTYPE *)"LASTRC.1",8,ITEM_LASTRC,1,LVL_GLOB},
   {(CHARTYPE *)"LENGTH.0",8,ITEM_LENGTH,0,LVL_FILE},
   {(CHARTYPE *)"LENGTH.1",8,ITEM_LENGTH,1,LVL_FILE},
   {(CHARTYPE *)"LINE.0",6,ITEM_LINE,0,LVL_VIEW},
   {(CHARTYPE *)"LINE.1",6,ITEM_LINE,1,LVL_VIEW},
   {(CHARTYPE *)"LINEFLAG.0",10,ITEM_LINEFLAG,0,LVL_FILE},
   {(CHARTYPE *)"LINEFLAG.1",10,ITEM_LINEFLAG,1,LVL_FILE},
   {(CHARTYPE *)"LINEFLAG.2",10,ITEM_LINEFLAG,2,LVL_FILE},
   {(CHARTYPE *)"LINEFLAG.3",10,ITEM_LINEFLAG,3,LVL_FILE},
   {(CHARTYPE *)"LINEND.0",8,ITEM_LINEND,0,LVL_VIEW},
   {(CHARTYPE *)"LINEND.1",8,ITEM_LINEND,1,LVL_VIEW},
   {(CHARTYPE *)"LINEND.2",8,ITEM_LINEND,2,LVL_VIEW},
   {(CHARTYPE *)"LSCREEN.0",9,ITEM_LSCREEN,0,LVL_GLOB},
   {(CHARTYPE *)"LSCREEN.1",9,ITEM_LSCREEN,1,LVL_GLOB},
   {(CHARTYPE *)"LSCREEN.2",9,ITEM_LSCREEN,2,LVL_GLOB},
   {(CHARTYPE *)"LSCREEN.3",9,ITEM_LSCREEN,3,LVL_GLOB},
   {(CHARTYPE *)"LSCREEN.4",9,ITEM_LSCREEN,4,LVL_GLOB},
   {(CHARTYPE *)"LSCREEN.5",9,ITEM_LSCREEN,5,LVL_GLOB},
   {(CHARTYPE *)"LSCREEN.6",9,ITEM_LSCREEN,6,LVL_GLOB},
   {(CHARTYPE *)"MACRO.0",7,ITEM_MACRO,0,LVL_VIEW},
   {(CHARTYPE *)"MACRO.1",7,ITEM_MACRO,1,LVL_VIEW},
   {(CHARTYPE *)"MACROEXT.0",10,ITEM_MACROEXT,0,LVL_GLOB},
   {(CHARTYPE *)"MACROEXT.1",10,ITEM_MACROEXT,1,LVL_GLOB},
   {(CHARTYPE *)"MACROPATH.0",11,ITEM_MACROPATH,0,LVL_GLOB},
   {(CHARTYPE *)"MACROPATH.1",11,ITEM_MACROPATH,1,LVL_GLOB},
   {(CHARTYPE *)"MARGINS.0",9,ITEM_MARGINS,0,LVL_VIEW},
   {(CHARTYPE *)"MARGINS.1",9,ITEM_MARGINS,1,LVL_VIEW},
   {(CHARTYPE *)"MARGINS.2",9,ITEM_MARGINS,2,LVL_VIEW},
   {(CHARTYPE *)"MARGINS.3",9,ITEM_MARGINS,3,LVL_VIEW},
   {(CHARTYPE *)"MONITOR.0",9,ITEM_MONITOR,0,LVL_GLOB},
   {(CHARTYPE *)"MONITOR.1",9,ITEM_MONITOR,1,LVL_GLOB},
   {(CHARTYPE *)"MONITOR.2",9,ITEM_MONITOR,2,LVL_GLOB},
   {(CHARTYPE *)"MOUSE.0",7,ITEM_MOUSE,0,LVL_GLOB},
   {(CHARTYPE *)"MOUSE.1",7,ITEM_MOUSE,1,LVL_GLOB},
   {(CHARTYPE *)"MSGLINE.0",9,ITEM_MSGLINE,0,LVL_VIEW},
   {(CHARTYPE *)"MSGLINE.1",9,ITEM_MSGLINE,1,LVL_VIEW},
   {(CHARTYPE *)"MSGLINE.2",9,ITEM_MSGLINE,2,LVL_VIEW},
   {(CHARTYPE *)"MSGLINE.3",9,ITEM_MSGLINE,3,LVL_VIEW},
   {(CHARTYPE *)"MSGLINE.4",9,ITEM_MSGLINE,4,LVL_VIEW},
   {(CHARTYPE *)"MSGMODE.0",9,ITEM_MSGMODE,0,LVL_VIEW},
   {(CHARTYPE *)"MSGMODE.1",9,ITEM_MSGMODE,1,LVL_VIEW},
   {(CHARTYPE *)"NBFILE.0",8,ITEM_NBFILE,0,LVL_GLOB},
   {(CHARTYPE *)"NBFILE.1",8,ITEM_NBFILE,1,LVL_GLOB},
   {(CHARTYPE *)"NEWLINES.0",10,ITEM_NEWLINES,0,LVL_VIEW},
   {(CHARTYPE *)"NEWLINES.1",10,ITEM_NEWLINES,1,LVL_VIEW},
   {(CHARTYPE *)"NONDISP.0",9,ITEM_NONDISP,0,LVL_GLOB},
   {(CHARTYPE *)"NONDISP.1",9,ITEM_NONDISP,1,LVL_GLOB},
   {(CHARTYPE *)"NUMBER.0",8,ITEM_NUMBER,0,LVL_VIEW},
   {(CHARTYPE *)"NUMBER.1",8,ITEM_NUMBER,1,LVL_VIEW},
   {(CHARTYPE *)"POSITION.0",10,ITEM_POSITION,0,LVL_VIEW},
   {(CHARTYPE *)"POSITION.1",10,ITEM_POSITION,1,LVL_VIEW},
   {(CHARTYPE *)"POSITION.2",10,ITEM_POSITION,2,LVL_VIEW},
   {(CHARTYPE *)"POSITION.3",10,ITEM_POSITION,3,LVL_VIEW},
   {(CHARTYPE *)"PREFIX.0",8,ITEM_PREFIX,0,LVL_VIEW},
   {(CHARTYPE *)"PREFIX.1",8,ITEM_PREFIX,1,LVL_VIEW},
   {(CHARTYPE *)"PREFIX.2",8,ITEM_PREFIX,2,LVL_VIEW},
   {(CHARTYPE *)"PREFIX.3",8,ITEM_PREFIX,3,LVL_VIEW},
   {(CHARTYPE *)"PREFIX.4",8,ITEM_PREFIX,4,LVL_VIEW},
   {(CHARTYPE *)"PRINTER.0",9,ITEM_PRINTER,0,LVL_GLOB},
   {(CHARTYPE *)"PRINTER.1",9,ITEM_PRINTER,1,LVL_GLOB},
   {(CHARTYPE *)"REPROFILE.0",11,ITEM_REPROFILE,0,LVL_GLOB},
   {(CHARTYPE *)"REPROFILE.1",11,ITEM_REPROFILE,1,LVL_GLOB},
   {(CHARTYPE *)"RESERVED.0",10,ITEM_RESERVED,0,LVL_FILE},
   {(CHARTYPE *)"RESERVED.1",10,ITEM_RESERVED,1,LVL_FILE},
   {(CHARTYPE *)"REXXOUTPUT.0",12,ITEM_REXXOUTPUT,0,LVL_GLOB},
   {(CHARTYPE *)"REXXOUTPUT.1",12,ITEM_REXXOUTPUT,1,LVL_GLOB},
   {(CHARTYPE *)"REXXOUTPUT.2",12,ITEM_REXXOUTPUT,2,LVL_GLOB},
   {(CHARTYPE *)"RING.0",6,ITEM_RING,0,LVL_GLOB},
   {(CHARTYPE *)"SCALE.0",7,ITEM_SCALE,0,LVL_VIEW},
   {(CHARTYPE *)"SCALE.1",7,ITEM_SCALE,1,LVL_VIEW},
   {(CHARTYPE *)"SCALE.2",7,ITEM_SCALE,2,LVL_VIEW},
   {(CHARTYPE *)"SCOPE.0",7,ITEM_SCOPE,0,LVL_VIEW},
   {(CHARTYPE *)"SCOPE.1",7,ITEM_SCOPE,1,LVL_VIEW},
   {(CHARTYPE *)"SCREEN.0",8,ITEM_SCREEN,0,LVL_GLOB},
   {(CHARTYPE *)"SCREEN.1",8,ITEM_SCREEN,1,LVL_GLOB},
   {(CHARTYPE *)"SCREEN.2",8,ITEM_SCREEN,2,LVL_GLOB},
   {(CHARTYPE *)"SELECT.0",8,ITEM_SELECT,0,LVL_FILE},
   {(CHARTYPE *)"SELECT.1",8,ITEM_SELECT,1,LVL_FILE},
   {(CHARTYPE *)"SELECT.2",8,ITEM_SELECT,2,LVL_FILE},
   {(CHARTYPE *)"SHADOW.0",8,ITEM_SHADOW,0,LVL_VIEW},
   {(CHARTYPE *)"SHADOW.1",8,ITEM_SHADOW,1,LVL_VIEW},
   {(CHARTYPE *)"SIZE.0",6,ITEM_SIZE,0,LVL_FILE},
   {(CHARTYPE *)"SIZE.1",6,ITEM_SIZE,1,LVL_FILE},
   {(CHARTYPE *)"STATUSLINE.0",12,ITEM_STATUSLINE,0,LVL_GLOB},
   {(CHARTYPE *)"STATUSLINE.1",12,ITEM_STATUSLINE,1,LVL_GLOB},
   {(CHARTYPE *)"STAY.0",6,ITEM_STAY,0,LVL_VIEW},
   {(CHARTYPE *)"STAY.1",6,ITEM_STAY,1,LVL_VIEW},
   {(CHARTYPE *)"TABKEY.0",8,ITEM_TABKEY,0,LVL_GLOB},
   {(CHARTYPE *)"TABKEY.1",8,ITEM_TABKEY,1,LVL_GLOB},
   {(CHARTYPE *)"TABKEY.2",8,ITEM_TABKEY,2,LVL_GLOB},
   {(CHARTYPE *)"TABLINE.0",9,ITEM_TABLINE,0,LVL_VIEW},
   {(CHARTYPE *)"TABLINE.1",9,ITEM_TABLINE,1,LVL_VIEW},
   {(CHARTYPE *)"TABLINE.2",9,ITEM_TABLINE,2,LVL_VIEW},
   {(CHARTYPE *)"TABS.0",6,ITEM_TABS,0,LVL_VIEW},
   {(CHARTYPE *)"TABS.1",6,ITEM_TABS,1,LVL_VIEW},
   {(CHARTYPE *)"TABSIN.0",8,ITEM_TABSIN,0,LVL_GLOB},
   {(CHARTYPE *)"TABSIN.1",8,ITEM_TABSIN,1,LVL_GLOB},
   {(CHARTYPE *)"TABSIN.2",8,ITEM_TABSIN,2,LVL_GLOB},
   {(CHARTYPE *)"TABSOUT.0",9,ITEM_TABSOUT,0,LVL_FILE},
   {(CHARTYPE *)"TABSOUT.1",9,ITEM_TABSOUT,1,LVL_FILE},
   {(CHARTYPE *)"TABSOUT.2",9,ITEM_TABSOUT,2,LVL_FILE},
   {(CHARTYPE *)"TERMINAL.0",10,ITEM_TERMINAL,0,LVL_GLOB},
   {(CHARTYPE *)"TERMINAL.1",10,ITEM_TERMINAL,1,LVL_GLOB},
   {(CHARTYPE *)"TOF.0",5,ITEM_TOF,0,LVL_VIEW},
   {(CHARTYPE *)"TOF.1",5,ITEM_TOF,1,LVL_VIEW},
   {(CHARTYPE *)"UNDOING.0",9,ITEM_UNDOING,0,LVL_FILE},
   {(CHARTYPE *)"UNDOING.1",9,ITEM_UNDOING,1,LVL_FILE},
   {(CHARTYPE *)"UNTAA.0",7,ITEM_UNTAA,0,LVL_GLOB},
   {(CHARTYPE *)"UNTAA.1",7,ITEM_UNTAA,1,LVL_GLOB},
   {(CHARTYPE *)"VERIFY.0",8,ITEM_VERIFY,0,LVL_VIEW},
   {(CHARTYPE *)"VERIFY.1",8,ITEM_VERIFY,1,LVL_VIEW},
   {(CHARTYPE *)"VERSHIFT.0",10,ITEM_VERSHIFT,0,LVL_VIEW},
   {(CHARTYPE *)"VERSHIFT.1",10,ITEM_VERSHIFT,1,LVL_VIEW},
   {(CHARTYPE *)"VERSION.0",9,ITEM_VERSION,0,LVL_GLOB},
   {(CHARTYPE *)"VERSION.1",9,ITEM_VERSION,1,LVL_GLOB},
   {(CHARTYPE *)"VERSION.2",9,ITEM_VERSION,2,LVL_GLOB},
   {(CHARTYPE *)"VERSION.3",9,ITEM_VERSION,3,LVL_GLOB},
   {(CHARTYPE *)"VERSION.4",9,ITEM_VERSION,4,LVL_GLOB},
   {(CHARTYPE *)"WIDTH.0",7,ITEM_WIDTH,0,LVL_GLOB},
   {(CHARTYPE *)"WIDTH.1",7,ITEM_WIDTH,1,LVL_GLOB},
   {(CHARTYPE *)"WORD.0",6,ITEM_WORD,0,LVL_VIEW},
   {(CHARTYPE *)"WORD.1",6,ITEM_WORD,1,LVL_VIEW},
   {(CHARTYPE *)"WORDWRAP.0",10,ITEM_WORDWRAP,0,LVL_VIEW},
   {(CHARTYPE *)"WORDWRAP.1",10,ITEM_WORDWRAP,1,LVL_VIEW},
   {(CHARTYPE *)"WRAP.0",6,ITEM_WRAP,0,LVL_VIEW},
   {(CHARTYPE *)"WRAP.1",6,ITEM_WRAP,1,LVL_VIEW},
   {(CHARTYPE *)"ZONE.0",6,ITEM_ZONE,0,LVL_VIEW},
   {(CHARTYPE *)"ZONE.1",6,ITEM_ZONE,1,LVL_VIEW},
   {(CHARTYPE *)"ZONE.2",6,ITEM_ZONE,2,LVL_VIEW},
   {(CHARTYPE *)"AFTER",5,ITEM_AFTER_FUNCTION,1,LVL_VIEW},
   {(CHARTYPE *)"BATCH",5,ITEM_BATCH_FUNCTION,1,LVL_GLOB},
   {(CHARTYPE *)"BEFORE",6,ITEM_BEFORE_FUNCTION,1,LVL_VIEW},
   {(CHARTYPE *)"BLANK",5,ITEM_BLANK_FUNCTION,1,LVL_VIEW},
   {(CHARTYPE *)"BLOCK",5,ITEM_BLOCK_FUNCTION,1,LVL_VIEW},
   {(CHARTYPE *)"BOTTOMEDGE",10,ITEM_BOTTOMEDGE_FUNCTION,1,LVL_VIEW},
   {(CHARTYPE *)"COMMAND",7,ITEM_COMMAND_FUNCTION,1,LVL_VIEW},
   {(CHARTYPE *)"CURRENT",7,ITEM_CURRENT_FUNCTION,1,LVL_VIEW},
   {(CHARTYPE *)"DIR",3,ITEM_DIR_FUNCTION,1,LVL_FILE},
   {(CHARTYPE *)"END",3,ITEM_END_FUNCTION,1,LVL_VIEW},
   {(CHARTYPE *)"EOF",3,ITEM_EOF_FUNCTION,1,LVL_VIEW},
   {(CHARTYPE *)"FIRST",5,ITEM_FIRST_FUNCTION,1,LVL_VIEW},
   {(CHARTYPE *)"FOCUSEOF",8,ITEM_FOCUSEOF_FUNCTION,1,LVL_VIEW},
   {(CHARTYPE *)"FOCUSTOF",8,ITEM_FOCUSTOF_FUNCTION,1,LVL_VIEW},
   {(CHARTYPE *)"INBLOCK",7,ITEM_INBLOCK_FUNCTION,1,LVL_VIEW},
   {(CHARTYPE *)"INCOMMAND",9,ITEM_INCOMMAND_FUNCTION,1,LVL_VIEW},
   {(CHARTYPE *)"INITIAL",7,ITEM_INITIAL_FUNCTION,1,LVL_GLOB},
   {(CHARTYPE *)"INPREFIX",8,ITEM_INPREFIX_FUNCTION,1,LVL_VIEW},
   {(CHARTYPE *)"LEFTEDGE",8,ITEM_LEFTEDGE_FUNCTION,1,LVL_VIEW},
   {(CHARTYPE *)"MODIFIABLE",10,ITEM_MODIFIABLE_FUNCTION,1,LVL_VIEW},
   {(CHARTYPE *)"RIGHTEDGE",9,ITEM_RIGHTEDGE_FUNCTION,1,LVL_VIEW},
   {(CHARTYPE *)"SHADOW",6,ITEM_SHADOW_FUNCTION,1,LVL_VIEW},
   {(CHARTYPE *)"SPACECHAR",9,ITEM_SPACECHAR_FUNCTION,1,LVL_VIEW},
   {(CHARTYPE *)"TOF",3,ITEM_TOF_FUNCTION,1,LVL_VIEW},
   {(CHARTYPE *)"TOPEDGE",7,ITEM_TOPEDGE_FUNCTION,1,LVL_VIEW},
   {(CHARTYPE *)"VERONE",6,ITEM_VERONE_FUNCTION,1,LVL_VIEW},
   {(CHARTYPE *)"VALID_TARGET",12,ITEM_VALID_TARGET_FUNCTION,1,LVL_VIEW},
   {(CHARTYPE *)"RUN_OS",6,ITEM_RUN_OS_FUNCTION,1,LVL_GLOB},
   {NULL,0,0,0,0},
  };

/***********************************************************************/
RSH_RETURN_TYPE THE_Commands
#if defined(HAVE_PROTO)
   (
   RSH_ARG0_TYPE Command,    /* Command string passed from the caller    */
   RSH_ARG1_TYPE Flags,      /* pointer to short for return of flags     */
   RSH_ARG2_TYPE Retstr)     /* pointer to RXSTRING for RC return        */
#else
   ( Command, Flags, Retstr )
   RSH_ARG0_TYPE Command;    /* Command string passed from the caller    */
   RSH_ARG1_TYPE Flags;      /* pointer to short for return of flags     */
   RSH_ARG2_TYPE Retstr;     /* pointer to RXSTRING for RC return        */
#endif
/***********************************************************************/
{
/*-------------------------- external data ----------------------------*/
 extern CHARTYPE *temp_cmd;
/*--------------------------- local data ------------------------------*/
 short rc=RC_OK;
 SHVBLOCK shv;
 RXSTRING argstr;
/*--------------------------- processing ------------------------------*/
 if (allocate_temp_space(Command->strlength,TEMP_TEMP_CMD) != RC_OK)
   {
    display_error(30,(CHARTYPE *)"",FALSE);
    *Flags = RXSUBCOM_ERROR;             /* raise an error condition   */
    sprintf((DEFCHAR *)Retstr->strptr, "%d", rc);   /* format return code string  */
                                         /* and set the correct length */
    Retstr->strlength = strlen((DEFCHAR *)Retstr->strptr);
    return 0L;                           /* processing completed       */
   }
 memcpy(temp_cmd,Command->strptr,Command->strlength);
 temp_cmd[Command->strlength] = '\0';

 if (strcmp("XXYYZZ",(DEFCHAR *)temp_cmd) == 0)
   {
    shv.shvnext=NULL;                                /* only one block */
    shv.shvcode=RXSHV_NEXTV;                             /* direct set */

    argstr.strptr=NULL;
    argstr.strlength=0;
    shv.shvname=argstr;
    rc = 0;
    while(rc != 2)
     {
      rc = RexxVariablePool(&shv);            /* get the next variable */
      if (rc != 2)
        {
         sprintf((DEFCHAR *)temp_cmd,"i <%s> <%s> <%ld>",
             shv.shvname.strptr,shv.shvvalue.strptr,shv.shvvalue.strlength);
         command_line(temp_cmd,COMMAND_ONLY_FALSE);
        }
     }
   }
 else
   rc = command_line(temp_cmd,COMMAND_ONLY_FALSE);
 if (rc < 0)
    *Flags = RXSUBCOM_ERROR;             /* raise an error condition   */
 else
    *Flags = RXSUBCOM_OK;                /* not found is not an error  */

 sprintf((DEFCHAR *)Retstr->strptr, "%d", rc); /* format return code string  */
                                         /* and set the correct length */
 Retstr->strlength = strlen((DEFCHAR *)Retstr->strptr);
 return 0L;                              /* processing completed       */
}
/***********************************************************************/
REH_RETURN_TYPE THE_Exit_Handler
#if defined(HAVE_PROTO)
   (
   REH_ARG0_TYPE ExitNumber,    /* code defining the exit function    */
   REH_ARG1_TYPE Subfunction,   /* code defining the exit subfunction */
   REH_ARG2_TYPE ParmBlock      /* function dependent control block   */
   )
#else
   ( ExitNumber, Subfunction, ParmBlock )
   REH_ARG0_TYPE ExitNumber;    /* code defining the exit function    */
   REH_ARG1_TYPE Subfunction;   /* code defining the exit subfunction */
   REH_ARG2_TYPE ParmBlock;     /* function dependent control block   */
#endif
/***********************************************************************/
{
/*-------------------------- external data ----------------------------*/
#ifndef XCURSES
 extern WINDOW *statarea;
 extern bool batch_only;
#endif
#if !defined(MULTIPLE_PSEUDO_FILES)
 extern CHARTYPE rexx_filename[10];
 extern CHARTYPE rexx_pathname[MAX_FILE_NAME+1];
#endif
 extern LINETYPE CAPREXXMAXx;
 extern bool CAPREXXOUTx;
 extern bool rexx_output;
/*--------------------------- local data ------------------------------*/
 RXSIOTRC_PARM *trc_parm = (RXSIOTRC_PARM *)ParmBlock;
 LONG rc=0L;
 char rexxout_temp[60];
 VIEW_DETAILS *found_view=NULL;
/*--------------------------- processing ------------------------------*/
 if (Subfunction != RXSIOSAY   /* ignore all but RXSIOSAY and RXSIOTRC */
 &&  Subfunction != RXSIOTRC)
    return(RXEXIT_NOT_HANDLED);
/*---------------------------------------------------------------------*/
/* If this is the first time this exit handler is called, set up the   */
/* handling of the result; either open the capture file, or set the    */
/* terminal out of curses mode so scrolling etc. work.                 */
/*---------------------------------------------------------------------*/
 if (!rexx_output)
   {
    rexx_output = TRUE;
    if (CAPREXXOUTx)
      {
/*---------------------------------------------------------------------*/
/* Free up the existing linked list (if any)                           */
/*---------------------------------------------------------------------*/
#if !defined(MULTIPLE_PSEUDO_FILES)
       rexxout_first_line = rexxout_last_line = lll_free(rexxout_first_line);
       rexxout_number_lines = 0L;
       if ((found_view = find_file(rexx_pathname,rexx_filename)) != (VIEW_DETAILS *)NULL)
         {
          found_view->file_for_view->first_line = found_view->file_for_view->last_line = NULL;
          found_view->file_for_view->number_lines = 0L;
         }
#endif
/*---------------------------------------------------------------------*/
/* first_line is set to "Top of File"                                  */
/*---------------------------------------------------------------------*/
       if ((rexxout_first_line = add_line(rexxout_first_line,NULL,TOP_OF_FILE,
            strlen((DEFCHAR *)TOP_OF_FILE),0,FALSE)) == NULL)
          rc = RXEXIT_RAISE_ERROR;
/*---------------------------------------------------------------------*/
/* last line is set to "Bottom of File"                                */
/*---------------------------------------------------------------------*/
       if ((rexxout_last_line = add_line(rexxout_first_line,rexxout_first_line,BOTTOM_OF_FILE,
            strlen((DEFCHAR *)BOTTOM_OF_FILE),0,FALSE)) == NULL)
          rc = RXEXIT_RAISE_ERROR;
       rexxout_curr = rexxout_first_line;
       if (found_view != (VIEW_DETAILS *)NULL)
         {
          found_view->file_for_view->first_line = rexxout_first_line;
          found_view->file_for_view->last_line = rexxout_last_line;
         }
      }
#ifndef XCURSES
    else
      {
       if (!batch_only)
         {
          wmove(statarea,0,COLS-1);
          wrefresh(statarea);
          suspend_curses();
         }
       printf("\n");                       /* scroll the screen 1 line */
       fflush(stdout);
      }
#endif
   }
/*---------------------------------------------------------------------*/
/* If the REXX interpreter has been halted by line limit exceeded, just*/
/* return to the interpreter indicating that THE is hadnling the output*/
/* of messages. This is done to stop the "clutter" that comes back as  */
/* the interpreter tries to tell us that it is stopping.               */
/*---------------------------------------------------------------------*/
 if (rexx_halted)
    return(RXEXIT_HANDLED);
/*---------------------------------------------------------------------*/
/* If we are capturing the rexx output, print the string to the file.  */
/*---------------------------------------------------------------------*/
 if (CAPREXXOUTx)
   {
    rexxout_number_lines++;
    if ((rexxout_curr = add_line(rexxout_first_line,rexxout_curr,
                                 (CHARTYPE *)trc_parm->rxsio_string.strptr,
                                 (trc_parm->rxsio_string.strlength==(-1))?0:trc_parm->rxsio_string.strlength,0,FALSE)) == NULL)
       rc = RXEXIT_RAISE_ERROR;
    else
       rc = RXEXIT_HANDLED;
   }
 else
    rc = RXEXIT_NOT_HANDLED;
/*---------------------------------------------------------------------*/
/* If the number of lines processed exceeds the line limit, display our*/
/* own message telling what has happened and exit with                 */
/* RXEXIT_RAISE_ERROR. This tells the interpreter that it is to stop.  */
/*---------------------------------------------------------------------*/
 if (++captured_lines > CAPREXXMAXx)
   {
    if (CAPREXXOUTx)
      {
       rexxout_number_lines++;
       sprintf(rexxout_temp,"THE: REXX macro halted - line limit (%ld) exceeded",CAPREXXMAXx);
       rexxout_curr = add_line(rexxout_first_line,rexxout_curr,
                               (CHARTYPE *)rexxout_temp,
                               strlen((DEFCHAR *)rexxout_temp),0,FALSE);
      }
    else
       printf("THE: REXX macro halted - line limit (%ld) exceeded\n",CAPREXXMAXx);
    rc = RXEXIT_RAISE_ERROR;
    rexx_halted = TRUE;
   }
 return(rc);
}
/***********************************************************************/
RFH_RETURN_TYPE THE_Function_Handler
#if defined(HAVE_PROTO)
   (
   RFH_ARG0_TYPE FunctionName,  /* name of function */
   RFH_ARG1_TYPE Argc,          /* number of arguments    */
   RFH_ARG2_TYPE Argv,          /* array of arguments in RXSTRINGs */
   RFH_ARG3_TYPE QueueName,     /* name of queue */
   RFH_ARG4_TYPE Retstr         /* return string   */
   )
#else
   ( FunctionName, Argc, Argv, QueueName, Retstr )
   RFH_ARG0_TYPE FunctionName;  /* name of function */
   RFH_ARG1_TYPE Argc;          /* number of arguments    */
   RFH_ARG2_TYPE Argv;          /* array of arguments in RXSTRINGs */
   RFH_ARG3_TYPE QueueName;     /* name of queue */
   RFH_ARG4_TYPE Retstr;        /* return string   */
#endif

/***********************************************************************/
{
/*-------------------------- external data ----------------------------*/
 extern VALUE item_values[MAX_VARIABLES_RETURNED];
 extern CHARTYPE number_of_files;
/*--------------------------- local data ------------------------------*/
 register short i=0;
 int functionname_length = strlen((DEFCHAR*)FunctionName);
/*--------------------------- processing ------------------------------*/
/*---------------------------------------------------------------------*/
/* Find the external function name in the array. Error if not found.   */
/*---------------------------------------------------------------------*/
 for (i=0;function_item[i].name != NULL;i++)
   {
    if (memcmpi((CHARTYPE *)FunctionName,
                function_item[i].name,
                (int)function_item[i].name_length) == 0
    &&  (int)function_item[i].name_length == functionname_length)
      {
       switch(function_item[i].item_number)
         {
          case ITEM_VALID_TARGET_FUNCTION:
               if (number_of_files == 0)
                 {
                  display_error(83,(CHARTYPE *)"",FALSE);
                  return(1);
                 }
               valid_target_function(Argc,Argv);
               break;
          case ITEM_RUN_OS_FUNCTION:
               run_os_function(Argc,Argv);
               break;
          default:
               if (number_of_files == 0
               &&  function_item[i].level != LVL_GLOB)
                 {
                  display_error(83,(CHARTYPE *)"",FALSE);
                  return(1);
                 }
              if ((Argv == NULL) || (Argc == 0)) /* FGC */
                  (void)get_item_values(function_item[i].item_number,
                        (CHARTYPE *)"",QUERY_FUNCTION,(LINETYPE)Argc,NULL,0L);
               else
                  (void)get_item_values(function_item[i].item_number,
                        (CHARTYPE *)"",QUERY_FUNCTION,(LINETYPE)Argc,
                        (CHARTYPE *)Argv[0].strptr,(LINETYPE)Argv[0].strlength);
               break;
         }
       if (item_values[function_item[i].item_index].len > 256)
         {
          if ((Retstr->strptr = (RXSTRING_STRPTR_TYPE)(*the_malloc)(item_values[function_item[i].item_index].len)) == NULL)
            {
             display_error(30,(CHARTYPE *)"",FALSE);
             return(1);
            }
         }
       memcpy(Retstr->strptr,item_values[function_item[i].item_index].value,
                             item_values[function_item[i].item_index].len);
       Retstr->strlength = item_values[function_item[i].item_index].len;
       return(0);
      }
   }
 return(1);                                    /* fatal error for REXX */
}
/***********************************************************************/
short initialise_rexx
#if defined(HAVE_PROTO)
      (void)
#else
      ()
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 ULONG rc;
 register short i=0;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("rexx.c:    initialise_rexx");
#endif

#if defined(MSWIN)
 if (RexxThread(GetCurrentTask(),THREAD_ATTACH) != THREAD_ATTACH_AOK)
   {
#ifdef TRACE
    trace_return();
#endif
    return(RC_INVALID_ENVIRON);
   }
#endif

#ifdef TRACE
    trace_string("before Subcom\n");
#endif
#if defined(USE_REXX6000)
 rc = RexxRegisterSubcom((RRSE_ARG0_TYPE)"THE",
                         (RRSE_ARG1_TYPE)THE_Commands,
                         (RRSE_ARG2_TYPE)NULL);
#else
 rc = RexxRegisterSubcomExe((RRSE_ARG0_TYPE)"THE",
                            (RRSE_ARG1_TYPE)THE_Commands,
                            (RRSE_ARG2_TYPE)NULL);
#endif
 if (rc != RXSUBCOM_OK)
   {
#ifdef TRACE
    trace_return();
#endif
    return((short)rc);
   }
#ifdef TRACE
    trace_string("before exits\n");
#endif

#if !defined(USE_REXX6000)
 rc = RexxRegisterExitExe((RREE_ARG0_TYPE)"THE_EXIT",
                          (RREE_ARG1_TYPE)THE_Exit_Handler,
                          (RREE_ARG2_TYPE)NULL);
 if (rc != RXEXIT_OK)
   {
#ifdef TRACE
    trace_return();
#endif
    return((short)rc);
   }
#endif

 for (i=0;function_item[i].name != NULL;i++)
   {
#ifdef TRACE
    trace_string("before function: %d\n",i);
#endif
#if defined(USE_REXX6000)
    rc = RexxRegisterFunction((RRFE_ARG0_TYPE)function_item[i].name,
                              (RRFE_ARG1_TYPE)THE_Function_Handler,
                              NULL);
#else
    rc = RexxRegisterFunctionExe((RRFE_ARG0_TYPE)function_item[i].name,
                                 (RRFE_ARG1_TYPE)THE_Function_Handler);
#endif
    if (rc != RXFUNC_OK)
      {
#ifdef TRACE
       trace_return();
#endif
       return((short)rc);
      }
   }

#ifdef TRACE
    trace_constant("before returning\n");
#endif
#ifdef TRACE
 trace_return();
#endif
 return((short)rc);
}
/***********************************************************************/
short finalise_rexx
#if defined(HAVE_PROTO)
    (void)
#else
    ()
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 ULONG rc;
 register short i=0;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("rexx.c:    finalise_rexx");
#endif

#if defined(USE_REXX6000)
 rc = RexxDeregisterSubcom((RDS_ARG0_TYPE)"THE");
#else
 rc = RexxDeregisterSubcom((RDS_ARG0_TYPE)"THE",
                           (RDS_ARG1_TYPE)NULL);
 rc = RexxDeregisterExit((RDE_ARG0_TYPE)"THE_EXIT",
                         (RDE_ARG1_TYPE)NULL);
#endif
 for (i=0;function_item[i].name != NULL;i++)
   {
    rc = RexxDeregisterFunction((RDF_ARG0_TYPE)function_item[i].name);
   }

#if defined(MSWIN)
 (void)RexxThread(GetCurrentTask(),THREAD_DETACH);
#endif

#ifdef TRACE
 trace_return();
#endif
 return((short)rc);
}
/***********************************************************************/
short execute_macro_file
#if defined(HAVE_PROTO)
      (CHARTYPE *filename,CHARTYPE *params,short *macrorc)
#else
      (filename,params,macrorc)
       CHARTYPE *filename;
       CHARTYPE *params;
       short *macrorc;
#endif
/***********************************************************************/
{
/*-------------------------- external data ----------------------------*/
 extern bool batch_only;
 extern bool error_on_screen;
#ifndef XCURSES
 extern CHARTYPE number_of_files;
#endif
#if !defined(MULTIPLE_PSEUDO_FILES)
 extern CHARTYPE rexx_filename[10];
 extern CHARTYPE rexx_pathname[MAX_FILE_NAME+1];
#endif
 extern CHARTYPE rexx_macro_name[MAX_FILE_NAME+1];
 extern CHARTYPE rexx_macro_parameters[MAX_FILE_NAME+1];
 extern CHARTYPE *temp_cmd;
 extern bool CAPREXXOUTx;
 extern bool rexx_output;
/*--------------------------- local data ------------------------------*/
#if defined(USE_REXX6000)
 LONG rexxrc=0L;
#elif defined(__EMX__) || defined(USE_REGINA)
 SHORT rexxrc=0;
#else
 USHORT rexxrc=0L;
#endif
 RXSTRING retstr;
 RXSTRING argstr;
 ULONG rc=0;
 CHAR retbuf[260];
 LONG num_params=0L;
 CHARTYPE *rexx_args=NULL;
 RXSYSEXIT exit_list[2];                /* system exit list           */
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("rexx.c:    execute_macro_file");
#endif
/*---------------------------------------------------------------------*/
/* Determine how many parameters are to be passed to the interpreter.  */
/* Only 0 or 1 are valid values.                                       */
/*---------------------------------------------------------------------*/
 if (params == NULL
 || strcmp((DEFCHAR *)params,"") == 0)
   {
    num_params = 0;
    MAKERXSTRING(argstr,"",0);
    strcpy((DEFCHAR *)rexx_macro_parameters,"");
   }
 else
   {
    num_params = 1;
    if ((rexx_args = (CHARTYPE *)(*the_malloc)(strlen((DEFCHAR *)params)+1)) == (CHARTYPE *)NULL)
      {
       display_error(30,(CHARTYPE *)"",FALSE);
#ifdef TRACE
       trace_return();
#endif
       return(RC_OUT_OF_MEMORY);
      }
    strcpy((DEFCHAR *)rexx_macro_parameters,(DEFCHAR *)params);
    strcpy((DEFCHAR *)rexx_args,(DEFCHAR *)params);
    MAKERXSTRING(argstr,(DEFCHAR *)rexx_args,strlen((DEFCHAR *)rexx_args));
   }

 MAKERXSTRING(retstr,retbuf,sizeof(retbuf));

 strcpy((DEFCHAR *)rexx_macro_name,(DEFCHAR *)filename);
/*---------------------------------------------------------------------*/
/* Set up pointer to REXX Exit Handler.                                */
/*---------------------------------------------------------------------*/
#if defined(USE_REXX6000)
 exit_list[0].sysexit_func = THE_Exit_Handler;
#else
 exit_list[0].sysexit_name = "THE_EXIT";
#endif
 exit_list[0].sysexit_code = RXSIO;
 exit_list[1].sysexit_code = RXENDLST;

/*---------------------------------------------------------------------*/
/* Under OS/2 use of interactive trace in a macro only works if an OS  */
/* command has been run before executing the macro, so we run a REM    */
/*---------------------------------------------------------------------*/
#if defined(OS2) || defined(WIN32)
 execute_os_command((CHARTYPE*)"REM",TRUE,FALSE);
#endif
#ifdef UNIX
 execute_os_command((CHARTYPE*)"echo",TRUE,FALSE);
#endif

 captured_lines = 0L;
 rexx_output = FALSE;
 rexx_halted = FALSE;
/*---------------------------------------------------------------------*/
/* Call the REXX interpreter.                                          */
/*---------------------------------------------------------------------*/
 rc = RexxStart((RS_ARG0_TYPE)num_params,
                (RS_ARG1_TYPE)&argstr,
                (RS_ARG2_TYPE)filename,
                (RS_ARG3_TYPE)NULL,
                (RS_ARG4_TYPE)"THE",
                (RS_ARG5_TYPE)RXCOMMAND,
                (RS_ARG6_TYPE)exit_list,
                (RS_ARG7_TYPE)&rexxrc,
                (RS_ARG8_TYPE)&retstr);

/*---------------------------------------------------------------------*/
/* Edit the captured file or clean up after REXX output displays.      */
/*---------------------------------------------------------------------*/
 if (rexx_output)
   {
    rexx_output = FALSE;
    if (CAPREXXOUTx)
      {
#if defined(MULTIPLE_PSEUDO_FILES)
       Xedit((CHARTYPE *)"***REXXOUT***");
#else
       strcpy((DEFCHAR *)temp_cmd,(DEFCHAR *)rexx_pathname);
       strcat((DEFCHAR *)temp_cmd,(DEFCHAR *)rexx_filename);
       Xedit(temp_cmd);
#endif
      }
    else
      {
       if (batch_only)
          error_on_screen = TRUE;
#ifndef XCURSES
       else
/*---------------------------------------------------------------------*/
/* Pause for operator intervention and restore the screen to the       */
/* current screen if there are still file(s) in the ring.              */
/*---------------------------------------------------------------------*/
         {
          printf("\n%s",HIT_ANY_KEY);
          fflush(stdout);
          resume_curses();
          (void)my_getch(stdscr);
          if (number_of_files > 0)
            {
#if defined(HAVE_BROKEN_SYSVR4_CURSES)
             short x=0,y=0;
             getyx(CURRENT_WINDOW,y,x);
             force_curses_background();
             wmove(CURRENT_WINDOW,y,x);
             refresh();
#endif
             restore_THE();
            }
         }
#endif
      }
   }
#if defined(WIN32) && defined(HAVE_RESET_PROG_MODE)
 else
    reset_prog_mode();
#endif

 if (rexx_args != NULL)
    (*the_free)(rexx_args);
#ifdef TRACE
 trace_return();
#endif
 *macrorc = (short)rexxrc;
 return((short)rc);
}
/***********************************************************************/
short execute_macro_instore
#if defined(HAVE_PROTO)
      (CHARTYPE *commands,short *macrorc)
#else
      (commands, macrorc)
       CHARTYPE *commands;
       short *macrorc;
#endif
/***********************************************************************/
{
/*-------------------------- external data ----------------------------*/
 extern bool batch_only;
 extern bool error_on_screen;
#ifndef XCURSES
 extern CHARTYPE number_of_files;
#endif
#if !defined(MULTIPLE_PSEUDO_FILES)
 extern CHARTYPE rexx_filename[10];
 extern CHARTYPE rexx_pathname[MAX_FILE_NAME+1];
#endif
 extern CHARTYPE *temp_cmd;
 extern bool CAPREXXOUTx;
 extern bool rexx_output;
 extern bool in_macro;
/*--------------------------- local data ------------------------------*/
#if defined(__EMX__) || defined(USE_REGINA)
 SHORT rexxrc=0;
#elif defined(USE_REXX6000)
 LONG rexxrc=0L;
#else
 USHORT rexxrc=0L;
#endif
 RXSTRING instore[2];
 RXSTRING retstr;
 CHAR retbuf[260];
 ULONG rc=0;
 LONG num_params=0L;
 RXSYSEXIT exit_list[2];                /* system exit list           */
 bool save_in_macro=in_macro;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("rexx.c:    execute_macro_instore");
#endif
 in_macro = TRUE;
/*---------------------------------------------------------------------*/
/* Set up pointer to REXX Exit Handler.                                */
/*---------------------------------------------------------------------*/
#if defined(USE_REXX6000)
 exit_list[0].sysexit_func = THE_Exit_Handler;
#else
 exit_list[0].sysexit_name = "THE_EXIT";
#endif
 exit_list[0].sysexit_code = RXSIO;
 exit_list[1].sysexit_code = RXENDLST;

 captured_lines = 0L;
 rexx_output = FALSE;
 rexx_halted = FALSE;
 instore[0].strptr = (RXSTRING_STRPTR_TYPE)commands;
 instore[0].strlength = strlen((DEFCHAR *)commands);
 instore[1].strptr = NULL;
 instore[1].strlength = 0;
 MAKERXSTRING(retstr,retbuf,sizeof(retbuf));
/*---------------------------------------------------------------------*/
/* Call the REXX interpreter.                                          */
/*---------------------------------------------------------------------*/
 rc = RexxStart((RS_ARG0_TYPE)num_params,
                (RS_ARG1_TYPE)NULL,
                (RS_ARG2_TYPE)"INSTORE",
                (RS_ARG3_TYPE)instore,
                (RS_ARG4_TYPE)"THE",
                (RS_ARG5_TYPE)RXCOMMAND,
                (RS_ARG6_TYPE)exit_list,
                (RS_ARG7_TYPE)&rexxrc,
                (RS_ARG8_TYPE)&retstr);
 if (instore[1].strptr)
#if defined(WIN32) && (defined(USE_OREXX) || defined(USE_WINREXX) || defined(USE_QUERCUS))
    GlobalFree( instore[1].strptr );
#elif defined(USE_OS2REXX)
    DosFreeMem(instore[1].strptr);
#else
    (*the_free)(instore[1].strptr);
#endif
/*---------------------------------------------------------------------*/
/* Edit the captured file or clean up after REXX output displays.      */
/*---------------------------------------------------------------------*/
 if (rexx_output)
   {
    rexx_output = FALSE;
    if (CAPREXXOUTx)
      {
#if defined(MULTIPLE_PSEUDO_FILES)
       Xedit((CHARTYPE *)"***REXXOUT***");
#else
       strcpy((DEFCHAR *)temp_cmd,(DEFCHAR *)rexx_pathname);
       strcat((DEFCHAR *)temp_cmd,(DEFCHAR *)rexx_filename);
       Xedit(temp_cmd);
#endif
      }
    else
      {
       if (batch_only)
          error_on_screen = TRUE;
#ifndef XCURSES
       else
/*---------------------------------------------------------------------*/
/* Pause for operator intervention and restore the screen to the       */
/* current screen if there are still file(s) in the ring.              */
/*---------------------------------------------------------------------*/
         {
          printf("\n%s",HIT_ANY_KEY);
          fflush(stdout);
          resume_curses();
          (void)my_getch(stdscr);
          if (number_of_files > 0)
            {
#if defined(HAVE_BROKEN_SYSVR4_CURSES)
             short x=0,y=0;
             getyx(CURRENT_WINDOW,y,x);
             force_curses_background();
             wmove(CURRENT_WINDOW,y,x);
             refresh();
#endif
             restore_THE();
            }
         }
#endif
      }
   }
#if defined(WIN32) && defined(HAVE_RESET_PROG_MODE)
 else
    reset_prog_mode();
#endif
 in_macro = save_in_macro;
#ifdef TRACE
 trace_return();
#endif
 *macrorc = (short)rexxrc;
 return((short)rc);
}

/***********************************************************************/
short get_rexx_variable
#if defined(HAVE_PROTO)
      (CHARTYPE *name,CHARTYPE **value,int *value_length)
#else
      (name,value,value_length)
       CHARTYPE *name;
       CHARTYPE **value;
       int *value_length;
#endif
/***********************************************************************/
{
/*-------------------------- external data ----------------------------*/
/*--------------------------- local data ------------------------------*/
 RXSTRING retstr;
 short rc=RC_OK;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("rexx.c:    get_rexx_variable");
#endif
 MAKERXSTRING(retstr,"",0);
 (void)get_compound_rexx_variable(name,&retstr,(-1));
 if (retstr.strptr == NULL)
    rc = RC_INVALID_ENVIRON;
 *value = (CHARTYPE*)retstr.strptr;
 *value_length = retstr.strlength;
#ifdef TRACE
 trace_return();
#endif
 return(rc);
}

/***********************************************************************/
short set_rexx_variable
#if defined(HAVE_PROTO)
      (CHARTYPE *name,CHARTYPE *value,short value_length,short suffix)
#else
      (name,value,value_length,suffix)
       CHARTYPE *name;
       CHARTYPE *value;
       short value_length;
       short suffix;
#endif
/***********************************************************************/
{
/*-------------------------- external data ----------------------------*/
/*--------------------------- local data ------------------------------*/
 SHVBLOCK shv;
 CHAR variable_name[250];
 short rc=0;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("rexx.c:    set_rexx_variable");
#endif

 shv.shvnext=NULL;                                   /* only one block */
#if defined(USE_REGINA)
 shv.shvcode=RXSHV_SYSET; /* for Regina (no direct set) use symbolic set */
#else
 shv.shvcode=RXSHV_SET;               /* ... for others use direct set */
#endif
/*---------------------------------------------------------------------*/
/* This calls the RexxVariablePool() function for each value. This is  */
/* not the most efficient way of doing this.                           */
/*---------------------------------------------------------------------*/
 if (suffix == (-1))
    strcpy(variable_name,(DEFCHAR*)name);
 else
    sprintf(variable_name,"%s.%-d",name,suffix);
 (void)make_upper((CHARTYPE *)variable_name);/* make variable name uppercase */
/*---------------------------------------------------------------------*/
/* Now (attempt to) set the REXX variable                              */
/* Add name/value to SHVBLOCK                                          */
/*---------------------------------------------------------------------*/
 MAKERXSTRING(shv.shvname, variable_name, strlen(variable_name));
 MAKERXSTRING(shv.shvvalue,(DEFCHAR *)value,value_length);
/*---------------------------------------------------------------------*/
/* One or both of these is needed, too <sigh>                          */
/*---------------------------------------------------------------------*/
 shv.shvnamelen=strlen(variable_name);
 shv.shvvaluelen=value_length;

#if defined(USE_OS2REXX) || defined(USE_REXX6000)
 rc=(short)RexxVariablePool(&shv);              /* Set the REXX variable */
#else
 rc = RexxVariablePool(&shv);                 /* Set the REXX variable */
/* rc = RXSHV_OK;*/
#endif
 if (rc != RXSHV_OK 
 &&  rc != RXSHV_NEWV)
   {
    display_error(25,(CHARTYPE *)"",FALSE);
    rc = RC_SYSTEM_ERROR;
   }
 else
    rc = RC_OK;
#ifdef TRACE
 trace_return();
#endif
 return(rc);
}
/***********************************************************************/
static RXSTRING *get_compound_rexx_variable
#if defined(HAVE_PROTO)
      (CHARTYPE *name,RXSTRING *value,short suffix)
#else
      (name,value,suffix)
       CHARTYPE *name;
       RXSTRING *value;
       short suffix;
#endif
/***********************************************************************/
{
/*-------------------------- external data ----------------------------*/
/*--------------------------- local data ------------------------------*/
 static SHVBLOCK shv;
 CHAR variable_name[250];
 short rc=0;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("rexx.c:    get_compound_rexx_variable");
#endif
 shv.shvnext=NULL;                                   /* only one block */
#if defined(USE_REGINA)
 shv.shvcode=RXSHV_SYFET; /* for Regina (no direct set) use symbolic set */
#else
 shv.shvcode=RXSHV_FETCH;             /* ... for others use direct set */
#endif
/*---------------------------------------------------------------------*/
/* This calls the RexxVariablePool() function for each value. This is  */
/* not the most efficient way of doing this.                           */
/*---------------------------------------------------------------------*/
 if (suffix == (-1))
    strcpy(variable_name,(DEFCHAR*)name);
 else
    sprintf(variable_name,"%s.%-d",name,suffix);
 (void)make_upper((CHARTYPE *)variable_name);/* make variable name uppercase */
/*---------------------------------------------------------------------*/
/* Now (attempt to) get the REXX variable                              */
/* Set shv.shvvalue to NULL to force interpreter to allocate memory.   */
/*---------------------------------------------------------------------*/
 MAKERXSTRING(shv.shvname, variable_name, strlen(variable_name));
 shv.shvvalue.strptr = NULL;
 shv.shvvalue.strlength = 0;
/*---------------------------------------------------------------------*/
/* One or both of these is needed, too <sigh>                          */
/*---------------------------------------------------------------------*/
 shv.shvnamelen=strlen(variable_name);
 shv.shvvaluelen=0;
#if defined(USE_OS2REXX) || defined(USE_REXX6000)
 rc=(short)RexxVariablePool(&shv);              /* Set the REXX variable */
#else
 rc = RexxVariablePool(&shv);                 /* Set the REXX variable */
#endif
 switch(rc)
   {
    case RXSHV_OK:
#ifdef USE_REXX6000
         value->strptr = (PUCHAR)(*the_malloc)((sizeof(char)*shv.shvvalue.strlength)+1);
#else
         value->strptr = (char *)(*the_malloc)((sizeof(char)*shv.shvvalue.strlength)+1);
#endif
         if (value->strptr != NULL)
           {
            value->strlength = shv.shvvalue.strlength;
            memcpy(value->strptr,shv.shvvalue.strptr,value->strlength);
            *(value->strptr+value->strlength) = '\0';
           }
#if defined(WIN32) && (defined(USE_OREXX) || defined(USE_WINREXX) || defined(USE_QUERCUS))
         GlobalFree( shv.shvvalue.strptr );
#elif defined(USE_OS2REXX)
         DosFreeMem( shv.shvvalue.strptr );
#else
         free( shv.shvvalue.strptr );
#endif
         break;
   case RXSHV_NEWV:
#ifdef USE_REXX6000
         value->strptr = (PUCHAR)(*the_malloc)((sizeof(char)*shv.shvname.strlength)+1);
#else
         value->strptr = (char *)(*the_malloc)((sizeof(char)*shv.shvname.strlength)+1);
#endif
         if (value->strptr != NULL)
           {
            value->strlength = shv.shvname.strlength;
            memcpy(value->strptr,shv.shvname.strptr,value->strlength);
            *(value->strptr+value->strlength) = '\0';
           }
         break;
   default:
         value->strptr = NULL;
         value->strlength = 0;
         break;
   }
#ifdef TRACE
 trace_return();
#endif
 return(value);
}
/***********************************************************************/
static short valid_target_function
#if defined(HAVE_PROTO)
      (ULONG Argc,RXSTRING Argv[])
#else
     (Argc,Argv)
      ULONG Argc;
      RXSTRING Argv[];
#endif
/***********************************************************************/
{
/*-------------------------- external data ----------------------------*/
 extern bool in_prefix_macro;
 extern LINETYPE prefix_current_line;
 extern VALUE item_values[MAX_VARIABLES_RETURNED];
 extern CHARTYPE *target_buffer;
 extern short target_buffer_len;
/*--------------------------- local data ------------------------------*/
 static TARGET target={NULL,0L,0L,0L,NULL,0,0,FALSE};
 short target_type=TARGET_NORMAL|TARGET_BLOCK_CURRENT|TARGET_ALL;
 LINETYPE true_line=0L;
 short rc=0;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("rexx.c:    valid_target_function");
#endif
 switch(1)
   {
    case 1:
         if (Argc < 1 || Argc > 2)  /* incorrect no of arguments - error */
           {
            item_values[1].value = (CHARTYPE *)"ERROR";
            item_values[1].len = 5;
            break;
           }
         if (Argc == 2)
            target_type = target_type | TARGET_SPARE;
/* allocate sufficient space for the spare string and 2 longs */
         if (target_buffer == NULL)
           {
            target_buffer = (CHARTYPE *)(*the_malloc)(sizeof(CHARTYPE)*(Argv[0].strlength+30));
            target_buffer_len = Argv[0].strlength+30;
           }
         else
           {
            if (target_buffer_len < Argv[0].strlength+30)
              {
               target_buffer = (CHARTYPE *)(*the_realloc)(target_buffer,sizeof(CHARTYPE)*(Argv[0].strlength+30));
               target_buffer_len = Argv[0].strlength+30;
              }
           }
         if (target_buffer == (CHARTYPE *)NULL)
           {
            item_values[1].value = (CHARTYPE *)"ERROR";
            item_values[1].len = 5;
            free_target(&target);
            break;
           }
         memcpy(target_buffer,Argv[0].strptr,Argv[0].strlength);
         *(target_buffer+Argv[0].strlength) = '\0';
         if (in_prefix_macro)
            true_line = prefix_current_line;
         else
            true_line = get_true_line(TRUE);

         initialise_target(&target);
         rc = validate_target(target_buffer,&target,target_type,true_line,FALSE,FALSE);
         if (rc == RC_TARGET_NOT_FOUND)
           {
            item_values[1].value = (CHARTYPE *)"NOTFOUND";
            item_values[1].len = 8;
            free_target(&target);
            break;
           }
         if (rc != RC_OK)
           {
            item_values[1].value = (CHARTYPE *)"ERROR";
            item_values[1].len = 5;
            free_target(&target);
            break;
           }
         if (Argc == 2
         &&  target.spare != (-1))
            sprintf((DEFCHAR *)target_buffer,"%ld %ld %s",target.true_line,target.num_lines,
                                        target.rt[target.spare].string);
         else
             sprintf((DEFCHAR *)target_buffer,"%ld %ld",target.true_line,target.num_lines);
         item_values[1].value = target_buffer;
         item_values[1].len = strlen((DEFCHAR *)target_buffer);
         free_target(&target);
         break;
   }
 item_values[0].value = (CHARTYPE *)"1";
 item_values[0].len = 1;
#ifdef TRACE
 trace_return();
#endif
 return(rc);
}
/***********************************************************************/
static short run_os_function
#if defined(HAVE_PROTO)
      (ULONG Argc,RXSTRING Argv[])
#else
     (Argc,Argv)
      ULONG Argc;
      RXSTRING Argv[];
#endif
/***********************************************************************/
{
/*-------------------------- external data ----------------------------*/
 extern VALUE item_values[MAX_VARIABLES_RETURNED];
/*--------------------------- local data ------------------------------*/
 int rc=0;
 static CHARTYPE num0[5];                  /* large enough for 1000+rc */
 CHARTYPE *cmd=NULL,*instem=NULL,*outstem=NULL,*errstem=NULL;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("rexx.c:    run_os_function");
#endif
 switch(Argc)
   {
    case 0:
         sprintf((DEFCHAR *)num0,"%d",RC_INVALID_OPERAND+1000);
         break;
    case 4:
         if ((errstem = (CHARTYPE *)MakeAscii(&Argv[3])) == NULL)
           {
            sprintf((DEFCHAR *)num0,"%d",RC_OUT_OF_MEMORY+1000);
            break;
           }
    case 3:
         if ((outstem = (CHARTYPE *)MakeAscii(&Argv[2])) == NULL)
           {
            sprintf((DEFCHAR *)num0,"%d",RC_OUT_OF_MEMORY+1000);
            break;
           }
    case 2:
         if ((instem = (CHARTYPE *)MakeAscii(&Argv[1])) == NULL)
           {
            sprintf((DEFCHAR *)num0,"%d",RC_OUT_OF_MEMORY+1000);
            break;
           }
    case 1:
         if ((cmd = (CHARTYPE *)MakeAscii(&Argv[0])) == NULL)
           {
            sprintf((DEFCHAR *)num0,"%d",RC_OUT_OF_MEMORY+1000);
            break;
           }
         rc = run_os_command(cmd,instem,outstem,errstem);
         sprintf((DEFCHAR *)num0,"%d",rc);
         break;
    default:
         sprintf((DEFCHAR *)num0,"%d",RC_INVALID_OPERAND+1000);
         break;
   }
 item_values[1].value = num0;
 item_values[1].len = strlen((DEFCHAR *)num0);
 item_values[0].value = (CHARTYPE *)"1";
 item_values[0].len = 1;
 if (cmd) (*the_free)(cmd);
 if (instem) (*the_free)(instem);
 if (outstem) (*the_free)(outstem);
 if (errstem) (*the_free)(errstem);
#ifdef TRACE
 trace_return();
#endif
 return(RC_OK);
}
/***********************************************************************/
static int run_os_command
#if defined(HAVE_PROTO)
      (CHARTYPE *cmd,CHARTYPE *instem,CHARTYPE *outstem,CHARTYPE *errstem)
#else
      (cmd,instem,outstem,errstem)
       CHARTYPE *cmd;
       CHARTYPE *instem;
       CHARTYPE *outstem;
       CHARTYPE *errstem;
#endif
/***********************************************************************/
{
/*-------------------------- external data ----------------------------*/
/*--------------------------- local data ------------------------------*/
 RXSTRING tmpstr;
 bool in=TRUE,out=TRUE,err=TRUE;
 bool out_and_err_same=FALSE;
 int inlen=0,outlen=0,errlen=0;
 int i=0;
 FILE *infp=NULL;
 char *infile="",*outfile="",*errfile="";
 long innum=0L;
 int rc=0,rcode=0;
 int save_stdin=0,save_stdout=0,save_stderr=0;
 int infd=0,outfd=0,errfd=0;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("rexx.c:    run_os_command");
#endif
/*---------------------------------------------------------------------*/
/* Determine if we are redirecting stdin, stdout or both and if the    */
/* values passed as stem variables end in '.'.                         */
/*---------------------------------------------------------------------*/
 if (instem == NULL
 ||  strcmp((DEFCHAR *)instem,"") == 0)
    in = FALSE;
 else
   {
    inlen = strlen((DEFCHAR *)instem);
    if (*(instem+inlen-1) == '.')
       *(instem+inlen-1) = '\0';
    else
      {
#ifdef TRACE
       trace_return();
#endif
       return(RC_INVALID_OPERAND+1000);
      }
   }
 if (outstem == NULL
 ||  strcmp((DEFCHAR *)outstem,"") == 0)
    out = FALSE;
 else
   {
    outlen = strlen((DEFCHAR *)outstem);
    if (*(outstem+outlen-1) == '.')
       *(outstem+outlen-1) = '\0';
    else
      {
#ifdef TRACE
       trace_return();
#endif
       return(RC_INVALID_OPERAND+1000);
      }
   }
 if (errstem == NULL
 ||  strcmp((DEFCHAR *)errstem,"") == 0)
    err = FALSE;
 else
   {
    errlen = strlen((DEFCHAR *)errstem);
    if (*(errstem+errlen-1) == '.')
       *(errstem+errlen-1) = '\0';
    else
      {
#ifdef TRACE
       trace_return();
#endif
       return(RC_INVALID_OPERAND+1000);
      }
   }
/*---------------------------------------------------------------------*/
/* Ensure that stdin stem is different to both stdout and stderr stems.*/
/*---------------------------------------------------------------------*/
 if (in)
   {
    if (out
    &&  strcmp((DEFCHAR *)instem,(DEFCHAR *)outstem) == 0)
      {
#ifdef TRACE
       trace_return();
#endif
       return(RC_INVALID_OPERAND+1000);
      }
    if (err
    &&  strcmp((DEFCHAR *)instem,(DEFCHAR *)errstem) == 0)
      {
#ifdef TRACE
       trace_return();
#endif
       return(RC_INVALID_OPERAND+1000);
      }
   }
/*---------------------------------------------------------------------*/
/* An extra check here to determine if stdout and stderr are to be     */
/* redirected to the same place.                                       */
/*---------------------------------------------------------------------*/
 if (out && err)
   {
    if (strcmp((DEFCHAR *)outstem,(DEFCHAR *)errstem)==0)
       out_and_err_same = TRUE;
   }
/*---------------------------------------------------------------------*/
/* If redirecting stdin, get the value of instem.0 to determine how    */
/* many variables to get...                                            */
/*---------------------------------------------------------------------*/
 if (in)
   {
    tmpstr.strptr = NULL;
    (void)get_compound_rexx_variable(instem,&tmpstr,0);
    if (tmpstr.strptr == NULL)
      {
#ifdef TRACE
       trace_return();
#endif
       return(RC_SYSTEM_ERROR+1000);
      }
    if (!valid_positive_integer((CHARTYPE *)tmpstr.strptr))
      {
#ifdef TRACE
       trace_return();
#endif
       return(RC_INVALID_OPERAND+1000);
      }
    innum = atol((DEFCHAR *)tmpstr.strptr);
    (*the_free)(tmpstr.strptr);
/*---------------------------------------------------------------------*/
/* Write the contents of the stdin stem to a temporary file...         */
/*---------------------------------------------------------------------*/
    infile = (char *)(*the_malloc)(L_tmpnam);
    if (infile == NULL)
      {
#ifdef TRACE
       trace_return();
#endif
       return(RC_OUT_OF_MEMORY+1000);
      }
    if ((infile = tmpnam(infile)) == NULL)
      {
#ifdef TRACE
       trace_return();
#endif
       return(RC_ACCESS_DENIED+1000);
      }
#if defined(GO32) || defined(__EMX__)
/*---------------------------------------------------------------------*/
/* For djgpp and emx convert all \ to / for internal file handling     */
/* functions.                                                          */
/*---------------------------------------------------------------------*/
    strrmdup(strtrans(infile,'\\','/'),'/');
#endif
    if ((infp = fopen(infile,"w")) == NULL)
      {
#ifdef TRACE
       trace_return();
#endif
       return(RC_ACCESS_DENIED+1000);
      }
    for (i=0;i<innum;i++)
      {
       tmpstr.strptr = NULL;
       (void)get_compound_rexx_variable(instem,&tmpstr,i+1);
       if (tmpstr.strptr == NULL)
         {
#ifdef TRACE
          trace_return();
#endif
          return(RC_SYSTEM_ERROR+1000);
         }
       fputs((DEFCHAR *)tmpstr.strptr,infp);
       fputs("\n",infp);
       (*the_free)(tmpstr.strptr);
      }
    if (fclose(infp))
      {
#ifdef TRACE
       trace_return();
#endif
       return(RC_ACCESS_DENIED+1000);
      }
   }
/*---------------------------------------------------------------------*/
/* If redirecting stdout, create the name of a temporary file for the  */
/* output.                                                             */
/*---------------------------------------------------------------------*/
 if (out)
   {
    outfile = (char *)(*the_malloc)(L_tmpnam);
    if (outfile == NULL)
      {
#ifdef TRACE
       trace_return();
#endif
       return(RC_OUT_OF_MEMORY+1000);
      }
    if ((outfile = tmpnam(outfile)) == NULL)
      {
#ifdef TRACE
       trace_return();
#endif
       return(RC_ACCESS_DENIED+1000);
      }
   }
/*---------------------------------------------------------------------*/
/* If redirecting stderr, create the name of a temporary file for the  */
/* output.                                                             */
/*---------------------------------------------------------------------*/
 if (err)
   {
    if (out_and_err_same)
      {
       errfile = outfile;
      }
    else
      {
       errfile = (char *)(*the_malloc)(L_tmpnam);
       if (errfile == NULL)
         {
#ifdef TRACE
          trace_return();
#endif
          return(RC_OUT_OF_MEMORY+1000);
         }
       if ((errfile = tmpnam(errfile)) == NULL)
         {
#ifdef TRACE
          trace_return();
#endif
          return(RC_ACCESS_DENIED+1000);
         }
      }
   }
/*---------------------------------------------------------------------*/
/* Save file ids for stdin, stdout and stderr, then reassign them to   */
/* the appropriate temporary files.                                    */
/*---------------------------------------------------------------------*/
 if (in) save_stdin = dup(fileno(stdin));
 if (out) save_stdout = dup(fileno(stdout));
 if (err) save_stderr = dup(fileno(stderr));
 if (in)
   {
    if ((infd = open(infile,O_RDONLY)) == (-1))
      {
#ifdef TRACE
       trace_return();
#endif
       return(RC_ACCESS_DENIED+1000);
      }
   }
 if (out)
   {
#if defined(UNIX)
    if ((outfd = open(outfile,O_RDWR|O_CREAT|O_TRUNC)) == (-1))
#else
    if ((outfd = open(outfile,O_RDWR|O_CREAT|O_TRUNC,S_IWRITE|S_IREAD)) == (-1))
#endif
      {
#ifdef TRACE
       trace_return();
#endif
       return(RC_ACCESS_DENIED+1000);
      }
   }
 if (out_and_err_same)
    errfd = outfd;
 else
   {
    if (err)
      {
#if defined(UNIX)
       if ((errfd = open(errfile,O_RDWR|O_CREAT|O_TRUNC)) == (-1))
#else
       if ((errfd = open(errfile,O_RDWR|O_CREAT|O_TRUNC,S_IWRITE|S_IREAD)) == (-1))
#endif
         {
#ifdef TRACE
          trace_return();
#endif
          return(RC_ACCESS_DENIED+1000);
         }
      }
   }
#if defined(UNIX)
  if (out)
     chmod(outfile,S_IWUSR|S_IRUSR);
  if (!out_and_err_same)
     if (err)
        chmod(errfile,S_IWUSR|S_IRUSR);
#endif
 if (in)  dup2(infd,fileno(stdin));
 if (out) dup2(outfd,fileno(stdout));
 if (err) dup2(errfd,fileno(stderr));
 if (in)  close(infd);
 if (out) close(outfd);
 if (!out_and_err_same)
    if (err) close(errfd);
/*---------------------------------------------------------------------*/
/* Execute the OS command supplied.                                    */
/*---------------------------------------------------------------------*/
 rcode = system((DEFCHAR *)cmd);
#if defined(HAVE_SYS_WAIT_H)
 if (rcode) rcode = WEXITSTATUS(rcode);
#endif
/*---------------------------------------------------------------------*/
/* Put all file ids back the way they were...                          */
/*---------------------------------------------------------------------*/
 if (in)  dup2(save_stdin,fileno(stdin));
 if (out) dup2(save_stdout,fileno(stdout));
 if (err) dup2(save_stderr,fileno(stderr));
 if (in)  close(save_stdin);
 if (out) close(save_stdout);
 if (err) close(save_stderr);
/*---------------------------------------------------------------------*/
/* If redirecting stdout, we now have to read the file and set a REXX  */
/* variable for each line read.                                        */
/*---------------------------------------------------------------------*/
 if (out)
    rc = set_rexx_variables_from_file(outfile,outstem);
 if (err)
   {
    if (!out_and_err_same)
       rc = set_rexx_variables_from_file(errfile,errstem);
   }
/*---------------------------------------------------------------------*/
/* Delete the temporary file(s) and free up any memory.                */
/*---------------------------------------------------------------------*/
 if (in)
   {
    unlink(infile);
    (*the_free)(infile);
   }
 if (out)
   {
    unlink(outfile);
    (*the_free)(outfile);
   }
 if (err)
   {
    if (!out_and_err_same)
      {
       unlink(errfile);
       (*the_free)(errfile);
      }
   }
/*---------------------------------------------------------------------*/
/* Return with, hopefully, return code from system() command.          */
/*---------------------------------------------------------------------*/
#ifdef TRACE
 trace_return();
#endif
 if (rc)
    return(rc+1000);
 else
    return(rcode);
}
/***********************************************************************/
static CHARTYPE *MakeAscii
#if defined(HAVE_PROTO)
      (RXSTRING *rxstring)
#else
     (rxstring)
      RXSTRING *rxstring;
#endif
/***********************************************************************/
{
/*-------------------------- external data ----------------------------*/
/*--------------------------- local data ------------------------------*/
 CHARTYPE *string=NULL;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("rexx.c:    MakeAscii");
#endif

 string = (CHARTYPE *)(*the_malloc)((sizeof(CHARTYPE)*rxstring->strlength)+1);
 if (string != NULL)
   {
    memcpy(string,rxstring->strptr,rxstring->strlength);
    *(string+(rxstring->strlength)) = '\0';
   }
#ifdef TRACE
 trace_return();
#endif
 return(string);
}
/***********************************************************************/
static char *get_a_line
#if defined(HAVE_PROTO)
      (FILE *fp,char *string,int *length,int *rcode)
#else
      (fp,string,length,rcode)
      FILE *fp;
      char *string;
      int *length;
      int *rcode;
#endif
/***********************************************************************/
{
 int ch;
 static int bufs = 1;
 register int i=0;
/*---------------------------------------------------------------------*/
/* Allocate the first block of memory.                                 */
/*---------------------------------------------------------------------*/
 if ((string = (char *)(*the_malloc)(BUF_SIZE+1)) == NULL)
   {
    *rcode = RC_OUT_OF_MEMORY;
    return(NULL);
   }
 while(1)
   {
/*---------------------------------------------------------------------*/
/* Read a character from the stream...                                 */
/*---------------------------------------------------------------------*/
    if ((ch = fgetc(fp)) == EOF)
      {
/*---------------------------------------------------------------------*/
/* If EOF is reached, check that it really is end of file.             */
/*---------------------------------------------------------------------*/
       if (feof(fp))
         {
          *length = i;
          *rcode = RC_TOF_EOF_REACHED;
          return(string);
         }
      }
/*---------------------------------------------------------------------*/
/* If end of line is reached, nul terminate string and return.         */
/*---------------------------------------------------------------------*/
    if ((char)ch == '\n')
      {
       *(string+i) = '\0';
       break;
      }
/*---------------------------------------------------------------------*/
/* All other characters, copy to string.                               */
/*---------------------------------------------------------------------*/
    *(string+i++) = (char)ch;
/*---------------------------------------------------------------------*/
/* If we have got to the end of the allocated memory, realloc some more*/
/*---------------------------------------------------------------------*/
    if (i == BUF_SIZE*bufs)
      {
       if ((string = (char *)realloc(string,(BUF_SIZE*(++bufs))+1)) == NULL)
         {
          *rcode = RC_OUT_OF_MEMORY;
          return(NULL);
         }
      }
   }
/*---------------------------------------------------------------------*/
/* Return a line read from the temporary file.                         */
/*---------------------------------------------------------------------*/
 *length = i;
 *rcode = 0;
 return(string);
}
/***********************************************************************/
static short set_rexx_variables_from_file
#if defined(HAVE_PROTO)
      (char *filename,CHARTYPE *stem)
#else
      (filename,stem)
       char *filename;
       CHARTYPE *stem;
#endif
/***********************************************************************/
{
/*-------------------------- external data ----------------------------*/
/*--------------------------- local data ------------------------------*/
 FILE *fp=NULL;
 register int i=0;
 char *string=NULL;
 int length=0,rcode=0,rc=0;
 char tmpnum[10];
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("rexx.c:    set_rexx_variables_from_file");
#endif
 if ((fp = fopen(filename,"r")) == NULL)
   {
#ifdef TRACE
    trace_return();
#endif
    return(RC_ACCESS_DENIED);
   }
 for (i=0;;i++)
   {
    string = get_a_line(fp,string,&length,&rcode);
    if (rcode == RC_OUT_OF_MEMORY)
      {
#ifdef TRACE
       trace_return();
#endif
       return(rcode);
      }
    if (rcode == RC_TOF_EOF_REACHED
    && length == 0)
      {
       (*the_free)(string);
       break;
      }
    rc = set_rexx_variable(stem,(CHARTYPE *)string,strlen(string),i+1);
    (*the_free)(string);
    if (rcode == RC_TOF_EOF_REACHED)
       break;
   }
 sprintf(tmpnum,"%d",i);
 rc = set_rexx_variable(stem,(CHARTYPE *)tmpnum,strlen(tmpnum),0);
 if (fclose(fp))
    rc = RC_ACCESS_DENIED;
#ifdef TRACE
 trace_return();
#endif
 return(rc);
}
#else
/*---------------------------------------------------------------------*/
/* The following are dummy routines to enable the compliation of THE   */
/* with a nonANSI compiler.                                            */
/*---------------------------------------------------------------------*/
/***********************************************************************/
short initialise_rexx
#if defined(HAVE_PROTO)
      (void)
#else
      ()
#endif
/***********************************************************************/
{
 return(RC_INVALID_ENVIRON);                        /* force an error */
}
/***********************************************************************/
short finalise_rexx
#if defined(HAVE_PROTO)
      (void)
#else
      ()
#endif
/***********************************************************************/
{
 return(RC_OK);
}
/***********************************************************************/
short execute_macro_file
#if defined(HAVE_PROTO)
      (CHARTYPE *filename,CHARTYPE *params,short *macrorc)
#else
      (filename,params,macrorc)
      CHARTYPE *filename;
      CHARTYPE *params;
      short *macrorc;
#endif
/***********************************************************************/
{
 return(RC_OK);
}
/***********************************************************************/
short execute_macro_instore
#if defined(HAVE_PROTO)
      (CHARTYPE *commands,short *macrorc)
#else
      (commands,macrorc)
      CHARTYPE *commands;
      short *macrorc;
#endif
/***********************************************************************/
{
 return(RC_OK);
}
/***********************************************************************/
short set_rexx_variable
#if defined(HAVE_PROTO)
      (CHARTYPE *name,CHARTYPE *value,short value_length,short suffix)
#else
      (name,value,value_length,suffix)
      CHARTYPE *name;
      CHARTYPE *value;
      short value_length;
      short suffix;
#endif
/***********************************************************************/
{
 return(RC_OK);
}

/***********************************************************************/
short get_rexx_variable
#if defined(HAVE_PROTO)
      (CHARTYPE *name,CHARTYPE **value,int *value_length)
#else
      (name,value,value_length)
       CHARTYPE *name;
       CHARTYPE **value;
       int *value_length;
#endif
/***********************************************************************/
{
 return(RC_OK);
}
#endif
