#include "header.h"

implementActionCallback(TestMenu)

TestMenu::TestMenu(Glyph* screen_) {
        my_glyph = screen_;
        menuwindow = nil;
}

PolyGlyph* TestMenu::compose(WidgetKit &kit) {
        const LayoutKit& layout = *LayoutKit::instance();
        Menu *m = CreateMenu(kit);
        return layout.vbox(m, kit.inset_frame(
               layout.margin(my_glyph, 10.0) )
                          );
}

Menu* TestMenu::CreateMenu(WidgetKit& kit) {
       Menu *file = kit.pulldown();
         MenuItem* m1 = kit.menu_item(
                        kit.fancy_label("Copyright") );
               Action *copyright = new ActionCallback(TestMenu)
                                    (this,&TestMenu::copyright);
               m1->action(copyright);
         MenuItem* m2 = kit.menu_item(
                        kit.fancy_label("Quit") );
               Action *quit = new ActionCallback(TestMenu)
                                    (this,&TestMenu::quit);
               m2->action(quit);
         file->append_item(m1);
         file->append_item(m2);

       Menu *options = kit.pulldown();
         MenuItem* m3 = kit.menu_item(
                        kit.fancy_label("Preferences") );
         Action *preferences = new ActionCallback(TestMenu)
                              (this,&TestMenu::preferences);
               m3->action(preferences);
         MenuItem* m4 = kit.menu_item(
                        kit.fancy_label("DialogBox") );
         Action *dialogbox = new ActionCallback(TestMenu)
                         (this,&TestMenu::call_dialogbox);
               m4->action(dialogbox);
        options->append_item(m3);
        options->append_item(m4);

        Menu *mb = kit.menubar();
          MenuItem *mb1 = kit.menubar_item(
                          kit.fancy_label("File") );
               mb1->menu(file);
          MenuItem *mb2 = kit.menubar_item(
                          kit.fancy_label("Options") );
               mb2->menu(options);
               mb->append_item(mb1);
               mb->append_item(mb2);
        return mb;
}

void TestMenu::set_window(ApplicationWindow *aw) {
        menuwindow = aw;
}

void TestMenu::copyright() {
        cerr<<"TestMenu::copyright called\n";
}

void TestMenu::preferences() {
        cerr<<"TestMenu::preferences called\n";
}

void TestMenu::quit() {
        Session::instance()->quit();
}

void TestMenu::call_dialogbox() {
        WidgetKit& kit = *WidgetKit::instance();
        MyDialog *MD = new MyDialog(kit.style(), this);
        MD->post_for(menuwindow);
}

void TestMenu::delete_dialogbox(const char* text) {
        cerr<<"you entered: "<<text<<"\n";
}

