
/* parser.dlg -- DLG Description of scanner
 *
 * Generated from: sor.g
 *
 * Terence Parr, Will Cohen, and Hank Dietz: 1989-1994
 * Purdue University Electrical Engineering
 * With AHPCRC, University of Minnesota
 * ANTLR Version 1.32
 */

#include <stdio.h>
#define ANTLR_VERSION	132

#define ZZLEXBUFSIZE	8000
#include "charbuf.h"
#include "hash.h"
#include "set.h"
#include "sor.h"
#define AST_FIELDS	\
int token; char text[MaxAtom+1], label[MaxRuleName+1]; \
char *action;		/* if action node, here is ptr to it */ \
char in,out; \
char init_action;	/* set if Action and 1st action of alt */ \
int file; int line; /* set for BLOCK, ALT, nonterm nodes */ \
int upper_range;	/* only if T1..T2 found */	\
GLA *start_state;	/* ptr into GLA for this block */ \
int no_copy;		/* copy input ptr to output ptr? */ \
ListNode *refvars;	/* any ref vars defined for this rule */ \
unsigned char is_root; /* this token is a root #( A ... ) */
#define zzcr_ast(node, cur, _tok, _text)	\
{(node)->token=_tok; strncpy((node)->text, _text,MaxAtom);}
#define USER_ZZSYN
#define zzAST_DOUBLE
extern int define_num;
#define LL_K 2
#include "antlr.h"
#include "ast.h"
#include "tokens.h"
#include "dlgdef.h"
LOOKAHEAD
void zzerraction()
{
	(*zzerr)("invalid token");
	zzadvance();
	zzskip();
}
/*
 * D L G tables
 *
 * Generated from: parser.dlg
 *
 * 1989-1998 by  Will Cohen, Terence Parr, and Hank Dietz
 * Purdue University Electrical Engineering
 * DLG Version 1.33MR12b
 */

#include "mode.h"




#include "sym.h"
#include "proto.h"

int define_num = 0;

char *
scarf_to_end_of_func_call()
{
	static char func_call_str[MaxAtom+1];
	char *p;
	
	p = &func_call_str[0];
	
more:
	if ( zzchar==')' ) { *p++ = zzchar; *p++ = '\0'; zzadvance(); return func_call_str; }
	if ( zzchar=='"' )
	{
		*p++ = zzchar; zzadvance();
		while ( zzchar!='"' )
		{
			if ( zzchar=='\\' ) { *p++ = zzchar; zzadvance(); }
			*p++ = zzchar; zzadvance();
		}
	}
	*p++ = zzchar; zzadvance();
	goto more;
}

static void act1()
{ 
		NLA = Eof;
		/* L o o k  F o r  A n o t h e r  F i l e */
		{
			FILE *new_input;
			new_input = NextFile();
			if ( new_input != NULL ) {
				fclose( input );
				input = new_input;
				zzrdstream( input );
				/*zzadvance();	/* Get 1st char of this file */
				zzskip();	/* Skip the Eof (@) char i.e continue */
			}
		}
	}


static void act2()
{ 
		NLA = 56;
		zzskip();   
	}


static void act3()
{ 
		NLA = 57;
		zzline++; zzskip();   
	}


static void act4()
{ 
		NLA = 58;
		zzmode(ACTIONS); zzmore();
		istackreset();
		pushint(']');   
	}


static void act5()
{ 
		NLA = 59;
		action_file=CurFile; action_line=zzline;
		zzmode(ACTIONS); zzmore();
		istackreset();
		pushint('>');   
	}


static void act6()
{ 
		NLA = 60;
		zzmode(STRINGS); zzmore();   
	}


static void act7()
{ 
		NLA = 61;
		zzmode(COMMENTS); zzskip();   
	}


static void act8()
{ 
		NLA = 62;
		err("Missing /*; found dangling */"); zzskip();   
	}


static void act9()
{ 
		NLA = 63;
		zzmode(CPP_COMMENTS); zzskip();   
	}


static void act10()
{ 
		NLA = 64;
		err("Missing <<; found dangling \>\>"); zzskip();   
	}


static void act11()
{ 
		NLA = Header;
	}


static void act12()
{ 
		NLA = Tokdef;
	}


static void act13()
{ 
		NLA = LABEL;
	}


static void act14()
{ 
		NLA = OPT;
	}


static void act15()
{ 
		NLA = POS_CLOSURE;
	}


static void act16()
{ 
		NLA = CLOSURE;
	}


static void act17()
{ 
		NLA = WILD;
	}


static void act18()
{ 
		NLA = PRED_OP;
	}


static void act19()
{ 
		NLA = BT;
	}


static void act20()
{ 
		NLA = 80;
	}


static void act21()
{ 
		NLA = 81;
	}


static void act22()
{ 
		NLA = 84;
	}


static void act23()
{ 
		NLA = 85;
	}


static void act24()
{ 
		NLA = 86;
	}


static void act25()
{ 
		NLA = 87;
	}


static void act26()
{ 
		NLA = 88;
	}


static void act27()
{ 
		NLA = 89;
	}


static void act28()
{ 
		NLA = 90;
	}


static void act29()
{ 
		NLA = 91;
	}


static void act30()
{ 
		NLA = NonTerm;
	}


static void act31()
{ 
		NLA = Token;
	}


static void act32()
{ 
		NLA = 92;
		warn(eMsg1("unknown meta-op: %s",LATEXT(1))); zzskip();   
	}

static unsigned char shift0[257] = {
  0, 36, 36, 36, 36, 36, 36, 36, 36, 36, 
  1, 2, 36, 36, 2, 36, 36, 36, 36, 36, 
  36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 
  36, 36, 36, 1, 29, 5, 9, 36, 36, 36, 
  36, 25, 32, 7, 22, 36, 36, 23, 6, 35, 
  35, 35, 35, 35, 35, 35, 35, 35, 35, 20, 
  30, 4, 36, 8, 24, 36, 34, 34, 34, 34, 
  34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 
  34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 
  34, 34, 3, 36, 36, 36, 35, 36, 12, 33, 
  27, 13, 11, 18, 33, 10, 33, 33, 17, 28, 
  33, 33, 16, 33, 33, 14, 19, 15, 33, 33, 
  33, 33, 33, 33, 21, 31, 26, 36, 36, 36, 
  36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 
  36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 
  36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 
  36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 
  36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 
  36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 
  36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 
  36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 
  36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 
  36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 
  36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 
  36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 
  36, 36, 36, 36, 36, 36, 36
};


static void act33()
{ 
		NLA = Eof;
	}


static void act34()
{ 
		NLA = RExpr;
		zzmode(START);   
	}


static void act35()
{ 
		NLA = 3;
		
		zzline++;
		warn("eoln found in string");
		zzskip();
	}


static void act36()
{ 
		NLA = 4;
		zzmore();   
	}


static void act37()
{ 
		NLA = 5;
		zzmore();   
	}

static unsigned char shift1[257] = {
  0, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 2, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 1, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 3, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4
};


static void act38()
{ 
		NLA = Eof;
	}


static void act39()
{ 
		NLA = 6;
		zzmode(ACTIONS); zzmore();   
	}


static void act40()
{ 
		NLA = 7;
		
		zzline++;
		warn("eoln found in string (in user action)");
		zzskip();
	}


static void act41()
{ 
		NLA = 8;
		zzmore();   
	}


static void act42()
{ 
		NLA = 9;
		zzmore();   
	}

static unsigned char shift2[257] = {
  0, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 2, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 1, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 3, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4
};


static void act43()
{ 
		NLA = Eof;
	}


static void act44()
{ 
		NLA = 10;
		zzmode(ACTIONS); zzmore();   
	}


static void act45()
{ 
		NLA = 11;
		
		zzline++;
		warn("eoln found in char literal (in user action)");
		zzskip();
	}


static void act46()
{ 
		NLA = 12;
		zzmore();   
	}


static void act47()
{ 
		NLA = 13;
		zzmore();   
	}

static unsigned char shift3[257] = {
  0, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 2, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  1, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 3, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4
};


static void act48()
{ 
		NLA = Eof;
	}


static void act49()
{ 
		NLA = 14;
		zzmode(ACTIONS); zzmore();   
	}


static void act50()
{ 
		NLA = 15;
		zzmore();   
	}


static void act51()
{ 
		NLA = 16;
		zzline++; zzmore();   
	}


static void act52()
{ 
		NLA = 17;
		zzmore();   
	}

static unsigned char shift4[257] = {
  0, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 3, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 1, 4, 4, 4, 4, 2, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4
};


static void act53()
{ 
		NLA = Eof;
	}


static void act54()
{ 
		NLA = 18;
		zzline++; zzmode(ACTIONS); zzmore();   
	}


static void act55()
{ 
		NLA = 19;
		zzmore();   
	}

static unsigned char shift5[257] = {
  0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2
};


static void act56()
{ 
		NLA = Eof;
	}


static void act57()
{ 
		NLA = 20;
		zzline++; zzmode(START); zzskip();   
	}


static void act58()
{ 
		NLA = 21;
		zzskip();   
	}

static unsigned char shift6[257] = {
  0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2
};


static void act59()
{ 
		NLA = Eof;
	}


static void act60()
{ 
		NLA = 22;
		zzmode(START); zzskip();   
	}


static void act61()
{ 
		NLA = 23;
		zzskip();   
	}


static void act62()
{ 
		NLA = 24;
		zzline++; zzskip();   
	}


static void act63()
{ 
		NLA = 25;
		zzskip();   
	}

static unsigned char shift7[257] = {
  0, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 3, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 1, 4, 4, 4, 4, 2, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4
};


static void act64()
{ 
		NLA = Eof;
	}


static void act65()
{ 
		NLA = 26;
		{
			RefVarRec *rf;
			zzskip();
			zzbegexpr[strlen(zzbegexpr)-1] = '\0';
			rf=refVarRec(zzbegexpr);
			list_add(&AllRefVars, rf);
			list_add(&RefVars, rf);
			zzmode(ACTIONS); zzmore(); zzreplstr("");
		}  
	}

static unsigned char shift8[257] = {
  0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1
};


static void act66()
{ 
		NLA = Eof;
	}


static void act67()
{ 
		NLA = Action;
		/* these do not nest */
		zzmode(START);
		NLATEXT[0] = ' ';
		NLATEXT[1] = ' ';
		zzbegexpr[0] = ' ';
		zzbegexpr[1] = ' ';
		if ( zzbufovf ) {
			found_error = 1;
			err( eMsgd("action buffer overflow; size %d",ZZLEXBUFSIZE));
		}
	}


static void act68()
{ 
		NLA = PassAction;
		if ( topint() == ']' ) {
			popint();
			if ( istackempty() )	/* terminate action */
			{
				zzmode(START);
				NLATEXT[0] = ' ';
				zzbegexpr[0] = ' ';
				if ( zzbufovf ) {
					found_error = 1;
					err( eMsgd("parameter buffer overflow; size %d",ZZLEXBUFSIZE));
				}
			}
			else {
				/* terminate #[..] */
				zzreplstr(")");
				zzmore();
			}
		}
		else if ( topint() == '|' ) { /* end of simple [...] */
			popint();
			zzmore();
		}
		else zzmore();
	}


static void act69()
{ 
		NLA = 29;
		zzline++; zzmore();   
	}


static void act70()
{ 
		NLA = 30;
		zzmore();   
	}


static void act71()
{ 
		NLA = 31;
		
		if ( !(strcmp(zzbegexpr, "#ifdef")==0 ||
		strcmp(zzbegexpr, "#else")==0 ||
		strcmp(zzbegexpr, "#endif")==0 ||
		strcmp(zzbegexpr, "#ifndef")==0 ||
		strcmp(zzbegexpr, "#if")==0 ||
		strcmp(zzbegexpr, "#define")==0 ||
		strcmp(zzbegexpr, "#pragma")==0 ||
		strcmp(zzbegexpr, "#undef")==0 ||
		strcmp(zzbegexpr, "#import")==0 ||
		strcmp(zzbegexpr, "#line")==0 ||
		strcmp(zzbegexpr, "#include")==0 ||
		strcmp(zzbegexpr, "#error")==0) )
		{
			static char buf[100];
			if ( !transform ) {
				warn("#id used in nontransform mode; # ignored");
				sprintf(buf, "%s", zzbegexpr+1);
			}
			else {
				if ( CurRule==NULL )
				{warn("#id used in action outside of rule; ignored");}
				else if ( strcmp(zzbegexpr+1,CurRule)==0 )
				strcpy(buf, "(*_result)");
			}
			zzreplstr(buf);
		}
		zzmore();
	}


static void act72()
{ 
		NLA = 32;
		
		if ( GenCPP ) zzreplstr("new SORAST");
		else zzreplstr("ast_empty_node()");
		zzmore();
	}


static void act73()
{ 
		NLA = 33;
		zzreplstr("NULL"); zzmore();   
	}


static void act74()
{ 
		NLA = 34;
		
		pushint(']');
		if ( GenCPP ) zzreplstr("new SORAST(");
		else zzreplstr("ast_node(");
		zzmore();
	}


static void act75()
{ 
		NLA = 35;
		
		pushint('}');
		if ( GenCPP ) zzreplstr("PCCTS_AST::make(");
		else zzreplstr("ast_make(");
		zzmore();
	}


static void act76()
{ 
		NLA = 36;
		zzmore();   
	}


static void act77()
{ 
		NLA = 37;
		
		if ( istackempty() )
		zzmore();
		else if ( topint()==')' ) {
			popint();
		}
		else if ( topint()=='}' ) {
			popint();
			/* terminate #(..) */
			zzreplstr(", NULL)");
		}
		zzmore();
	}


static void act78()
{ 
		NLA = 38;
		
		pushint('|');	/* look for '|' to terminate simple [...] */
		zzmore();
	}


static void act79()
{ 
		NLA = 39;
		
		pushint(')');
		zzmore();
	}


static void act80()
{ 
		NLA = 40;
		zzreplstr("]");  zzmore();   
	}


static void act81()
{ 
		NLA = 41;
		zzreplstr(")");  zzmore();   
	}


static void act82()
{ 
		NLA = 42;
		zzreplstr(">");  zzmore();   
	}


static void act83()
{ 
		NLA = 43;
		zzmode(ACTION_CHARS); zzmore();  
	}


static void act84()
{ 
		NLA = 44;
		zzmode(ACTION_STRINGS); zzmore();  
	}


static void act85()
{ 
		NLA = 45;
		zzreplstr("#");  zzmore();   
	}


static void act86()
{ 
		NLA = 46;
		zzmore();   
	}


static void act87()
{ 
		NLA = 47;
		zzmore();   
	}


static void act88()
{ 
		NLA = 48;
		zzmode(ACTION_COMMENTS); zzmore();   
	}


static void act89()
{ 
		NLA = 49;
		err("Missing /*; found dangling */ in action"); zzmore();   
	}


static void act90()
{ 
		NLA = 50;
		zzmode(ACTION_CPP_COMMENTS); zzmore();   
	}


static void act91()
{ 
		NLA = 51;
		zzmode(REFVAR_SCARF); zzmore(); zzreplstr("");  
	}


static void act92()
{ 
		NLA = 52;
		
		zzmore(); if ( !GenCPP ) zzreplstr("_parser->");
	}


static void act93()
{ 
		NLA = 53;
		
		if ( (GenCPP && strcmp(zzbegexpr,"ast_scan(")==0) ||
		(!GenCPP && strcmp(zzbegexpr,"ast_scan(")==0) ) {
			char *args=scarf_to_end_of_func_call();
			zzreplstr(cvt_token_str(zzbegexpr, args));
			zzmore();
		}
		else { pushint(')'); zzmore(); }
	}


static void act94()
{ 
		NLA = 54;
		zzmore();   
	}


static void act95()
{ 
		NLA = 55;
		zzmore();   
	}

static unsigned char shift9[257] = {
  0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 
  16, 3, 16, 16, 16, 16, 16, 16, 16, 16, 
  16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 
  16, 16, 16, 16, 16, 12, 4, 16, 16, 16, 
  11, 8, 9, 14, 16, 16, 16, 16, 13, 6, 
  6, 6, 6, 6, 6, 6, 6, 6, 6, 16, 
  16, 16, 16, 1, 16, 15, 5, 5, 5, 5, 
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 
  5, 5, 7, 10, 2, 16, 5, 16, 5, 5, 
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 
  5, 5, 5, 5, 16, 16, 16, 16, 16, 16, 
  16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 
  16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 
  16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 
  16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 
  16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 
  16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 
  16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 
  16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 
  16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 
  16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 
  16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 
  16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 
  16, 16, 16, 16, 16, 16, 16
};


static void act96()
{ 
		NLA = Eof;
	}


static void act97()
{ 
		NLA = 93;
		zzmode(PARSE_ENUM_FILE); zzmore();   
	}


static void act98()
{ 
		NLA = 94;
		zzmore();   
	}


static void act99()
{ 
		NLA = 95;
		zzline++; zzmore();   
	}


static void act100()
{ 
		NLA = 96;
		zzmore();   
	}

static unsigned char shift10[257] = {
  0, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 3, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 1, 4, 4, 4, 4, 2, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4
};


static void act101()
{ 
		NLA = Eof;
	}


static void act102()
{ 
		NLA = 97;
		zzline++; zzmode(PARSE_ENUM_FILE); zzskip();   
	}


static void act103()
{ 
		NLA = 98;
		zzskip();   
	}

static unsigned char shift11[257] = {
  0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2
};


static void act104()
{ 
		NLA = Eof;
		/*zzmode(START); zzskip();*/   
	}


static void act105()
{ 
		NLA = 99;
		zzskip();   
	}


static void act106()
{ 
		NLA = 100;
		zzline++; zzskip();   
	}


static void act107()
{ 
		NLA = 101;
		zzmode(TOK_DEF_CPP_COMMENTS); zzmore();   
	}


static void act108()
{ 
		NLA = 102;
		zzmode(TOK_DEF_COMMENTS); zzmore();   
	}


static void act109()
{ 
		NLA = 103;
		
	}


static void act110()
{ 
		NLA = 104;
		zzmode(TOK_DEF_CPP_COMMENTS); zzskip();   
	}


static void act111()
{ 
		NLA = 105;
		zzmode(TOK_DEF_CPP_COMMENTS); zzskip();   
	}


static void act112()
{ 
		NLA = 106;
		
	}


static void act113()
{ 
		NLA = 107;
		zzmode(TOK_DEF_CPP_COMMENTS); zzskip();   
	}


static void act114()
{ 
		NLA = 110;
	}


static void act115()
{ 
		NLA = 111;
	}


static void act116()
{ 
		NLA = 112;
	}


static void act117()
{ 
		NLA = 113;
	}


static void act118()
{ 
		NLA = 114;
	}


static void act119()
{ 
		NLA = 115;
	}


static void act120()
{ 
		NLA = INT;
	}


static void act121()
{ 
		NLA = ID;
	}

static unsigned char shift12[257] = {
  0, 22, 22, 22, 22, 22, 22, 22, 22, 22, 
  1, 2, 22, 22, 2, 22, 22, 22, 22, 22, 
  22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 
  22, 22, 22, 1, 22, 22, 5, 22, 22, 22, 
  22, 22, 22, 4, 22, 17, 22, 22, 3, 20, 
  20, 20, 20, 20, 20, 20, 20, 20, 20, 22, 
  19, 22, 16, 22, 22, 22, 21, 21, 21, 21, 
  21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 
  21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 
  21, 21, 22, 22, 22, 22, 21, 22, 21, 21, 
  21, 9, 10, 7, 21, 21, 6, 21, 21, 11, 
  14, 8, 21, 21, 21, 21, 12, 21, 13, 21, 
  21, 21, 21, 21, 15, 22, 18, 22, 22, 22, 
  22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 
  22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 
  22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 
  22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 
  22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 
  22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 
  22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 
  22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 
  22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 
  22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 
  22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 
  22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 
  22, 22, 22, 22, 22, 22, 22
};

#define DfaStates	184
typedef unsigned short DfaState;

static DfaState st0[37] = {
  1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  12, 13, 14, 15, 16, 17, 18, 19, 11, 20, 
  21, 22, 23, 11, 24, 184, 184
};

static DfaState st1[37] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184
};

static DfaState st2[37] = {
  184, 2, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184
};

static DfaState st3[37] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184
};

static DfaState st4[37] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184
};

static DfaState st5[37] = {
  184, 184, 184, 184, 25, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184
};

static DfaState st6[37] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184
};

static DfaState st7[37] = {
  184, 184, 184, 184, 184, 184, 26, 27, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184
};

static DfaState st8[37] = {
  184, 184, 184, 184, 184, 184, 28, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184
};

static DfaState st9[37] = {
  184, 184, 184, 184, 184, 184, 184, 184, 29, 184, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184
};

static DfaState st10[37] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  30, 31, 31, 31, 31, 32, 31, 31, 31, 31, 
  184, 184, 184, 184, 184, 33, 184, 31, 31, 184, 
  184, 184, 184, 31, 31, 31, 184
};

static DfaState st11[37] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 
  184, 184, 184, 184, 184, 184, 184, 34, 34, 184, 
  184, 184, 184, 34, 34, 34, 184
};

static DfaState st12[37] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184
};

static DfaState st13[37] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184
};

static DfaState st14[37] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184
};

static DfaState st15[37] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 35, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184
};

static DfaState st16[37] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184
};

static DfaState st17[37] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184
};

static DfaState st18[37] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184
};

static DfaState st19[37] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 
  184, 184, 184, 184, 184, 184, 184, 34, 36, 184, 
  184, 184, 184, 34, 34, 34, 184
};

static DfaState st20[37] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184
};

static DfaState st21[37] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184
};

static DfaState st22[37] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184
};

static DfaState st23[37] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184
};

static DfaState st24[37] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 
  184, 184, 184, 184, 184, 184, 184, 37, 37, 184, 
  184, 184, 184, 37, 37, 37, 184
};

static DfaState st25[37] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184
};

static DfaState st26[37] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184
};

static DfaState st27[37] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184
};

static DfaState st28[37] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184
};

static DfaState st29[37] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184
};

static DfaState st30[37] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  31, 38, 31, 31, 31, 31, 31, 31, 31, 31, 
  184, 184, 184, 184, 184, 184, 184, 31, 31, 184, 
  184, 184, 184, 31, 31, 31, 184
};

static DfaState st31[37] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 
  184, 184, 184, 184, 184, 184, 184, 31, 31, 184, 
  184, 184, 184, 31, 31, 31, 184
};

static DfaState st32[37] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  31, 31, 31, 31, 31, 31, 39, 31, 31, 31, 
  184, 184, 184, 184, 184, 184, 184, 31, 31, 184, 
  184, 184, 184, 31, 31, 31, 184
};

static DfaState st33[37] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184
};

static DfaState st34[37] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 
  184, 184, 184, 184, 184, 184, 184, 34, 34, 184, 
  184, 184, 184, 34, 34, 34, 184
};

static DfaState st35[37] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184
};

static DfaState st36[37] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  34, 34, 40, 34, 34, 34, 34, 34, 34, 34, 
  184, 184, 184, 184, 184, 184, 184, 34, 34, 184, 
  184, 184, 184, 34, 34, 34, 184
};

static DfaState st37[37] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 
  184, 184, 184, 184, 184, 184, 184, 37, 37, 184, 
  184, 184, 184, 37, 37, 37, 184
};

static DfaState st38[37] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  31, 31, 41, 31, 31, 31, 31, 31, 31, 31, 
  184, 184, 184, 184, 184, 184, 184, 31, 31, 184, 
  184, 184, 184, 31, 31, 31, 184
};

static DfaState st39[37] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  31, 31, 31, 31, 31, 31, 31, 42, 31, 31, 
  184, 184, 184, 184, 184, 184, 184, 31, 31, 184, 
  184, 184, 184, 31, 31, 31, 184
};

static DfaState st40[37] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  34, 34, 34, 34, 34, 34, 34, 34, 34, 43, 
  184, 184, 184, 184, 184, 184, 184, 34, 34, 184, 
  184, 184, 184, 34, 34, 34, 184
};

static DfaState st41[37] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  31, 31, 31, 44, 31, 31, 31, 31, 31, 31, 
  184, 184, 184, 184, 184, 184, 184, 31, 31, 184, 
  184, 184, 184, 31, 31, 31, 184
};

static DfaState st42[37] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  31, 31, 31, 45, 31, 31, 31, 31, 31, 31, 
  184, 184, 184, 184, 184, 184, 184, 31, 31, 184, 
  184, 184, 184, 31, 31, 31, 184
};

static DfaState st43[37] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  34, 34, 34, 34, 34, 34, 34, 34, 34, 46, 
  184, 184, 184, 184, 184, 184, 184, 34, 34, 184, 
  184, 184, 184, 34, 34, 34, 184
};

static DfaState st44[37] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  31, 47, 31, 31, 31, 31, 31, 31, 31, 31, 
  184, 184, 184, 184, 184, 184, 184, 31, 31, 184, 
  184, 184, 184, 31, 31, 31, 184
};

static DfaState st45[37] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  31, 48, 31, 31, 31, 31, 31, 31, 31, 31, 
  184, 184, 184, 184, 184, 184, 184, 31, 31, 184, 
  184, 184, 184, 31, 31, 31, 184
};

static DfaState st46[37] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 
  184, 184, 184, 184, 184, 184, 184, 34, 34, 184, 
  184, 184, 184, 34, 34, 34, 184
};

static DfaState st47[37] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  31, 31, 31, 31, 49, 31, 31, 31, 31, 31, 
  184, 184, 184, 184, 184, 184, 184, 31, 31, 184, 
  184, 184, 184, 31, 31, 31, 184
};

static DfaState st48[37] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  31, 31, 31, 31, 31, 31, 31, 31, 50, 31, 
  184, 184, 184, 184, 184, 184, 184, 31, 31, 184, 
  184, 184, 184, 31, 31, 31, 184
};

static DfaState st49[37] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 
  184, 184, 184, 184, 184, 184, 184, 31, 31, 184, 
  184, 184, 184, 31, 31, 31, 184
};

static DfaState st50[37] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  31, 31, 31, 31, 31, 31, 31, 31, 31, 51, 
  184, 184, 184, 184, 184, 184, 184, 31, 31, 184, 
  184, 184, 184, 31, 31, 31, 184
};

static DfaState st51[37] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 
  184, 184, 184, 184, 184, 184, 184, 31, 31, 184, 
  184, 184, 184, 31, 31, 31, 184
};

static DfaState st52[6] = {
  53, 54, 55, 56, 57, 184
};

static DfaState st53[6] = {
  184, 184, 184, 184, 184, 184
};

static DfaState st54[6] = {
  184, 184, 184, 184, 184, 184
};

static DfaState st55[6] = {
  184, 184, 184, 184, 184, 184
};

static DfaState st56[6] = {
  184, 58, 58, 58, 58, 184
};

static DfaState st57[6] = {
  184, 184, 184, 184, 57, 184
};

static DfaState st58[6] = {
  184, 184, 184, 184, 184, 184
};

static DfaState st59[6] = {
  60, 61, 62, 63, 64, 184
};

static DfaState st60[6] = {
  184, 184, 184, 184, 184, 184
};

static DfaState st61[6] = {
  184, 184, 184, 184, 184, 184
};

static DfaState st62[6] = {
  184, 184, 184, 184, 184, 184
};

static DfaState st63[6] = {
  184, 65, 65, 65, 65, 184
};

static DfaState st64[6] = {
  184, 184, 184, 184, 64, 184
};

static DfaState st65[6] = {
  184, 184, 184, 184, 184, 184
};

static DfaState st66[6] = {
  67, 68, 69, 70, 71, 184
};

static DfaState st67[6] = {
  184, 184, 184, 184, 184, 184
};

static DfaState st68[6] = {
  184, 184, 184, 184, 184, 184
};

static DfaState st69[6] = {
  184, 184, 184, 184, 184, 184
};

static DfaState st70[6] = {
  184, 72, 72, 72, 72, 184
};

static DfaState st71[6] = {
  184, 184, 184, 184, 71, 184
};

static DfaState st72[6] = {
  184, 184, 184, 184, 184, 184
};

static DfaState st73[6] = {
  74, 75, 76, 77, 76, 184
};

static DfaState st74[6] = {
  184, 184, 184, 184, 184, 184
};

static DfaState st75[6] = {
  184, 184, 78, 184, 184, 184
};

static DfaState st76[6] = {
  184, 184, 76, 184, 76, 184
};

static DfaState st77[6] = {
  184, 184, 184, 184, 184, 184
};

static DfaState st78[6] = {
  184, 184, 184, 184, 184, 184
};

static DfaState st79[4] = {
  80, 81, 82, 184
};

static DfaState st80[4] = {
  184, 184, 184, 184
};

static DfaState st81[4] = {
  184, 184, 184, 184
};

static DfaState st82[4] = {
  184, 184, 82, 184
};

static DfaState st83[4] = {
  84, 85, 86, 184
};

static DfaState st84[4] = {
  184, 184, 184, 184
};

static DfaState st85[4] = {
  184, 184, 184, 184
};

static DfaState st86[4] = {
  184, 184, 86, 184
};

static DfaState st87[6] = {
  88, 89, 90, 91, 90, 184
};

static DfaState st88[6] = {
  184, 184, 184, 184, 184, 184
};

static DfaState st89[6] = {
  184, 184, 92, 184, 184, 184
};

static DfaState st90[6] = {
  184, 184, 90, 184, 90, 184
};

static DfaState st91[6] = {
  184, 184, 184, 184, 184, 184
};

static DfaState st92[6] = {
  184, 184, 184, 184, 184, 184
};

static DfaState st93[4] = {
  94, 95, 184, 184
};

static DfaState st94[4] = {
  184, 184, 184, 184
};

static DfaState st95[4] = {
  184, 95, 96, 184
};

static DfaState st96[4] = {
  184, 184, 184, 184
};

static DfaState st97[18] = {
  98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 
  108, 109, 110, 111, 112, 113, 104, 184
};

static DfaState st98[18] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184
};

static DfaState st99[18] = {
  184, 114, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184
};

static DfaState st100[18] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184
};

static DfaState st101[18] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184
};

static DfaState st102[18] = {
  184, 184, 184, 184, 184, 115, 184, 116, 117, 184, 
  184, 184, 184, 184, 184, 184, 184, 184
};

static DfaState st103[18] = {
  184, 184, 184, 184, 184, 103, 184, 184, 118, 184, 
  184, 184, 184, 184, 184, 184, 184, 184
};

static DfaState st104[18] = {
  184, 184, 184, 184, 184, 184, 104, 184, 184, 184, 
  184, 184, 184, 184, 104, 184, 104, 184
};

static DfaState st105[18] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184
};

static DfaState st106[18] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184
};

static DfaState st107[18] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184
};

static DfaState st108[18] = {
  184, 119, 120, 121, 122, 121, 121, 121, 121, 123, 
  121, 121, 121, 121, 121, 121, 121, 184
};

static DfaState st109[18] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184
};

static DfaState st110[18] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184
};

static DfaState st111[18] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 124, 125, 184, 184, 184
};

static DfaState st112[18] = {
  184, 184, 184, 184, 184, 184, 104, 184, 184, 184, 
  184, 184, 184, 126, 104, 184, 104, 184
};

static DfaState st113[18] = {
  184, 184, 184, 184, 184, 184, 184, 184, 127, 184, 
  184, 184, 184, 184, 184, 184, 184, 184
};

static DfaState st114[18] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184
};

static DfaState st115[18] = {
  184, 184, 184, 184, 184, 128, 128, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184
};

static DfaState st116[18] = {
  184, 184, 129, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184
};

static DfaState st117[18] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 130, 
  184, 184, 184, 184, 184, 184, 184, 184
};

static DfaState st118[18] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184
};

static DfaState st119[18] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184
};

static DfaState st120[18] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184
};

static DfaState st121[18] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184
};

static DfaState st122[18] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184
};

static DfaState st123[18] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184
};

static DfaState st124[18] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184
};

static DfaState st125[18] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184
};

static DfaState st126[18] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184
};

static DfaState st127[18] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184
};

static DfaState st128[18] = {
  184, 184, 184, 184, 184, 128, 128, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184
};

static DfaState st129[18] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184
};

static DfaState st130[18] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184
};

static DfaState st131[6] = {
  132, 133, 134, 135, 134, 184
};

static DfaState st132[6] = {
  184, 184, 184, 184, 184, 184
};

static DfaState st133[6] = {
  184, 184, 136, 184, 184, 184
};

static DfaState st134[6] = {
  184, 184, 134, 184, 134, 184
};

static DfaState st135[6] = {
  184, 184, 184, 184, 184, 184
};

static DfaState st136[6] = {
  184, 184, 184, 184, 184, 184
};

static DfaState st137[4] = {
  138, 139, 140, 184
};

static DfaState st138[4] = {
  184, 184, 184, 184
};

static DfaState st139[4] = {
  184, 184, 184, 184
};

static DfaState st140[4] = {
  184, 184, 140, 184
};

static DfaState st141[23] = {
  142, 143, 144, 145, 184, 146, 147, 147, 147, 147, 
  148, 147, 147, 147, 147, 149, 150, 151, 152, 153, 
  154, 147, 184
};

static DfaState st142[23] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184
};

static DfaState st143[23] = {
  184, 143, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184
};

static DfaState st144[23] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184
};

static DfaState st145[23] = {
  184, 184, 184, 155, 156, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184
};

static DfaState st146[23] = {
  184, 184, 184, 184, 184, 184, 157, 184, 184, 158, 
  159, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184
};

static DfaState st147[23] = {
  184, 184, 184, 184, 184, 184, 160, 160, 160, 160, 
  160, 160, 160, 160, 160, 184, 184, 184, 184, 184, 
  160, 160, 184
};

static DfaState st148[23] = {
  184, 184, 184, 184, 184, 184, 160, 160, 161, 160, 
  160, 160, 160, 160, 160, 184, 184, 184, 184, 184, 
  160, 160, 184
};

static DfaState st149[23] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184
};

static DfaState st150[23] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184
};

static DfaState st151[23] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184
};

static DfaState st152[23] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184
};

static DfaState st153[23] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184
};

static DfaState st154[23] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  154, 184, 184
};

static DfaState st155[23] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184
};

static DfaState st156[23] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184
};

static DfaState st157[23] = {
  184, 184, 184, 184, 184, 184, 184, 162, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184
};

static DfaState st158[23] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  163, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184
};

static DfaState st159[23] = {
  184, 184, 184, 184, 184, 184, 184, 184, 164, 184, 
  184, 165, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184
};

static DfaState st160[23] = {
  184, 184, 184, 184, 184, 184, 160, 160, 160, 160, 
  160, 160, 160, 160, 160, 184, 184, 184, 184, 184, 
  160, 160, 184
};

static DfaState st161[23] = {
  184, 184, 184, 184, 184, 184, 160, 160, 160, 160, 
  160, 160, 160, 166, 160, 184, 184, 184, 184, 184, 
  160, 160, 184
};

static DfaState st162[23] = {
  184, 184, 184, 184, 184, 184, 184, 184, 167, 168, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184
};

static DfaState st163[23] = {
  184, 184, 184, 184, 184, 184, 184, 169, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184
};

static DfaState st164[23] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 170, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184
};

static DfaState st165[23] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 171, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184
};

static DfaState st166[23] = {
  184, 184, 184, 184, 184, 184, 160, 160, 160, 160, 
  160, 160, 160, 160, 172, 184, 184, 184, 184, 184, 
  160, 160, 184
};

static DfaState st167[23] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 173, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184
};

static DfaState st168[23] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  174, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184
};

static DfaState st169[23] = {
  184, 184, 184, 184, 184, 184, 175, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184
};

static DfaState st170[23] = {
  184, 184, 184, 184, 184, 184, 176, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184
};

static DfaState st171[23] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  177, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184
};

static DfaState st172[23] = {
  184, 184, 184, 184, 184, 184, 160, 160, 160, 160, 
  160, 160, 160, 160, 160, 184, 184, 184, 184, 184, 
  160, 160, 184
};

static DfaState st173[23] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  178, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184
};

static DfaState st174[23] = {
  184, 184, 184, 184, 184, 184, 184, 179, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184
};

static DfaState st175[23] = {
  184, 184, 184, 184, 184, 184, 184, 184, 180, 184, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184
};

static DfaState st176[23] = {
  184, 184, 184, 184, 184, 184, 184, 181, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184
};

static DfaState st177[23] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184
};

static DfaState st178[23] = {
  184, 184, 184, 184, 184, 184, 184, 182, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184
};

static DfaState st179[23] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184
};

static DfaState st180[23] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  183, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184
};

static DfaState st181[23] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184
};

static DfaState st182[23] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184
};

static DfaState st183[23] = {
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
  184, 184, 184
};


DfaState *dfa[184] = {
	st0,
	st1,
	st2,
	st3,
	st4,
	st5,
	st6,
	st7,
	st8,
	st9,
	st10,
	st11,
	st12,
	st13,
	st14,
	st15,
	st16,
	st17,
	st18,
	st19,
	st20,
	st21,
	st22,
	st23,
	st24,
	st25,
	st26,
	st27,
	st28,
	st29,
	st30,
	st31,
	st32,
	st33,
	st34,
	st35,
	st36,
	st37,
	st38,
	st39,
	st40,
	st41,
	st42,
	st43,
	st44,
	st45,
	st46,
	st47,
	st48,
	st49,
	st50,
	st51,
	st52,
	st53,
	st54,
	st55,
	st56,
	st57,
	st58,
	st59,
	st60,
	st61,
	st62,
	st63,
	st64,
	st65,
	st66,
	st67,
	st68,
	st69,
	st70,
	st71,
	st72,
	st73,
	st74,
	st75,
	st76,
	st77,
	st78,
	st79,
	st80,
	st81,
	st82,
	st83,
	st84,
	st85,
	st86,
	st87,
	st88,
	st89,
	st90,
	st91,
	st92,
	st93,
	st94,
	st95,
	st96,
	st97,
	st98,
	st99,
	st100,
	st101,
	st102,
	st103,
	st104,
	st105,
	st106,
	st107,
	st108,
	st109,
	st110,
	st111,
	st112,
	st113,
	st114,
	st115,
	st116,
	st117,
	st118,
	st119,
	st120,
	st121,
	st122,
	st123,
	st124,
	st125,
	st126,
	st127,
	st128,
	st129,
	st130,
	st131,
	st132,
	st133,
	st134,
	st135,
	st136,
	st137,
	st138,
	st139,
	st140,
	st141,
	st142,
	st143,
	st144,
	st145,
	st146,
	st147,
	st148,
	st149,
	st150,
	st151,
	st152,
	st153,
	st154,
	st155,
	st156,
	st157,
	st158,
	st159,
	st160,
	st161,
	st162,
	st163,
	st164,
	st165,
	st166,
	st167,
	st168,
	st169,
	st170,
	st171,
	st172,
	st173,
	st174,
	st175,
	st176,
	st177,
	st178,
	st179,
	st180,
	st181,
	st182,
	st183
};


DfaState accepts[185] = {
  0, 1, 2, 3, 4, 23, 6, 0, 16, 24, 
  32, 30, 13, 14, 15, 17, 18, 27, 20, 30, 
  22, 25, 26, 28, 31, 5, 9, 7, 8, 10, 
  32, 32, 32, 19, 30, 29, 30, 31, 32, 32, 
  30, 32, 32, 30, 32, 32, 21, 32, 32, 11, 
  32, 12, 0, 33, 34, 35, 0, 37, 36, 0, 
  38, 39, 40, 0, 42, 41, 0, 43, 44, 45, 
  0, 47, 46, 0, 48, 50, 52, 51, 49, 0, 
  53, 54, 55, 0, 56, 57, 58, 0, 59, 61, 
  63, 62, 60, 0, 64, 0, 65, 0, 66, 70, 
  68, 69, 76, 94, 95, 78, 79, 77, 0, 83, 
  84, 87, 95, 92, 67, 71, 74, 75, 93, 82, 
  80, 86, 85, 81, 90, 88, 89, 91, 71, 72, 
  73, 0, 96, 98, 100, 99, 97, 0, 101, 102, 
  103, 0, 104, 105, 106, 0, 0, 121, 121, 115, 
  116, 117, 118, 119, 120, 107, 108, 0, 0, 0, 
  121, 121, 0, 0, 0, 0, 121, 0, 0, 0, 
  0, 0, 114, 0, 0, 0, 0, 111, 0, 110, 
  0, 113, 109, 112, 0
};

void (*actions[122])() = {
	zzerraction,
	act1,
	act2,
	act3,
	act4,
	act5,
	act6,
	act7,
	act8,
	act9,
	act10,
	act11,
	act12,
	act13,
	act14,
	act15,
	act16,
	act17,
	act18,
	act19,
	act20,
	act21,
	act22,
	act23,
	act24,
	act25,
	act26,
	act27,
	act28,
	act29,
	act30,
	act31,
	act32,
	act33,
	act34,
	act35,
	act36,
	act37,
	act38,
	act39,
	act40,
	act41,
	act42,
	act43,
	act44,
	act45,
	act46,
	act47,
	act48,
	act49,
	act50,
	act51,
	act52,
	act53,
	act54,
	act55,
	act56,
	act57,
	act58,
	act59,
	act60,
	act61,
	act62,
	act63,
	act64,
	act65,
	act66,
	act67,
	act68,
	act69,
	act70,
	act71,
	act72,
	act73,
	act74,
	act75,
	act76,
	act77,
	act78,
	act79,
	act80,
	act81,
	act82,
	act83,
	act84,
	act85,
	act86,
	act87,
	act88,
	act89,
	act90,
	act91,
	act92,
	act93,
	act94,
	act95,
	act96,
	act97,
	act98,
	act99,
	act100,
	act101,
	act102,
	act103,
	act104,
	act105,
	act106,
	act107,
	act108,
	act109,
	act110,
	act111,
	act112,
	act113,
	act114,
	act115,
	act116,
	act117,
	act118,
	act119,
	act120,
	act121
};

static DfaState dfa_base[] = {
	0,
	52,
	59,
	66,
	73,
	79,
	83,
	87,
	93,
	97,
	131,
	137,
	141
};

static unsigned char *b_class_no[] = {
	shift0,
	shift1,
	shift2,
	shift3,
	shift4,
	shift5,
	shift6,
	shift7,
	shift8,
	shift9,
	shift10,
	shift11,
	shift12
};



#define ZZSHIFT(c) (b_class_no[zzauto][1+c])
#define MAX_MODE 13
#include "dlgauto.h"
