#include "SList.h"

/* Iterate over a list of elements; returns ptr to a new element
 * in list upon every call and NULL when no more are left.
 * Very useful like this:
 *
 *		cursor = mylist;
 *		while ( (p=mylist->iterate(&cursor)) ) {
 *			// place with element p
 *		}
 *
 * The cursor must be initialized to point to the list to iterate over.
 */
void *SList::
iterate(SListNode **cursor)
{
	void *e;

	if ( cursor == NULL || *cursor==NULL ) return NULL;
	if ( head == *cursor ) { *cursor = (*cursor)->next(); }
	e = (*cursor)->elem();
	(*cursor) = (*cursor)->next();
	return e;
}

/* add an element to end of list. */
void SList::
add(void *e)
{
	SListNode *p, *tail;
	require(e!=NULL, "slist_add: attempting to add NULL list element");

	p = new SListNode;
	require(p!=NULL, "add: cannot alloc new list node");
	p->setElem(e);
	if ( head == NULL )
	{
		head = tail = p;
	}
	else								/* find end of list */
	{
		tail->setNext(p);
		tail = p;
	}
}

void SList::
lfree()
{
	SListNode *p,*q;

	if ( head==NULL ) return;	/* empty list */
	for (p = head; p!=NULL; p=q)
	{
		q = p->next();
		free(p);
	}
}

PCCTS_AST *SList::
to_ast(SList list)
{
	PCCTS_AST *t=NULL, *last=NULL;
	SListNode *p;

	for (p = head; p!=NULL; p=p->next())
	{
		PCCTS_AST *u = (PCCTS_AST *)p->elem();
		if ( last==NULL ) last = t = u;
		else { last->setRight(u); last = u; }
	}
	return t;
}
