#|------------------------------------------------------------*-Scheme-*--|
 | File:    modules/iolib/input.scm
 |
 |          Copyright (C)1997 Donovan Kolbly <d.kolbly@rscheme.org>
 |          as part of the RScheme project, licensed for free use.
 |          See <http://www.rscheme.org/> for the latest information.
 |
 | File version:     1.6
 | File mod date:    1997.11.29 23:10:41
 | System build:     v0.7.2, 97.12.21
 | Owned by module:  iolib
 |
 | Purpose:          Generic <input-port> interface
 `------------------------------------------------------------------------|#

;;
;;  general input stuff
;;

(define-class <input-port> (<object>)
  (input-port-line-number type: <fixnum> init-value: 1))

(define-syntax (increment-line self)
  (set-input-port-line-number! self (add1 (input-port-line-number self))))

(define (input-port? x)
  (instance? x <input-port>))
;;

(define-class <eof> (<object>))

(define $eof-object (make <eof>))

(define (eof-object? thing)
  (eq? thing $eof-object))

;; these generic functions define the basic
;; functionality.
;;
;; there is no default for the first two, but
;; the higher-level functions
;; have defaults which are written in terms of read-char

(define-generic-function input-port-read-char)
(define-generic-function input-port-peek-char)
(define-generic-function close-input-port)

(define-generic-function input-port-scan-token)
(define-generic-function input-port-read)
(define-generic-function input-port-read-line)

(define-generic-function set-input-port-prompt!)
(define-generic-function set-input-port-completions!)


(define-rewriter (with-default-input-port form)
  (let ((fn (cadr form)))
    (list 'define
	  (cons fn 'args)
	  (list
	   (string->symbol 
	    (string-append "input-port-"
			   (symbol->string fn)))
	   '(if (null? args)
		(current-input-port)
		(car args))))))

(define-method input-port-read-line ((self <input-port>))
  (let (((first <pair>) (cons 0 '())))
    (let loop (((prev <pair>) first))
      (let ((ch (input-port-read-char self)))
	(if (eq? ch $eof-object)
	    (if (eq? prev first)
		$eof-object
		(list->string (cdr first)))
	    (if (eq? ch #\newline)
		(list->string (cdr first))
		(let (((cell <pair>) (cons ch '())))
		  (set-cdr! prev cell)
		  (loop cell))))))))

;; it's worth noting that being at EOF means a char is ALWAYS
;; ready (because read-char will never block, because it will
;; immediately return $eof-object)

(define-method input-port-char-ready? ((self <input-port>))
  #t)

(with-default-input-port read-char)
(with-default-input-port char-ready?)
(with-default-input-port peek-char)
(with-default-input-port scan-token)
(with-default-input-port read)
(with-default-input-port read-line)
