#|------------------------------------------------------------*-Scheme-*--|
 | File:    modules/hacks/disassem.scm
 |
 |          Copyright (C)1997 Donovan Kolbly <d.kolbly@rscheme.org>
 |          as part of the RScheme project, licensed for free use.
 |          See <http://www.rscheme.org/> for the latest information.
 |
 | File version:     1.5
 | File mod date:    1997.11.29 23:10:30
 | System build:     v0.7.2, 97.12.21
 | Owned by module:  hacks
 |
 | Purpose:          functions for hacking on bytecoded programs
 `------------------------------------------------------------------------|#

;;
;;  return the bytecoded program (and instance of <byte-coded>)
;;  for the given template or function
;;

(define-method bytecodes ((self <function>))
  (bytecodes (template self)))

(define-method bytecodes ((self <template>))
  (let ((s (and (fixnum>? (gvec-length self) 3)
		(gvec-ref self 3))))
    (if (instance? s <byte-coded>)
	s
	(error "~s: not a byte-coded template" self))))

