#|------------------------------------------------------------*-Scheme-*--|
 | File:    modules/corelib/str2num.scm
 |
 |          Copyright (C)1997 Donovan Kolbly <d.kolbly@rscheme.org>
 |          as part of the RScheme project, licensed for free use.
 |          See <http://www.rscheme.org/> for the latest information.
 |
 | File version:     1.8
 | File mod date:    1997.11.29 23:10:39
 | System build:     v0.7.2, 97.12.21
 | Owned by module:  corelib
 |
 | Purpose:          convert strings to numbers (option radix override)
 `------------------------------------------------------------------------|#

(define-glue (string->fixnum str radix)
{
  REG0 = string_to_fixnum( string_text(str), 
			   string_length(str),
			   fx2int(radix) );
  RETURN1();
})

(define-glue (string->float str radix)
{
  REG0 = string_to_float( string_text(str), 
			  string_length(str),
			  fx2int(radix) );
  RETURN1();
})

(define-glue (string->long-int str radix)
{
  INT_64 v;
  rs_bool ok;

  ok = string_to_int_64( string_text(str), 
			 string_length(str),
			 fx2int(radix),
			 &v );
  REG0 = ok ? make_long_int(v) : FALSE_OBJ;
  RETURN1();
})

(define-safe-glue (sprintf-float (fmt <raw-string>)
                                 (len <raw-int>)
                                 (num <double-float>))
{
  double x = extract_float(num);
  REG0 = c_vprintf( fmt, len, x );
  RETURN1();
})

(define-safe-glue (sprintf-fixnum (fmt <raw-string>)
                                  (len <raw-int>)
                                  (num <raw-int>))
{
  REG0 = c_vprintf( fmt, len, num );
  RETURN1();
})
