#|------------------------------------------------------------*-Scheme-*--|
 | File:    modules/codegen/disassem.scm
 |
 |          Copyright (C)1997 Donovan Kolbly <d.kolbly@rscheme.org>
 |          as part of the RScheme project, licensed for free use.
 |          See <http://www.rscheme.org/> for the latest information.
 |
 | File version:     1.6
 | File mod date:    1997.11.29 23:10:33
 | System build:     v0.7.2, 97.12.21
 | Owned by module:  codegen
 |
 `------------------------------------------------------------------------|#

(define *bytecode-vec* #f)
(define *primop-vec* #f)
(define *tried-loading-disassembly-info* #f)

(define (load-disassembly-table bcstuff)
  ;;
  (let ((p (append-path bcstuff (string->file "bctable.dat"))))
    (if (file-exists? p)
	(let ((v (make-vector 256)))
	  (set! *bytecode-vec* v)
	  (for-each (lambda (opcode)
		      (vector-set! v (car opcode) opcode))
		    (with-input-from-file (pathname->os-path p) read)))))
  ;;
  (let ((p (append-path bcstuff (string->file "potable.dat"))))
    (if (file-exists? p)
	(let ((v (make-vector 256)))
	  (set! *primop-vec* v)
	  (for-each (lambda (primop)
		      (vector-set! v
				   (cdr (assq 'bytecode (vector-ref primop 3)))
				   primop))
		    (with-input-from-file (pathname->os-path p) read))))))

(define (force-disassembly-info)
  (if (not *tried-loading-disassembly-info*)
      (begin
	(set! *tried-loading-disassembly-info* #t)
	(load-disassembly-table 
	  (string->dir "[resource]/compiler/bytecode")))))

(define-method print ((self <byte-coded>))
  (force-disassembly-info)
  (if (not (and *bytecode-vec* *primop-vec*))
      (print-bvec self)
      (disassemble self)))

(define (disassemble (self <byte-coded>))
  (let loop ((i 0))
    (if (< i (bvec-length self))
	(let ((c (bvec-ref self i)))
	  (format #t "~-3d: ~-3d" i c)
	  (if (eq? c 255)
	      ;; it's a primop
	      (let* ((pon (bvec-ref self (+ i 1)))
		     (po (vector-ref *primop-vec* pon)))
		(if po
		    ;; check to see if it has a return value
		    (if (vector-ref po 2)
			(format #t 
				" ~-3d             | ~s ~s => ~s\n"
				pon
				(vector-ref po 0)
				(vector-ref po 1)
				(vector-ref po 2))
			(format #t 
				" ~-3d             | ~s ~s\n"
				pon
				(vector-ref po 0)
				(vector-ref po 1)))
		    (format #t " ~d ILLEGAL PRIMOP\n" pon))
		(loop (+ i 2)))
	      ;; it's a normal bcode
	      (let ((d (vector-ref *bytecode-vec* c)))
		(if d
		    (begin
		      (let iloop ((j (+ i 1)) (n (caddr d)))
			(if (> n 0)
			    (begin
			      (format #t " ~-3d" (bvec-ref self j))
			      (iloop (+ j 1) (- n 1)))
			    (begin
			      (display (vector-ref 
					'#("                "
					   "            "
					   "        "
					   "    "
					   "")
					(caddr d)))
			      (format #t " | ~s" (cadr d))
			      (format #t "\n")
			      (loop j)))))
		    (begin
		      (format #t "             ?\n")
		      (loop (+ i 1)))))))
	self)))
