/* Quinn Diff, Compares two Packages files looking for differences between Archs */
/* Copyright (C) 1997-1998, James Troup <james@nocrew.org> */

/* This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "config.h"
#include "common.h"
#include "error.h"
#include "getopt.h"
#include "init.h"

void 
parse_opt (int argc, char **argv, primary_package_info *primary, secondary_package_info *secondary)
{
  char *debug_argument;
  int c;

  while (1)
    {
      int option_index = 0;
      static struct option long_options[] =
      {
	{"arch-specific-packages", required_argument, NULL, 'a'},
	{"debug", required_argument, NULL, 'D'},
	{"help", no_argument, NULL, 'h'},
	{"primary-packages", required_argument, NULL, 'p'},
	{"secondary-packages", required_argument, NULL, 's'},
	{"source-packages", required_argument, NULL, 'o'}, 
	{"version", no_argument, NULL, 'V'},
	{"visible-warn", required_argument, NULL, 'w'}, 
	{"warn-older", no_argument, &warn_older, 1},
	{0, 0, 0, 0}
      };

      c = getopt_long (argc, argv, "a:D:o:p:s:w:hV",
		       long_options, &option_index);
      if (c == EOF)
	break;

      switch (c)
	{
	case 'a':
	  strncpy (packages_arch_specific_filename, optarg, PACKAGE_NAME_LENGTH);
	  break;

	case 'D':
	  if (!strcmp (optarg, "help"))
	    debug_help();
	  else
	    {
	      debug_level = strtoul (optarg, &debug_argument, 8);
	      if (*debug_argument)
		{
		  error ("--debug requires an octal argument");
		  usage (1);
		}
	    }
	  break;

	case 'h':
	  usage (0);
	  break;

	case 'o': 
	  strncpy (packages_source_filename, optarg, PACKAGE_NAME_LENGTH);
	  break;

	case 'p':
	  strncpy (primary->file_name, optarg, PACKAGE_NAME_LENGTH);
	  break;

	case 's':
	  strncpy (secondary->file_name, optarg, PACKAGE_NAME_LENGTH);
	  break;

	case 'w':
	  visible_warn_level = strtoul (optarg, &debug_argument, 8);
	  if (*debug_argument)
	    {
	      error ("-w/--visible-warn requires an octal argument");
	      usage (1);
	    }
	  break;

	case 'V':
	  fprintf (stderr, "Quinn diff version %s\n", VERSION);
	  exit (0);
	  break;

	case '?':
	  usage(1);
	  break;

	default:
	  break;
	}
    }

   if (optind != argc)  
     {
       error ("Quinn diff no longer accepts non-option arguments.");
       usage(1);
     }

}

void
usage (int status)
{
  fprintf (status ? stderr : stdout, "Usage: %s [-dapshV]\n\
-a --arch-specific-packages  filename of Packages-arch-specific file.\n\
                              default: Packages-arch-specific in cwd\n\
-D --debug=<octal value>     enable debug output; see -Dhelp or --debug=help\n\
-h --help                    give this help\n\
-o --source-packages         filename of source Packages file.\n\
-p --primary-packages        filename of primary architectures' Packages file.\n\
                              default: Packages-primary in cwd\n\
-s --secondary-packages      filename of secondary architectures' Packages file.\n\
                              default: Packages-sceondary in cwd\n\
-V --version                 display version number\n\
-w --visible-warn=<octal value> show packages which are consider erroneous.\n\
   --warn-older              warn about packages older on primary\n", program_name);

  exit (status);

}
