/* testopt.c */

#include <stdio.h>
#include <stdlib.h>
#include <opt.h>

int month=4;
int day=24;
int year=1993;
char *who=NULL;

int go(int argc, char **argv)
{
    if (argc>1) {
        printf("In program %s, Extra option: %s\n",argv[0],argv[1]);
    }

    if (optinvoked(&month)) {
        printf("User set month...\n");
    }

    if (month == 9 && day == 11 && year == 1989) {
        printf("Happy birthday, Max\n");
    } else {
        printf("Hello, %s: %4d/%02d/%02d\n",(who==NULL ? "world" : who),
               year,month,day);
    }
    return OPT_OK;
}

int checkyear(void *v)
{
    if (year == 2000) {
        printf("Watch out for that year=2000 bug!\n");
        return OPT_ERROR;
    }
    return OPT_OK;
}
int quit()
{
    printf("Bye...\n");
    return OPT_OK;
}
int write_version()
{
    printf("Version XXX\n");
    optExitNumber(12);
    return OPT_EXIT;
}
int fix_mon(void *v)
{
    int m;
    /* fix whatever int variable v is pointing to */
    m = *((int *)v);
    if (m < 1 || m > 12) 
        m=1;
    *((int *)v) = m;
    return OPT_OK;
} 

main(int argc, char **argv)
{
    optreg(&month,OPT_INT,'m',"Month");
    optlongname(&month,"month");
    opthook(&month,fix_mon);

    optrega(&day,OPT_INT,'d',"day","Day");
    opthelp(&day,"Use day of month, should be less than 32");
    
    optreg_INT(&year,'y',"Year");
    optreg(&year,OPT_INT,'Y',"Year");
    optdescript(&year,"What Year");
    opthook(&year,checkyear);

    optreg(&who,OPT_UNDELIMV,'\0',"Who to say hello to");

    optexec("version",write_version,"Write version number and exit");

    optEnvVarName( "OPT" );
    
    optMain(go);
    optQuit(quit);

    opt(&argc,&argv);
    return go(argc,argv);
}



