/*
 *	Ohio Trollius
 *	(public domain software)
 *
 *	$Log:	tsetbuf.c,v $
 * Revision 6.1  96/11/24  00:36:12  nevin
 * Ohio Release
 * 
 * Revision 6.0  96/02/29  14:06:38  gdburns
 * Ohio Release
 * 
 * Revision 5.2  94/08/22  14:17:40  gdburns
 * Ohio Release
 * 
 * Revision 5.1  94/05/18  12:58:57  gdburns
 * Ohio Release
 * 
 * Revision 2.3  94/04/22  12:47:01  gdburns
 * Ohio Release
 * 
 * Revision 2.2  93/05/10  16:39:03  raja
 * pre-release to 2.3
 * 
 *	We are just putting our stamp on this for housekeeping reasons.
 */

/*
 * This file is originally from dLibs 1.2 by Dale Schumacher et al.
 * It was modified for Trollius by MB, 88/12.
 * It was modified again for portability by GDB, 91/08.
 * And yet again by JRV for LAM, 93/05.
 */

#include <tstdio.h>

void
tsetbuffer(fp, buf, size)
	TFILE *fp;
	unsigned char *buf;
	int size;
{
	if (! (fp->_flag & (_TIOREAD | _TIOWRT))) return;
	fp->_cnt = 0;
	fp->_ptr = buf;
	if(fp->_base = buf)		/* assignment intentional */
	{
		fp->_bsiz = size;
	}
	else
	{
		fp->_flag &= ~(_TIOFBF | _TIOLBF | _TIONBF | _TIOMYBUF);
		fp->_flag |= _TIONBF;
		fp->_bsiz = 0;
	}
}

void
tsetbuf(fp, buf)

TFILE		*fp;
unsigned char	*buf;

{
	tsetbuffer(fp, buf, TBUFSIZ);
}

int
tsetvbuf(fp, buf, type, size)

TFILE		*fp;
unsigned char	*buf;
int		type;
int		size;

{
	if (! (fp->_flag & (_TIOREAD | _TIOWRT))) {
		return(EOF);
	}

	if ((type != _TIOFBF) || (type != _TIOLBF) || (type != _TIONBF)) {
		return(EOF);
	}

	fp->_flag &= ~(_TIOFBF | _TIOLBF | _TIONBF);
	fp->_flag |= type;

	if (buf) {

		if (size <= 0) {
			return(EOF);
		}

		fp->_base = buf;
		fp->_ptr = buf;
		fp->_bsiz = size;
		fp->_cnt = 0;
	}

	return(0);
}

int
tsetlinebuf(fp)

TFILE		*fp;

{
	if (! (fp->_flag & (_TIOREAD | _TIOWRT))) {
		return(EOF);
	}

	fp->_flag &= ~(_TIOFBF | _TIOLBF | _TIONBF);
	fp->_flag |= _TIOLBF;
	return(0);
}
