/*
 *	Ohio Trollius
 *	(public domain software)
 *
 *	$Log:	tfputc.c,v $
 * Revision 6.1  96/11/24  00:36:00  nevin
 * Ohio Release
 * 
 * Revision 6.0  96/02/29  14:06:31  gdburns
 * Ohio Release
 * 
 * Revision 5.2  94/08/22  14:17:35  gdburns
 * Ohio Release
 * 
 * Revision 5.1  94/05/18  12:58:50  gdburns
 * Ohio Release
 * 
 * Revision 2.3  94/04/22  12:46:56  gdburns
 * Ohio Release
 * 
 * Revision 2.2  93/05/10  16:38:58  raja
 * pre-release to 2.3
 * 
 *	We are just putting our stamp on this for housekeeping reasons.
 */

/*
 * This file is originally from dLibs 1.2 by Dale Schumacher et al.
 * It was modified for Trollius by MB, 88/12.
 * MB: added call to atkexit() 891012
 * It was modified again for portability by GDB, 91/08.
 * And yet again by JRV for LAM, 93/05.
 */

/*
 * the CRLF --> \n translation left in case we ever go back to MS-DOS
 */

#include <tstdio.h>

/*
 * external variables
 */
extern int _ioexit;

/*
 * external functions
 */
extern void tfcloseall();
extern void _getbuf();
extern int iomap_write();

int
tfputc(c, fp)
	int c;
	TFILE *fp;
{
	int f, m, nl = 0;

	if (! _ioexit) {
		if (atkexit (tfcloseall, (char *) 0) != 0)
			return (EOF);
		_ioexit = 1;
	}

	f = (fp->_flag |= _TIORW);
	if(!(f & _TIOWRT)			/* not opened for write? */
	|| (f & (_TIOERR | _TIOEOF)))		/* error/eof conditions? */
		return(EOF);
	if(fp->_base == NULL)	/* allocate a buffer if there wasn't one */
		_getbuf(fp);
	if(!(f & _TIOBIN) && (c == '\n'))	/* NL -> CR+LF ? */
	{
#ifdef	DOS
		c = '\r';
		nl = 1;
#endif
	}
_fputc:
	*(fp->_ptr)++ = c;
	if (((++(fp->_cnt)) >= fp->_bsiz)
	||  (c == '\n' && (f & _TIOLBF)))	/* - MB: added */
	{
		m = fp->_cnt;			/* MB: may be < _bsiz */
		fp->_cnt = 0;
		fp->_ptr = fp->_base;
		if((iomap_write(f,
				fp->_file,
				(char *) fp->_base,
				(long) m)) != m)
		{
			fp->_flag |= _TIOERR;
			return(EOF);
		}
	}
	if(nl && (c == '\r'))			/* NL -> CR+LF ? */
	{
		c = '\n';
		goto _fputc;
	}
	return(c);
}
