/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	GDB/RBD
 *
 *	$Id: rploadgo.c,v 6.1 96/11/24 00:26:10 nevin Rel $
 *
 *	Function:	- loads and executes program with arguments on node
 *	Accepts:	- source node of program file 
 *			- destination node to load/execute on
 *			- program filename
 *			- process runtime flags
 *			- arguments argv structure
 *			- process ID (out)
 *			- process index (out)
 *	Returns:	- 0 or ERROR
 */

#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include <args.h>
#include <flatreq.h>
#include <kio.h>
#include <lreq.h>
#include <net.h>
#include <portable.h>
#include <preq.h>
#include <typical.h>

/*
 * external functions
 */
char			*_path_env_find();

/*
 * external variables
 */
extern struct kio_t	_kio;


int
rploadgo(srcnode, destnode, filename, rtflags, argv, pid, idx)

int4			srcnode;
int4			destnode;
CONST char		*filename;
int4			rtflags;
char			**argv;
int4			*pid;
int4			*idx;

{
	int		packsize;	/* size of packed argv */
	int		r;
	int4		argvtag;	/* argv flat tag */
	int4		progtag;	/* program flat tag */
	char		*args;		/* glued argv structure */
	char		*fullpath;
/*
 * Standard IO is to be mapped to passed file descriptors only if the
 * process is to be run locally and is not being spawned.  
 */
	if (rtflags & RTF_IO) {
		if ((destnode == LOCAL || destnode == getnodeid())
				&& (_kio.ki_parent == 0)) {
			rtflags |= RTF_PFDIO;
		} else {
			rtflags &= ~RTF_PFDIO;
		}
	}
/*
 * If the process is to be run locally and is not set to use the
 * application directory then its working directory is to be changed to
 * that of the caller.
 */
	if ((destnode == LOCAL || destnode == getnodeid())
			&& !(rtflags & RTF_APPWD)) {
		rtflags |= RTF_CWD;
	}
/*
 * If source and destination nodes are the same, call rpcreate().
 */
	if (srcnode == destnode) {

		if ((srcnode == LOCAL) || (srcnode == getnodeid())) {
			fullpath = _path_env_find(filename, R_OK | X_OK);
			if (fullpath == 0) return(LAMERROR);

			r = rpcreate(srcnode, fullpath, rtflags, argv, pid,
					idx);
			free(fullpath);
		} else {
			r = rpcreate(srcnode, filename, rtflags, argv, pid,
					idx);
		}

		return(r);
	}
/*
 * Source and destination nodes are different, do the real work.
 */
	progtag = getpid();
/*
 * Load the program on the destination node.
 */
	if (rload(srcnode, destnode, progtag, filename)) return(LAMERROR);
/*
 * Load arguments on the destination node.
 */
	if (argv) {
		argvtag = progtag;
		args = argvglue(argv, 0xa, MAXNMSGLEN);

		if (args == 0) {
			rflclean(destnode, progtag);
			return(LAMERROR);
		}

		packsize = strlen(args) + 1;

		if (rflat(destnode, args, (int4) packsize,
				(int4) packsize, argvtag)) {
			rflclean(destnode, progtag);
			return(LAMERROR);
		}

		free(args);
	} else {
		argvtag = 0;
	}
/*
 * Create/execute the process.
 */
	return(rpgo(destnode, progtag, rtflags, argvtag, pid, idx));
}
