/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	GDB
 *
 *	$Id: ldolinks.c,v 6.1 96/11/24 00:25:46 nevin Rel $
 *
 *	Function:	- client functions for dlo link services
 */

#include <stdlib.h>
#include <unistd.h>

#include <dl_inet.h>
#include <events.h>
#include <net.h>
#include <terror.h>
#include <typical.h>

/*
 *	ldogetlinks
 *
 *	Function:	- gets link information from dlo_inet
 *	Accepts:	- # links (value returned)
 *			- link array, malloc'd and filled (value returned)
 */
int
ldogetlinks(ppdol, pndol)

struct dolink		**ppdol;
int4			*pndol;

{
	struct doreq	*pdoq;		/* dlo request */
	struct doreply	*pdor;		/* dlo reply */
	struct nmsg	nhq;		/* request message */

	pdoq = (struct doreq *) nhq.nh_data;
	pdoq->doq_req = DOQGETLINKS;
	pdoq->doq_src_event = -getpid();

	nhq.nh_node = LOCAL;
	nhq.nh_event = EVDL0;
	nhq.nh_type = DLCTL;
	nhq.nh_flags = NOBUF;
	nhq.nh_length = 0;
	nhq.nh_msg = 0;

	if (nsend(&nhq)) return(LAMERROR);

	pdor = (struct doreply *) nhq.nh_data;
	nhq.nh_event = pdoq->doq_src_event;
	nhq.nh_type = 0;
	nhq.nh_flags = 0;

	if (nrecv(&nhq)) return(LAMERROR);

	if (pdor->dor_reply != 0) {
		errno = pdor->dor_reply;
		return(LAMERROR);
	}

	*pndol = pdor->dor_nlinks;

	nhq.nh_type = 0;
	nhq.nh_length = *pndol * sizeof(struct dolink);

	*ppdol = (struct dolink *) malloc((unsigned) nhq.nh_length);
	if (*ppdol == 0) return(LAMERROR);

	nhq.nh_msg = (char *) *ppdol;
	return(nrecv(&nhq));
}

/*
 *	ldosetlink
 *
 *	Function:	- sets link information in dlo_inet
 *	Accepts:	- link information
 */
int
ldosetlink(pdol)

struct dolink		*pdol;

{
	struct doreq	*pdoq;		/* dlo request */
	struct nmsg	nhq;		/* request message */

	pdoq = (struct doreq *) nhq.nh_data;
	pdoq->doq_req = DOQSETLINK;

	nhq.nh_node = LOCAL;
	nhq.nh_event = EVDL0;
	nhq.nh_type = DLCTL;
	nhq.nh_flags = NOBUF;
	nhq.nh_length = sizeof(struct dolink);
	nhq.nh_msg = (char *) pdol;

	return(nsend(&nhq));
}

/*
 *	ldoremlink
 *
 *	Function:	- removes link information in dlo_inet
 *	Accepts:	- link number
 */
int
ldoremlink(link)

int4			link;

{
	struct doreq	*pdoq;		/* dlo request */
	struct nmsg	nhq;		/* request message */

	pdoq = (struct doreq *) nhq.nh_data;
	pdoq->doq_req = DOQREMLINK;
	pdoq->doq_link = link;

	nhq.nh_node = LOCAL;
	nhq.nh_event = EVDL0;
	nhq.nh_type = DLCTL;
	nhq.nh_flags = NOBUF;
	nhq.nh_length = 0;
	nhq.nh_msg = 0;

	return(nsend(&nhq));
}
