/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	NJN
 *
 *	$Id: shm.hpux.c,v 6.1 96/11/22 13:35:11 nevin Rel $
 *
 *	Function:	- HPUX shared memory low-level routines
 */

#include <lam_config.h>

#include <errno.h>
#include <stdlib.h>
#include <fcntl.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/uio.h>

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <rpisys.h>
#include <terror.h>
#include <typical.h>
#include <t_types.h>

/*
 * global functions
 */
int			_shm_serverinit();
int			_shm_clientinit();
int			_shm_cleanup();

/*
 * external functions
 */
extern void		_sysv_slop_add();
extern void		_sysv_slop_del();
extern void		_sysv_slop_clean();


/*
 *	_shm_clientinit
 *
 *	Function:	- client side shared memory initialization
 *	Accepts:	- process
 *			- LAM msg containing server info
 *	Returns:	- 0 or LAMERROR
 */
int
_shm_clientinit(ps, msg)

struct c2c_proc		*ps;
struct nmsg		*msg;

{
	ps->cp_shm = (int) msg->nh_data[1];
/*
 * Attach the shared memory segment.
 */
	ps->cp_shmbuf = (char *) shmat(ps->cp_shm, (char *) 0, 0);
	if (ps->cp_shmbuf == (char *) -1) return(LAMERROR);
/*
 * Mark it for deletion. It will be removed once all attached
 * processes detach.
 */
	if (shmctl(ps->cp_shm, IPC_RMID, (struct shmid_ds *) 0) < 0) {
		return(LAMERROR);
	}

	ps->cp_shmin = ps->cp_shmbuf + 2 * CACHELINESIZE;
	ps->cp_shmout = ps->cp_shmbuf + SHMBUFSIZE + 2 * CACHELINESIZE;
/*
 * Set the locks.
 */
	ps->cp_iwtlock = (int *) ps->cp_shmbuf;
	ps->cp_irdlock = (int *) (ps->cp_shmbuf + CACHELINESIZE);
	ps->cp_owtlock = (int *) (ps->cp_shmbuf + SHMBUFSIZE); 
	ps->cp_ordlock = (int *) (ps->cp_shmbuf + SHMBUFSIZE + CACHELINESIZE);

	return(0);
}

/*
 *	_shm_serverinit
 *
 *	Function:	- server side shared memory initialization
 *	Accepts:	- process
 *			- LAM msg to fill with info for client
 *	Returns:	- 0 or LAMERROR
 */
int
_shm_serverinit(ps, msg)

struct c2c_proc		*ps;
struct nmsg		*msg;

{
	int		shmid;
/*
 * Create the shared memory segment.
 */
	shmid = shmget(IPC_PRIVATE, SHMBLKSIZE, 0600 | IPC_CREAT);
	if (shmid < 0) return(LAMERROR);
    
	ps->cp_shmbuf = (char *) shmat(shmid, (char *) 0, 0);
	if (ps->cp_shmbuf == (char *) -1) {
		shmctl(shmid, IPC_RMID, (struct shmid_ds *) 0);
		return(LAMERROR);
	}

	ps->cp_shmout = ps->cp_shmbuf + 2 * CACHELINESIZE;
	ps->cp_shmin = ps->cp_shmbuf + SHMBUFSIZE + 2 * CACHELINESIZE;
	ps->cp_shm = shmid;
/*
 * Initialize the locks.
 */
	ps->cp_owtlock = (int *) ps->cp_shmbuf;
	ps->cp_ordlock = (int *) (ps->cp_shmbuf + CACHELINESIZE);
	ps->cp_iwtlock = (int *) (ps->cp_shmbuf + SHMBUFSIZE);
	ps->cp_irdlock = (int *) (ps->cp_shmbuf + SHMBUFSIZE + CACHELINESIZE);

	_hp_lockinit(ps->cp_owtlock);
	_hp_lockinit(ps->cp_iwtlock);
	_hp_lockinit(ps->cp_ordlock);
	_hp_lockinit(ps->cp_irdlock);

	_hp_lock(ps->cp_ordlock);
	_hp_lock(ps->cp_irdlock);
/*
 * Set information to pass to client.
 */
	msg->nh_data[1] = (int4) shmid;
/*
 * Register id for cleanup.
 */
	_sysv_slop_add(1, 'm', shmid);

	return(0);
}

/*
 *	_shm_cleanup
 *
 *	Function:	- clean up a process's shared memory structures
 *	Accepts:	- process
 *	Returns:	- 0 or LAMERROR
 */
int
_shm_cleanup(ps)

struct c2c_proc		*ps;

{
	if (shmdt(ps->cp_shmbuf) < 0) return(LAMERROR);

	_sysv_slop_del('m', ps->cp_shm);
	return(0);
}

/*
 *      _shm_mop_up
 *
 *      Function:       - complete mop up of persistent state
 */
void
_shm_mop_up()

{
	_sysv_slop_clean();
}
