/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD/GDB
 *
 *	$Id: recv.c,v 6.1 96/11/23 22:53:45 nevin Rel $
 *
 *	Function:	- receive a message
 *	Accepts:	- buffer
 *			- count
 *			- datatype
 *			- source
 *			- tag
 *			- communicator
 *			- ptr to status
 *	Returns: 	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <mpitrace.h>
#include <rpisys.h>

/*
 * external functions
 */
extern void		lam_initerr();
extern void		lam_resetfunc();
extern void		lam_setfunc();
extern void		lam_tr_msg();
extern void		_mpi_req_add();
extern void		_mpi_req_blkclr();
extern void		_mpi_req_blkset();
extern void		_mpi_req_rem();
extern int		lam_errfunc();
extern int		lam_mkerr();
extern int		lam_tr_incff();
extern int		_mpi_req_advance();
extern int		_mpi_req_build();
extern int		_mpi_req_destroy();
extern int		_mpi_req_start();
extern int		_mpi_req_end();

int
MPI_Recv(buf, count, dtype, src, tag, comm, stat)

void			*buf;
int			count;
MPI_Datatype		dtype;
int			src;
int			tag;
MPI_Comm		comm;
MPI_Status		*stat;

{
	int		err;
	struct _req	req_storage;
	MPI_Request	req;
	int		seqnum;			/* message sequence number */
	int		fl_trace;		/* do tracing? */
	double		startt;			/* start time */
	double		finisht;		/* finish time */
	
	lam_initerr_m();
/*
 * Check the bozo MPI_PROC_NULL case.  I'm not even tracing this.
 */
	if (src == MPI_PROC_NULL) {
		stat->MPI_ERROR = MPI_SUCCESS;
		stat->MPI_SOURCE = MPI_PROC_NULL;
		stat->MPI_TAG = MPI_ANY_TAG;
		stat->st_count = 0;
		stat->st_nelem = 0;
		stat->st_length = 0;
		stat->st_dtype = MPI_DATATYPE_NULL;
		return(MPI_SUCCESS);
	}

	lam_setfunc_m(BLKMPIRECV);

	if ((fl_trace = LAM_TRACE_TOP())) {
		startt = MPI_Wtime();
		_kio.ki_blktime = 0.0;
	}

	req = &req_storage;
	err = _mpi_req_build(buf, count, dtype, 
				src, tag, comm, LAM_RQIRECV, &req);
	if (err != MPI_SUCCESS) return(lam_errfunc(comm, BLKMPIRECV, err));

	req->rq_marks |= LAM_RQFBLKTYPE;

	err = _mpi_req_start(req);
	if (err != MPI_SUCCESS) return(lam_errfunc(comm, BLKMPIRECV, err));

	_mpi_req_add_m(req);
	_mpi_req_blkclr_m();
	_mpi_req_blkset_m(req);

	err = _mpi_req_advance();
	if (err != MPI_SUCCESS) return(lam_errfunc(comm, BLKMPIRECV, err));
	
	_mpi_req_rem_m(req);

	err = _mpi_req_end(req);
	if (err != MPI_SUCCESS) return(lam_errfunc(comm, BLKMPIRECV, err));

	*stat = req->rq_status;
	seqnum = req->rq_seq;
	
	err = _mpi_req_destroy(&req);
	if (err != MPI_SUCCESS) return(lam_errfunc(comm, BLKMPIRECV, err));
/*
 * Generate a run time trace.
 */
	if (fl_trace) {
		finisht = MPI_Wtime();
		
		lam_tr_msg(TRTINPUT, startt,
				LAM_S2US(finisht - startt - _kio.ki_blktime),
				LAM_S2US(_kio.ki_blktime), src, tag, comm,
				dtype, count, stat->MPI_SOURCE, stat->MPI_TAG,
				seqnum, LAM_RQIRECV);
	}
	
	if (stat->MPI_ERROR != MPI_SUCCESS) {
		return(lam_errfunc(comm, BLKMPIRECV, stat->MPI_ERROR));
	}

	lam_resetfunc_m(BLKMPIRECV);
	return(MPI_SUCCESS);
}
