/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	NJN
 *
 *	$Id: nameget.c,v 6.1 96/11/22 13:35:04 nevin Rel $
 *
 *	Function:	- get port name associated with service name
 *	Accepts:	- service name
 *			- info
 *			- port name (out)
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <errno.h>
#include <stdlib.h>

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <terror.h>
#include <trreq.h>


int
MPI_Name_get(service_name, info, port_name)

char			*service_name;
MPI_Info		info;
char			*port_name;

{
	char		*port_buf;
	
	lam_initerr();
	lam_setfunc(BLKMPINAMEGET);
/*
 * Check arguments.
 */
	if (port_name == 0 || service_name == 0) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPINAMEGET,
				lam_mkerr(MPI_ERR_ARG, 0)));
	}
/*
 * Get port name.
 */
	if (lam_rtrnameget(0, service_name, &port_buf)) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPINAMEGET,
				lam_mkerr(MPI_ERR_NAME, errno))); 
	}

	strcpy(port_name, port_buf);
	free(port_buf);
	
        lam_resetfunc(BLKMPINAMEGET);
	return(MPI_SUCCESS);
}
