/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	NJN
 *
 *	$Id: mpil_trace.c,v 6.1 96/11/23 22:53:32 nevin Rel $
 *
 *	Function:	- toggles tracing status
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <terror.h>

/*
 *	MPIL_Trace_on
 *
 *	Function:	- enables tracing; begins segment
 */
int
MPIL_Trace_on()

{
	int		err;			/* error code */
	int		trmodesave;		/* save trace mode */
/*
 * This is a NOP if trace mode is off.
 */
	if ( ! (_kio.ki_rtf & RTF_TRACE)) return(MPI_SUCCESS);

	lam_initerr();
	lam_setfunc(BLKMPILTRACEON);
/*
 * Synchronize. We don't want to trace it though!
 */
	trmodesave = _kio.ki_rtf & RTF_TRSWITCH;
	_kio.ki_rtf &= ~RTF_TRSWITCH;
	
	err = MPI_Barrier(MPI_COMM_WORLD);

	_kio.ki_rtf |= trmodesave;
	
	if (err != MPI_SUCCESS) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPILTRACEON, err));
	}
/*
 * Turn tracing on.
 */
	if (lam_tr_on() < 0) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPILTRACEON,
				lam_mkerr(MPI_ERR_OTHER, errno)));
	}
	
	lam_resetfunc(BLKMPILTRACEON);
	return(MPI_SUCCESS);
}

/*
 *	MPIL_Trace_off
 *
 *	Function:	- disables tracing; ends segment
 */
int
MPIL_Trace_off()

{
	int		err;			/* error code */
	int		trmodesave;		/* save trace mode */
/*
 * This is a NOP if trace mode is off.
 */
	if ( ! (_kio.ki_rtf & RTF_TRACE)) return(MPI_SUCCESS);
	
	lam_initerr();
	lam_setfunc(BLKMPILTRACEOFF);
/*
 * Synchronize. We don't want to trace it though!
 */
	trmodesave = _kio.ki_rtf & RTF_TRSWITCH;
	_kio.ki_rtf &= ~RTF_TRSWITCH;

	err = MPI_Barrier(MPI_COMM_WORLD);

	_kio.ki_rtf |= trmodesave;

	if (err != MPI_SUCCESS) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPILTRACEOFF, err));
	}
/*
 * Turn tracing off.
 */
	if (lam_tr_off() < 0) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPILTRACEOFF,
				lam_mkerr(MPI_ERR_OTHER, errno)));
	}
	
	lam_resetfunc(BLKMPILTRACEOFF);
	return(MPI_SUCCESS);
}
