/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	NJN
 *
 *	$Id: infofree.c,v 6.1 96/11/22 13:34:56 nevin Rel $
 *
 *	Function:	- free an info object
 *	Accepts:	- info (modified)
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <stdlib.h>

#include <all_list.h>
#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>


int
MPI_Info_free(info)

MPI_Info		*info;

{
	struct _info	*p;			/* key/value pair */
	
        lam_initerr();
	lam_setfunc(BLKMPIINFOFREE);

	if (info == 0) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPIINFOFREE,
					lam_mkerr(MPI_ERR_ARG, 0)));
	}

	for (p = al_top((LIST *) *info); p; p = al_next((LIST *) *info, p)) {
		if (p->info_value) {
			free(p->info_value);
		}
	}

	(void) al_free((LIST *) *info);
	*info = MPI_INFO_NULL;

        lam_resetfunc(BLKMPIINFOFREE);
	return(MPI_SUCCESS);
}
