/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: gfree.c,v 6.1 96/11/23 22:52:04 nevin Rel $
 *
 *	Function:	- free a group
 *	Accepts:	- group (inout)
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <stdlib.h>

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <rpisys.h>

int
MPI_Group_free(grp)

MPI_Group		*grp;

{
	struct _proc	**p;
	int		i;
	
	lam_initerr();
	lam_setfunc(BLKMPIGROUPFREE);

	if (grp == 0 || *grp == MPI_GROUP_NULL) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPIGROUPFREE, lam_mkerr(MPI_ERR_GROUP, 0)));
	} else {
		if ((--(*grp)->g_refcount) == 0) {
/*
 * We don't check for the empty group before since a user may
 * legitimately free a copy of it.  The problem is now that we won't
 * catch an explicit free of MPI_GROUP_EMPTY when copies of it exist.
 */
			if (*grp == MPI_GROUP_EMPTY) {
				++(*grp)->g_refcount;
				return(lam_errfunc(MPI_COMM_WORLD,
					BLKMPIGROUPFREE,
					lam_mkerr(MPI_ERR_GROUP, 0)));
			}
			
			for (i = (*grp)->g_nprocs, p = (*grp)->g_procs; i > 0;
			     i--, p++) {

				if ((--(*p)->p_refcount) == 0) {
					lam_procfree(*p);
				}
			}

			free((char *) *grp);
		}

		*grp = MPI_GROUP_NULL;
	}

	lam_resetfunc(BLKMPIGROUPFREE);
	return(MPI_SUCCESS);
}
