/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: gdiff.c,v 6.1 96/11/23 22:51:56 nevin Rel $
 *
 *	Function:	- form the difference of two groups
 *	Accepts:	- first group
 *			- second group
 *			- ptr difference group
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <stdlib.h>

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <rpisys.h>
#include <terror.h>

int
MPI_Group_difference(g1, g2, pgd)

MPI_Group		g1;
MPI_Group		g2;
MPI_Group		*pgd;

{
	int		i, j;			/* favourite indices */
	int		nproc;			/* # procs in difference */
	struct _proc	**pi, **pj;		/* favourite pointers */
	MPI_Group	gd;			/* difference group */

	lam_initerr();
	lam_setfunc(BLKMPIGROUPDIFF);
/*
 * Check the arguments.
 */
	if ((g1 == MPI_GROUP_NULL) || (g2 == MPI_GROUP_NULL)) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPIGROUPDIFF, lam_mkerr(MPI_ERR_GROUP, 0)));
	}

	if (pgd == 0) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPIGROUPDIFF, lam_mkerr(MPI_ERR_ARG, 0)));
	}
/*
 * Handle the trivial cases.
 */
	if ((g1->g_nprocs == 0) || (g2->g_nprocs == 0)) {
		*pgd = g1;
		g1->g_refcount++;
		lam_resetfunc(BLKMPIGROUPDIFF);
		return(MPI_SUCCESS);
	}
/*
 * Get the # of processes in the difference.
 * Flag the processes common to both groups.
 */
	nproc = g1->g_nprocs;

	for (i = 0, pi = g1->g_procs; i < g1->g_nprocs; ++i, ++pi) {

		for (j = 0, pj = g2->g_procs; j < g2->g_nprocs; ++j, ++pj) {

			if (*pi == *pj) {
				(*pi)->p_mode |= LAM_PFLAG;
				--nproc;
				break;
			}
		}
	}
/*
 * Handle the empty difference case.
 */
	if (nproc == 0) {
		*pgd = MPI_GROUP_EMPTY;
		MPI_GROUP_EMPTY->g_refcount++;

		for (i = 0, pi = g1->g_procs; i < g1->g_nprocs; ++i, ++pi) {
			(*pi)->p_mode &= ~LAM_PFLAG;
		}

		lam_resetfunc(BLKMPIGROUPDIFF);
		return(MPI_SUCCESS);
	}
/*
 * Allocate a new group.
 */
	gd = (MPI_Group) malloc((unsigned) sizeof(struct _group) +
					(nproc * sizeof(struct _proc *)));
	if (gd == 0) {
		for (i = 0, pi = g1->g_procs; i < g1->g_nprocs; ++i, ++pi) {
			(*pi)->p_mode &= ~LAM_PFLAG;
		}

		return(lam_errfunc(MPI_COMM_WORLD, BLKMPIGROUPDIFF,
				lam_mkerr(MPI_ERR_OTHER, errno)));
	}

	*pgd = gd;
	gd->g_nprocs = nproc;
	gd->g_myrank = MPI_UNDEFINED;
	gd->g_refcount = 1;
	gd->g_procs = (struct _proc **) ((char *) gd + sizeof(struct _group));
/*
 * Fill the new group processes.
 */
	pj = gd->g_procs;

	for (i = 0, pi = g1->g_procs; i < g1->g_nprocs; ++i, ++pi) {

		if ((*pi)->p_mode & LAM_PFLAG) {
			(*pi)->p_mode &= ~LAM_PFLAG;
		} else {
			if (*pi == lam_myproc) {
				gd->g_myrank = (int) (pj - gd->g_procs);
			}
			(*pi)->p_refcount++;
			*pj = *pi;
			++pj;
		}
	}

	lam_resetfunc(BLKMPIGROUPDIFF);
	return(MPI_SUCCESS);
}
