/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: errcreate.c,v 6.1 96/11/23 22:51:42 nevin Rel $
 *
 *	Function:	- create error handler
 *	Accepts:	- error function
 *			- ptr error handler (returned value)
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <stdlib.h>

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <terror.h>

int
MPI_Errhandler_create(errfunc, errhdl)

MPI_Handler_function 	*errfunc;
MPI_Errhandler		*errhdl;

{
	lam_initerr();
	lam_setfunc(BLKMPIERRCREATE);
/*
 * Check the arguments.
 */
	if ((errfunc == 0) || (errhdl == 0)) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPIERRCREATE, lam_mkerr(MPI_ERR_ARG, 0)));
	}
/*
 * Create the handler.
 */
	*errhdl = (MPI_Errhandler) malloc((unsigned) sizeof(struct _errhdl));
	if (*errhdl == 0) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPIERRCREATE, lam_mkerr(MPI_ERR_OTHER, errno)));
	}

	(*errhdl)->eh_func = (void (*)()) errfunc;
	(*errhdl)->eh_f77hdl = -1;
	(*errhdl)->eh_refcount = 1;

	lam_resetfunc(BLKMPIERRCREATE);
	return(MPI_SUCCESS);
}
