/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: ctestinter.c,v 6.1 96/11/23 22:51:36 nevin Rel $
 *
 *	Function:	- check if inter-communicator
 *	Accepts:	- communicator
 *			- flag (out)
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>

int
MPI_Comm_test_inter(comm, flag)

MPI_Comm		comm;
int			*flag;

{
	lam_initerr();
	lam_setfunc(BLKMPICOMMTESTINTER);

	if (comm == MPI_COMM_NULL) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPICOMMTESTINTER, lam_mkerr(MPI_ERR_COMM, 0)));
	}

	if (flag == 0) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPICOMMTESTINTER, lam_mkerr(MPI_ERR_ARG, 0)));
	}

	*flag = LAM_IS_INTER(comm) ? 1 : 0;

	lam_resetfunc(BLKMPICOMMTESTINTER);
	return(MPI_SUCCESS);
}
