/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: attrdel.c,v 6.1 96/11/23 22:50:49 nevin Rel $
 *
 *	Function:	- delete attribute
 *			- detach attribute from communicator
 *	Accepts:	- communicator
 *			- attribute key
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <terror.h>

/*
 * external functions
 */
extern struct _attrkey	*lam_getattr();
extern struct _attr	*lam_getkey();

int
MPI_Attr_delete(comm, key)

MPI_Comm		comm;
int			key;

{
	struct _attrkey	*p;
	struct _attr	*pk;
	int		err;

	lam_initerr();
	lam_setfunc(BLKMPIATTRDEL);
/*
 * Check the arguments.
 */
	if (comm == MPI_COMM_NULL) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPIATTRDEL, lam_mkerr(MPI_ERR_COMM, 0)));
	}

	p = lam_getattr(key);
	if (p == 0) {
		return(lam_errfunc(comm,
			BLKMPIATTRDEL, lam_mkerr(MPI_ERR_KEYVAL, 0)));
	}
/*
 * Check if the key is attached to the communicator.
 */
	pk = lam_getkey(comm, key);
	if (pk == 0) {
		return(lam_errfunc(comm, BLKMPIATTRDEL,
				lam_mkerr(MPI_ERR_KEYVAL, 0)));
	}
/*
 * Delete the attribute via the callback function.
 */
	if (p->ak_del != MPI_NULL_DELETE_FN) {
		if (p->ak_f77comm < 0) {
			err = (*(p->ak_del))(comm, key,
					pk->a_value, p->ak_extra);
		} else {
			(*(p->ak_del))(&p->ak_f77comm, &key,
					(int *) &(pk->a_value),
                                	(int *) &(p->ak_extra), &err);
		}

		if (err != MPI_SUCCESS) {
			return(lam_errfunc(comm,
				BLKMPIATTRDEL, lam_mkerr(err, 0)));
		}
	}
/*
 * Detach the key from the communicator.
 */
	if (lam_delkey(comm, key)) {
		return(lam_errfunc(comm, BLKMPIATTRDEL,
				lam_mkerr(MPI_ERR_INTERN, errno)));
	}

	lam_resetfunc(BLKMPIATTRDEL);
	return(MPI_SUCCESS);
}
