/*
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	NJN
 *
 *	$Id: mpi_types.h,v 6.1.1.1 97/01/21 10:00:10 nevin Exp $
 *
 *	Function:	- type conversions for ANSI C types and alignment
 *			  checking
 */

#ifndef _MPI_TYPES_H
#define _MPI_TYPES_H

#include <lam_config.h>
#include <portable.h>
#include <t_types.h>

/*
 * short
 */
#if SIZEOF_SHORT == 2

#define	ttol_short(x, y)	ttoli2(x, y)
#define	ltot_short(x, y)	ltoti2(x, y)
#define	mttol_short(x, l)	mttoli2(x, l)
#define	mltot_short(x, l)	mltoti2(x, l)

#elif SIZEOF_SHORT == 4

#define	ttol_short(x, y)	ttoli4(x, y)
#define	ltot_short(x, y)	ltoti4(x, y)
#define	mttol_short(x, l)	mttoli4(x, l)
#define	mltot_short(x, l)	mltoti4(x, l)

#endif

/*
 * int
 */
#if SIZEOF_INT == 2

#define	ttol_int(x, y)		ttoli2(x, y)
#define	ltot_int(x, y)		ltoti2(x, y)
#define	mttol_int(x, l)		mttoli2(x, l)
#define	mltot_int(x, l)		mltoti2(x, l)

#elif SIZEOF_INT == 4

#define	ttol_int(x, y)		ttoli4(x, y)
#define	ltot_int(x, y)		ltoti4(x, y)
#define	mttol_int(x, l)		mttoli4(x, l)
#define	mltot_int(x, l)		mltoti4(x, l)

#elif SIZEOF_INT == 8

#define	ttol_int(x, y)		ttoli8(x, y)
#define	ltot_int(x, y)		ltoti8(x, y)
#define	mttol_int(x, l)		mttoli8(x, l)
#define	mltot_int(x, l)		mltoti8(x, l)

#endif

/*
 * long
 */
#if SIZEOF_LONG == 4

#define	ttol_long(x, y)		ttoli4(x, y)
#define	ltot_long(x, y)		ltoti4(x, y)
#define	mttol_long(x, l)	mttoli4(x, l)
#define	mltot_long(x, l)	mltoti4(x, l)

#elif SIZEOF_LONG == 8

#define	ttol_long(x, y)		ttoli8(x, y)
#define	ltot_long(x, y)		ltoti8(x, y)
#define	mttol_long(x, l)	mttoli8(x, l)
#define	mltot_long(x, l)	mltoti8(x, l)

#endif

/*
 * float
 */
#if SIZEOF_FLOAT == 4

#define	ttol_float(x, y)	ttolf4(x, y)
#define	ltot_float(x, y)	ltotf4(x, y)
#define	mttol_float(x, l)	mttolf4(x, l)
#define	mltot_float(x, l)	mltotf4(x, l)

#elif SIZEOF_FLOAT == 8

#define	ttol_float(x, y)	ttolf8(x, y)
#define	ltot_float(x, y)	ltotf8(x, y)
#define	mttol_float(x, l)	mttolf8(x, l)
#define	mltot_float(x, l)	mltotf8(x, l)

#endif

/*
 * double
 */
#define	ttol_double(x, y)	ttolf8(x, y)
#define	ltot_double(x, y)	ltotf8(x, y)
#define	mttol_double(x, l)	mttolf8(x, l)
#define	mltot_double(x, l)	mltotf8(x, l)

/*
 * long double - if available
 */
#if __STDC__

#if SIZEOF_LONG_DOUBLE == 8

#define ttol_longdbl(x, y)	ttolf8(x, y)
#define ltot_longdbl(x, y)	ltotf8(x, y)
#define	mttol_longdbl(x, l)	mttolf8(x, l)
#define	mltot_longdbl(x, l)	mltotf8(x, l)

#elif SIZEOF_LONG_DOUBLE == 12
/*
 * This is Intel x86 weirdness. We do this only for IEEE FP.
 */
#if WORDS_BIGENDIAN

#define ttol_longdbl(x, y)	*((long double *) (y)) = *((long double *) (x))
#define ltot_longdbl(x, y)	*((long double *) (y)) = *((long double *) (x))
#define	mttol_longdbl(x, l)	
#define	mltot_longdbl(x, l)	

#else  /* not WORDS_BIGENDIAN */

#define ttol_longdbl(x, y)	revn(x, y, 12)
#define ltot_longdbl(x, y)	revn(x, y, 12)
#define	mttol_longdbl(x, l)	mrevn(x, 12, l)
#define	mltot_longdbl(x, l)	mrevn(x, 12, l)

#endif /* not WORDS_BIGENDIAN  */

#elif SIZEOF_LONG_DOUBLE == 16

#if HAVE_IEEE_FP

#if WORDS_BIGENDIAN

#define ttol_longdbl(x, y)	*((long double *) (y)) = *((long double *) (x))
#define ltot_longdbl(x, y)	*((long double *) (y)) = *((long double *) (x))
#define	mttol_longdbl(x, l)	
#define	mltot_longdbl(x, l)	

#else  /* not WORDS_BIGENDIAN */

#define ttol_longdbl(x, y)	revn(x, y, 16)
#define ltot_longdbl(x, y)	revn(x, y, 16)
#define	mttol_longdbl(x, l)	mrevn(x, 16, l)
#define	mltot_longdbl(x, l)	mrevn(x, 16, l)

#endif /* not WORDS_BIGENDIAN  */

#else  /* not HAVE_IEEE_FP */

#define ttol_longdbl(x, y)	ieeetolld(x, y)
#define ltot_longdbl(x, y)	ltoieeeld(x, y)
#define	mttol_longdbl(x, l)	mieeetolld(x, l)
#define	mltot_longdbl(x, l)	mltoieeeld(x, l)

#endif /* not HAVE_IEEE_FP */

#endif /* SIZEOF_LONG_DOUBLE == 16 */

#endif /* __STDC__ */

/*
 * alignment checking macros
 */

#if SIZEOF_INT == 4
#define ALIGNEDU4(p)	((((MPI_Aint) (p)) & (ALIGNMENT_INT - 1)) == 0)
#elif SIZEOF_SHORT == 4
#define ALIGNEDU4(p)	((((MPI_Aint) (p)) & (ALIGNMENT_SHORT - 1)) == 0)
#elif SIZEOF_LONG == 4
#define ALIGNEDU4(p)	((((MPI_Aint) (p)) & (ALIGNMENT_LONG - 1)) == 0)
#endif

#if SIZEOF_FLOAT == 8
#define ALIGNEDF8(p)	((((MPI_Aint) (p)) & (ALIGNMENT_FLOAT - 1)) == 0)
#elif SIZEOF_DOUBLE == 8
#define ALIGNEDF8(p)	((((MPI_Aint) (p)) & (ALIGNMENT_DOUBLE - 1)) == 0)
#endif


#ifndef __ARGS
#if __STDC__ || defined(c_plusplus) || defined(__cplusplus)
#define __ARGS(a)	a
#else
#define __ARGS(a)	()
#endif
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
extern void		lam_copyrev2 __ARGS((void *, void *, int));
extern void		lam_copyrev4 __ARGS((void *, void *, int));
extern void		lam_copyrev8 __ARGS((void *, void *, int));
extern void		lam_copyrevn __ARGS((void *, void *, int, int));

#ifdef __cplusplus
}
#endif

#endif /* _MPI_TYPES_H */
