/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	NJN
 *
 *	$Id: lam_config.h,v 6.1 96/11/22 14:10:05 nevin Rel $
 *
 *	Function:	- OS, CPU and compiler dependent configuration
 */

#ifndef _LAM_CONFIG_H
#define _LAM_CONFIG_H

/*
 * OS/compiler specific defines.
 *
 * Defines of form HAVE_* indicate whether the OS/compiler provides a certain 
 * feature or not.  Define as 1 if the feature is provided, else define as 0.
 *
 * HAVE_SA_RESTART		- SA_RESTART flag to sigaction()
 * HAVE_ATEXIT			- atexit function
 * HAVE_GETCWD			- getcwd function
 * HAVE_SA_LEN			- struct sockaddr has the field sa_len
 * HAVE_UNION_SEMUN		- union semun is defined
 * HAVE_BSD43_FD_PASSING	- can pass file desc. using BSD43 access rights
 * HAVE_BSD44_FD_PASSING	- can pass file desc. using BSD44 control msg
 *
 *
 * Defines of form NEED_* indicate whether certain code is needed when
 * compiling under the OS.  Define as 1 if the code is needed, else define as 0.
 *
 * NEED_SYS_SELECT_H		- need to include sys/select.h 
 * NEED_RSH_MINUSMINUS		- rsh needs "--" to prevent options to the 
 *					remote command being interpreted as 
 *					options to rsh.
 *
 *
 * Defines of form BROKEN_* indicate whether the OS implementation of a
 * feature is broken.  Define as 1 if broken, else define as 0.
 * For example Solaris returns a protocol error when setting an 
 * AF_INET socket buffer size.	This is supposed to be protocol and socket
 * independent.	 Even the Solaris man page concurs.
 *
 * BROKEN_SET_INET_SO_BUFSIZES	- setting of Internet domain socket
 *					send/receive buffer size is broken
 * BROKEN_SET_UNIX_SO_BUFSIZES	- setting of UNIX domain socket
 *					send/receive buffer size is broken
 *
 *
 * Set *ONE* of these to 1 according to the format the FORTRAN compiler
 * uses for external names.
 *
 * FORTRANNOUNDERSCORE		- no underscore appended
 * FORTRANCAPS			- all capitals
 * FORTRANUNDERSCORE		- one underscore appended
 * FORTRANDOUBLEUNDERSCORE	- two underscores appended if name contains
 *				  an underscore else one appended (g77 default)
 */

#if defined(OSF1)

#define HAVE_SA_RESTART			1
#define HAVE_ATEXIT			1
#define HAVE_GETCWD			1
#define HAVE_SA_LEN			0
#define HAVE_UNION_SEMUN		0
#define HAVE_BSD43_FD_PASSING		1
#define HAVE_BSD44_FD_PASSING		1

#define NEED_SYS_SELECT_H		0
#define NEED_RSH_MINUSMINUS		0

#define BROKEN_SET_INET_SO_BUFSIZES	0
#define BROKEN_SET_UNIX_SO_BUFSIZES	0

#define FORTRANNOUNDERSCORE		0
#define FORTRANCAPS			0
#define FORTRANUNDERSCORE		1
#define FORTRANDOUBLEUNDERSCORE		0

#elif defined(AIX)

#define HAVE_SA_RESTART			1
#define HAVE_ATEXIT			1
#define HAVE_GETCWD			1
#define HAVE_SA_LEN			1
#define HAVE_UNION_SEMUN		0
#define HAVE_BSD43_FD_PASSING		1
#define HAVE_BSD44_FD_PASSING		0

#define NEED_SYS_SELECT_H		1
#define NEED_RSH_MINUSMINUS		0

#define BROKEN_SET_INET_SO_BUFSIZES	0
#define BROKEN_SET_UNIX_SO_BUFSIZES	0

#define FORTRANNOUNDERSCORE		1
#define FORTRANCAPS			0
#define FORTRANUNDERSCORE		0
#define FORTRANDOUBLEUNDERSCORE		0

#elif defined(SOLARIS)

#define HAVE_SA_RESTART			1
#define HAVE_ATEXIT			1
#define HAVE_GETCWD			1
#define HAVE_SA_LEN			0
#define HAVE_UNION_SEMUN		0
#define HAVE_BSD43_FD_PASSING		1
#define HAVE_BSD44_FD_PASSING		0

#define NEED_SYS_SELECT_H		0
#define NEED_RSH_MINUSMINUS		0

#define BROKEN_SET_INET_SO_BUFSIZES	0
#define BROKEN_SET_UNIX_SO_BUFSIZES	1

#define FORTRANNOUNDERSCORE		0
#define FORTRANCAPS			0
#define FORTRANUNDERSCORE		0
#define FORTRANDOUBLEUNDERSCORE		1

#elif defined(SUNOS)

#define HAVE_SA_RESTART			0
#define HAVE_ATEXIT			0
#define HAVE_GETCWD			1
#define HAVE_SA_LEN			0
#define HAVE_UNION_SEMUN		0
#define HAVE_BSD43_FD_PASSING		1
#define HAVE_BSD44_FD_PASSING		0

#define NEED_SYS_SELECT_H		0
#define NEED_RSH_MINUSMINUS		0

#define BROKEN_SET_INET_SO_BUFSIZES	0
#define BROKEN_SET_UNIX_SO_BUFSIZES	0

#define FORTRANNOUNDERSCORE		0
#define FORTRANCAPS			0
#define FORTRANUNDERSCORE		1
#define FORTRANDOUBLEUNDERSCORE		0

#elif defined(LINUX)

#define HAVE_SA_RESTART			1
#define HAVE_ATEXIT			1
#define HAVE_GETCWD			1
#define HAVE_SA_LEN			0
#define HAVE_UNION_SEMUN		1
#define HAVE_BSD43_FD_PASSING		0
#define HAVE_BSD44_FD_PASSING		1

#define NEED_SYS_SELECT_H		0
#define NEED_RSH_MINUSMINUS		1

#define BROKEN_SET_INET_SO_BUFSIZES	1
#define BROKEN_SET_UNIX_SO_BUFSIZES	1

#define FORTRANNOUNDERSCORE		0
#define FORTRANCAPS			0
#define FORTRANUNDERSCORE		0
#define FORTRANDOUBLEUNDERSCORE		1

#elif defined(HPUX)

#define HAVE_SA_RESTART			0
#define HAVE_ATEXIT			1
#define HAVE_GETCWD			1
#define HAVE_SA_LEN			0
#define HAVE_UNION_SEMUN		0
#define HAVE_BSD43_FD_PASSING		1
#define HAVE_BSD44_FD_PASSING		0

#define NEED_SYS_SELECT_H		0
#define NEED_RSH_MINUSMINUS		0

#define BROKEN_SET_INET_SO_BUFSIZES	0
#define BROKEN_SET_UNIX_SO_BUFSIZES	0

#define FORTRANNOUNDERSCORE		1
#define FORTRANCAPS			0
#define FORTRANUNDERSCORE		0
#define FORTRANDOUBLEUNDERSCORE		0

#elif defined(IRIX5) || defined(IRIX6)

#define HAVE_SA_RESTART			0
#define HAVE_ATEXIT			1
#define HAVE_GETCWD			1
#define HAVE_SA_LEN			0
#define HAVE_UNION_SEMUN		0
#define HAVE_BSD43_FD_PASSING		1
#define HAVE_BSD44_FD_PASSING		0

#define NEED_SYS_SELECT_H		0
#define NEED_RSH_MINUSMINUS		0

#define BROKEN_SET_INET_SO_BUFSIZES	0
#define BROKEN_SET_UNIX_SO_BUFSIZES	0

#define FORTRANNOUNDERSCORE		0
#define FORTRANCAPS			0
#define FORTRANUNDERSCORE		1
#define FORTRANDOUBLEUNDERSCORE		0

#else

ERROR: OS type not recognized

#endif


/*
 * CPU and compiler specific defines.
 *
 * WORDS_BIGENDIAN	- 1 if big-endian, 0 if little-endian
 * HAVE_IEEE_FP		- 1 if uses IEEE floating point representation, else 0

 * SIZEOF_SHORT		- size of a short in bytes
 * SIZEOF_INT		- size of an int in bytes
 * SIZEOF_LONG		- size of a long int in bytes
 * SIZEOF_FLOAT		- size of a float in bytes
 * SIZEOF_DOUBLE	- size of a double in bytes
 * SIZEOF_VOID_P	- size of a generic void * pointer in bytes
 *
 * ALIGNMENT_SHORT	- alignment required for a short in bytes
 * ALIGNMENT_INT	- alignment required for an int in bytes
 * ALIGNMENT_LONG	- alignment required for a long in bytes
 * ALIGNMENT_FLOAT	- alignment required for a float in bytes
 * ALIGNMENT_DOUBLE	- alignment required for a double in bytes
 * ALIGNMENT_LONG_DOUBLE- alignment required for a long double in bytes
 *
 * Make sure to set the sizes correctly according to the compiler options you
 * are using.
 */
#if defined(alpha) || defined(__alpha)

#define WORDS_BIGENDIAN			0
#define HAVE_IEEE_FP			1

#define SIZEOF_SHORT			2
#define SIZEOF_INT			4
#define SIZEOF_LONG			8
#define SIZEOF_FLOAT			4
#define SIZEOF_DOUBLE			8
#define SIZEOF_LONG_DOUBLE		8
#define SIZEOF_VOID_P			8
#define ALIGNMENT_SHORT			2
#define ALIGNMENT_INT			4
#define ALIGNMENT_LONG			8
#define ALIGNMENT_FLOAT			4
#define ALIGNMENT_DOUBLE		8
#define ALIGNMENT_LONG_DOUBLE		8

#elif defined(hppa) || defined(__hppa)

#define WORDS_BIGENDIAN			1
#define HAVE_IEEE_FP			1

#define SIZEOF_SHORT			2
#define SIZEOF_INT			4
#define SIZEOF_LONG			4
#define SIZEOF_FLOAT			4
#define SIZEOF_DOUBLE			8
#define SIZEOF_LONG_DOUBLE		8
#define SIZEOF_VOID_P			4
#define ALIGNMENT_SHORT			2
#define ALIGNMENT_INT			4
#define ALIGNMENT_LONG			4
#define ALIGNMENT_FLOAT			4
#define ALIGNMENT_DOUBLE		8
#define ALIGNMENT_LONG_DOUBLE		8

#elif defined(i386) || defined(i486) || defined(i586) || defined(ix86)

#define WORDS_BIGENDIAN			0
#define HAVE_IEEE_FP			1

#define SIZEOF_SHORT			2
#define SIZEOF_INT			4
#define SIZEOF_LONG			4
#define SIZEOF_FLOAT			4
#define SIZEOF_DOUBLE			8
#define SIZEOF_LONG_DOUBLE		12
#define SIZEOF_VOID_P			4
#define ALIGNMENT_SHORT			2
#define ALIGNMENT_INT			4
#define ALIGNMENT_LONG			4
#define ALIGNMENT_FLOAT			4
#define ALIGNMENT_DOUBLE		4
#define ALIGNMENT_LONG_DOUBLE		4

#elif defined(mips32)

#define WORDS_BIGENDIAN			1
#define HAVE_IEEE_FP			1

#define SIZEOF_SHORT			2
#define SIZEOF_INT			4
#define SIZEOF_LONG			4
#define SIZEOF_FLOAT			4
#define SIZEOF_DOUBLE			8
#define SIZEOF_LONG_DOUBLE		8
#define SIZEOF_VOID_P			4
#define ALIGNMENT_SHORT			2
#define ALIGNMENT_INT			4
#define ALIGNMENT_LONG			4
#define ALIGNMENT_FLOAT			4
#define ALIGNMENT_DOUBLE		8
#define ALIGNMENT_LONG_DOUBLE		8

#elif defined(mips64)

#define WORDS_BIGENDIAN			1
#define HAVE_IEEE_FP			1

#define SIZEOF_SHORT			2
#define SIZEOF_INT			4
#define SIZEOF_LONG			8
#define SIZEOF_FLOAT			4
#define SIZEOF_DOUBLE			8
#define SIZEOF_LONG_DOUBLE		16
#define SIZEOF_VOID_P			8
#define ALIGNMENT_SHORT			2
#define ALIGNMENT_INT			4
#define ALIGNMENT_LONG			8
#define ALIGNMENT_FLOAT			4
#define ALIGNMENT_DOUBLE		8
#define ALIGNMENT_LONG_DOUBLE		16

#elif defined(rs6000) || defined(rs6k)

#define WORDS_BIGENDIAN			1
#define HAVE_IEEE_FP			1

#define SIZEOF_SHORT			2
#define SIZEOF_INT			4
#define SIZEOF_LONG			4
#define SIZEOF_FLOAT			4
#define SIZEOF_DOUBLE			8
#define SIZEOF_LONG_DOUBLE		8
#define SIZEOF_VOID_P			4
#define ALIGNMENT_SHORT			2
#define ALIGNMENT_INT			4
#define ALIGNMENT_LONG			4
#define ALIGNMENT_FLOAT			4
#define ALIGNMENT_DOUBLE		4
#define ALIGNMENT_LONG_DOUBLE		4

#elif defined(sparc) || defined(__sparc)

#define WORDS_BIGENDIAN			1
#define HAVE_IEEE_FP			1

#define SIZEOF_SHORT			2
#define SIZEOF_INT			4
#define SIZEOF_LONG			4
#define SIZEOF_FLOAT			4
#define SIZEOF_DOUBLE			8
#define SIZEOF_LONG_DOUBLE		8
#define SIZEOF_VOID_P			4
#define ALIGNMENT_SHORT			2
#define ALIGNMENT_INT			4
#define ALIGNMENT_LONG			4
#define ALIGNMENT_FLOAT			4
#define ALIGNMENT_DOUBLE		8
#define ALIGNMENT_LONG_DOUBLE		8

#else

ERROR: CPU type not recognized

#endif

#endif	/* _LAM_CONFIG_H */
