/*
 *	Ohio Trollius
 *	Copyright 1995 The Ohio State University
 *	GDB
 *
 *	$Log:	rflseek.c,v $
 * Revision 6.1  96/11/23  19:58:52  nevin
 * Ohio Release
 * 
 * Revision 6.0  96/02/29  13:50:08  gdburns
 * Ohio Release
 * 
 * Revision 5.2.1.1  95/11/20  13:10:30  gdburns
 * Remove Cubix.
 * Qualify names for LAM.
 * 
 * Revision 5.2  94/08/22  13:59:14  gdburns
 * Ohio Release
 * 
 * Revision 5.1  94/05/18  10:58:11  gdburns
 * Ohio Release
 * 
 * Revision 2.3  94/04/22  12:38:26  gdburns
 * Ohio Release
 *
 *	Function:	- seeks on a file using remote filed
 *	Accepts:	- runtime file descriptor
 *			- seek offset
 *			- type of seek operation
 *	Returns:	- 0 or ERROR
 */

#include <events.h>
#include <freq.h>
#include <ksignal.h>
#include <net.h>
#include <typical.h>

/*
 * external variables
 */
extern int		errno;		/* error number */
extern struct fclient	_ufd[FUMAX];	/* client file descriptor table */

/*
 * external functions
 */
extern int		_fdvalid();	/* check validity of file desc */

int4
lam_rflseek(fd, offset, whence)

int			fd;
int4			offset;
int			whence;

{
	struct nmsg	nhead;		/* network message desc. */
	struct freq  	*request;	/* filed request */
	struct freply	*reply;		/* filed reply */
	int		mask;		/* signal mask */
/*
 * Do simple error checking.
 */
	if (_fdvalid(fd)) return(LAMERROR);

	request = (struct freq *) nhead.nh_data;
	reply = (struct freply *) nhead.nh_data;

	request->fq_src_node = getnodeid();
	request->fq_src_event = -getpid();
	request->fq_req = FQLSEEK;
	request->fq_tfd = _ufd[fd].fu_tfd;
	request->fq_offset = offset;
	request->fq_whence = (int4) whence;

	if ((fd <= 2) && (_ufd[fd].fu_node == NOTNODEID)) {
		_ufd[fd].fu_node = getorigin();
	}

	nhead.nh_node = _ufd[fd].fu_node;
	nhead.nh_event = EVFILED;
	nhead.nh_type = 0;
	nhead.nh_flags = 0;
	nhead.nh_length = 0;
	nhead.nh_msg = 0;

	mask = ksigblock(sigmask(SIGUDIE) | sigmask(SIGARREST));

	if (nsend(&nhead)) {
		ksigsetmask(mask);
		return(LAMERROR);
	}

	nhead.nh_event = -getpid();

	if (nrecv(&nhead)) {
		ksigsetmask(mask);
		return(LAMERROR);
	}

	if (reply->fr_errno != 0) {
		errno = reply->fr_errno;
		ksigsetmask(mask);
		return(LAMERROR);
	}

	ksigsetmask(mask);
	return(reply->fr_ret);
}

/*
 * backwards compatibility
 */
int4 rflseek(fd, offset, whence) int fd, whence; int4 offset;
	{ return(lam_rflseek(fd, offset, whence)); }
