/*
 *	Ohio Trollius
 *	Copyright 1993 The Ohio State University
 *	GDB
 *
 *	$Log:	echod.c,v $
 * Revision 6.1  96/11/23  19:57:06  nevin
 * Ohio Release
 * 
 * Revision 6.0  96/02/29  13:44:41  gdburns
 * Ohio Release
 * 
 * Revision 5.2  94/08/22  13:55:55  gdburns
 * Ohio Release
 * 
 * Revision 5.1  94/05/18  10:45:38  gdburns
 * Ohio Release
 * 
 * Revision 2.3  94/04/22  12:33:53  gdburns
 * Ohio Release
 * 
 * Revision 2.2.1.4  93/12/05  17:35:23  gdburns
 * Convert to internal process.
 * 
 *	Function:	- echo server
 *			- receives a message and echos it back to the sender
 *			- primarily a diagnostic tool
 *			- message size limited to MAXNMSGLEN
 */

#include <events.h>
#include <ereq.h>
#include <net.h>

/*
 * local variables
 */
static char		msg[MAXNMSGLEN];	/* echo message */
static struct nmsg	nhead;			/* echo network message */

/*
 * global functions
 */
void			(*(e_init()))();
void			(*(echod()))();

/*
 *	e_init
 *
 *	Function:	- echod initialization
 */
void (*(
e_init()))()

{
/*
 * Attach to kernel.
 */
	if (lpattach("echod")) {
		panic("echod (lpattach)");
	}
/*
 * Receive first request.
 */
	nhead.nh_event = EVECHOD;
	nhead.nh_type = 0;
	nhead.nh_flags = 0;
	nhead.nh_length = MAXNMSGLEN;
	nhead.nh_msg = msg;

	if (nrecv(&nhead)) {
		panic("echod (nrecv)");
	}

	return((void (*)()) echod);
}

/*
 *	echod
 *
 *	Function:	- server loop
 *			- replies message & receives next request
 */
void
(*(echod()))()

{
	struct ereq	*request;		/* request from client */

	request = (struct ereq *) nhead.nh_data;
/*
 * Reply to the request.
 */
	nhead.nh_node = request->eq_node;
	nhead.nh_event = request->eq_event;
	nhead.nh_flags = NREEL;
	nhead.nh_msg = msg;

	if (nsend(&nhead)) {
		panic("echod (nsend)");
	}
/*
 * Receive a request.
 */
	nhead.nh_event = EVECHOD;
	nhead.nh_type = 0;
	nhead.nh_flags = 0;
	nhead.nh_length = MAXNMSGLEN;
	nhead.nh_msg = msg;

	if (nrecv(&nhead)) {
		panic("echod (nrecv)");
	}

	return((void (*)()) echod);
}
