/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	NJN
 *
 *	$Id: iod.int.c,v 6.1 96/11/21 15:42:53 nevin Rel $
 *
 *	Function:	- internal IO daemon
 */

#include <typical.h>

/*
 * public functions
 */
void			(*(iod()))();
void			io_accept();
void			io_register();
void			io_deregister();

/*
 * external functions
 */
extern void		kio_intr();
extern void		kio_intr_clr();
extern void		io_forward();
extern void		io_new();

/*
 *	iod
 *
 *	Function:	- server loop
 */
void (*(
iod()))()

{
	return((void (*)()) iod);
}

/*
 *	io_accept
 *
 *	Function:	- prepare to accept client connections
 *	Accepts:	- IO server file descriptor
 */
void
io_accept(fd)

int			fd;

{
	kio_intr(fd, io_new, FALSE);
}

/*
 *	io_register
 *
 *	Function:	- register a new client connection
 *			- iod will now read and forward client data
 *	Accepts:	- client file descriptor
 */
void
io_register(fd)

int			fd;

{
	kio_intr(fd, io_forward, FALSE);
}

/*
 *	io_deregister
 *
 *	Function:	- deregister a client connection
 *			- iod will no longer read and forward client data
 *	Accepts:	- client file descriptor
 */
void
io_deregister(fd)

int			fd;

{
	kio_intr_clr(fd);
}
