/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	GDB/RBD
 *
 *	$Id: di_bootcmd.c,v 6.1 96/11/23 18:39:25 nevin Rel $
 *
 *	Function:	- obtains link information from command line
 *	Accepts:	- link array (value returned)
 *			- link array size (value returned)
 *			- argument vector length
 *			- argument vector
 */

#include <lam_config.h>
#include <sfh.h>

#include <netdb.h>			/* Solaris MAXHOSTNAMELEN */
#include <stdlib.h>
#include <sys/param.h>
#include <sys/socket.h>

#include <args.h>
#include <dl_inet.h>
#include <terror.h>
#include <typical.h>

/*
 * external functions
 */
extern int		getinetaddr();

/*
 * local variables
 */
static char		my_hname[MAXHOSTNAMELEN + 1];

int
di_bootcmd(pdilinks, pndil, argc, argv)

struct dilink		**pdilinks;
int4			*pndil;
int			argc;
char			**argv;

{
	int		dli_port;	/* datalink input port */
	int		dli_sd;		/* datalink input socket */
	int4		i;
	int4		my_link;	/* my datalink # */
	int4		ngbr_link;	/* neighbour link # */
	unsigned char	ngbr_haddr[4];	/* neighbour host address */
	unsigned char	my_haddr[4];	/* my host address */

	if ((argc % 2) != 0) {
		errno = EUSAGE;
		lampanic("dli_inet: <host>, <link> go in pairs");
	}
/*
 * Get my dli port number.
 */
	if (opt_taken('p')) {
		intparam('p', &dli_port);
	} else {
		dli_port = DLDEFPORT;
	}
/*
 * Create the inter-node communication socket.
 */
	if ((dli_sd = sfh_sock_open_srv_inet_dgm(&dli_port)) < 0) {
		lampanic("dli_inet (sfh_sock_open_srv_inet_dgm)");
	}

#if !BROKEN_SET_INET_SO_BUFSIZES
	{
		int	bufsize;		/* socket buffer size */
		int	optlen;			/* socket option length */

		optlen = sizeof(bufsize);
		if (getsockopt(dli_sd, SOL_SOCKET, SO_RCVBUF,
				(char *) &bufsize, &optlen)) {
			lampanic("dli_inet (getsockopt)");
		}

		if (bufsize < sizeof(struct dlframe) * DOMAXPENDING) {
		
			bufsize = sizeof(struct dlframe) * DOMAXPENDING;

			if (setsockopt(dli_sd, SOL_SOCKET, SO_RCVBUF,
					(char *) &bufsize, sizeof(bufsize))) {
				lampanic("dli_inet (setsockopt)");
			}
		}
	}
#endif
/*
 * Get my link #.
 */
	if (opt_taken('n')) {
		intparam('n', &my_link);
	} else {
		my_link = 0;
	}
/*
 * Get my host network address.
 */
	if (gethostname(my_hname, MAXHOSTNAMELEN + 1)) {
		lampanic("dli_inet (gethostname)");
	}

	if (getinetaddr(my_hname, my_haddr)) {
		lampanic("dli_inet (getinetaddr)");
	}

	*pndil = 0;

	for (i = 1; i < argc; i += 2) {
		*pndil = max(atoi(argv[i]), *pndil);
	}

	*pndil = max(my_link, *pndil);
	(*pndil)++;
/*
 * Create the links array.
 */
	*pdilinks = (struct dilink *) malloc((unsigned) *pndil *
			sizeof(struct dilink));
	if (*pdilinks == 0) lampanic("dli_inet (malloc)");
/*
 * Init all entries to invalid link.
 */
	for (i = 0; i < *pndil; ++i) {
		(*pdilinks)[i].dil_link = NOTLINKID;
		(*pdilinks)[i].dil_seqrecv = 0;
	}
/*
 * Parse active link information off the command line.
 */
	for (i = 0; i < (argc / 2); ++i) {
		if (getinetaddr(*argv++, ngbr_haddr))
				lampanic("dli_inet (getinetaddr)");
		ngbr_link = atoi(*argv++);

		if ((ngbr_link < 0) || (ngbr_link >= *pndil)) {
			errno = EBADLINK;
			lampanic("dli_inet");
		}

		(*pdilinks)[ngbr_link].dil_link = ngbr_link;
		sfh_sock_fill_inet_addr(ngbr_haddr, (int) dli_port,
				&((*pdilinks)[ngbr_link].dil_addr));
	}
/*
 * Set my link.
 */
	(*pdilinks)[my_link].dil_link = my_link;
	sfh_sock_fill_inet_addr(my_haddr, (int) dli_port,
			&((*pdilinks)[my_link].dil_addr));

	return(dli_sd);
}
