/*  Gtk+ User Interface Builder
 *  Copyright (C) 1998  Damon Chaplin
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
#ifndef __GLD_CONFIG_H__
#define __GLD_CONFIG_H__

#include <config.h>

/* Define GLD_HAVE_GTK_1_1 if we have GTK version 1.1 or greater. */
#if GTK_MAJOR_VERSION > 1 || (GTK_MAJOR_VERSION == 1 && GTK_MINOR_VERSION >= 1)
#define GLD_HAVE_GTK_1_1
#endif

/* Internationalization. */
#ifdef ENABLE_NLS
#include <libintl.h>
#undef _
#define _(String) dgettext (PACKAGE, String)
#ifdef gettext_noop
#define N_(String) gettext_noop (String)
#else
#define N_(String) (String)
#endif
#else
/* Stubs that do something close enough.  */
#define textdomain(String) (String)
#define gettext(String) (String)
#define dgettext(Domain,Message) (Message)
#define dcgettext(Domain,Message,Type) (Message)
#define bindtextdomain(Domain,Directory) (Domain)
#define _(String) (String)
#define N_(String) (String)
#endif


/* Debugging macros. */
#ifdef GLD_DEBUG
#define MSG(message) g_print("%s (%i): %s\n", __FILE__, __LINE__, message)
#define MSG1(message, arg) \
      g_print("%s (%i): " message "\n", __FILE__, __LINE__, arg)
#define MSG2(message, arg, arg2) \
      g_print("%s (%i): " message "\n", __FILE__, __LINE__, arg, arg2)
#define MSG3(message, arg, arg2, arg3) \
      g_print("%s (%i): " message "\n", __FILE__, __LINE__, arg, arg2, arg3)
#else
#define MSG(message)
#define MSG1(message, arg)
#define MSG2(message, arg, arg2)
#define MSG3(message, arg, arg2, arg3)
#endif


#endif	/* __GLD_CONFIG_H__ */
