{
Copyright (C) 1998-99 Free Software Foundation, Inc.

Author: Frank Heckenbach <frank@pascal.gnu.de>

Turbo Pascal 3.0 compatibility unit

This library is free software; you can redistribute it and/or modify
it under the terms of the GNU Library General Public License as published by
the Free Software Foundation, version 2.

This library is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
License for more details.

You should have received a copy of the GNU Library General Public License
along with this library; see the file COPYING.LIB.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
MA 02111-1307, USA.
}

{$if __GPC_RELEASE__ < 19981206}
{$error This unit requires GPC release 19981206 or newer}
{$endif}

unit Turbo3;

interface

uses GPC, CRT;

(*@@*) type AnyFile=File;

var
  Kbd: Text;
  CBreak: Boolean absolute CheckBreak;

procedure AssignKbd(var F: Text);
function LongFileSize(var F: AnyFile): Real;
function LongFilePos(var F: AnyFile): Real;
procedure LongSeek(var F: AnyFile; Pos: Real);
procedure NormVideo; external;
procedure HighVideo; external;
procedure LowVideo; external;

implementation

function Kbd_Read (var PrivateData; var Buffer; Size : SizeType) = Result : SizeType;
var CharBuf : array [1 .. Size] of Char absolute Buffer;
begin
  Result := 0;
  repeat
    Inc (Result);
    CharBuf [Result] := ReadKey;
    if CharBuf [Result] = #0 then CharBuf [Result] := #27
  until (Result = Size) or not KeyPressed
end;

procedure AssignKbd(var F: Text);
begin
  AssignTFDD (F, (*@@*)TOpenProc(nil), Kbd_Read, (*@@*)TWriteFunc(nil),TFlushProc(nil),TCloseProc(nil),TDoneProc(nil), nil)
end;

function LongFileSize(var F: AnyFile): Real;
begin
  LongFileSize := FileSize (F)
end;

function LongFilePos(var F: AnyFile): Real;
begin
  LongFilePos := FilePos (F)
end;

procedure LongSeek(var F: AnyFile; Pos: Real);
begin
  Seek (F, Round (Pos))
end;

to begin do
begin
  AssignKbd (Kbd);
  Reset (Kbd)
end;

end.
