/*
Copyright (C) 1998-99 Free Software Foundation, Inc.

Author: Frank Heckenbach <frank@pascal.gnu.de>

Dos/PDCurses specific include file for crtc.c

This file implements the functions, as described in crtdummy.h, for a
Dos system using PDCurses 2.3. Everything except changing the number
of screen columns is implemented.

This library is free software; you can redistribute it and/or modify
it under the terms of the GNU Library General Public License as published by
the Free Software Foundation, version 2.

This library is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
License for more details.

You should have received a copy of the GNU Library General Public License
along with this library; see the file COPYING.LIB.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
MA 02111-1307, USA.
*/

#include <signal.h>
#include <pc.h>
#include <bios.h>

struct sigaction crt_int_action  = { 0, &crt_int_handler,  { { 0 } } };
struct sigaction crt_term_action = { 0, &crt_term_handler, { { 0 } } };

static void crt_special_init ()
{
  sigaction (SIGINT,  &crt_int_action,  0);
  sigaction (SIGTERM, &crt_term_action, 0);
}

static void crt_special_done ()
{
}

static void crt_doupdate ()
{
  crt_update ();
}

static void crt_stop_update ()
{
}

void crt_settextmode (Boolean Columns40, Boolean Lines50)
{
  resize_term (Lines50 ? 50 : 25, Columns40 ? 40 : 80); /* 40 columns are not supported as of PDCurses 2.3 */
  screen_size_changed (0);
}

int crt_getshiftstate ()
{
  int state = bioskey (_KEYBRD_SHIFTSTATUS) & (shShift | shCtrl | shAlt);
  return Shiftstate | state | ((state & shAlt) ? shAltGr : 0);
}

void crt_sound (unsigned Hz)
{
  sound(Hz);
}

void crt_nosound ()
{
  nosound();
}
