{
Copyright (C) 1998-99 Free Software Foundation, Inc.

Author: Frank Heckenbach <frank@pascal.gnu.de>

Demo program for the GetOpt unit

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, version 2.

This program is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
MA 02111-1307, USA.
}

program GetOptDemo;

uses GetOpt;

var
  ch : Char;
  i, LongIndex, LongOptFlag : Integer;

const
  LongOptions : array [1 .. 4] of OptionType =
    (('x',      NoArgument,       nil,          Ord ('x')),
     ('noarg',  NoArgument,       @LongOptFlag, 1),
     ('reqarg', RequiredArgument, @LongOptFlag, 2),
     ('optarg', OptionalArgument, @LongOptFlag, 3));

begin
  if ParamCount = 0 then
    begin
      Writeln (StdErr, 'GetOpt demo');
      Writeln (StdErr, 'Usage: ', ParamStr (0),
                       ' [-n] [-r foo] [-o[bar]] [--noarg] [--reqarg foo] ');
      Writeln (StdErr, '       [--optarg bar] [--x] [baz...]');
      Halt (1)
    end;
  LongIndex := - 1;
  OptErr := 1;
  repeat
    ch := GetOptLong ('nr:o::', LongOptions, @LongIndex, True);
    if ch = EndOfOptions then Break; (*@@fjf287*)
    case ch of
      NoOption      : Write ('no-option argument');
      UnknownOption : if OptOpt = OptOptLong
                        then Write ('(incorrect long option)')
                        else Write ('unknown option `', Chr (OptOpt), '''');
      LongOption    : with LongOptions [LongIndex + Low (LongOptions)] do
                        begin
                          Write ('long option `', CString2String (Name), '''');
                          if LongOptFlag <> LongIndex then
                            Write (' <internal error> ')
                        end;
      else            Write ('option `', ch, '''')
    end;
    if OptArg = nil
      then Writeln
      else Writeln (' with argument `', CString2String (OptArg), '''');
  until False;
  if (OptInd < 1) or (OptInd > ParamCount + 1) then
    begin
      Writeln ('Internal error with OptInd.');
      Halt (2)
    end;
  if OptInd <= ParamCount then Writeln ('Remaining arguments:');
  for i := OptInd to ParamCount do Writeln (ParamStr (i))
end.
