/*
 *	VME Linux/m68k Loader
 *
 *	(c) Copyright 1997 by Nick Holgate
 *
 *	This file is subject to the terms and conditions of the GNU General Public
 *	License.  See the file COPYING for more details.
 */

/*--------------------------------------------------------------------------*/

#include <linux/linkage.h>
#include <linux/types.h>

/*--------------------------------------------------------------------------*/
/*  Program Entry
 */

__asm(".text\n"
__ALIGN_STR "\n"
".globl " SYMBOL_NAME_STR(_start) ";\n"
SYMBOL_NAME_STR(_start) ":
	jbra	(" SYMBOL_NAME_STR(Main) ")
");

/*--------------------------------------------------------------------------*/

#include "mvmebug.h"

/*--------------------------------------------------------------------------*/

void
Main
(	void
)
{
	asm volatile (
	"
		move.l	%%d0,-(%%a7)
		lea.l	0x70(%%a1),%%a1
	1:
		move.b	%%d0,1(%%a1)
		move.l	%%a1,-(%%a7)
		trap	#15
		dc.w	0x0010
		tst.w	2(%%a1)
		beq.s	2f
		trap	#15
		dc.w	0x0063
	2:
		lea.l	0x10(%%a1),%%a1
		tst.b	(%%a1)
		beq.s	1b
		jsr		0x10000
	"
	: /* no outputs */
	: /* no inputs  */
	: "a1", "d0"
	);
}

/*-----------------------------< end of file >------------------------------*/
