/* Prompt handling
   
   Copyright (C) 1996 Maurizio Plaza
   		 1996 Jakub Jelinek
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include "silo.h"

char cbuff[CMD_LENG];
char passwdbuff[CMD_LENG];

void cmdinit ()
{
    cbuff[0] = 0;
    passwdbuff[0] = 0;
}

void cmdedit (void (*tabfunc) (void), int password)
{
    int x, c;
    char *buff = password ? passwdbuff : cbuff;

    for (x = 0; x < CMD_LENG - 1; x++) {
	if (buff[x] == 0)
	    break;
	else if (password)
	    prom_puts ("*", 1);
    }
    if (!password)
        prom_puts (buff, x);

    for (;;) {
	c = prom_getchar ();
	if (c == -1)
	    break;
	if (c == '\n' || c == '\r') {
	    break;
	}
	if (c == '\t' && tabfunc)
	    (*tabfunc) ();
	if (c == '\b' || c == 0x7F) {
	    if (x > 0) {
		--x;
		prom_puts ("\b \b", 3);
	    }
	} else if ((c & 0xE0) != 0) {
	    if (x < CMD_LENG - 1) {
		buff[x] = c;
		buff[x + 1] = 0;
		if (password)
			prom_puts ("*", 1);
		else
			prom_puts (buff + x, 1);
		x++;
	    }
	}
    }

    buff[x] = 0;
}

