.TH UPDATED-PACKAGES 8 
.\" NAME should be all caps, SECTION should be 1-8, maybe w/ subsection
.\" other parms are allowed: see man(7), man(1)
.SH NAME
updated-packages \- list Debian packages for which a newer version is available.
.SH SYNOPSIS
.B updated-packages
.RB [\| \-\-old \|]
.I status-file available-file
\&.\|.\|.
.SH DESCRIPTION
This script is a part of the
.B dpkg-mountable
package for Debian GNU/Linux, which implements an intelligent package
installation based on the available versions of packages. Under normal
operation it will not be used independently, but is provided in case it is
useful to somebody; see especially the
.B \-\-old
switch.

The script takes as arguments the pathname of the dpkg status file, followed
by that of one or more 
.I available 
files, containing a summary of the packages available on your local mirror.
It parses these files to work out what files have changed on the mirror
compared to your current installation and which packages need reinstalling,
and sends this list to stdout.

.SS "Output Format"

The list has one line per package, made up of a number of TAB-separated
fields:
.br
.I package\-name filename current\-version new\-version md5sum priority
.br
which are defined as follows:
.br
.TP
.I package\-name
the name of the package
.TP
.I filename
the name of the .deb file containing the package, relative
to the root of the distribution. This is the 
.B Filename:
field from the available file.
.TP
.IR current\-version \|, new-version
The versions currently installed on the system and offered in the available
file. At the time of writing, 
.I current\-version
is empty if the package is not installed, or if the installation is broken;
however, there are plans to add a set of flags for the broken packages,
which will probably begin with 
.RB `!'.
.TP
.I md5sum
the MD5 checksum of the .deb file, taken from the available file.
.TP
.I priority
the priority field for this package.

Some attempt is made to order the list for installation: packages are
ordered first by priority, and then alphabetically by package name.

.SS "Removal of Out-of-date Packages"
If the
.B \-\-old
switch is passed, instead of listing packages which should be installed, 
.B updated\-packages
lists those packages which have already been installed, and may safely be
deleted (on the assumption that the files are only required for this one
machine). The list is exactly the same as above.

This option is good if you are keeping a local directory of packages which
you've downloaded, say, and want to keep it tidy to save disk space. See 
.B /usr/doc/dpkg-mountable/README.old-pkgs
for more information on this.
.SH OPTIONS
.TP
.B \-\-available
I'm not really sure what this option does; have a play with it. It's
something to do with the list of packages which is taken from the status
file; possibly it was designed to give a list of new packages. I'm fairly
sure it's never been used, and may only be half-coded.
.TP
.B \-\-old
List up-to-date packages rather than new packages.
.SH BUGS
This script was  designed to be an internal engine for 
.BR dpkg\-mountable ,
and so is not expected to be particularly robust. Of course, if you do find
any bugs, do let me know and I'll do my best to fix them.

On my machine, the script runs fairly slowly. I have a couple of ideas, but
if optimising perl is your thing, I'd appreciate a hand.
.SH AUTHOR
Andy Mortimer <andy.mortimer@poboxes.com>
