#include <config.h>
#include <gnome.h>
#include "properties.h"
#include "procbar.h"
#include "procview.h"
#include "fsview.h"
#include "fsusage.h"

GList *gtop_properties_hook = NULL;

GTopProperties gtop_temp_properties;
GTopProperties gtop_properties;

static GtkWidget *win = NULL;

static void
properties_close (void)
{
	win = NULL;
}

static void
properties_hook_init (GtkWidget *win)
{
	GList *c;

	for (c = gtop_properties_hook; c; c = c->next) {
		GTopPropertiesHook *hook = c->data;
		
		if ((hook == NULL) || (hook->init_func == NULL))
			continue;
		
		hook->init_func (hook, win);
	}
}

static void
properties_hook_apply (void)
{
	GList *c;

	for (c = gtop_properties_hook; c; c = c->next) {
		GTopPropertiesHook *hook = c->data;
		
		if ((hook == NULL) || (hook->apply_func == NULL))
			continue;
		
		hook->apply_func (hook);
	}
}

static void
properties_hook_update (void)
{
	GList *c;

	for (c = gtop_properties_hook; c; c = c->next) {
		GTopPropertiesHook *hook = c->data;
		
		if ((hook == NULL) || (hook->update_func == NULL))
			continue;
		
		hook->update_func (hook);
	}
}

static void
properties_hook_load (void)
{
	GList *c;

	for (c = gtop_properties_hook; c; c = c->next) {
		GTopPropertiesHook *hook = c->data;
		
		if ((hook == NULL) || (hook->load_func == NULL))
			continue;
		
		hook->load_func (hook);
	}
}

static void
properties_hook_save (void)
{
	GList *c;

	for (c = gtop_properties_hook; c; c = c->next) {
		GTopPropertiesHook *hook = c->data;
		
		if ((hook == NULL) || (hook->save_func == NULL))
			continue;
		
		hook->save_func (hook);
	}
}

static void
properties_apply (void)
{
	properties_hook_apply ();

	memcpy (&gtop_properties, &gtop_temp_properties, sizeof (GTopProperties));

	properties_hook_update ();

	properties_hook_save ();
}

void
gtop_properties_changed (void)
{
        gnome_property_box_changed (GNOME_PROPERTY_BOX (win));
}

void
gtop_show_properties (void)
{
	GtkWidget *vb, *vbox, *frame, *label, *button, *spin, *table;
	GSList *group;
	gint i;

	memcpy (&gtop_temp_properties, &gtop_properties, sizeof (GTopProperties));

	if (win) {
		gdk_window_raise (win->window);

		return;
	}
	
	win = gnome_property_box_new ();

	properties_hook_init (win);

	gtk_signal_connect (GTK_OBJECT (win), "apply",
			    GTK_SIGNAL_FUNC(properties_apply), NULL);

	gtk_signal_connect (GTK_OBJECT (win), "destroy",
			    GTK_SIGNAL_FUNC(properties_close), NULL);

	gtk_widget_show_all (win);
}

void
gtop_init_properties (void)
{
	properties_hook_load ();
}
