/*
 * $Id: main_panel.h,v 1.2 1998/05/03 02:20:39 gregm Exp $
 * GXSNMP -- An snmp mangament application
 * Copyright (C) 1998 Gregory McLean & Jochen Freidrich
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc.,  59 Temple Place - Suite 330, Cambridge, MA 02139, USA.
 *
 * Main panel code. (actually the 'control panel' of sorts
 */
#ifndef __MAIN_PANEL_H__
#define __MAIN_PANEL_H__

#define CONTROL_KNOWN_HOSTS        0
#define CONTROL_KNOWN_NETWK        1
#define CONTROL_ALARM_OUTSD        2
#define CONTROL_EVENT_PENDG        3
#define CONTROL_TASKS_PENDG        4

/*
 * Exported functions in this module, all modules/panels should
 * at the very least provide the following functions.
 */

/*
 * Initilizing (creation)
 */
void        open_control_panel          (void);

/*
 * Finialization (closeing)
 */
void        destroy_control_panel       (void);

/*
 * Hiding (iconization/docking or what have you)
 */
void        hide_control_panel          (void);

/*
 * Reset the panel to a known state.
 */
void        reset_control_panel         (void);
/*
 * All else can be considered optional
 */
void        update_known_hosts          (int i);
void        update_known_networks       (int i);

#endif
/* EOF */
