#include <stdio.h>
#include "dinstall.h"
#include INCLINGUA

#ifdef NFSROOT
static struct fdisk_partition* select_NFS_server(void);
#endif

struct fdisk_partition *
select_not_mounted( const char *message, const char *title, int ntypes, ... ) {
	struct fdisk_partition *p,**plist;
	struct d_choices *choices;
	va_list argp;
	char *name, *fstypes_list=NULL;
	int fstype,rs,i,items=0;
#ifdef NFSROOT
	int addnfs=0;
#endif

	choices=malloc(5*sizeof(struct d_choices));
	plist=malloc(5*sizeof(struct fdisk_partition *));

	if (ntypes) {
		va_start (argp, ntypes); 
		for (i = 0; i < ntypes; i++) {
			fstype= va_arg(argp, int);		
			if (fstype==FSTYPE_EXTPART) {
				name="extended";
			} else {
				name = fstype_name[fstype];
			}
#ifdef NFSROOT
			if (fstype == FSTYPE_NFS) {
				addnfs=1;
			} else 
#endif
			{
				p = fdisk_partitions_by_type[fstype];
				if (fstypes_list)
					addtolist(&fstypes_list,name);
				else
					fstypes_list = strdup(name);
				while (p) {
					if (! p->in_use){
						choices[items].string=p->name;
						choices[items].tag=NULL;
						choices[items].state=0;
						plist[items]=p;
						items++;
						if ((items%5)==0) {
							choices = realloc(choices,(items+5)*sizeof(struct d_choices));
							plist = realloc(plist,(items+5)*sizeof(struct fdisk_partition *));
						}
					}
					p = p->next_by_type;
				}
			}
		}
		va_end (ap);
	} else {
/* Offer NFS only when explicitely requested */
		p = fdisk_partitions;
		while (p) {
			if (! p->in_use){
				choices[items].string=p->name;
				choices[items].tag=NULL;
				choices[items].state=0;
				plist[items]=p;
				items++;
				if ((items%5)==0) {
					choices = realloc(choices,(items+5)*sizeof(struct d_choices));
					plist = realloc(plist,(items+5)*sizeof(struct fdisk_partition *));
				}
			}
			p = p->next;
		}
	}

#ifdef NFSROOT
	if (addnfs) {
		choices[items].string="NFS";
		choices[items].tag=NULL;
		choices[items].state=0;
		plist[items]=NULL;
		items++;
		if ((items%5)==0) {
			choices = realloc(choices,(items+5)*sizeof(struct d_choices));
			plist = realloc(plist,(items+5)*sizeof(struct fdisk_partition *));
		}
	}
#endif
/* FIXME Add "loop" and "manual" options. */

	p = NULL;
	if (! items){
		if (ntypes) {
			sprintf(prtbuf,MSG_ERROR_NO_X_PARTITIONS,fstypes_list);
			problemBox(prtbuf,MSG_PROBLEM);
		} else {
			problemBox(MSG_ERROR_NO_PARTITIONS,MSG_PROBLEM);
		}
	} else {
		rs = menuBox(message, title, choices, items, 1);
		if (rs != -1) {
			p = plist[rs];
#ifdef NFSROOT
			if ((p == NULL) && (0 == strcmp(choices[rs].string,"NFS"))) {
				p=select_NFS_server();
			}
#endif
/* FIXME
			if (loop) select_loop blah, blah...
			if (manually) select_manually blah, blah...
*/
		}
	}

	free(plist);
	free(choices);
	return(p);
}


#ifdef NFSROOT
static struct fdisk_partition*
select_NFS_server(void)
{
	char *nfsmountpath;
	static char *preventry=NULL;
	struct fdisk_partition *p;

	sprintf(prtbuf,"modprobe nfs");
	system(prtbuf);
	/* keep user entry between calls to choose_NFS_server */
	for(;;) {
		if (!preventry) preventry=strdup("");
		nfsmountpath=inputBox(MSG_CHOOSE_NFS_ANY,MSG_CHOOSE_NFS_ANY_T,preventry);
		if (! nfsmountpath) return NULL;
		free(preventry);
		preventry=nfsmountpath;
		/* repeat the loop until the path entered is not already mounted */
		if (! fdisk_find_partition_by_name(nfsmountpath))
			break;
	}
	p=fdisk_add_partition(nfsmountpath,-1,PTYPE_NFS,0);
	return p;
}
#endif

#ifdef _STESTING_
/*
 * To test, compile using: make select_not_mounted_test
 */
int main() {
	Archive_Dir=NULL;
	disqtype=base;
	InstallationRootDevice=strdup("/dev/sdc");
    
	initScreen("select_not_mounted");
	select_not_mounted(MSG_SELECT_INITIALIZE,MSG_SELECT_PARTITION,1,FSTYPE_EXT2);
	select_not_mounted(MSG_ROOT_IS_LOGICAL,MSG_SELECT_PARTITION, 1,FSTYPE_EXTPART);
	select_not_mounted(MSG_SELECT_PARTITION_ARCHIVE,MSG_SELECT_PARTITION, 5,FSTYPE_EXT2,FSTYPE_MINIX,FSTYPE_MSDOS,FSTYPE_AFFS,FSTYPE_HFS);
        
	finishScreen();
	return 0;
}
#endif
