#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include "dinstall.h"
#include INCLINGUA

#ifdef _TESTING_
#  define RELEASE_FILE	"../../scripts/rootdisk/messages/" LINGUA "/release_notes"
#else
#  define RELEASE_FILE	"/release_notes"
#endif

int release_notes (void) {
	struct stat s;
	int fd, num;
	char *buf;

	if ( NAME_ISREG(RELEASE_FILE, &s) && 
	     ( (fd=open(RELEASE_FILE, O_RDONLY)) >= 0 ) ) {
		buf = (char *) malloc (s.st_size+1);
		num = read (fd, buf, s.st_size);
		close(fd);
		buf[s.st_size] = '\0';
		wideMessageBox(buf, MSG_RELEASE_NOTES);
	}
	return (0);
}

#ifdef _TESTING_
/* To test, compile using: make release_notes_test */
void main(void){
	initScreen("Release Notes test program");

	release_notes();

	finishScreen();
}
#endif

