// scheddlg.C
//
// This program is free software. See the file COPYING for details.
// Author: Mattias Engdegrd, 1997, 1998

#include <sched.h>

#include "scheddlg.h"
#include "dialogs.h"

#include <qpushbt.h>
#include <qaccel.h>
#include <qstring.h>

SchedDialog::SchedDialog(int policy, int prio)
         : QDialog(0, 0, TRUE)
{
    setCaption("Change scheduling");

    QPushButton *ok, *cancel;
    ok = new QPushButton("OK", this);
    ok->setGeometry(70, 130, 64, 24);
    connect(ok, SIGNAL(clicked()), SLOT(done_dialog()));
    cancel = new QPushButton("Cancel", this);
    cancel->setGeometry(310, ok->y(), ok->width(), ok->height());
    connect(cancel, SIGNAL(clicked()), SLOT(reject()));
    ok->setDefault(TRUE);

    bgrp = new QButtonGroup("Scheduling Policy", this);
    rb_other = new QRadioButton("SCHED_OTHER (time-sharing)",
					      bgrp);
    rb_other->setGeometry(10, 20, 220, 25);
    rb_fifo = new QRadioButton("SCHED_FIFO (real-time)", bgrp);
    rb_fifo->setGeometry(rb_other->x(), rb_other->y() + 25,
			 rb_other->width(), rb_other->height());
    rb_rr = new QRadioButton("SCHED_RR (real-time)", bgrp);
    rb_rr->setGeometry(rb_fifo->x(), rb_fifo->y() + 25,
		       rb_other->width(), rb_other->height());
    bgrp->setGeometry(10, 10, 240, 105);
    connect(bgrp, SIGNAL(clicked(int)), SLOT(button_clicked(int)));

    int active = 0;
    switch(policy) {
    case SCHED_OTHER:
	active = 0; break;
    case SCHED_FIFO:
	active = 1; break;
    case SCHED_RR:
	active = 2; break;
    }
    ((QRadioButton *)(bgrp->find(active)))->setChecked(TRUE);
    out_policy = policy;
    out_prio = prio;

    lbl = new QLabel("Priority (1-99):", this);
    lbl->setGeometry(bgrp->x() + bgrp->width() + 10,
		     bgrp->y() + (rb_fifo->y() + rb_rr->y()) / 2,
		     110, 30);

    lined = new QLineEdit(this);
    QFont f = font();
    f.setBold(FALSE);
    lined->setFont(f);
    lined->resize(60, lined->sizeHint().height());
    lined->move(lbl->x() + lbl->width(),
		lbl->y() + (lbl->height() - lined->height()) / 2);
    lined->setMaxLength(4);
    QString s(4);
    s.setNum(prio);
    lined->setText(s);

    button_clicked(active);

    // make sure return and escape work as accelerators
    connect(lined, SIGNAL(returnPressed()), SLOT(done_dialog()));
    QAccel *acc = new QAccel(this);
    acc->connectItem(acc->insertItem(Key_Escape), this, SLOT(reject()));
}

void SchedDialog::done_dialog()
{
    if(rb_rr->isChecked())
	out_policy = SCHED_RR;
    else if(rb_fifo->isChecked())
	out_policy = SCHED_FIFO;
    else
	out_policy = SCHED_OTHER;
    QString s(lined->text());
    bool ok;
    out_prio = s.toInt(&ok);
    if(out_policy != SCHED_OTHER && (!ok || out_prio < 1 || out_prio > 99)) {
	MessageDialog::message("Invalid input",
			       "The priority must be in the range 1..99",
			       "OK", MessageDialog::warningIcon());
    } else
	accept();
}

void SchedDialog::button_clicked(int id)
{
    if(id == 0) {
	lbl->setEnabled(FALSE);
	lined->setEnabled(FALSE);
    } else {
	QString s(lined->text());
	bool ok;
	int n = s.toInt(&ok);
	if(ok && n == 0)
	    lined->setText("1");
	lbl->setEnabled(TRUE);
	lined->setEnabled(TRUE);

	lined->setFocus();
	lined->selectAll();
    }
}

