#include <qmsgbox.h> 

#include "icqfunctions.h"


//-----InfoField::constructor----------------------------------------------------------------------
InfoField::InfoField(int x, int y, int len, char *title, bool isReadOnly, QWidget *parent)
{
   int t;
   if (title != NULL) 
   {
      lblTitle = new QLabel(title, parent);
      lblTitle->setGeometry(x, y, 45, 20);
      t = 50;
   }
   else t = 0;

   readOnly = isReadOnly;
   if (readOnly) 
   {
      lblInfo = new QLabel(parent);
      lblInfo->setFrameStyle(QFrame::WinPanel | QFrame::Sunken);
      lblInfo->setGeometry(x + t, y, len, 20);
   }
   else
   {
      edtInfo = new QLineEdit(parent);
      edtInfo->setGeometry(x + t, y, len, 20);
   }
   
}


void InfoField::setData(char *data)
{
   if (readOnly) lblInfo->setText(data);
   else edtInfo->setText(data);
}


//-----ICQFunctions::constructor-------------------------------------------------------------------
ICQFunctions::ICQFunctions(ICQ *s, QWidget *parent, const char *name) : QTabDialog(parent, name)
{
   server = s;
   icqEvent = NULL;
   setGeometry(100, 100, 400, 360);
   setMinimumSize(400, 360);
   setMaximumSize(400, 360);
   setApplyButton();
   setCancelButton("Close");
   
   // get rid of the stupid OK button
   QPushButton *okButton = CHILD(this,QPushButton,"ok");
   okButton->hide();
   btnApply = CHILD(this, QPushButton, "apply settings");
   
   tabLabel[TAB_READ] = new char[16];
   strcpy(tabLabel[TAB_READ], "View Event");
   fcnTab[TAB_READ] = new QWidget(this, tabLabel[TAB_READ]);
   msgView = new MsgView(fcnTab[TAB_READ]);
   msgView->setGeometry(5, 5, 360, 100);
   msgView->setFrameStyle( QFrame::WinPanel | QFrame::Sunken);
   mleRead = new MLEditWrap(true, fcnTab[TAB_READ]);
   mleRead->setGeometry(5, 110, 360, 170);
   mleRead->setFrameStyle( QFrame::WinPanel | QFrame::Sunken);
   mleRead->setReadOnly(true);   
   connect (msgView, SIGNAL(doubleClicked(QListViewItem *)), this, SLOT(printMessage(QListViewItem *)));

   tabLabel[TAB_SEND] = new char[16];
   strcpy(tabLabel[TAB_SEND], "Send Event");
   fcnTab[TAB_SEND] = new QWidget(this, tabLabel[TAB_SEND]);
   grpCmd = new QButtonGroup("Select Function", fcnTab[TAB_SEND]);
   grpCmd->setGeometry(5, 5, 320, 60);
   grpCmd->setExclusive(true);
   rdbMsg = new QRadioButton("Message", grpCmd);
   rdbMsg->setGeometry(10, 15, 90, 20);
   rdbMsg->setChecked(true);
   rdbUrl = new QRadioButton("URL", grpCmd);
   rdbUrl->setGeometry(110, 15, 90, 20);
   rdbUrl->setChecked(true);
   rdbAway = new QRadioButton("Check Away Msg", grpCmd);
   rdbAway->setGeometry(170, 15, 120, 20);
   rdbAway->setChecked(true);
   rdbChat = new QRadioButton("Chat Request", grpCmd);
   rdbChat->setGeometry(10, 35, 90, 20);
   rdbFile = new QRadioButton("File Transfer", grpCmd);
   rdbFile->setGeometry(110, 35, 100, 20);
   rdbFile->setEnabled(false);
   connect(grpCmd, SIGNAL(clicked(int)), this, SLOT(specialFcn(int)));
   lblDescription = new QLabel(fcnTab[TAB_SEND]);
   lblDescription->setGeometry(5, 70, 120, 20);   
   mleSend = new MLEditWrap(true, fcnTab[TAB_SEND]);
   mleSend->setGeometry(5, 90, 360, 120);
   mleSend->setFrameStyle( QFrame::WinPanel | QFrame::Sunken);
   msgVal = new char[2];
   lblItem = new QLabel(fcnTab[TAB_SEND]);
   lblItem->setGeometry(5, 220, 80, 20);
   edtItem = new QLineEdit(fcnTab[TAB_SEND]);
   edtItem->setGeometry(70, 220, 295, 20);
   chkSendServer = new QCheckBox("Send through server", fcnTab[TAB_SEND]);
   chkSendServer->setGeometry(5, 250, 150, 20);
   chkSpoof = new QCheckBox("Spoof Message:", fcnTab[TAB_SEND]);
   chkSpoof->setGeometry(140, 250, 150, 20);
   edtSpoof = new QLineEdit(fcnTab[TAB_SEND]);
   edtSpoof->setGeometry(250, 250, 115, 20);
   edtSpoof->setEnabled(false);
   edtSpoof->setMaxLength(10);
   edtSpoof->setValidator(new QIntValidator(0, 2147483647, edtSpoof));
   connect(chkSpoof, SIGNAL(toggled(bool)), edtSpoof, SLOT(setEnabled(bool)));
   
   tabLabel[TAB_USERINFO] = new char[16];
   strcpy(tabLabel[TAB_USERINFO], "User Info");
   fcnTab[TAB_USERINFO] = new QWidget(this, tabLabel[TAB_USERINFO]);
   nfoAlias = new InfoField(5, 5, 100, "Alias:", false, fcnTab[TAB_USERINFO]);
   nfoStatus = new InfoField(5, 35, 100, "Status:", true, fcnTab[TAB_USERINFO]);
   nfoFirstName = new InfoField(5, 65, 100, "Name:", false, fcnTab[TAB_USERINFO]);
   nfoLastName = new InfoField(160, 65, 195, NULL, false, fcnTab[TAB_USERINFO]);
   nfoEMail = new InfoField(5, 95, 300, "EMail:", false, fcnTab[TAB_USERINFO]);   
   nfoHistory = new InfoField(5, 125, 300, "History:", false, fcnTab[TAB_USERINFO]);
   nfoUin = new InfoField(180, 5, 130, "UIN:", true, fcnTab[TAB_USERINFO]);
   nfoIp = new InfoField(180, 35, 130, "IP:", true, fcnTab[TAB_USERINFO]); 
   boxAwayMsg = new QGroupBox (fcnTab[TAB_USERINFO]);
   boxAwayMsg->setGeometry(5, 160, 270, 120);
   boxAwayMsg->setFrameStyle(QFrame::Box | QFrame::Sunken);
   boxAwayMsg->setAlignment(AlignLeft);                               
   boxAwayMsg->setTitle("Away Message");   
   mleAwayMsg = new MLEditWrap(true, boxAwayMsg);
   mleAwayMsg->setReadOnly(true);
   mleAwayMsg->setGeometry(10, 15, 245, 95);
   btnSave = new QPushButton("Save Info", fcnTab[TAB_USERINFO]);
   btnSave->setGeometry(290, 220, 80, 25);
   connect(btnSave, SIGNAL(clicked()), this, SLOT(saveUserInfo()));
   
   tabLabel[TAB_HISTORY] = new char[16];
   strcpy(tabLabel[TAB_HISTORY], "History");
   fcnTab[TAB_HISTORY] = new QWidget(this, tabLabel[TAB_HISTORY]);
   mleHistory = new MLEditWrap(true, fcnTab[TAB_HISTORY]);
   mleHistory->setGeometry(5, 5, 360, 240);
   chkEditHistory = new QCheckBox("History read only", fcnTab[TAB_HISTORY]);
   chkEditHistory->setGeometry(100, 250, 150, 20);
   connect(chkEditHistory, SIGNAL(toggled(bool)), mleHistory, SLOT(setReadOnly(bool)));
   btnSaveHistory = new QPushButton("Save", fcnTab[TAB_HISTORY]);
   btnSaveHistory->setGeometry(5, 250, 80, 25);
   connect (btnSaveHistory, SIGNAL(clicked()), this, SLOT(saveHistory()));
   
   addTab(fcnTab[TAB_READ], tabLabel[TAB_READ]);
   addTab(fcnTab[TAB_SEND], tabLabel[TAB_SEND]);
   addTab(fcnTab[TAB_USERINFO], tabLabel[TAB_USERINFO]);
   addTab(fcnTab[TAB_HISTORY], tabLabel[TAB_HISTORY]);
  
   lblProgress = new QLabel (this);
   lblProgress->setGeometry(10, 330, 180, 20);
   lblProgress->setFrameStyle(QFrame::Box | QFrame::Raised);
   
   connect (chkSpoof, SIGNAL(clicked()), this, SLOT(setSpoofed()));
   connect (this, SIGNAL(selected(const char *)), this, SLOT(tabSelected(const char *)));
   connect (server, SIGNAL(doneUserFcn(bool, ICQEvent *)), this, SLOT(doneFcn(bool, ICQEvent *)));
   connect (this, SIGNAL(cancelButtonPressed()), this, SLOT(hide()));
   connect (this, SIGNAL(applyButtonPressed()), this, SLOT(callFcn()));

}


//-----ICQFunctions::setup-------------------------------------------------------------------------
void ICQFunctions::setup(ICQUser *u, int index, bool isAutoClose)
{
   theUser = u;
   autoClose = isAutoClose;
   clear();
   setInfo();
   
   // mark the user as no longer new if they are new
   if (theUser->newUser()) 
   {
      theUser->setNewUser(false);
      theUser->saveInfo();
      emit updatedUsers();
   }
   
   if (server->icqOwner.status() == ICQ_STATUS_OFFLINE) btnApply->setEnabled(false);
   show();
   tabBar()->setCurrentTab(index);
}


//-----ICQFunctions::clear-------------------------------------------------------------------------
void ICQFunctions::clear(void)
{
   lblProgress->hide();
   //mleRead->clear();
   //msgView->clear();
   //mleSend->clear();
   if (theUser->status() == ICQ_STATUS_OFFLINE)
   {
      chkSendServer->setChecked(true);
      rdbAway->setEnabled(false);
   }
   else
   {
      chkSendServer->setChecked(false);
      rdbAway->setEnabled(true);
   }
   if (theUser->status() == ICQ_STATUS_ONLINE) rdbAway->setEnabled(false);
   chkSpoof->setChecked(false);
   //edtSpoof->setText("");
   //edtItem->setText("");
   rdbMsg->setChecked(true);
   specialFcn(0);
   mleHistory->setReadOnly(true);
   //mleHistory->clear();
   chkEditHistory->setChecked(true);
}


//-----ICQFunctions::setInfo-----------------------------------------------------------------------
void ICQFunctions::setInfo(void)
{
   // read tab
   for (short i = theUser->numMessages() - 1; i >= 0; i--) 
   {
      (void) new MsgViewItem(theUser->getMessage(i), i, msgView);
   }
   
   // print the first event if it's a message
   MsgViewItem *e = (MsgViewItem *)msgView->firstChild();
   if (e != NULL && (e->msg.cmd() == ICQ_CMDxTCP_START || e->msg.cmd() == ICQ_CMDxRCV_SYSxMSGxONLINE) && e->msg.subCmd() == ICQ_CMDxTCP_MSG)
   {
      msgView->setSelected(e, true);
      printMessage(e);
   }

   // send tab
   if (chkSendServer->isEnabled()) chkSendServer->setChecked(theUser->sendServer());
   if (theUser->status() == ICQ_STATUS_OFFLINE) 
   {
      chkSendServer->setChecked(true);
      chkSendServer->setEnabled(false);
   }

   // info tab
   struct UserStatusline us;   
   theUser->getStatusInfo(us);
   nfoAlias->setData(us.alias);
   nfoStatus->setData(us.status);
   nfoFirstName->setData(us.firstname);
   nfoLastName->setData(us.lastname);
   nfoEMail->setData(us.email);
   nfoHistory->setData(us.history);
   nfoUin->setData(us.uin);
   nfoIp->setData(us.ip_port);
   mleAwayMsg->setText(us.awayMessage);

   char title[128];
   sprintf(title, "Functions for %s (%s)", us.alias, us.name);
   setCaption(title);
   setIconText(us.alias);
}


//-----ICQFunctions::tabSelected-------------------------------------------------------------------
void ICQFunctions::tabSelected(const char *tab)
{
   if (strcmp(tab, tabLabel[TAB_SEND]) == 0) 
   { 
      setApplyButton("Send"); 
      currentTab = TAB_SEND; 
   }
   else if (strcmp(tab, tabLabel[TAB_USERINFO]) == 0) 
   { 
      setApplyButton("Update"); 
      currentTab = TAB_USERINFO; 
   }
   else if (strcmp(tab, tabLabel[TAB_READ]) == 0) 
   { 
      setApplyButton("Ok"); 
      currentTab = TAB_READ;
   }
   else if (strcmp(tab, tabLabel[TAB_HISTORY]) == 0) 
   { 
      if (mleHistory->numLines() == 1) showHistory();  // if no history, then get it
      setApplyButton("Ok"); 
      currentTab = TAB_HISTORY;
   }
   else 
   {
      setApplyButton("Ok");
   }
}


//-----ICQFunctions::printMessage------------------------------------------------------------------
void ICQFunctions::printMessage(QListViewItem *e)
{
   Message *m;
   m = &((MsgViewItem *)e)->msg;
   char theMsg[strlen(m->msg()) + 128];
   sprintf(theMsg, "%s\n----------------------------------------------\n", m->msg());
   mleRead->clear();
   mleRead->append(theMsg);
   if (m->cmd() == ICQ_CMDxTCP_START && m->subCmd() == ICQ_CMDxTCP_CHAT) 
   {
      // accept or refuse the chat request
      unsigned short chatResult = QMessageBox::information(this, "Licq", "Accept or refuse chat request here.", "Accept", "Refuse", "Ignore");
      if (chatResult == 1)
         server->chatRefuse(theUser, "chat request refused", m->sequence());
      else if (chatResult == 0)
      {
         unsigned short port;
         if (server->tcpServerPort != 0)   // assign the chat port
         {
            unsigned short i = 0;
            while (i < 10 && server->tcpPorts[i]) i++;
            port = server->tcpServerPort + i + 1;
            server->tcpPorts[i] = true;
         }
         else port = 0;
         ChatDlg *chatDlg = new ChatDlg(theUser, &(server->icqOwner), true, port);
         server->chatAccept(theUser, chatDlg->port(), m->sequence());
         chatDlg->show();
      }
   }
   short index = ((MsgViewItem *)e)->index;
   if (index >= 0)   // the message has not been seen yet
   {
      theUser->clearMessage(index);
      msgView->markRead(index);
   }
   emit updatedUsers();
}


//-----ICQFunctions::saveUserInfo------------------------------------------------------------------
void ICQFunctions::saveUserInfo()
{
   sprintf(theUser->aliasVal, "%s", (const char *)nfoAlias->edtInfo->text());
   sprintf(theUser->firstNameVal, "%s", (const char *)nfoFirstName->edtInfo->text());
   sprintf(theUser->lastNameVal, "%s", (const char *)nfoLastName->edtInfo->text());
   sprintf(theUser->emailVal, "%s", (const char *)nfoEMail->edtInfo->text());
   sprintf(theUser->historyFileVal, "%s", (const char *)nfoHistory->edtInfo->text());
   theUser->saveInfo();
   server->saveUsers();
}


//-----ICQFunctions::showHistory-------------------------------------------------------------------
void ICQFunctions::showHistory()
{
   char *buf;
   if (theUser->history != NULL) 
   {
      theUser->history->close();
      if (!theUser->history->open(IO_ReadOnly))  // a serious error occured
      {
         mleHistory->setText("History is having problems: ");
         mleHistory->append(theUser->history->name());
         theUser->history->open(IO_Append | IO_WriteOnly);
         return;
      }
      int historyLen = theUser->history->size();
      buf = new char[historyLen + 1];
      theUser->history->readBlock(buf, historyLen);
      buf[historyLen] = '\0';
      mleHistory->setText(buf);
      delete buf;
      theUser->history->close();
      theUser->history->open(IO_Append | IO_WriteOnly);
   }
}


//-----ICQFunctions::saveHistory-------------------------------------------------------------------
void ICQFunctions::saveHistory()
{
   if (theUser->history != NULL) 
   {
      theUser->history->close();
      theUser->history->open(IO_WriteOnly);
      theUser->history->writeBlock((const char *)mleHistory->text(), strlen((const char *)mleHistory->text()) );
      theUser->history->close();
      theUser->history->open(IO_Append | IO_WriteOnly);      
   }
}



//-----ICQFunctions::setSpoofed--------------------------------------------------------------------
void ICQFunctions::setSpoofed()
{
   if (chkSpoof->isChecked()) 
   {
      if (QMessageBox::warning(this, "Licq", "Spoofing messages is immoral and possibly illegal.\nIn clicking OK you absolve the author from any \nresponsibility for your actions.\nDo you want to continue?", 
                               QMessageBox::Ok, QMessageBox::Cancel) == 2) 
      {
         chkSpoof->setChecked(false);
      }
   }
}


//-----ICQFunctions::specialFcn--------------------------------------------------------------------
void ICQFunctions::specialFcn(int theFcn)
{
   switch (theFcn) 
   {
   case 0:
      lblItem->hide();
      edtItem->hide();
      lblDescription->setText("Message:");
      mleSend->setEnabled(true);
      break;   
   case 1:
      lblItem->setText("URL:");
      lblItem->show();
      edtItem->show();
      lblDescription->setText("Description:");
      mleSend->setEnabled(true);      
      break;
   case 2:
      lblItem->hide();
      edtItem->hide();
      lblDescription->setText("Check Away Message");
      mleSend->setEnabled(false);
      break;
   case 3:
      lblItem->hide();
      edtItem->hide();
      lblDescription->setText("Reason:");
      mleSend->setEnabled(true);
      break;
   case 4:
      lblItem->setText("Filename:");
      lblItem->show();
      edtItem->show();
      lblDescription->setText("Description:");
      mleSend->setEnabled(true);
      break;
   }
}


//-----ICQFunctions::msg---------------------------------------------------------------------------
const char *ICQFunctions::msg(void)
{ 
   delete msgVal;
   msgVal = new char[strlen((const char *)mleSend->text()) + 1];
   strcpy(msgVal, (const char *)mleSend->text());
   return (msgVal);
}


//-----ICQFunctions::callFcn-----------------------------------------------------------------------
void ICQFunctions::callFcn()
{
   unsigned long uin;
   char progressMsg[64];

   // disable user input
   btnApply->setEnabled(false);

   // do nothing if a command is already being processed
   if (icqEvent != NULL) return;

   switch (currentTab) 
   {
   case TAB_READ: hide(); break;
   case TAB_SEND:
      if (strlen(msg()) > MAX_MESSAGE_SIZE) 
      {
         char theWarning[1024];
         sprintf (theWarning, "Message is %d characters, over the ICQ limit of %d.  \nLicq and other clones support longer messages \nhowever Mirabilis clients will not.  Continue?", strlen(msg()), MAX_MESSAGE_SIZE);
         if(QMessageBox::warning( this, "Licq", theWarning, QMessageBox::Ok, QMessageBox::Cancel) == 2)
         {
            btnApply->setEnabled(true);
            break;
         }
      }      
      uin = (chkSpoof->isChecked() ? atoi(edtSpoof->text()) : server->icqOwner.uin());
      if (rdbMsg->isChecked())  // send a message
      {
         theUser->setSendServer(chkSendServer->isChecked());
         sprintf(progressMsg, "Sending msg %s...", (chkSendServer->isChecked() ? "server" : "direct"));
         lblProgress->setText(progressMsg);
         lblProgress->show();
         if ((icqEvent = server->sendMessage(theUser, msg(), (chkSendServer->isChecked() ? false : true), uin)) == NULL)
            doneFcn(false, NULL);
      }      
      else if (rdbAway->isChecked()) // check away message
      {
         lblProgress->setText("Fetching...");
         lblProgress->show();
         if ((icqEvent = server->sendReadAwayMsg(theUser, (chkSendServer->isChecked() ? false : true), uin)) == NULL)
            doneFcn(false, NULL);
      }
      else if (rdbUrl->isChecked()) // send URL
      {
         sprintf(progressMsg, "Sending URL %s...", (chkSendServer->isChecked() ? "server" : "direct"));
         lblProgress->setText(progressMsg);
         lblProgress->show();
         if ((icqEvent = server->sendUrl(theUser, (char *)edtItem->text(), msg(), (chkSendServer->isChecked() ? false : true), uin)) == NULL)
            doneFcn(false, NULL);
      }
      else if (rdbChat->isChecked())   // send Chat request
      {
         sprintf(progressMsg, "Sending chat request %s...", (chkSendServer->isChecked() ? "server" : "direct"));
         lblProgress->setText(progressMsg);
         lblProgress->show();
         if ((icqEvent = server->sendChat(theUser, msg(), (chkSendServer->isChecked() ? false : true), uin)) == NULL)
            doneFcn(false, NULL);
      }
      break;
   case TAB_USERINFO: 
      lblProgress->setText("Updating...");
      lblProgress->show();
      connect (server, SIGNAL(doneUserInfo(bool, unsigned long)), this, SLOT(doneUserInfo(bool, unsigned long)));
      server->getUserInfo(theUser);
      break;
   case TAB_HISTORY: hide(); break;
   }
}


//-----ICQFunctions::doneFcn-----------------------------------------------------------------------
void ICQFunctions::doneFcn(bool isOk, ICQEvent *e)
{
   if (e != icqEvent) return;
   
   char progress[128];
   sprintf(progress, "%s%s", (const char *)lblProgress->text(), (isOk ? "done" : "failed"));
   lblProgress->setText(progress);
   btnApply->setEnabled(true);
   unsigned short theCmd = 0;
   if (e != NULL) theCmd = e->cmd;
   icqEvent = NULL;
   
   if (isOk) 
   {
      if (theCmd == ICQ_CMDxTCP_START
          && theUser->status() != ICQ_STATUS_ONLINE 
          && theUser->status() != ICQ_STATUS_OFFLINE
          && theUser->status() != ICQ_STATUS_FREEFORCHAT)
      {
         setInfo();
         tabBar()->setCurrentTab(TAB_USERINFO);
      }
      else
         if (autoClose) hide();
   }
}


void ICQFunctions::doneUserInfo(bool isOk, unsigned long uin)
{
   if (uin != theUser->uin()) return;
   
   char progress[128];
   sprintf(progress, "%s%s", (const char *)lblProgress->text(), (isOk ? "done" : "failed"));
   lblProgress->setText(progress);
   btnApply->setEnabled(true);   
   
   if (isOk) setInfo();
}


void ICQFunctions::hide()
{
   QDialog::hide();
   //delete this;
   if (icqEvent != NULL) server->cancelEvent(icqEvent);
   disconnect (server, SIGNAL(doneUserFcn(bool, ICQEvent *)), this, SLOT(doneFcn(bool, ICQEvent *)));
   emit finished(theUser);
}


ICQFunctions::~ICQFunctions(void)
{
   for (unsigned short i = 0; i < 4; i++) delete tabLabel[i];
   delete msgVal;
} 
