#include <stdlib.h>
#include <qvalidator.h>
#include "adduserdlg.h"

                   
AddUserDlg::AddUserDlg(ICQ *s, QWidget *parent = 0, const char *name = 0 ) : QDialog(parent, name)
{
   server = s;
   resize(240, 120);
   lblUin = new QLabel("New User UIN:", this);
   lblUin->setGeometry(10, 15, 80, 20);
   edtUin = new QLineEdit(this);
   edtUin->setGeometry(100, 15, 120, 20);
   edtUin->setValidator(new QIntValidator(0, 2147483647, edtUin));
   chkAlert = new QCheckBox("Alert User", this);
   chkAlert->setStyle(WindowsStyle);
   chkAlert->setGeometry(10, 50, 80, 20);
   chkAlert->setEnabled(false);  //for now
   btnOk = new QPushButton("Ok", this);
   btnOk->setGeometry(30, 80, 80, 30);
   btnCancel = new QPushButton("Cancel", this);
   btnCancel->setGeometry(130, 80, 80, 30);
   connect (btnOk, SIGNAL(clicked()), SLOT(ok()) );
   connect (btnCancel, SIGNAL(clicked()), SLOT(reject()) );
}


void AddUserDlg::show()
{
   edtUin->setText("");
   chkAlert->setChecked(false);
   QDialog::show();
}


void AddUserDlg::ok()
{
   server->addUser(atol((const char *)edtUin->text()), NULL, true);
   if (chkAlert->isChecked()) // alert the user they were added
   ;
   emit updatedUsers();
   accept();
}
